/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.CallAs;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.TemplateSummaryConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTemplateSummaryRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, GetTemplateSummaryRequest> {
    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateBody").getter(GetTemplateSummaryRequest.getter(GetTemplateSummaryRequest::templateBody)).setter(GetTemplateSummaryRequest.setter(Builder::templateBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateBody").build()}).build();
    private static final SdkField<String> TEMPLATE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateURL").getter(GetTemplateSummaryRequest.getter(GetTemplateSummaryRequest::templateURL)).setter(GetTemplateSummaryRequest.setter(Builder::templateURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateURL").build()}).build();
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackName").getter(GetTemplateSummaryRequest.getter(GetTemplateSummaryRequest::stackName)).setter(GetTemplateSummaryRequest.setter(Builder::stackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()}).build();
    private static final SdkField<String> STACK_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackSetName").getter(GetTemplateSummaryRequest.getter(GetTemplateSummaryRequest::stackSetName)).setter(GetTemplateSummaryRequest.setter(Builder::stackSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetName").build()}).build();
    private static final SdkField<String> CALL_AS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CallAs").getter(GetTemplateSummaryRequest.getter(GetTemplateSummaryRequest::callAsAsString)).setter(GetTemplateSummaryRequest.setter(Builder::callAs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallAs").build()}).build();
    private static final SdkField<TemplateSummaryConfig> TEMPLATE_SUMMARY_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TemplateSummaryConfig").getter(GetTemplateSummaryRequest.getter(GetTemplateSummaryRequest::templateSummaryConfig)).setter(GetTemplateSummaryRequest.setter(Builder::templateSummaryConfig)).constructor(TemplateSummaryConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateSummaryConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_BODY_FIELD, TEMPLATE_URL_FIELD, STACK_NAME_FIELD, STACK_SET_NAME_FIELD, CALL_AS_FIELD, TEMPLATE_SUMMARY_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetTemplateSummaryRequest.memberNameToFieldInitializer();
    private final String templateBody;
    private final String templateURL;
    private final String stackName;
    private final String stackSetName;
    private final String callAs;
    private final TemplateSummaryConfig templateSummaryConfig;

    private GetTemplateSummaryRequest(BuilderImpl builder) {
        super(builder);
        this.templateBody = builder.templateBody;
        this.templateURL = builder.templateURL;
        this.stackName = builder.stackName;
        this.stackSetName = builder.stackSetName;
        this.callAs = builder.callAs;
        this.templateSummaryConfig = builder.templateSummaryConfig;
    }

    public final String templateBody() {
        return this.templateBody;
    }

    public final String templateURL() {
        return this.templateURL;
    }

    public final String stackName() {
        return this.stackName;
    }

    public final String stackSetName() {
        return this.stackSetName;
    }

    public final CallAs callAs() {
        return CallAs.fromValue(this.callAs);
    }

    public final String callAsAsString() {
        return this.callAs;
    }

    public final TemplateSummaryConfig templateSummaryConfig() {
        return this.templateSummaryConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.callAsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateSummaryConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTemplateSummaryRequest)) {
            return false;
        }
        GetTemplateSummaryRequest other = (GetTemplateSummaryRequest)((Object)obj);
        return Objects.equals(this.templateBody(), other.templateBody()) && Objects.equals(this.templateURL(), other.templateURL()) && Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.stackSetName(), other.stackSetName()) && Objects.equals(this.callAsAsString(), other.callAsAsString()) && Objects.equals(this.templateSummaryConfig(), other.templateSummaryConfig());
    }

    public final String toString() {
        return ToString.builder((String)"GetTemplateSummaryRequest").add("TemplateBody", (Object)this.templateBody()).add("TemplateURL", (Object)this.templateURL()).add("StackName", (Object)this.stackName()).add("StackSetName", (Object)this.stackSetName()).add("CallAs", (Object)this.callAsAsString()).add("TemplateSummaryConfig", (Object)this.templateSummaryConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemplateBody": {
                return Optional.ofNullable(clazz.cast(this.templateBody()));
            }
            case "TemplateURL": {
                return Optional.ofNullable(clazz.cast(this.templateURL()));
            }
            case "StackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
            case "StackSetName": {
                return Optional.ofNullable(clazz.cast(this.stackSetName()));
            }
            case "CallAs": {
                return Optional.ofNullable(clazz.cast(this.callAsAsString()));
            }
            case "TemplateSummaryConfig": {
                return Optional.ofNullable(clazz.cast(this.templateSummaryConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TemplateBody", TEMPLATE_BODY_FIELD);
        map.put("TemplateURL", TEMPLATE_URL_FIELD);
        map.put("StackName", STACK_NAME_FIELD);
        map.put("StackSetName", STACK_SET_NAME_FIELD);
        map.put("CallAs", CALL_AS_FIELD);
        map.put("TemplateSummaryConfig", TEMPLATE_SUMMARY_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTemplateSummaryRequest, T> g) {
        return obj -> g.apply((GetTemplateSummaryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String templateBody;
        private String templateURL;
        private String stackName;
        private String stackSetName;
        private String callAs;
        private TemplateSummaryConfig templateSummaryConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTemplateSummaryRequest model) {
            super(model);
            this.templateBody(model.templateBody);
            this.templateURL(model.templateURL);
            this.stackName(model.stackName);
            this.stackSetName(model.stackSetName);
            this.callAs(model.callAs);
            this.templateSummaryConfig(model.templateSummaryConfig);
        }

        public final String getTemplateBody() {
            return this.templateBody;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final String getTemplateURL() {
            return this.templateURL;
        }

        public final void setTemplateURL(String templateURL) {
            this.templateURL = templateURL;
        }

        @Override
        public final Builder templateURL(String templateURL) {
            this.templateURL = templateURL;
            return this;
        }

        public final String getStackName() {
            return this.stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final String getStackSetName() {
            return this.stackSetName;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        @Override
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final String getCallAs() {
            return this.callAs;
        }

        public final void setCallAs(String callAs) {
            this.callAs = callAs;
        }

        @Override
        public final Builder callAs(String callAs) {
            this.callAs = callAs;
            return this;
        }

        @Override
        public final Builder callAs(CallAs callAs) {
            this.callAs(callAs == null ? null : callAs.toString());
            return this;
        }

        public final TemplateSummaryConfig.Builder getTemplateSummaryConfig() {
            return this.templateSummaryConfig != null ? this.templateSummaryConfig.toBuilder() : null;
        }

        public final void setTemplateSummaryConfig(TemplateSummaryConfig.BuilderImpl templateSummaryConfig) {
            this.templateSummaryConfig = templateSummaryConfig != null ? templateSummaryConfig.build() : null;
        }

        @Override
        public final Builder templateSummaryConfig(TemplateSummaryConfig templateSummaryConfig) {
            this.templateSummaryConfig = templateSummaryConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTemplateSummaryRequest build() {
            return new GetTemplateSummaryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTemplateSummaryRequest> {
        public Builder templateBody(String var1);

        public Builder templateURL(String var1);

        public Builder stackName(String var1);

        public Builder stackSetName(String var1);

        public Builder callAs(String var1);

        public Builder callAs(CallAs var1);

        public Builder templateSummaryConfig(TemplateSummaryConfig var1);

        default public Builder templateSummaryConfig(Consumer<TemplateSummaryConfig.Builder> templateSummaryConfig) {
            return this.templateSummaryConfig((TemplateSummaryConfig)((TemplateSummaryConfig.Builder)TemplateSummaryConfig.builder().applyMutation(templateSummaryConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

