/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.StackIdsCopier;
import software.amazon.awssdk.services.cloudformation.model.StackRefactorExecutionStatus;
import software.amazon.awssdk.services.cloudformation.model.StackRefactorStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStackRefactorResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, DescribeStackRefactorResponse> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeStackRefactorResponse.getter(DescribeStackRefactorResponse::description)).setter(DescribeStackRefactorResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STACK_REFACTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackRefactorId").getter(DescribeStackRefactorResponse.getter(DescribeStackRefactorResponse::stackRefactorId)).setter(DescribeStackRefactorResponse.setter(Builder::stackRefactorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackRefactorId").build()}).build();
    private static final SdkField<List<String>> STACK_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StackIds").getter(DescribeStackRefactorResponse.getter(DescribeStackRefactorResponse::stackIds)).setter(DescribeStackRefactorResponse.setter(Builder::stackIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EXECUTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionStatus").getter(DescribeStackRefactorResponse.getter(DescribeStackRefactorResponse::executionStatusAsString)).setter(DescribeStackRefactorResponse.setter(Builder::executionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStatus").build()}).build();
    private static final SdkField<String> EXECUTION_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionStatusReason").getter(DescribeStackRefactorResponse.getter(DescribeStackRefactorResponse::executionStatusReason)).setter(DescribeStackRefactorResponse.setter(Builder::executionStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStatusReason").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeStackRefactorResponse.getter(DescribeStackRefactorResponse::statusAsString)).setter(DescribeStackRefactorResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(DescribeStackRefactorResponse.getter(DescribeStackRefactorResponse::statusReason)).setter(DescribeStackRefactorResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, STACK_REFACTOR_ID_FIELD, STACK_IDS_FIELD, EXECUTION_STATUS_FIELD, EXECUTION_STATUS_REASON_FIELD, STATUS_FIELD, STATUS_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeStackRefactorResponse.memberNameToFieldInitializer();
    private final String description;
    private final String stackRefactorId;
    private final List<String> stackIds;
    private final String executionStatus;
    private final String executionStatusReason;
    private final String status;
    private final String statusReason;

    private DescribeStackRefactorResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.stackRefactorId = builder.stackRefactorId;
        this.stackIds = builder.stackIds;
        this.executionStatus = builder.executionStatus;
        this.executionStatusReason = builder.executionStatusReason;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
    }

    public final String description() {
        return this.description;
    }

    public final String stackRefactorId() {
        return this.stackRefactorId;
    }

    public final boolean hasStackIds() {
        return this.stackIds != null && !(this.stackIds instanceof SdkAutoConstructList);
    }

    public final List<String> stackIds() {
        return this.stackIds;
    }

    public final StackRefactorExecutionStatus executionStatus() {
        return StackRefactorExecutionStatus.fromValue(this.executionStatus);
    }

    public final String executionStatusAsString() {
        return this.executionStatus;
    }

    public final String executionStatusReason() {
        return this.executionStatusReason;
    }

    public final StackRefactorStatus status() {
        return StackRefactorStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackRefactorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStackIds() ? this.stackIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackRefactorResponse)) {
            return false;
        }
        DescribeStackRefactorResponse other = (DescribeStackRefactorResponse)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.stackRefactorId(), other.stackRefactorId()) && this.hasStackIds() == other.hasStackIds() && Objects.equals(this.stackIds(), other.stackIds()) && Objects.equals(this.executionStatusAsString(), other.executionStatusAsString()) && Objects.equals(this.executionStatusReason(), other.executionStatusReason()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeStackRefactorResponse").add("Description", (Object)this.description()).add("StackRefactorId", (Object)this.stackRefactorId()).add("StackIds", this.hasStackIds() ? this.stackIds() : null).add("ExecutionStatus", (Object)this.executionStatusAsString()).add("ExecutionStatusReason", (Object)this.executionStatusReason()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "StackRefactorId": {
                return Optional.ofNullable(clazz.cast(this.stackRefactorId()));
            }
            case "StackIds": {
                return Optional.ofNullable(clazz.cast(this.stackIds()));
            }
            case "ExecutionStatus": {
                return Optional.ofNullable(clazz.cast(this.executionStatusAsString()));
            }
            case "ExecutionStatusReason": {
                return Optional.ofNullable(clazz.cast(this.executionStatusReason()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("StackRefactorId", STACK_REFACTOR_ID_FIELD);
        map.put("StackIds", STACK_IDS_FIELD);
        map.put("ExecutionStatus", EXECUTION_STATUS_FIELD);
        map.put("ExecutionStatusReason", EXECUTION_STATUS_REASON_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeStackRefactorResponse, T> g) {
        return obj -> g.apply((DescribeStackRefactorResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private String description;
        private String stackRefactorId;
        private List<String> stackIds = DefaultSdkAutoConstructList.getInstance();
        private String executionStatus;
        private String executionStatusReason;
        private String status;
        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackRefactorResponse model) {
            super(model);
            this.description(model.description);
            this.stackRefactorId(model.stackRefactorId);
            this.stackIds(model.stackIds);
            this.executionStatus(model.executionStatus);
            this.executionStatusReason(model.executionStatusReason);
            this.status(model.status);
            this.statusReason(model.statusReason);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStackRefactorId() {
            return this.stackRefactorId;
        }

        public final void setStackRefactorId(String stackRefactorId) {
            this.stackRefactorId = stackRefactorId;
        }

        @Override
        public final Builder stackRefactorId(String stackRefactorId) {
            this.stackRefactorId = stackRefactorId;
            return this;
        }

        public final Collection<String> getStackIds() {
            if (this.stackIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stackIds;
        }

        public final void setStackIds(Collection<String> stackIds) {
            this.stackIds = StackIdsCopier.copy(stackIds);
        }

        @Override
        public final Builder stackIds(Collection<String> stackIds) {
            this.stackIds = StackIdsCopier.copy(stackIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackIds(String ... stackIds) {
            this.stackIds(Arrays.asList(stackIds));
            return this;
        }

        public final String getExecutionStatus() {
            return this.executionStatus;
        }

        public final void setExecutionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
        }

        @Override
        public final Builder executionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        @Override
        public final Builder executionStatus(StackRefactorExecutionStatus executionStatus) {
            this.executionStatus(executionStatus == null ? null : executionStatus.toString());
            return this;
        }

        public final String getExecutionStatusReason() {
            return this.executionStatusReason;
        }

        public final void setExecutionStatusReason(String executionStatusReason) {
            this.executionStatusReason = executionStatusReason;
        }

        @Override
        public final Builder executionStatusReason(String executionStatusReason) {
            this.executionStatusReason = executionStatusReason;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StackRefactorStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public DescribeStackRefactorResponse build() {
            return new DescribeStackRefactorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStackRefactorResponse> {
        public Builder description(String var1);

        public Builder stackRefactorId(String var1);

        public Builder stackIds(Collection<String> var1);

        public Builder stackIds(String ... var1);

        public Builder executionStatus(String var1);

        public Builder executionStatus(StackRefactorExecutionStatus var1);

        public Builder executionStatusReason(String var1);

        public Builder status(String var1);

        public Builder status(StackRefactorStatus var1);

        public Builder statusReason(String var1);
    }
}

