/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.LoggingConfig;
import software.amazon.awssdk.services.cloudformation.model.ThirdPartyType;
import software.amazon.awssdk.services.cloudformation.model.VersionBump;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActivateTypeRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, ActivateTypeRequest> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ActivateTypeRequest.getter(ActivateTypeRequest::typeAsString)).setter(ActivateTypeRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> PUBLIC_TYPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicTypeArn").getter(ActivateTypeRequest.getter(ActivateTypeRequest::publicTypeArn)).setter(ActivateTypeRequest.setter(Builder::publicTypeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicTypeArn").build()}).build();
    private static final SdkField<String> PUBLISHER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublisherId").getter(ActivateTypeRequest.getter(ActivateTypeRequest::publisherId)).setter(ActivateTypeRequest.setter(Builder::publisherId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublisherId").build()}).build();
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeName").getter(ActivateTypeRequest.getter(ActivateTypeRequest::typeName)).setter(ActivateTypeRequest.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()}).build();
    private static final SdkField<String> TYPE_NAME_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeNameAlias").getter(ActivateTypeRequest.getter(ActivateTypeRequest::typeNameAlias)).setter(ActivateTypeRequest.setter(Builder::typeNameAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeNameAlias").build()}).build();
    private static final SdkField<Boolean> AUTO_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoUpdate").getter(ActivateTypeRequest.getter(ActivateTypeRequest::autoUpdate)).setter(ActivateTypeRequest.setter(Builder::autoUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoUpdate").build()}).build();
    private static final SdkField<LoggingConfig> LOGGING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoggingConfig").getter(ActivateTypeRequest.getter(ActivateTypeRequest::loggingConfig)).setter(ActivateTypeRequest.setter(Builder::loggingConfig)).constructor(LoggingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingConfig").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleArn").getter(ActivateTypeRequest.getter(ActivateTypeRequest::executionRoleArn)).setter(ActivateTypeRequest.setter(Builder::executionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()}).build();
    private static final SdkField<String> VERSION_BUMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionBump").getter(ActivateTypeRequest.getter(ActivateTypeRequest::versionBumpAsString)).setter(ActivateTypeRequest.setter(Builder::versionBump)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionBump").build()}).build();
    private static final SdkField<Long> MAJOR_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MajorVersion").getter(ActivateTypeRequest.getter(ActivateTypeRequest::majorVersion)).setter(ActivateTypeRequest.setter(Builder::majorVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MajorVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, PUBLIC_TYPE_ARN_FIELD, PUBLISHER_ID_FIELD, TYPE_NAME_FIELD, TYPE_NAME_ALIAS_FIELD, AUTO_UPDATE_FIELD, LOGGING_CONFIG_FIELD, EXECUTION_ROLE_ARN_FIELD, VERSION_BUMP_FIELD, MAJOR_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ActivateTypeRequest.memberNameToFieldInitializer();
    private final String type;
    private final String publicTypeArn;
    private final String publisherId;
    private final String typeName;
    private final String typeNameAlias;
    private final Boolean autoUpdate;
    private final LoggingConfig loggingConfig;
    private final String executionRoleArn;
    private final String versionBump;
    private final Long majorVersion;

    private ActivateTypeRequest(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.publicTypeArn = builder.publicTypeArn;
        this.publisherId = builder.publisherId;
        this.typeName = builder.typeName;
        this.typeNameAlias = builder.typeNameAlias;
        this.autoUpdate = builder.autoUpdate;
        this.loggingConfig = builder.loggingConfig;
        this.executionRoleArn = builder.executionRoleArn;
        this.versionBump = builder.versionBump;
        this.majorVersion = builder.majorVersion;
    }

    public final ThirdPartyType type() {
        return ThirdPartyType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String publicTypeArn() {
        return this.publicTypeArn;
    }

    public final String publisherId() {
        return this.publisherId;
    }

    public final String typeName() {
        return this.typeName;
    }

    public final String typeNameAlias() {
        return this.typeNameAlias;
    }

    public final Boolean autoUpdate() {
        return this.autoUpdate;
    }

    public final LoggingConfig loggingConfig() {
        return this.loggingConfig;
    }

    public final String executionRoleArn() {
        return this.executionRoleArn;
    }

    public final VersionBump versionBump() {
        return VersionBump.fromValue(this.versionBump);
    }

    public final String versionBumpAsString() {
        return this.versionBump;
    }

    public final Long majorVersion() {
        return this.majorVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicTypeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.publisherId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeNameAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionBumpAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.majorVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActivateTypeRequest)) {
            return false;
        }
        ActivateTypeRequest other = (ActivateTypeRequest)((Object)obj);
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.publicTypeArn(), other.publicTypeArn()) && Objects.equals(this.publisherId(), other.publisherId()) && Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.typeNameAlias(), other.typeNameAlias()) && Objects.equals(this.autoUpdate(), other.autoUpdate()) && Objects.equals(this.loggingConfig(), other.loggingConfig()) && Objects.equals(this.executionRoleArn(), other.executionRoleArn()) && Objects.equals(this.versionBumpAsString(), other.versionBumpAsString()) && Objects.equals(this.majorVersion(), other.majorVersion());
    }

    public final String toString() {
        return ToString.builder((String)"ActivateTypeRequest").add("Type", (Object)this.typeAsString()).add("PublicTypeArn", (Object)this.publicTypeArn()).add("PublisherId", (Object)this.publisherId()).add("TypeName", (Object)this.typeName()).add("TypeNameAlias", (Object)this.typeNameAlias()).add("AutoUpdate", (Object)this.autoUpdate()).add("LoggingConfig", (Object)this.loggingConfig()).add("ExecutionRoleArn", (Object)this.executionRoleArn()).add("VersionBump", (Object)this.versionBumpAsString()).add("MajorVersion", (Object)this.majorVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "PublicTypeArn": {
                return Optional.ofNullable(clazz.cast(this.publicTypeArn()));
            }
            case "PublisherId": {
                return Optional.ofNullable(clazz.cast(this.publisherId()));
            }
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "TypeNameAlias": {
                return Optional.ofNullable(clazz.cast(this.typeNameAlias()));
            }
            case "AutoUpdate": {
                return Optional.ofNullable(clazz.cast(this.autoUpdate()));
            }
            case "LoggingConfig": {
                return Optional.ofNullable(clazz.cast(this.loggingConfig()));
            }
            case "ExecutionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.executionRoleArn()));
            }
            case "VersionBump": {
                return Optional.ofNullable(clazz.cast(this.versionBumpAsString()));
            }
            case "MajorVersion": {
                return Optional.ofNullable(clazz.cast(this.majorVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Type", TYPE_FIELD);
        map.put("PublicTypeArn", PUBLIC_TYPE_ARN_FIELD);
        map.put("PublisherId", PUBLISHER_ID_FIELD);
        map.put("TypeName", TYPE_NAME_FIELD);
        map.put("TypeNameAlias", TYPE_NAME_ALIAS_FIELD);
        map.put("AutoUpdate", AUTO_UPDATE_FIELD);
        map.put("LoggingConfig", LOGGING_CONFIG_FIELD);
        map.put("ExecutionRoleArn", EXECUTION_ROLE_ARN_FIELD);
        map.put("VersionBump", VERSION_BUMP_FIELD);
        map.put("MajorVersion", MAJOR_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActivateTypeRequest, T> g) {
        return obj -> g.apply((ActivateTypeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String type;
        private String publicTypeArn;
        private String publisherId;
        private String typeName;
        private String typeNameAlias;
        private Boolean autoUpdate;
        private LoggingConfig loggingConfig;
        private String executionRoleArn;
        private String versionBump;
        private Long majorVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ActivateTypeRequest model) {
            super(model);
            this.type(model.type);
            this.publicTypeArn(model.publicTypeArn);
            this.publisherId(model.publisherId);
            this.typeName(model.typeName);
            this.typeNameAlias(model.typeNameAlias);
            this.autoUpdate(model.autoUpdate);
            this.loggingConfig(model.loggingConfig);
            this.executionRoleArn(model.executionRoleArn);
            this.versionBump(model.versionBump);
            this.majorVersion(model.majorVersion);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ThirdPartyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getPublicTypeArn() {
            return this.publicTypeArn;
        }

        public final void setPublicTypeArn(String publicTypeArn) {
            this.publicTypeArn = publicTypeArn;
        }

        @Override
        public final Builder publicTypeArn(String publicTypeArn) {
            this.publicTypeArn = publicTypeArn;
            return this;
        }

        public final String getPublisherId() {
            return this.publisherId;
        }

        public final void setPublisherId(String publisherId) {
            this.publisherId = publisherId;
        }

        @Override
        public final Builder publisherId(String publisherId) {
            this.publisherId = publisherId;
            return this;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getTypeNameAlias() {
            return this.typeNameAlias;
        }

        public final void setTypeNameAlias(String typeNameAlias) {
            this.typeNameAlias = typeNameAlias;
        }

        @Override
        public final Builder typeNameAlias(String typeNameAlias) {
            this.typeNameAlias = typeNameAlias;
            return this;
        }

        public final Boolean getAutoUpdate() {
            return this.autoUpdate;
        }

        public final void setAutoUpdate(Boolean autoUpdate) {
            this.autoUpdate = autoUpdate;
        }

        @Override
        public final Builder autoUpdate(Boolean autoUpdate) {
            this.autoUpdate = autoUpdate;
            return this;
        }

        public final LoggingConfig.Builder getLoggingConfig() {
            return this.loggingConfig != null ? this.loggingConfig.toBuilder() : null;
        }

        public final void setLoggingConfig(LoggingConfig.BuilderImpl loggingConfig) {
            this.loggingConfig = loggingConfig != null ? loggingConfig.build() : null;
        }

        @Override
        public final Builder loggingConfig(LoggingConfig loggingConfig) {
            this.loggingConfig = loggingConfig;
            return this;
        }

        public final String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final String getVersionBump() {
            return this.versionBump;
        }

        public final void setVersionBump(String versionBump) {
            this.versionBump = versionBump;
        }

        @Override
        public final Builder versionBump(String versionBump) {
            this.versionBump = versionBump;
            return this;
        }

        @Override
        public final Builder versionBump(VersionBump versionBump) {
            this.versionBump(versionBump == null ? null : versionBump.toString());
            return this;
        }

        public final Long getMajorVersion() {
            return this.majorVersion;
        }

        public final void setMajorVersion(Long majorVersion) {
            this.majorVersion = majorVersion;
        }

        @Override
        public final Builder majorVersion(Long majorVersion) {
            this.majorVersion = majorVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ActivateTypeRequest build() {
            return new ActivateTypeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ActivateTypeRequest> {
        public Builder type(String var1);

        public Builder type(ThirdPartyType var1);

        public Builder publicTypeArn(String var1);

        public Builder publisherId(String var1);

        public Builder typeName(String var1);

        public Builder typeNameAlias(String var1);

        public Builder autoUpdate(Boolean var1);

        public Builder loggingConfig(LoggingConfig var1);

        default public Builder loggingConfig(Consumer<LoggingConfig.Builder> loggingConfig) {
            return this.loggingConfig((LoggingConfig)((LoggingConfig.Builder)LoggingConfig.builder().applyMutation(loggingConfig)).build());
        }

        public Builder executionRoleArn(String var1);

        public Builder versionBump(String var1);

        public Builder versionBump(VersionBump var1);

        public Builder majorVersion(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

