/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.ChangeSetStatus;
import software.amazon.awssdk.services.cloudformation.model.ExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChangeSetSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChangeSetSummary> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackId").getter(ChangeSetSummary.getter(ChangeSetSummary::stackId)).setter(ChangeSetSummary.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()}).build();
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackName").getter(ChangeSetSummary.getter(ChangeSetSummary::stackName)).setter(ChangeSetSummary.setter(Builder::stackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()}).build();
    private static final SdkField<String> CHANGE_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeSetId").getter(ChangeSetSummary.getter(ChangeSetSummary::changeSetId)).setter(ChangeSetSummary.setter(Builder::changeSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetId").build()}).build();
    private static final SdkField<String> CHANGE_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeSetName").getter(ChangeSetSummary.getter(ChangeSetSummary::changeSetName)).setter(ChangeSetSummary.setter(Builder::changeSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetName").build()}).build();
    private static final SdkField<String> EXECUTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionStatus").getter(ChangeSetSummary.getter(ChangeSetSummary::executionStatusAsString)).setter(ChangeSetSummary.setter(Builder::executionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStatus").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ChangeSetSummary.getter(ChangeSetSummary::statusAsString)).setter(ChangeSetSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(ChangeSetSummary.getter(ChangeSetSummary::statusReason)).setter(ChangeSetSummary.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ChangeSetSummary.getter(ChangeSetSummary::creationTime)).setter(ChangeSetSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ChangeSetSummary.getter(ChangeSetSummary::description)).setter(ChangeSetSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Boolean> INCLUDE_NESTED_STACKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeNestedStacks").getter(ChangeSetSummary.getter(ChangeSetSummary::includeNestedStacks)).setter(ChangeSetSummary.setter(Builder::includeNestedStacks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeNestedStacks").build()}).build();
    private static final SdkField<String> PARENT_CHANGE_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParentChangeSetId").getter(ChangeSetSummary.getter(ChangeSetSummary::parentChangeSetId)).setter(ChangeSetSummary.setter(Builder::parentChangeSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentChangeSetId").build()}).build();
    private static final SdkField<String> ROOT_CHANGE_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RootChangeSetId").getter(ChangeSetSummary.getter(ChangeSetSummary::rootChangeSetId)).setter(ChangeSetSummary.setter(Builder::rootChangeSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootChangeSetId").build()}).build();
    private static final SdkField<Boolean> IMPORT_EXISTING_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ImportExistingResources").getter(ChangeSetSummary.getter(ChangeSetSummary::importExistingResources)).setter(ChangeSetSummary.setter(Builder::importExistingResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportExistingResources").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD, STACK_NAME_FIELD, CHANGE_SET_ID_FIELD, CHANGE_SET_NAME_FIELD, EXECUTION_STATUS_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, CREATION_TIME_FIELD, DESCRIPTION_FIELD, INCLUDE_NESTED_STACKS_FIELD, PARENT_CHANGE_SET_ID_FIELD, ROOT_CHANGE_SET_ID_FIELD, IMPORT_EXISTING_RESOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ChangeSetSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String stackId;
    private final String stackName;
    private final String changeSetId;
    private final String changeSetName;
    private final String executionStatus;
    private final String status;
    private final String statusReason;
    private final Instant creationTime;
    private final String description;
    private final Boolean includeNestedStacks;
    private final String parentChangeSetId;
    private final String rootChangeSetId;
    private final Boolean importExistingResources;

    private ChangeSetSummary(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.stackName = builder.stackName;
        this.changeSetId = builder.changeSetId;
        this.changeSetName = builder.changeSetName;
        this.executionStatus = builder.executionStatus;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.includeNestedStacks = builder.includeNestedStacks;
        this.parentChangeSetId = builder.parentChangeSetId;
        this.rootChangeSetId = builder.rootChangeSetId;
        this.importExistingResources = builder.importExistingResources;
    }

    public final String stackId() {
        return this.stackId;
    }

    public final String stackName() {
        return this.stackName;
    }

    public final String changeSetId() {
        return this.changeSetId;
    }

    public final String changeSetName() {
        return this.changeSetName;
    }

    public final ExecutionStatus executionStatus() {
        return ExecutionStatus.fromValue(this.executionStatus);
    }

    public final String executionStatusAsString() {
        return this.executionStatus;
    }

    public final ChangeSetStatus status() {
        return ChangeSetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean includeNestedStacks() {
        return this.includeNestedStacks;
    }

    public final String parentChangeSetId() {
        return this.parentChangeSetId;
    }

    public final String rootChangeSetId() {
        return this.rootChangeSetId;
    }

    public final Boolean importExistingResources() {
        return this.importExistingResources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeNestedStacks());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentChangeSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootChangeSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.importExistingResources());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeSetSummary)) {
            return false;
        }
        ChangeSetSummary other = (ChangeSetSummary)obj;
        return Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.changeSetId(), other.changeSetId()) && Objects.equals(this.changeSetName(), other.changeSetName()) && Objects.equals(this.executionStatusAsString(), other.executionStatusAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.includeNestedStacks(), other.includeNestedStacks()) && Objects.equals(this.parentChangeSetId(), other.parentChangeSetId()) && Objects.equals(this.rootChangeSetId(), other.rootChangeSetId()) && Objects.equals(this.importExistingResources(), other.importExistingResources());
    }

    public final String toString() {
        return ToString.builder((String)"ChangeSetSummary").add("StackId", (Object)this.stackId()).add("StackName", (Object)this.stackName()).add("ChangeSetId", (Object)this.changeSetId()).add("ChangeSetName", (Object)this.changeSetName()).add("ExecutionStatus", (Object)this.executionStatusAsString()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("CreationTime", (Object)this.creationTime()).add("Description", (Object)this.description()).add("IncludeNestedStacks", (Object)this.includeNestedStacks()).add("ParentChangeSetId", (Object)this.parentChangeSetId()).add("RootChangeSetId", (Object)this.rootChangeSetId()).add("ImportExistingResources", (Object)this.importExistingResources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "StackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
            case "ChangeSetId": {
                return Optional.ofNullable(clazz.cast(this.changeSetId()));
            }
            case "ChangeSetName": {
                return Optional.ofNullable(clazz.cast(this.changeSetName()));
            }
            case "ExecutionStatus": {
                return Optional.ofNullable(clazz.cast(this.executionStatusAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "IncludeNestedStacks": {
                return Optional.ofNullable(clazz.cast(this.includeNestedStacks()));
            }
            case "ParentChangeSetId": {
                return Optional.ofNullable(clazz.cast(this.parentChangeSetId()));
            }
            case "RootChangeSetId": {
                return Optional.ofNullable(clazz.cast(this.rootChangeSetId()));
            }
            case "ImportExistingResources": {
                return Optional.ofNullable(clazz.cast(this.importExistingResources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StackId", STACK_ID_FIELD);
        map.put("StackName", STACK_NAME_FIELD);
        map.put("ChangeSetId", CHANGE_SET_ID_FIELD);
        map.put("ChangeSetName", CHANGE_SET_NAME_FIELD);
        map.put("ExecutionStatus", EXECUTION_STATUS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("IncludeNestedStacks", INCLUDE_NESTED_STACKS_FIELD);
        map.put("ParentChangeSetId", PARENT_CHANGE_SET_ID_FIELD);
        map.put("RootChangeSetId", ROOT_CHANGE_SET_ID_FIELD);
        map.put("ImportExistingResources", IMPORT_EXISTING_RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChangeSetSummary, T> g) {
        return obj -> g.apply((ChangeSetSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stackId;
        private String stackName;
        private String changeSetId;
        private String changeSetName;
        private String executionStatus;
        private String status;
        private String statusReason;
        private Instant creationTime;
        private String description;
        private Boolean includeNestedStacks;
        private String parentChangeSetId;
        private String rootChangeSetId;
        private Boolean importExistingResources;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeSetSummary model) {
            this.stackId(model.stackId);
            this.stackName(model.stackName);
            this.changeSetId(model.changeSetId);
            this.changeSetName(model.changeSetName);
            this.executionStatus(model.executionStatus);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.creationTime(model.creationTime);
            this.description(model.description);
            this.includeNestedStacks(model.includeNestedStacks);
            this.parentChangeSetId(model.parentChangeSetId);
            this.rootChangeSetId(model.rootChangeSetId);
            this.importExistingResources(model.importExistingResources);
        }

        public final String getStackId() {
            return this.stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final String getStackName() {
            return this.stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final String getChangeSetId() {
            return this.changeSetId;
        }

        public final void setChangeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
        }

        @Override
        public final Builder changeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
            return this;
        }

        public final String getChangeSetName() {
            return this.changeSetName;
        }

        public final void setChangeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
        }

        @Override
        public final Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public final String getExecutionStatus() {
            return this.executionStatus;
        }

        public final void setExecutionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
        }

        @Override
        public final Builder executionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        @Override
        public final Builder executionStatus(ExecutionStatus executionStatus) {
            this.executionStatus(executionStatus == null ? null : executionStatus.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChangeSetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getIncludeNestedStacks() {
            return this.includeNestedStacks;
        }

        public final void setIncludeNestedStacks(Boolean includeNestedStacks) {
            this.includeNestedStacks = includeNestedStacks;
        }

        @Override
        public final Builder includeNestedStacks(Boolean includeNestedStacks) {
            this.includeNestedStacks = includeNestedStacks;
            return this;
        }

        public final String getParentChangeSetId() {
            return this.parentChangeSetId;
        }

        public final void setParentChangeSetId(String parentChangeSetId) {
            this.parentChangeSetId = parentChangeSetId;
        }

        @Override
        public final Builder parentChangeSetId(String parentChangeSetId) {
            this.parentChangeSetId = parentChangeSetId;
            return this;
        }

        public final String getRootChangeSetId() {
            return this.rootChangeSetId;
        }

        public final void setRootChangeSetId(String rootChangeSetId) {
            this.rootChangeSetId = rootChangeSetId;
        }

        @Override
        public final Builder rootChangeSetId(String rootChangeSetId) {
            this.rootChangeSetId = rootChangeSetId;
            return this;
        }

        public final Boolean getImportExistingResources() {
            return this.importExistingResources;
        }

        public final void setImportExistingResources(Boolean importExistingResources) {
            this.importExistingResources = importExistingResources;
        }

        @Override
        public final Builder importExistingResources(Boolean importExistingResources) {
            this.importExistingResources = importExistingResources;
            return this;
        }

        public ChangeSetSummary build() {
            return new ChangeSetSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChangeSetSummary> {
        public Builder stackId(String var1);

        public Builder stackName(String var1);

        public Builder changeSetId(String var1);

        public Builder changeSetName(String var1);

        public Builder executionStatus(String var1);

        public Builder executionStatus(ExecutionStatus var1);

        public Builder status(String var1);

        public Builder status(ChangeSetStatus var1);

        public Builder statusReason(String var1);

        public Builder creationTime(Instant var1);

        public Builder description(String var1);

        public Builder includeNestedStacks(Boolean var1);

        public Builder parentChangeSetId(String var1);

        public Builder rootChangeSetId(String var1);

        public Builder importExistingResources(Boolean var1);
    }
}

