/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.AutoDeployment;
import software.amazon.awssdk.services.cloudformation.model.CapabilitiesCopier;
import software.amazon.awssdk.services.cloudformation.model.Capability;
import software.amazon.awssdk.services.cloudformation.model.ManagedExecution;
import software.amazon.awssdk.services.cloudformation.model.OrganizationalUnitIdListCopier;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.ParametersCopier;
import software.amazon.awssdk.services.cloudformation.model.PermissionModels;
import software.amazon.awssdk.services.cloudformation.model.RegionListCopier;
import software.amazon.awssdk.services.cloudformation.model.StackSetDriftDetectionDetails;
import software.amazon.awssdk.services.cloudformation.model.StackSetStatus;
import software.amazon.awssdk.services.cloudformation.model.Tag;
import software.amazon.awssdk.services.cloudformation.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StackSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StackSet> {
    private static final SdkField<String> STACK_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackSetName").getter(StackSet.getter(StackSet::stackSetName)).setter(StackSet.setter(Builder::stackSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetName").build()}).build();
    private static final SdkField<String> STACK_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackSetId").getter(StackSet.getter(StackSet::stackSetId)).setter(StackSet.setter(Builder::stackSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(StackSet.getter(StackSet::description)).setter(StackSet.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(StackSet.getter(StackSet::statusAsString)).setter(StackSet.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateBody").getter(StackSet.getter(StackSet::templateBody)).setter(StackSet.setter(Builder::templateBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateBody").build()}).build();
    private static final SdkField<List<Parameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Parameters").getter(StackSet.getter(StackSet::parameters)).setter(StackSet.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Parameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Capabilities").getter(StackSet.getter(StackSet::capabilitiesAsStrings)).setter(StackSet.setter(Builder::capabilitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(StackSet.getter(StackSet::tags)).setter(StackSet.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STACK_SET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackSetARN").getter(StackSet.getter(StackSet::stackSetARN)).setter(StackSet.setter(Builder::stackSetARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetARN").build()}).build();
    private static final SdkField<String> ADMINISTRATION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdministrationRoleARN").getter(StackSet.getter(StackSet::administrationRoleARN)).setter(StackSet.setter(Builder::administrationRoleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdministrationRoleARN").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRoleName").getter(StackSet.getter(StackSet::executionRoleName)).setter(StackSet.setter(Builder::executionRoleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleName").build()}).build();
    private static final SdkField<StackSetDriftDetectionDetails> STACK_SET_DRIFT_DETECTION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StackSetDriftDetectionDetails").getter(StackSet.getter(StackSet::stackSetDriftDetectionDetails)).setter(StackSet.setter(Builder::stackSetDriftDetectionDetails)).constructor(StackSetDriftDetectionDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackSetDriftDetectionDetails").build()}).build();
    private static final SdkField<AutoDeployment> AUTO_DEPLOYMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoDeployment").getter(StackSet.getter(StackSet::autoDeployment)).setter(StackSet.setter(Builder::autoDeployment)).constructor(AutoDeployment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoDeployment").build()}).build();
    private static final SdkField<String> PERMISSION_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PermissionModel").getter(StackSet.getter(StackSet::permissionModelAsString)).setter(StackSet.setter(Builder::permissionModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionModel").build()}).build();
    private static final SdkField<List<String>> ORGANIZATIONAL_UNIT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrganizationalUnitIds").getter(StackSet.getter(StackSet::organizationalUnitIds)).setter(StackSet.setter(Builder::organizationalUnitIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnitIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ManagedExecution> MANAGED_EXECUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ManagedExecution").getter(StackSet.getter(StackSet::managedExecution)).setter(StackSet.setter(Builder::managedExecution)).constructor(ManagedExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedExecution").build()}).build();
    private static final SdkField<List<String>> REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Regions").getter(StackSet.getter(StackSet::regions)).setter(StackSet.setter(Builder::regions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Regions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_SET_NAME_FIELD, STACK_SET_ID_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, TEMPLATE_BODY_FIELD, PARAMETERS_FIELD, CAPABILITIES_FIELD, TAGS_FIELD, STACK_SET_ARN_FIELD, ADMINISTRATION_ROLE_ARN_FIELD, EXECUTION_ROLE_NAME_FIELD, STACK_SET_DRIFT_DETECTION_DETAILS_FIELD, AUTO_DEPLOYMENT_FIELD, PERMISSION_MODEL_FIELD, ORGANIZATIONAL_UNIT_IDS_FIELD, MANAGED_EXECUTION_FIELD, REGIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StackSet.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String stackSetName;
    private final String stackSetId;
    private final String description;
    private final String status;
    private final String templateBody;
    private final List<Parameter> parameters;
    private final List<String> capabilities;
    private final List<Tag> tags;
    private final String stackSetARN;
    private final String administrationRoleARN;
    private final String executionRoleName;
    private final StackSetDriftDetectionDetails stackSetDriftDetectionDetails;
    private final AutoDeployment autoDeployment;
    private final String permissionModel;
    private final List<String> organizationalUnitIds;
    private final ManagedExecution managedExecution;
    private final List<String> regions;

    private StackSet(BuilderImpl builder) {
        this.stackSetName = builder.stackSetName;
        this.stackSetId = builder.stackSetId;
        this.description = builder.description;
        this.status = builder.status;
        this.templateBody = builder.templateBody;
        this.parameters = builder.parameters;
        this.capabilities = builder.capabilities;
        this.tags = builder.tags;
        this.stackSetARN = builder.stackSetARN;
        this.administrationRoleARN = builder.administrationRoleARN;
        this.executionRoleName = builder.executionRoleName;
        this.stackSetDriftDetectionDetails = builder.stackSetDriftDetectionDetails;
        this.autoDeployment = builder.autoDeployment;
        this.permissionModel = builder.permissionModel;
        this.organizationalUnitIds = builder.organizationalUnitIds;
        this.managedExecution = builder.managedExecution;
        this.regions = builder.regions;
    }

    public final String stackSetName() {
        return this.stackSetName;
    }

    public final String stackSetId() {
        return this.stackSetId;
    }

    public final String description() {
        return this.description;
    }

    public final StackSetStatus status() {
        return StackSetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String templateBody() {
        return this.templateBody;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<Parameter> parameters() {
        return this.parameters;
    }

    public final List<Capability> capabilities() {
        return CapabilitiesCopier.copyStringToEnum(this.capabilities);
    }

    public final boolean hasCapabilities() {
        return this.capabilities != null && !(this.capabilities instanceof SdkAutoConstructList);
    }

    public final List<String> capabilitiesAsStrings() {
        return this.capabilities;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String stackSetARN() {
        return this.stackSetARN;
    }

    public final String administrationRoleARN() {
        return this.administrationRoleARN;
    }

    public final String executionRoleName() {
        return this.executionRoleName;
    }

    public final StackSetDriftDetectionDetails stackSetDriftDetectionDetails() {
        return this.stackSetDriftDetectionDetails;
    }

    public final AutoDeployment autoDeployment() {
        return this.autoDeployment;
    }

    public final PermissionModels permissionModel() {
        return PermissionModels.fromValue(this.permissionModel);
    }

    public final String permissionModelAsString() {
        return this.permissionModel;
    }

    public final boolean hasOrganizationalUnitIds() {
        return this.organizationalUnitIds != null && !(this.organizationalUnitIds instanceof SdkAutoConstructList);
    }

    public final List<String> organizationalUnitIds() {
        return this.organizationalUnitIds;
    }

    public final ManagedExecution managedExecution() {
        return this.managedExecution;
    }

    public final boolean hasRegions() {
        return this.regions != null && !(this.regions instanceof SdkAutoConstructList);
    }

    public final List<String> regions() {
        return this.regions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapabilities() ? this.capabilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.administrationRoleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackSetDriftDetectionDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoDeployment());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrganizationalUnitIds() ? this.organizationalUnitIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.managedExecution());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegions() ? this.regions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackSet)) {
            return false;
        }
        StackSet other = (StackSet)obj;
        return Objects.equals(this.stackSetName(), other.stackSetName()) && Objects.equals(this.stackSetId(), other.stackSetId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.templateBody(), other.templateBody()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && this.hasCapabilities() == other.hasCapabilities() && Objects.equals(this.capabilitiesAsStrings(), other.capabilitiesAsStrings()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.stackSetARN(), other.stackSetARN()) && Objects.equals(this.administrationRoleARN(), other.administrationRoleARN()) && Objects.equals(this.executionRoleName(), other.executionRoleName()) && Objects.equals(this.stackSetDriftDetectionDetails(), other.stackSetDriftDetectionDetails()) && Objects.equals(this.autoDeployment(), other.autoDeployment()) && Objects.equals(this.permissionModelAsString(), other.permissionModelAsString()) && this.hasOrganizationalUnitIds() == other.hasOrganizationalUnitIds() && Objects.equals(this.organizationalUnitIds(), other.organizationalUnitIds()) && Objects.equals(this.managedExecution(), other.managedExecution()) && this.hasRegions() == other.hasRegions() && Objects.equals(this.regions(), other.regions());
    }

    public final String toString() {
        return ToString.builder((String)"StackSet").add("StackSetName", (Object)this.stackSetName()).add("StackSetId", (Object)this.stackSetId()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("TemplateBody", (Object)this.templateBody()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("Capabilities", this.hasCapabilities() ? this.capabilitiesAsStrings() : null).add("Tags", this.hasTags() ? this.tags() : null).add("StackSetARN", (Object)this.stackSetARN()).add("AdministrationRoleARN", (Object)this.administrationRoleARN()).add("ExecutionRoleName", (Object)this.executionRoleName()).add("StackSetDriftDetectionDetails", (Object)this.stackSetDriftDetectionDetails()).add("AutoDeployment", (Object)this.autoDeployment()).add("PermissionModel", (Object)this.permissionModelAsString()).add("OrganizationalUnitIds", this.hasOrganizationalUnitIds() ? this.organizationalUnitIds() : null).add("ManagedExecution", (Object)this.managedExecution()).add("Regions", this.hasRegions() ? this.regions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackSetName": {
                return Optional.ofNullable(clazz.cast(this.stackSetName()));
            }
            case "StackSetId": {
                return Optional.ofNullable(clazz.cast(this.stackSetId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "TemplateBody": {
                return Optional.ofNullable(clazz.cast(this.templateBody()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "Capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilitiesAsStrings()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "StackSetARN": {
                return Optional.ofNullable(clazz.cast(this.stackSetARN()));
            }
            case "AdministrationRoleARN": {
                return Optional.ofNullable(clazz.cast(this.administrationRoleARN()));
            }
            case "ExecutionRoleName": {
                return Optional.ofNullable(clazz.cast(this.executionRoleName()));
            }
            case "StackSetDriftDetectionDetails": {
                return Optional.ofNullable(clazz.cast(this.stackSetDriftDetectionDetails()));
            }
            case "AutoDeployment": {
                return Optional.ofNullable(clazz.cast(this.autoDeployment()));
            }
            case "PermissionModel": {
                return Optional.ofNullable(clazz.cast(this.permissionModelAsString()));
            }
            case "OrganizationalUnitIds": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnitIds()));
            }
            case "ManagedExecution": {
                return Optional.ofNullable(clazz.cast(this.managedExecution()));
            }
            case "Regions": {
                return Optional.ofNullable(clazz.cast(this.regions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StackSetName", STACK_SET_NAME_FIELD);
        map.put("StackSetId", STACK_SET_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("TemplateBody", TEMPLATE_BODY_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("Capabilities", CAPABILITIES_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("StackSetARN", STACK_SET_ARN_FIELD);
        map.put("AdministrationRoleARN", ADMINISTRATION_ROLE_ARN_FIELD);
        map.put("ExecutionRoleName", EXECUTION_ROLE_NAME_FIELD);
        map.put("StackSetDriftDetectionDetails", STACK_SET_DRIFT_DETECTION_DETAILS_FIELD);
        map.put("AutoDeployment", AUTO_DEPLOYMENT_FIELD);
        map.put("PermissionModel", PERMISSION_MODEL_FIELD);
        map.put("OrganizationalUnitIds", ORGANIZATIONAL_UNIT_IDS_FIELD);
        map.put("ManagedExecution", MANAGED_EXECUTION_FIELD);
        map.put("Regions", REGIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StackSet, T> g) {
        return obj -> g.apply((StackSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stackSetName;
        private String stackSetId;
        private String description;
        private String status;
        private String templateBody;
        private List<Parameter> parameters = DefaultSdkAutoConstructList.getInstance();
        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String stackSetARN;
        private String administrationRoleARN;
        private String executionRoleName;
        private StackSetDriftDetectionDetails stackSetDriftDetectionDetails;
        private AutoDeployment autoDeployment;
        private String permissionModel;
        private List<String> organizationalUnitIds = DefaultSdkAutoConstructList.getInstance();
        private ManagedExecution managedExecution;
        private List<String> regions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StackSet model) {
            this.stackSetName(model.stackSetName);
            this.stackSetId(model.stackSetId);
            this.description(model.description);
            this.status(model.status);
            this.templateBody(model.templateBody);
            this.parameters(model.parameters);
            this.capabilitiesWithStrings(model.capabilities);
            this.tags(model.tags);
            this.stackSetARN(model.stackSetARN);
            this.administrationRoleARN(model.administrationRoleARN);
            this.executionRoleName(model.executionRoleName);
            this.stackSetDriftDetectionDetails(model.stackSetDriftDetectionDetails);
            this.autoDeployment(model.autoDeployment);
            this.permissionModel(model.permissionModel);
            this.organizationalUnitIds(model.organizationalUnitIds);
            this.managedExecution(model.managedExecution);
            this.regions(model.regions);
        }

        public final String getStackSetName() {
            return this.stackSetName;
        }

        public final void setStackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
        }

        @Override
        public final Builder stackSetName(String stackSetName) {
            this.stackSetName = stackSetName;
            return this;
        }

        public final String getStackSetId() {
            return this.stackSetId;
        }

        public final void setStackSetId(String stackSetId) {
            this.stackSetId = stackSetId;
        }

        @Override
        public final Builder stackSetId(String stackSetId) {
            this.stackSetId = stackSetId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StackSetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTemplateBody() {
            return this.templateBody;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final List<Parameter.Builder> getParameters() {
            List<Parameter.Builder> result = ParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<Parameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (Parameter)((Parameter.Builder)Parameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getCapabilities() {
            if (this.capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.capabilities;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        @Override
        public final Builder capabilitiesWithStrings(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilitiesWithStrings(String ... capabilities) {
            this.capabilitiesWithStrings(Arrays.asList(capabilities));
            return this;
        }

        @Override
        public final Builder capabilities(Collection<Capability> capabilities) {
            this.capabilities = CapabilitiesCopier.copyEnumToString(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Capability ... capabilities) {
            this.capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStackSetARN() {
            return this.stackSetARN;
        }

        public final void setStackSetARN(String stackSetARN) {
            this.stackSetARN = stackSetARN;
        }

        @Override
        public final Builder stackSetARN(String stackSetARN) {
            this.stackSetARN = stackSetARN;
            return this;
        }

        public final String getAdministrationRoleARN() {
            return this.administrationRoleARN;
        }

        public final void setAdministrationRoleARN(String administrationRoleARN) {
            this.administrationRoleARN = administrationRoleARN;
        }

        @Override
        public final Builder administrationRoleARN(String administrationRoleARN) {
            this.administrationRoleARN = administrationRoleARN;
            return this;
        }

        public final String getExecutionRoleName() {
            return this.executionRoleName;
        }

        public final void setExecutionRoleName(String executionRoleName) {
            this.executionRoleName = executionRoleName;
        }

        @Override
        public final Builder executionRoleName(String executionRoleName) {
            this.executionRoleName = executionRoleName;
            return this;
        }

        public final StackSetDriftDetectionDetails.Builder getStackSetDriftDetectionDetails() {
            return this.stackSetDriftDetectionDetails != null ? this.stackSetDriftDetectionDetails.toBuilder() : null;
        }

        public final void setStackSetDriftDetectionDetails(StackSetDriftDetectionDetails.BuilderImpl stackSetDriftDetectionDetails) {
            this.stackSetDriftDetectionDetails = stackSetDriftDetectionDetails != null ? stackSetDriftDetectionDetails.build() : null;
        }

        @Override
        public final Builder stackSetDriftDetectionDetails(StackSetDriftDetectionDetails stackSetDriftDetectionDetails) {
            this.stackSetDriftDetectionDetails = stackSetDriftDetectionDetails;
            return this;
        }

        public final AutoDeployment.Builder getAutoDeployment() {
            return this.autoDeployment != null ? this.autoDeployment.toBuilder() : null;
        }

        public final void setAutoDeployment(AutoDeployment.BuilderImpl autoDeployment) {
            this.autoDeployment = autoDeployment != null ? autoDeployment.build() : null;
        }

        @Override
        public final Builder autoDeployment(AutoDeployment autoDeployment) {
            this.autoDeployment = autoDeployment;
            return this;
        }

        public final String getPermissionModel() {
            return this.permissionModel;
        }

        public final void setPermissionModel(String permissionModel) {
            this.permissionModel = permissionModel;
        }

        @Override
        public final Builder permissionModel(String permissionModel) {
            this.permissionModel = permissionModel;
            return this;
        }

        @Override
        public final Builder permissionModel(PermissionModels permissionModel) {
            this.permissionModel(permissionModel == null ? null : permissionModel.toString());
            return this;
        }

        public final Collection<String> getOrganizationalUnitIds() {
            if (this.organizationalUnitIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.organizationalUnitIds;
        }

        public final void setOrganizationalUnitIds(Collection<String> organizationalUnitIds) {
            this.organizationalUnitIds = OrganizationalUnitIdListCopier.copy(organizationalUnitIds);
        }

        @Override
        public final Builder organizationalUnitIds(Collection<String> organizationalUnitIds) {
            this.organizationalUnitIds = OrganizationalUnitIdListCopier.copy(organizationalUnitIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnitIds(String ... organizationalUnitIds) {
            this.organizationalUnitIds(Arrays.asList(organizationalUnitIds));
            return this;
        }

        public final ManagedExecution.Builder getManagedExecution() {
            return this.managedExecution != null ? this.managedExecution.toBuilder() : null;
        }

        public final void setManagedExecution(ManagedExecution.BuilderImpl managedExecution) {
            this.managedExecution = managedExecution != null ? managedExecution.build() : null;
        }

        @Override
        public final Builder managedExecution(ManagedExecution managedExecution) {
            this.managedExecution = managedExecution;
            return this;
        }

        public final Collection<String> getRegions() {
            if (this.regions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        public StackSet build() {
            return new StackSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StackSet> {
        public Builder stackSetName(String var1);

        public Builder stackSetId(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(StackSetStatus var1);

        public Builder templateBody(String var1);

        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);

        public Builder parameters(Consumer<Parameter.Builder> ... var1);

        public Builder capabilitiesWithStrings(Collection<String> var1);

        public Builder capabilitiesWithStrings(String ... var1);

        public Builder capabilities(Collection<Capability> var1);

        public Builder capabilities(Capability ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder stackSetARN(String var1);

        public Builder administrationRoleARN(String var1);

        public Builder executionRoleName(String var1);

        public Builder stackSetDriftDetectionDetails(StackSetDriftDetectionDetails var1);

        default public Builder stackSetDriftDetectionDetails(Consumer<StackSetDriftDetectionDetails.Builder> stackSetDriftDetectionDetails) {
            return this.stackSetDriftDetectionDetails((StackSetDriftDetectionDetails)((StackSetDriftDetectionDetails.Builder)StackSetDriftDetectionDetails.builder().applyMutation(stackSetDriftDetectionDetails)).build());
        }

        public Builder autoDeployment(AutoDeployment var1);

        default public Builder autoDeployment(Consumer<AutoDeployment.Builder> autoDeployment) {
            return this.autoDeployment((AutoDeployment)((AutoDeployment.Builder)AutoDeployment.builder().applyMutation(autoDeployment)).build());
        }

        public Builder permissionModel(String var1);

        public Builder permissionModel(PermissionModels var1);

        public Builder organizationalUnitIds(Collection<String> var1);

        public Builder organizationalUnitIds(String ... var1);

        public Builder managedExecution(ManagedExecution var1);

        default public Builder managedExecution(Consumer<ManagedExecution.Builder> managedExecution) {
            return this.managedExecution((ManagedExecution)((ManagedExecution.Builder)ManagedExecution.builder().applyMutation(managedExecution)).build());
        }

        public Builder regions(Collection<String> var1);

        public Builder regions(String ... var1);
    }
}

