/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the resource, the hook, and the hook version to be invoked.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChangeSetHook implements SdkPojo, Serializable, ToCopyableBuilder<ChangeSetHook.Builder, ChangeSetHook> {
    private static final SdkField<String> INVOCATION_POINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvocationPoint").getter(getter(ChangeSetHook::invocationPointAsString))
            .setter(setter(Builder::invocationPoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationPoint").build()).build();

    private static final SdkField<String> FAILURE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureMode").getter(getter(ChangeSetHook::failureModeAsString)).setter(setter(Builder::failureMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMode").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(ChangeSetHook::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> TYPE_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeVersionId").getter(getter(ChangeSetHook::typeVersionId)).setter(setter(Builder::typeVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeVersionId").build()).build();

    private static final SdkField<String> TYPE_CONFIGURATION_VERSION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TypeConfigurationVersionId")
            .getter(getter(ChangeSetHook::typeConfigurationVersionId))
            .setter(setter(Builder::typeConfigurationVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeConfigurationVersionId").build())
            .build();

    private static final SdkField<ChangeSetHookTargetDetails> TARGET_DETAILS_FIELD = SdkField
            .<ChangeSetHookTargetDetails> builder(MarshallingType.SDK_POJO).memberName("TargetDetails")
            .getter(getter(ChangeSetHook::targetDetails)).setter(setter(Builder::targetDetails))
            .constructor(ChangeSetHookTargetDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(INVOCATION_POINT_FIELD, FAILURE_MODE_FIELD, TYPE_NAME_FIELD, TYPE_VERSION_ID_FIELD,
                    TYPE_CONFIGURATION_VERSION_ID_FIELD, TARGET_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String invocationPoint;

    private final String failureMode;

    private final String typeName;

    private final String typeVersionId;

    private final String typeConfigurationVersionId;

    private final ChangeSetHookTargetDetails targetDetails;

    private ChangeSetHook(BuilderImpl builder) {
        this.invocationPoint = builder.invocationPoint;
        this.failureMode = builder.failureMode;
        this.typeName = builder.typeName;
        this.typeVersionId = builder.typeVersionId;
        this.typeConfigurationVersionId = builder.typeConfigurationVersionId;
        this.targetDetails = builder.targetDetails;
    }

    /**
     * <p>
     * Specifies the points in provisioning logic where a hook is invoked.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invocationPoint}
     * will return {@link HookInvocationPoint#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #invocationPointAsString}.
     * </p>
     * 
     * @return Specifies the points in provisioning logic where a hook is invoked.
     * @see HookInvocationPoint
     */
    public final HookInvocationPoint invocationPoint() {
        return HookInvocationPoint.fromValue(invocationPoint);
    }

    /**
     * <p>
     * Specifies the points in provisioning logic where a hook is invoked.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invocationPoint}
     * will return {@link HookInvocationPoint#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #invocationPointAsString}.
     * </p>
     * 
     * @return Specifies the points in provisioning logic where a hook is invoked.
     * @see HookInvocationPoint
     */
    public final String invocationPointAsString() {
        return invocationPoint;
    }

    /**
     * <p>
     * Specify the hook failure mode for non-compliant resources in the followings ways.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FAIL</code> Stops provisioning resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WARN</code> Allows provisioning to continue with a warning message.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureMode} will
     * return {@link HookFailureMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #failureModeAsString}.
     * </p>
     * 
     * @return Specify the hook failure mode for non-compliant resources in the followings ways.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FAIL</code> Stops provisioning resources.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WARN</code> Allows provisioning to continue with a warning message.
     *         </p>
     *         </li>
     * @see HookFailureMode
     */
    public final HookFailureMode failureMode() {
        return HookFailureMode.fromValue(failureMode);
    }

    /**
     * <p>
     * Specify the hook failure mode for non-compliant resources in the followings ways.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FAIL</code> Stops provisioning resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>WARN</code> Allows provisioning to continue with a warning message.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureMode} will
     * return {@link HookFailureMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #failureModeAsString}.
     * </p>
     * 
     * @return Specify the hook failure mode for non-compliant resources in the followings ways.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FAIL</code> Stops provisioning resources.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>WARN</code> Allows provisioning to continue with a warning message.
     *         </p>
     *         </li>
     * @see HookFailureMode
     */
    public final String failureModeAsString() {
        return failureMode;
    }

    /**
     * <p>
     * The unique name for your hook. Specifies a three-part namespace for your hook, with a recommended pattern of
     * <code>Organization::Service::Hook</code>.
     * </p>
     * <note>
     * <p>
     * The following organization namespaces are reserved and can't be used in your hook type names:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Alexa</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AMZN</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Amazon</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ASK</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Custom</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Dev</code>
     * </p>
     * </li>
     * </ul>
     * </note>
     * 
     * @return The unique name for your hook. Specifies a three-part namespace for your hook, with a recommended pattern
     *         of <code>Organization::Service::Hook</code>.</p> <note>
     *         <p>
     *         The following organization namespaces are reserved and can't be used in your hook type names:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Alexa</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AMZN</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Amazon</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ASK</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Custom</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Dev</code>
     *         </p>
     *         </li>
     *         </ul>
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The version ID of the type specified.
     * </p>
     * 
     * @return The version ID of the type specified.
     */
    public final String typeVersionId() {
        return typeVersionId;
    }

    /**
     * <p>
     * The version ID of the type configuration.
     * </p>
     * 
     * @return The version ID of the type configuration.
     */
    public final String typeConfigurationVersionId() {
        return typeConfigurationVersionId;
    }

    /**
     * <p>
     * Specifies details about the target that the hook will run against.
     * </p>
     * 
     * @return Specifies details about the target that the hook will run against.
     */
    public final ChangeSetHookTargetDetails targetDetails() {
        return targetDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(invocationPointAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(typeVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(typeConfigurationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(targetDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeSetHook)) {
            return false;
        }
        ChangeSetHook other = (ChangeSetHook) obj;
        return Objects.equals(invocationPointAsString(), other.invocationPointAsString())
                && Objects.equals(failureModeAsString(), other.failureModeAsString())
                && Objects.equals(typeName(), other.typeName()) && Objects.equals(typeVersionId(), other.typeVersionId())
                && Objects.equals(typeConfigurationVersionId(), other.typeConfigurationVersionId())
                && Objects.equals(targetDetails(), other.targetDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChangeSetHook").add("InvocationPoint", invocationPointAsString())
                .add("FailureMode", failureModeAsString()).add("TypeName", typeName()).add("TypeVersionId", typeVersionId())
                .add("TypeConfigurationVersionId", typeConfigurationVersionId()).add("TargetDetails", targetDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InvocationPoint":
            return Optional.ofNullable(clazz.cast(invocationPointAsString()));
        case "FailureMode":
            return Optional.ofNullable(clazz.cast(failureModeAsString()));
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "TypeVersionId":
            return Optional.ofNullable(clazz.cast(typeVersionId()));
        case "TypeConfigurationVersionId":
            return Optional.ofNullable(clazz.cast(typeConfigurationVersionId()));
        case "TargetDetails":
            return Optional.ofNullable(clazz.cast(targetDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InvocationPoint", INVOCATION_POINT_FIELD);
        map.put("FailureMode", FAILURE_MODE_FIELD);
        map.put("TypeName", TYPE_NAME_FIELD);
        map.put("TypeVersionId", TYPE_VERSION_ID_FIELD);
        map.put("TypeConfigurationVersionId", TYPE_CONFIGURATION_VERSION_ID_FIELD);
        map.put("TargetDetails", TARGET_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChangeSetHook, T> g) {
        return obj -> g.apply((ChangeSetHook) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChangeSetHook> {
        /**
         * <p>
         * Specifies the points in provisioning logic where a hook is invoked.
         * </p>
         * 
         * @param invocationPoint
         *        Specifies the points in provisioning logic where a hook is invoked.
         * @see HookInvocationPoint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookInvocationPoint
         */
        Builder invocationPoint(String invocationPoint);

        /**
         * <p>
         * Specifies the points in provisioning logic where a hook is invoked.
         * </p>
         * 
         * @param invocationPoint
         *        Specifies the points in provisioning logic where a hook is invoked.
         * @see HookInvocationPoint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookInvocationPoint
         */
        Builder invocationPoint(HookInvocationPoint invocationPoint);

        /**
         * <p>
         * Specify the hook failure mode for non-compliant resources in the followings ways.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FAIL</code> Stops provisioning resources.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WARN</code> Allows provisioning to continue with a warning message.
         * </p>
         * </li>
         * </ul>
         * 
         * @param failureMode
         *        Specify the hook failure mode for non-compliant resources in the followings ways.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FAIL</code> Stops provisioning resources.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WARN</code> Allows provisioning to continue with a warning message.
         *        </p>
         *        </li>
         * @see HookFailureMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookFailureMode
         */
        Builder failureMode(String failureMode);

        /**
         * <p>
         * Specify the hook failure mode for non-compliant resources in the followings ways.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FAIL</code> Stops provisioning resources.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>WARN</code> Allows provisioning to continue with a warning message.
         * </p>
         * </li>
         * </ul>
         * 
         * @param failureMode
         *        Specify the hook failure mode for non-compliant resources in the followings ways.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FAIL</code> Stops provisioning resources.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>WARN</code> Allows provisioning to continue with a warning message.
         *        </p>
         *        </li>
         * @see HookFailureMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookFailureMode
         */
        Builder failureMode(HookFailureMode failureMode);

        /**
         * <p>
         * The unique name for your hook. Specifies a three-part namespace for your hook, with a recommended pattern of
         * <code>Organization::Service::Hook</code>.
         * </p>
         * <note>
         * <p>
         * The following organization namespaces are reserved and can't be used in your hook type names:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Alexa</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AMZN</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Amazon</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ASK</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Custom</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Dev</code>
         * </p>
         * </li>
         * </ul>
         * </note>
         * 
         * @param typeName
         *        The unique name for your hook. Specifies a three-part namespace for your hook, with a recommended
         *        pattern of <code>Organization::Service::Hook</code>.</p> <note>
         *        <p>
         *        The following organization namespaces are reserved and can't be used in your hook type names:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Alexa</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AMZN</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Amazon</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ASK</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Custom</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Dev</code>
         *        </p>
         *        </li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The version ID of the type specified.
         * </p>
         * 
         * @param typeVersionId
         *        The version ID of the type specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeVersionId(String typeVersionId);

        /**
         * <p>
         * The version ID of the type configuration.
         * </p>
         * 
         * @param typeConfigurationVersionId
         *        The version ID of the type configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeConfigurationVersionId(String typeConfigurationVersionId);

        /**
         * <p>
         * Specifies details about the target that the hook will run against.
         * </p>
         * 
         * @param targetDetails
         *        Specifies details about the target that the hook will run against.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDetails(ChangeSetHookTargetDetails targetDetails);

        /**
         * <p>
         * Specifies details about the target that the hook will run against.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChangeSetHookTargetDetails.Builder}
         * avoiding the need to create one manually via {@link ChangeSetHookTargetDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChangeSetHookTargetDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #targetDetails(ChangeSetHookTargetDetails)}.
         * 
         * @param targetDetails
         *        a consumer that will call methods on {@link ChangeSetHookTargetDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetDetails(ChangeSetHookTargetDetails)
         */
        default Builder targetDetails(Consumer<ChangeSetHookTargetDetails.Builder> targetDetails) {
            return targetDetails(ChangeSetHookTargetDetails.builder().applyMutation(targetDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String invocationPoint;

        private String failureMode;

        private String typeName;

        private String typeVersionId;

        private String typeConfigurationVersionId;

        private ChangeSetHookTargetDetails targetDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeSetHook model) {
            invocationPoint(model.invocationPoint);
            failureMode(model.failureMode);
            typeName(model.typeName);
            typeVersionId(model.typeVersionId);
            typeConfigurationVersionId(model.typeConfigurationVersionId);
            targetDetails(model.targetDetails);
        }

        public final String getInvocationPoint() {
            return invocationPoint;
        }

        public final void setInvocationPoint(String invocationPoint) {
            this.invocationPoint = invocationPoint;
        }

        @Override
        public final Builder invocationPoint(String invocationPoint) {
            this.invocationPoint = invocationPoint;
            return this;
        }

        @Override
        public final Builder invocationPoint(HookInvocationPoint invocationPoint) {
            this.invocationPoint(invocationPoint == null ? null : invocationPoint.toString());
            return this;
        }

        public final String getFailureMode() {
            return failureMode;
        }

        public final void setFailureMode(String failureMode) {
            this.failureMode = failureMode;
        }

        @Override
        public final Builder failureMode(String failureMode) {
            this.failureMode = failureMode;
            return this;
        }

        @Override
        public final Builder failureMode(HookFailureMode failureMode) {
            this.failureMode(failureMode == null ? null : failureMode.toString());
            return this;
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getTypeVersionId() {
            return typeVersionId;
        }

        public final void setTypeVersionId(String typeVersionId) {
            this.typeVersionId = typeVersionId;
        }

        @Override
        public final Builder typeVersionId(String typeVersionId) {
            this.typeVersionId = typeVersionId;
            return this;
        }

        public final String getTypeConfigurationVersionId() {
            return typeConfigurationVersionId;
        }

        public final void setTypeConfigurationVersionId(String typeConfigurationVersionId) {
            this.typeConfigurationVersionId = typeConfigurationVersionId;
        }

        @Override
        public final Builder typeConfigurationVersionId(String typeConfigurationVersionId) {
            this.typeConfigurationVersionId = typeConfigurationVersionId;
            return this;
        }

        public final ChangeSetHookTargetDetails.Builder getTargetDetails() {
            return targetDetails != null ? targetDetails.toBuilder() : null;
        }

        public final void setTargetDetails(ChangeSetHookTargetDetails.BuilderImpl targetDetails) {
            this.targetDetails = targetDetails != null ? targetDetails.build() : null;
        }

        @Override
        public final Builder targetDetails(ChangeSetHookTargetDetails targetDetails) {
            this.targetDetails = targetDetails;
            return this;
        }

        @Override
        public ChangeSetHook build() {
            return new ChangeSetHook(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
