/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStackRefactorsRequest extends CloudFormationRequest implements
        ToCopyableBuilder<ListStackRefactorsRequest.Builder, ListStackRefactorsRequest> {
    private static final SdkField<List<String>> EXECUTION_STATUS_FILTER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExecutionStatusFilter")
            .getter(getter(ListStackRefactorsRequest::executionStatusFilterAsStrings))
            .setter(setter(Builder::executionStatusFilterWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStatusFilter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListStackRefactorsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListStackRefactorsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_STATUS_FILTER_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> executionStatusFilter;

    private final String nextToken;

    private final Integer maxResults;

    private ListStackRefactorsRequest(BuilderImpl builder) {
        super(builder);
        this.executionStatusFilter = builder.executionStatusFilter;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * Execution status to use as a filter. Specify one or more execution status codes to list only stack refactors with
     * the specified execution status codes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExecutionStatusFilter} method.
     * </p>
     * 
     * @return Execution status to use as a filter. Specify one or more execution status codes to list only stack
     *         refactors with the specified execution status codes.
     */
    public final List<StackRefactorExecutionStatus> executionStatusFilter() {
        return StackRefactorExecutionStatusFilterCopier.copyStringToEnum(executionStatusFilter);
    }

    /**
     * For responses, this returns true if the service returned a value for the ExecutionStatusFilter property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasExecutionStatusFilter() {
        return executionStatusFilter != null && !(executionStatusFilter instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Execution status to use as a filter. Specify one or more execution status codes to list only stack refactors with
     * the specified execution status codes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExecutionStatusFilter} method.
     * </p>
     * 
     * @return Execution status to use as a filter. Specify one or more execution status codes to list only stack
     *         refactors with the specified execution status codes.
     */
    public final List<String> executionStatusFilterAsStrings() {
        return executionStatusFilter;
    }

    /**
     * <p>
     * If the request doesn't return all the remaining results, <code>NextToken</code> is set to a token. To retrieve
     * the next set of results, call this action again and assign that token to the request object's
     * <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to
     * <code>null</code>.
     * </p>
     * 
     * @return If the request doesn't return all the remaining results, <code>NextToken</code> is set to a token. To
     *         retrieve the next set of results, call this action again and assign that token to the request object's
     *         <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to
     *         <code>null</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to be returned with a single call. If the number of available results exceeds this
     * maximum, the response includes a <code>NextToken</code> value that you can assign to the <code>NextToken</code>
     * request parameter to get the next set of results.
     * </p>
     * 
     * @return The maximum number of results to be returned with a single call. If the number of available results
     *         exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the
     *         <code>NextToken</code> request parameter to get the next set of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasExecutionStatusFilter() ? executionStatusFilterAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStackRefactorsRequest)) {
            return false;
        }
        ListStackRefactorsRequest other = (ListStackRefactorsRequest) obj;
        return hasExecutionStatusFilter() == other.hasExecutionStatusFilter()
                && Objects.equals(executionStatusFilterAsStrings(), other.executionStatusFilterAsStrings())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStackRefactorsRequest")
                .add("ExecutionStatusFilter", hasExecutionStatusFilter() ? executionStatusFilterAsStrings() : null)
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExecutionStatusFilter":
            return Optional.ofNullable(clazz.cast(executionStatusFilterAsStrings()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ExecutionStatusFilter", EXECUTION_STATUS_FILTER_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListStackRefactorsRequest, T> g) {
        return obj -> g.apply((ListStackRefactorsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListStackRefactorsRequest> {
        /**
         * <p>
         * Execution status to use as a filter. Specify one or more execution status codes to list only stack refactors
         * with the specified execution status codes.
         * </p>
         * 
         * @param executionStatusFilter
         *        Execution status to use as a filter. Specify one or more execution status codes to list only stack
         *        refactors with the specified execution status codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStatusFilterWithStrings(Collection<String> executionStatusFilter);

        /**
         * <p>
         * Execution status to use as a filter. Specify one or more execution status codes to list only stack refactors
         * with the specified execution status codes.
         * </p>
         * 
         * @param executionStatusFilter
         *        Execution status to use as a filter. Specify one or more execution status codes to list only stack
         *        refactors with the specified execution status codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStatusFilterWithStrings(String... executionStatusFilter);

        /**
         * <p>
         * Execution status to use as a filter. Specify one or more execution status codes to list only stack refactors
         * with the specified execution status codes.
         * </p>
         * 
         * @param executionStatusFilter
         *        Execution status to use as a filter. Specify one or more execution status codes to list only stack
         *        refactors with the specified execution status codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStatusFilter(Collection<StackRefactorExecutionStatus> executionStatusFilter);

        /**
         * <p>
         * Execution status to use as a filter. Specify one or more execution status codes to list only stack refactors
         * with the specified execution status codes.
         * </p>
         * 
         * @param executionStatusFilter
         *        Execution status to use as a filter. Specify one or more execution status codes to list only stack
         *        refactors with the specified execution status codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStatusFilter(StackRefactorExecutionStatus... executionStatusFilter);

        /**
         * <p>
         * If the request doesn't return all the remaining results, <code>NextToken</code> is set to a token. To
         * retrieve the next set of results, call this action again and assign that token to the request object's
         * <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to
         * <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If the request doesn't return all the remaining results, <code>NextToken</code> is set to a token. To
         *        retrieve the next set of results, call this action again and assign that token to the request object's
         *        <code>NextToken</code> parameter. If the request returns all results, <code>NextToken</code> is set to
         *        <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to be returned with a single call. If the number of available results exceeds
         * this maximum, the response includes a <code>NextToken</code> value that you can assign to the
         * <code>NextToken</code> request parameter to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to be returned with a single call. If the number of available results
         *        exceeds this maximum, the response includes a <code>NextToken</code> value that you can assign to the
         *        <code>NextToken</code> request parameter to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private List<String> executionStatusFilter = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStackRefactorsRequest model) {
            super(model);
            executionStatusFilterWithStrings(model.executionStatusFilter);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<String> getExecutionStatusFilter() {
            if (executionStatusFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return executionStatusFilter;
        }

        public final void setExecutionStatusFilter(Collection<String> executionStatusFilter) {
            this.executionStatusFilter = StackRefactorExecutionStatusFilterCopier.copy(executionStatusFilter);
        }

        @Override
        public final Builder executionStatusFilterWithStrings(Collection<String> executionStatusFilter) {
            this.executionStatusFilter = StackRefactorExecutionStatusFilterCopier.copy(executionStatusFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionStatusFilterWithStrings(String... executionStatusFilter) {
            executionStatusFilterWithStrings(Arrays.asList(executionStatusFilter));
            return this;
        }

        @Override
        public final Builder executionStatusFilter(Collection<StackRefactorExecutionStatus> executionStatusFilter) {
            this.executionStatusFilter = StackRefactorExecutionStatusFilterCopier.copyEnumToString(executionStatusFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionStatusFilter(StackRefactorExecutionStatus... executionStatusFilter) {
            executionStatusFilter(Arrays.asList(executionStatusFilter));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListStackRefactorsRequest build() {
            return new ListStackRefactorsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
