/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <a>DeleteChangeSet</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteChangeSetRequest extends CloudFormationRequest implements
        ToCopyableBuilder<DeleteChangeSetRequest.Builder, DeleteChangeSetRequest> {
    private static final SdkField<String> CHANGE_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeSetName").getter(getter(DeleteChangeSetRequest::changeSetName))
            .setter(setter(Builder::changeSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetName").build()).build();

    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackName").getter(getter(DeleteChangeSetRequest::stackName)).setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGE_SET_NAME_FIELD,
            STACK_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String changeSetName;

    private final String stackName;

    private DeleteChangeSetRequest(BuilderImpl builder) {
        super(builder);
        this.changeSetName = builder.changeSetName;
        this.stackName = builder.stackName;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the change set that you want to delete.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the change set that you want to delete.
     */
    public final String changeSetName() {
        return changeSetName;
    }

    /**
     * <p>
     * If you specified the name of a change set to delete, specify the stack name or Amazon Resource Name (ARN) that's
     * associated with it.
     * </p>
     * 
     * @return If you specified the name of a change set to delete, specify the stack name or Amazon Resource Name (ARN)
     *         that's associated with it.
     */
    public final String stackName() {
        return stackName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(changeSetName());
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteChangeSetRequest)) {
            return false;
        }
        DeleteChangeSetRequest other = (DeleteChangeSetRequest) obj;
        return Objects.equals(changeSetName(), other.changeSetName()) && Objects.equals(stackName(), other.stackName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteChangeSetRequest").add("ChangeSetName", changeSetName()).add("StackName", stackName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChangeSetName":
            return Optional.ofNullable(clazz.cast(changeSetName()));
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ChangeSetName", CHANGE_SET_NAME_FIELD);
        map.put("StackName", STACK_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteChangeSetRequest, T> g) {
        return obj -> g.apply((DeleteChangeSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteChangeSetRequest> {
        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the change set that you want to delete.
         * </p>
         * 
         * @param changeSetName
         *        The name or Amazon Resource Name (ARN) of the change set that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeSetName(String changeSetName);

        /**
         * <p>
         * If you specified the name of a change set to delete, specify the stack name or Amazon Resource Name (ARN)
         * that's associated with it.
         * </p>
         * 
         * @param stackName
         *        If you specified the name of a change set to delete, specify the stack name or Amazon Resource Name
         *        (ARN) that's associated with it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String changeSetName;

        private String stackName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteChangeSetRequest model) {
            super(model);
            changeSetName(model.changeSetName);
            stackName(model.stackName);
        }

        public final String getChangeSetName() {
            return changeSetName;
        }

        public final void setChangeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
        }

        @Override
        public final Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public final String getStackName() {
            return stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteChangeSetRequest build() {
            return new DeleteChangeSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
