/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.StackRefactorSummariesCopier;
import software.amazon.awssdk.services.cloudformation.model.StackRefactorSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStackRefactorsResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, ListStackRefactorsResponse> {
    private static final SdkField<List<StackRefactorSummary>> STACK_REFACTOR_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StackRefactorSummaries").getter(ListStackRefactorsResponse.getter(ListStackRefactorsResponse::stackRefactorSummaries)).setter(ListStackRefactorsResponse.setter(Builder::stackRefactorSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackRefactorSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StackRefactorSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListStackRefactorsResponse.getter(ListStackRefactorsResponse::nextToken)).setter(ListStackRefactorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_REFACTOR_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListStackRefactorsResponse.memberNameToFieldInitializer();
    private final List<StackRefactorSummary> stackRefactorSummaries;
    private final String nextToken;

    private ListStackRefactorsResponse(BuilderImpl builder) {
        super(builder);
        this.stackRefactorSummaries = builder.stackRefactorSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasStackRefactorSummaries() {
        return this.stackRefactorSummaries != null && !(this.stackRefactorSummaries instanceof SdkAutoConstructList);
    }

    public final List<StackRefactorSummary> stackRefactorSummaries() {
        return this.stackRefactorSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStackRefactorSummaries() ? this.stackRefactorSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStackRefactorsResponse)) {
            return false;
        }
        ListStackRefactorsResponse other = (ListStackRefactorsResponse)((Object)obj);
        return this.hasStackRefactorSummaries() == other.hasStackRefactorSummaries() && Objects.equals(this.stackRefactorSummaries(), other.stackRefactorSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListStackRefactorsResponse").add("StackRefactorSummaries", this.hasStackRefactorSummaries() ? this.stackRefactorSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackRefactorSummaries": {
                return Optional.ofNullable(clazz.cast(this.stackRefactorSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StackRefactorSummaries", STACK_REFACTOR_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListStackRefactorsResponse, T> g) {
        return obj -> g.apply((ListStackRefactorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private List<StackRefactorSummary> stackRefactorSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStackRefactorsResponse model) {
            super(model);
            this.stackRefactorSummaries(model.stackRefactorSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<StackRefactorSummary.Builder> getStackRefactorSummaries() {
            List<StackRefactorSummary.Builder> result = StackRefactorSummariesCopier.copyToBuilder(this.stackRefactorSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStackRefactorSummaries(Collection<StackRefactorSummary.BuilderImpl> stackRefactorSummaries) {
            this.stackRefactorSummaries = StackRefactorSummariesCopier.copyFromBuilder(stackRefactorSummaries);
        }

        @Override
        public final Builder stackRefactorSummaries(Collection<StackRefactorSummary> stackRefactorSummaries) {
            this.stackRefactorSummaries = StackRefactorSummariesCopier.copy(stackRefactorSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackRefactorSummaries(StackRefactorSummary ... stackRefactorSummaries) {
            this.stackRefactorSummaries(Arrays.asList(stackRefactorSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackRefactorSummaries(Consumer<StackRefactorSummary.Builder> ... stackRefactorSummaries) {
            this.stackRefactorSummaries(Stream.of(stackRefactorSummaries).map(c -> (StackRefactorSummary)((StackRefactorSummary.Builder)StackRefactorSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListStackRefactorsResponse build() {
            return new ListStackRefactorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStackRefactorsResponse> {
        public Builder stackRefactorSummaries(Collection<StackRefactorSummary> var1);

        public Builder stackRefactorSummaries(StackRefactorSummary ... var1);

        public Builder stackRefactorSummaries(Consumer<StackRefactorSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

