/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.ThirdPartyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetTypeConfigurationRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, SetTypeConfigurationRequest> {
    private static final SdkField<String> TYPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeArn").getter(SetTypeConfigurationRequest.getter(SetTypeConfigurationRequest::typeArn)).setter(SetTypeConfigurationRequest.setter(Builder::typeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeArn").build()}).build();
    private static final SdkField<String> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Configuration").getter(SetTypeConfigurationRequest.getter(SetTypeConfigurationRequest::configuration)).setter(SetTypeConfigurationRequest.setter(Builder::configuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()}).build();
    private static final SdkField<String> CONFIGURATION_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationAlias").getter(SetTypeConfigurationRequest.getter(SetTypeConfigurationRequest::configurationAlias)).setter(SetTypeConfigurationRequest.setter(Builder::configurationAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationAlias").build()}).build();
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeName").getter(SetTypeConfigurationRequest.getter(SetTypeConfigurationRequest::typeName)).setter(SetTypeConfigurationRequest.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(SetTypeConfigurationRequest.getter(SetTypeConfigurationRequest::typeAsString)).setter(SetTypeConfigurationRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_ARN_FIELD, CONFIGURATION_FIELD, CONFIGURATION_ALIAS_FIELD, TYPE_NAME_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SetTypeConfigurationRequest.memberNameToFieldInitializer();
    private final String typeArn;
    private final String configuration;
    private final String configurationAlias;
    private final String typeName;
    private final String type;

    private SetTypeConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.typeArn = builder.typeArn;
        this.configuration = builder.configuration;
        this.configurationAlias = builder.configurationAlias;
        this.typeName = builder.typeName;
        this.type = builder.type;
    }

    public final String typeArn() {
        return this.typeArn;
    }

    public final String configuration() {
        return this.configuration;
    }

    public final String configurationAlias() {
        return this.configurationAlias;
    }

    public final String typeName() {
        return this.typeName;
    }

    public final ThirdPartyType type() {
        return ThirdPartyType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.typeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetTypeConfigurationRequest)) {
            return false;
        }
        SetTypeConfigurationRequest other = (SetTypeConfigurationRequest)((Object)obj);
        return Objects.equals(this.typeArn(), other.typeArn()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.configurationAlias(), other.configurationAlias()) && Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SetTypeConfigurationRequest").add("TypeArn", (Object)this.typeArn()).add("Configuration", (Object)this.configuration()).add("ConfigurationAlias", (Object)this.configurationAlias()).add("TypeName", (Object)this.typeName()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TypeArn": {
                return Optional.ofNullable(clazz.cast(this.typeArn()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "ConfigurationAlias": {
                return Optional.ofNullable(clazz.cast(this.configurationAlias()));
            }
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("TypeArn", TYPE_ARN_FIELD);
        map.put("Configuration", CONFIGURATION_FIELD);
        map.put("ConfigurationAlias", CONFIGURATION_ALIAS_FIELD);
        map.put("TypeName", TYPE_NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SetTypeConfigurationRequest, T> g) {
        return obj -> g.apply((SetTypeConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String typeArn;
        private String configuration;
        private String configurationAlias;
        private String typeName;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(SetTypeConfigurationRequest model) {
            super(model);
            this.typeArn(model.typeArn);
            this.configuration(model.configuration);
            this.configurationAlias(model.configurationAlias);
            this.typeName(model.typeName);
            this.type(model.type);
        }

        public final String getTypeArn() {
            return this.typeArn;
        }

        public final void setTypeArn(String typeArn) {
            this.typeArn = typeArn;
        }

        @Override
        public final Builder typeArn(String typeArn) {
            this.typeArn = typeArn;
            return this;
        }

        public final String getConfiguration() {
            return this.configuration;
        }

        public final void setConfiguration(String configuration) {
            this.configuration = configuration;
        }

        @Override
        public final Builder configuration(String configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getConfigurationAlias() {
            return this.configurationAlias;
        }

        public final void setConfigurationAlias(String configurationAlias) {
            this.configurationAlias = configurationAlias;
        }

        @Override
        public final Builder configurationAlias(String configurationAlias) {
            this.configurationAlias = configurationAlias;
            return this;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ThirdPartyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetTypeConfigurationRequest build() {
            return new SetTypeConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SetTypeConfigurationRequest> {
        public Builder typeArn(String var1);

        public Builder configuration(String var1);

        public Builder configurationAlias(String var1);

        public Builder typeName(String var1);

        public Builder type(String var1);

        public Builder type(ThirdPartyType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

