/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.HookStatus;
import software.amazon.awssdk.services.cloudformation.model.ListHookResultsTargetType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListHookResultsRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, ListHookResultsRequest> {
    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetType").getter(ListHookResultsRequest.getter(ListHookResultsRequest::targetTypeAsString)).setter(ListHookResultsRequest.setter(Builder::targetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()}).build();
    private static final SdkField<String> TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetId").getter(ListHookResultsRequest.getter(ListHookResultsRequest::targetId)).setter(ListHookResultsRequest.setter(Builder::targetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetId").build()}).build();
    private static final SdkField<String> TYPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeArn").getter(ListHookResultsRequest.getter(ListHookResultsRequest::typeArn)).setter(ListHookResultsRequest.setter(Builder::typeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ListHookResultsRequest.getter(ListHookResultsRequest::statusAsString)).setter(ListHookResultsRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListHookResultsRequest.getter(ListHookResultsRequest::nextToken)).setter(ListHookResultsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_TYPE_FIELD, TARGET_ID_FIELD, TYPE_ARN_FIELD, STATUS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListHookResultsRequest.memberNameToFieldInitializer();
    private final String targetType;
    private final String targetId;
    private final String typeArn;
    private final String status;
    private final String nextToken;

    private ListHookResultsRequest(BuilderImpl builder) {
        super(builder);
        this.targetType = builder.targetType;
        this.targetId = builder.targetId;
        this.typeArn = builder.typeArn;
        this.status = builder.status;
        this.nextToken = builder.nextToken;
    }

    public final ListHookResultsTargetType targetType() {
        return ListHookResultsTargetType.fromValue(this.targetType);
    }

    public final String targetTypeAsString() {
        return this.targetType;
    }

    public final String targetId() {
        return this.targetId;
    }

    public final String typeArn() {
        return this.typeArn;
    }

    public final HookStatus status() {
        return HookStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHookResultsRequest)) {
            return false;
        }
        ListHookResultsRequest other = (ListHookResultsRequest)((Object)obj);
        return Objects.equals(this.targetTypeAsString(), other.targetTypeAsString()) && Objects.equals(this.targetId(), other.targetId()) && Objects.equals(this.typeArn(), other.typeArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListHookResultsRequest").add("TargetType", (Object)this.targetTypeAsString()).add("TargetId", (Object)this.targetId()).add("TypeArn", (Object)this.typeArn()).add("Status", (Object)this.statusAsString()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetType": {
                return Optional.ofNullable(clazz.cast(this.targetTypeAsString()));
            }
            case "TargetId": {
                return Optional.ofNullable(clazz.cast(this.targetId()));
            }
            case "TypeArn": {
                return Optional.ofNullable(clazz.cast(this.typeArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("TargetType", TARGET_TYPE_FIELD);
        map.put("TargetId", TARGET_ID_FIELD);
        map.put("TypeArn", TYPE_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListHookResultsRequest, T> g) {
        return obj -> g.apply((ListHookResultsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String targetType;
        private String targetId;
        private String typeArn;
        private String status;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHookResultsRequest model) {
            super(model);
            this.targetType(model.targetType);
            this.targetId(model.targetId);
            this.typeArn(model.typeArn);
            this.status(model.status);
            this.nextToken(model.nextToken);
        }

        public final String getTargetType() {
            return this.targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(ListHookResultsTargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        public final String getTargetId() {
            return this.targetId;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final String getTypeArn() {
            return this.typeArn;
        }

        public final void setTypeArn(String typeArn) {
            this.typeArn = typeArn;
        }

        @Override
        public final Builder typeArn(String typeArn) {
            this.typeArn = typeArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(HookStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListHookResultsRequest build() {
            return new ListHookResultsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListHookResultsRequest> {
        public Builder targetType(String var1);

        public Builder targetType(ListHookResultsTargetType var1);

        public Builder targetId(String var1);

        public Builder typeArn(String var1);

        public Builder status(String var1);

        public Builder status(HookStatus var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

