/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetHookResultRequest extends CloudFormationRequest implements
        ToCopyableBuilder<GetHookResultRequest.Builder, GetHookResultRequest> {
    private static final SdkField<String> HOOK_RESULT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HookResultId").getter(getter(GetHookResultRequest::hookResultId)).setter(setter(Builder::hookResultId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookResultId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOOK_RESULT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String hookResultId;

    private GetHookResultRequest(BuilderImpl builder) {
        super(builder);
        this.hookResultId = builder.hookResultId;
    }

    /**
     * <p>
     * The unique identifier (ID) of the Hook invocation result that you want details about. You can get the ID from the
     * <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListHookResults.html">
     * ListHookResults</a> operation.
     * </p>
     * 
     * @return The unique identifier (ID) of the Hook invocation result that you want details about. You can get the ID
     *         from the <a
     *         href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListHookResults.html"
     *         >ListHookResults</a> operation.
     */
    public final String hookResultId() {
        return hookResultId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hookResultId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHookResultRequest)) {
            return false;
        }
        GetHookResultRequest other = (GetHookResultRequest) obj;
        return Objects.equals(hookResultId(), other.hookResultId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetHookResultRequest").add("HookResultId", hookResultId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HookResultId":
            return Optional.ofNullable(clazz.cast(hookResultId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HookResultId", HOOK_RESULT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetHookResultRequest, T> g) {
        return obj -> g.apply((GetHookResultRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFormationRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetHookResultRequest> {
        /**
         * <p>
         * The unique identifier (ID) of the Hook invocation result that you want details about. You can get the ID from
         * the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListHookResults.html">
         * ListHookResults</a> operation.
         * </p>
         * 
         * @param hookResultId
         *        The unique identifier (ID) of the Hook invocation result that you want details about. You can get the
         *        ID from the <a
         *        href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListHookResults.html"
         *        >ListHookResults</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hookResultId(String hookResultId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFormationRequest.BuilderImpl implements Builder {
        private String hookResultId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHookResultRequest model) {
            super(model);
            hookResultId(model.hookResultId);
        }

        public final String getHookResultId() {
            return hookResultId;
        }

        public final void setHookResultId(String hookResultId) {
            this.hookResultId = hookResultId;
        }

        @Override
        public final Builder hookResultId(String hookResultId) {
            this.hookResultId = hookResultId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetHookResultRequest build() {
            return new GetHookResultRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
