/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudformation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetHookResultResponse extends CloudFormationResponse implements
        ToCopyableBuilder<GetHookResultResponse.Builder, GetHookResultResponse> {
    private static final SdkField<String> HOOK_RESULT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HookResultId").getter(getter(GetHookResultResponse::hookResultId)).setter(setter(Builder::hookResultId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookResultId").build()).build();

    private static final SdkField<String> INVOCATION_POINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvocationPoint").getter(getter(GetHookResultResponse::invocationPointAsString))
            .setter(setter(Builder::invocationPoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationPoint").build()).build();

    private static final SdkField<String> FAILURE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureMode").getter(getter(GetHookResultResponse::failureModeAsString))
            .setter(setter(Builder::failureMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMode").build()).build();

    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(GetHookResultResponse::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> ORIGINAL_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginalTypeName").getter(getter(GetHookResultResponse::originalTypeName))
            .setter(setter(Builder::originalTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalTypeName").build()).build();

    private static final SdkField<String> TYPE_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeVersionId").getter(getter(GetHookResultResponse::typeVersionId))
            .setter(setter(Builder::typeVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeVersionId").build()).build();

    private static final SdkField<String> TYPE_CONFIGURATION_VERSION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TypeConfigurationVersionId")
            .getter(getter(GetHookResultResponse::typeConfigurationVersionId))
            .setter(setter(Builder::typeConfigurationVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeConfigurationVersionId").build())
            .build();

    private static final SdkField<String> TYPE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeArn").getter(getter(GetHookResultResponse::typeArn)).setter(setter(Builder::typeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetHookResultResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> HOOK_STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HookStatusReason").getter(getter(GetHookResultResponse::hookStatusReason))
            .setter(setter(Builder::hookStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HookStatusReason").build()).build();

    private static final SdkField<Instant> INVOKED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("InvokedAt").getter(getter(GetHookResultResponse::invokedAt)).setter(setter(Builder::invokedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvokedAt").build()).build();

    private static final SdkField<HookTarget> TARGET_FIELD = SdkField.<HookTarget> builder(MarshallingType.SDK_POJO)
            .memberName("Target").getter(getter(GetHookResultResponse::target)).setter(setter(Builder::target))
            .constructor(HookTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final SdkField<List<Annotation>> ANNOTATIONS_FIELD = SdkField
            .<List<Annotation>> builder(MarshallingType.LIST)
            .memberName("Annotations")
            .getter(getter(GetHookResultResponse::annotations))
            .setter(setter(Builder::annotations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Annotations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Annotation> builder(MarshallingType.SDK_POJO)
                                            .constructor(Annotation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOOK_RESULT_ID_FIELD,
            INVOCATION_POINT_FIELD, FAILURE_MODE_FIELD, TYPE_NAME_FIELD, ORIGINAL_TYPE_NAME_FIELD, TYPE_VERSION_ID_FIELD,
            TYPE_CONFIGURATION_VERSION_ID_FIELD, TYPE_ARN_FIELD, STATUS_FIELD, HOOK_STATUS_REASON_FIELD, INVOKED_AT_FIELD,
            TARGET_FIELD, ANNOTATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String hookResultId;

    private final String invocationPoint;

    private final String failureMode;

    private final String typeName;

    private final String originalTypeName;

    private final String typeVersionId;

    private final String typeConfigurationVersionId;

    private final String typeArn;

    private final String status;

    private final String hookStatusReason;

    private final Instant invokedAt;

    private final HookTarget target;

    private final List<Annotation> annotations;

    private GetHookResultResponse(BuilderImpl builder) {
        super(builder);
        this.hookResultId = builder.hookResultId;
        this.invocationPoint = builder.invocationPoint;
        this.failureMode = builder.failureMode;
        this.typeName = builder.typeName;
        this.originalTypeName = builder.originalTypeName;
        this.typeVersionId = builder.typeVersionId;
        this.typeConfigurationVersionId = builder.typeConfigurationVersionId;
        this.typeArn = builder.typeArn;
        this.status = builder.status;
        this.hookStatusReason = builder.hookStatusReason;
        this.invokedAt = builder.invokedAt;
        this.target = builder.target;
        this.annotations = builder.annotations;
    }

    /**
     * <p>
     * The unique identifier of the Hook result.
     * </p>
     * 
     * @return The unique identifier of the Hook result.
     */
    public final String hookResultId() {
        return hookResultId;
    }

    /**
     * <p>
     * The specific point in the provisioning process where the Hook is invoked.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invocationPoint}
     * will return {@link HookInvocationPoint#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #invocationPointAsString}.
     * </p>
     * 
     * @return The specific point in the provisioning process where the Hook is invoked.
     * @see HookInvocationPoint
     */
    public final HookInvocationPoint invocationPoint() {
        return HookInvocationPoint.fromValue(invocationPoint);
    }

    /**
     * <p>
     * The specific point in the provisioning process where the Hook is invoked.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #invocationPoint}
     * will return {@link HookInvocationPoint#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #invocationPointAsString}.
     * </p>
     * 
     * @return The specific point in the provisioning process where the Hook is invoked.
     * @see HookInvocationPoint
     */
    public final String invocationPointAsString() {
        return invocationPoint;
    }

    /**
     * <p>
     * The failure mode of the invocation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureMode} will
     * return {@link HookFailureMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #failureModeAsString}.
     * </p>
     * 
     * @return The failure mode of the invocation.
     * @see HookFailureMode
     */
    public final HookFailureMode failureMode() {
        return HookFailureMode.fromValue(failureMode);
    }

    /**
     * <p>
     * The failure mode of the invocation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureMode} will
     * return {@link HookFailureMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #failureModeAsString}.
     * </p>
     * 
     * @return The failure mode of the invocation.
     * @see HookFailureMode
     */
    public final String failureModeAsString() {
        return failureMode;
    }

    /**
     * <p>
     * The name of the Hook that was invoked.
     * </p>
     * 
     * @return The name of the Hook that was invoked.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The original public type name of the Hook when an alias is used.
     * </p>
     * <p>
     * For example, if you activate <code>AWS::Hooks::GuardHook</code> with alias
     * <code>MyCompany::Custom::GuardHook</code>, then <code>TypeName</code> will be
     * <code>MyCompany::Custom::GuardHook</code> and <code>OriginalTypeName</code> will be
     * <code>AWS::Hooks::GuardHook</code>.
     * </p>
     * 
     * @return The original public type name of the Hook when an alias is used.</p>
     *         <p>
     *         For example, if you activate <code>AWS::Hooks::GuardHook</code> with alias
     *         <code>MyCompany::Custom::GuardHook</code>, then <code>TypeName</code> will be
     *         <code>MyCompany::Custom::GuardHook</code> and <code>OriginalTypeName</code> will be
     *         <code>AWS::Hooks::GuardHook</code>.
     */
    public final String originalTypeName() {
        return originalTypeName;
    }

    /**
     * <p>
     * The version identifier of the Hook that was invoked.
     * </p>
     * 
     * @return The version identifier of the Hook that was invoked.
     */
    public final String typeVersionId() {
        return typeVersionId;
    }

    /**
     * <p>
     * The version identifier of the Hook configuration data that was used during invocation.
     * </p>
     * 
     * @return The version identifier of the Hook configuration data that was used during invocation.
     */
    public final String typeConfigurationVersionId() {
        return typeConfigurationVersionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Hook.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Hook.
     */
    public final String typeArn() {
        return typeArn;
    }

    /**
     * <p>
     * The status of the Hook invocation. The following statuses are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HOOK_IN_PROGRESS</code>: The Hook is currently running.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HOOK_COMPLETE_SUCCEEDED</code>: The Hook completed successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HOOK_COMPLETE_FAILED</code>: The Hook completed but failed validation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HOOK_FAILED</code>: The Hook encountered an error during execution.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link HookStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Hook invocation. The following statuses are possible:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HOOK_IN_PROGRESS</code>: The Hook is currently running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HOOK_COMPLETE_SUCCEEDED</code>: The Hook completed successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HOOK_COMPLETE_FAILED</code>: The Hook completed but failed validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HOOK_FAILED</code>: The Hook encountered an error during execution.
     *         </p>
     *         </li>
     * @see HookStatus
     */
    public final HookStatus status() {
        return HookStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the Hook invocation. The following statuses are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HOOK_IN_PROGRESS</code>: The Hook is currently running.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HOOK_COMPLETE_SUCCEEDED</code>: The Hook completed successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HOOK_COMPLETE_FAILED</code>: The Hook completed but failed validation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HOOK_FAILED</code>: The Hook encountered an error during execution.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link HookStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Hook invocation. The following statuses are possible:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HOOK_IN_PROGRESS</code>: The Hook is currently running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HOOK_COMPLETE_SUCCEEDED</code>: The Hook completed successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HOOK_COMPLETE_FAILED</code>: The Hook completed but failed validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HOOK_FAILED</code>: The Hook encountered an error during execution.
     *         </p>
     *         </li>
     * @see HookStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A message that provides additional details about the Hook invocation status.
     * </p>
     * 
     * @return A message that provides additional details about the Hook invocation status.
     */
    public final String hookStatusReason() {
        return hookStatusReason;
    }

    /**
     * <p>
     * The timestamp when the Hook was invoked.
     * </p>
     * 
     * @return The timestamp when the Hook was invoked.
     */
    public final Instant invokedAt() {
        return invokedAt;
    }

    /**
     * <p>
     * Information about the target of the Hook invocation.
     * </p>
     * 
     * @return Information about the target of the Hook invocation.
     */
    public final HookTarget target() {
        return target;
    }

    /**
     * For responses, this returns true if the service returned a value for the Annotations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAnnotations() {
        return annotations != null && !(annotations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects with additional information and guidance that can help you resolve a failed Hook invocation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnnotations} method.
     * </p>
     * 
     * @return A list of objects with additional information and guidance that can help you resolve a failed Hook
     *         invocation.
     */
    public final List<Annotation> annotations() {
        return annotations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hookResultId());
        hashCode = 31 * hashCode + Objects.hashCode(invocationPointAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(originalTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(typeVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(typeConfigurationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(typeArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hookStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(invokedAt());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(hasAnnotations() ? annotations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHookResultResponse)) {
            return false;
        }
        GetHookResultResponse other = (GetHookResultResponse) obj;
        return Objects.equals(hookResultId(), other.hookResultId())
                && Objects.equals(invocationPointAsString(), other.invocationPointAsString())
                && Objects.equals(failureModeAsString(), other.failureModeAsString())
                && Objects.equals(typeName(), other.typeName()) && Objects.equals(originalTypeName(), other.originalTypeName())
                && Objects.equals(typeVersionId(), other.typeVersionId())
                && Objects.equals(typeConfigurationVersionId(), other.typeConfigurationVersionId())
                && Objects.equals(typeArn(), other.typeArn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(hookStatusReason(), other.hookStatusReason()) && Objects.equals(invokedAt(), other.invokedAt())
                && Objects.equals(target(), other.target()) && hasAnnotations() == other.hasAnnotations()
                && Objects.equals(annotations(), other.annotations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetHookResultResponse").add("HookResultId", hookResultId())
                .add("InvocationPoint", invocationPointAsString()).add("FailureMode", failureModeAsString())
                .add("TypeName", typeName()).add("OriginalTypeName", originalTypeName()).add("TypeVersionId", typeVersionId())
                .add("TypeConfigurationVersionId", typeConfigurationVersionId()).add("TypeArn", typeArn())
                .add("Status", statusAsString()).add("HookStatusReason", hookStatusReason()).add("InvokedAt", invokedAt())
                .add("Target", target()).add("Annotations", hasAnnotations() ? annotations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HookResultId":
            return Optional.ofNullable(clazz.cast(hookResultId()));
        case "InvocationPoint":
            return Optional.ofNullable(clazz.cast(invocationPointAsString()));
        case "FailureMode":
            return Optional.ofNullable(clazz.cast(failureModeAsString()));
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "OriginalTypeName":
            return Optional.ofNullable(clazz.cast(originalTypeName()));
        case "TypeVersionId":
            return Optional.ofNullable(clazz.cast(typeVersionId()));
        case "TypeConfigurationVersionId":
            return Optional.ofNullable(clazz.cast(typeConfigurationVersionId()));
        case "TypeArn":
            return Optional.ofNullable(clazz.cast(typeArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "HookStatusReason":
            return Optional.ofNullable(clazz.cast(hookStatusReason()));
        case "InvokedAt":
            return Optional.ofNullable(clazz.cast(invokedAt()));
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        case "Annotations":
            return Optional.ofNullable(clazz.cast(annotations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HookResultId", HOOK_RESULT_ID_FIELD);
        map.put("InvocationPoint", INVOCATION_POINT_FIELD);
        map.put("FailureMode", FAILURE_MODE_FIELD);
        map.put("TypeName", TYPE_NAME_FIELD);
        map.put("OriginalTypeName", ORIGINAL_TYPE_NAME_FIELD);
        map.put("TypeVersionId", TYPE_VERSION_ID_FIELD);
        map.put("TypeConfigurationVersionId", TYPE_CONFIGURATION_VERSION_ID_FIELD);
        map.put("TypeArn", TYPE_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("HookStatusReason", HOOK_STATUS_REASON_FIELD);
        map.put("InvokedAt", INVOKED_AT_FIELD);
        map.put("Target", TARGET_FIELD);
        map.put("Annotations", ANNOTATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetHookResultResponse, T> g) {
        return obj -> g.apply((GetHookResultResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFormationResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetHookResultResponse> {
        /**
         * <p>
         * The unique identifier of the Hook result.
         * </p>
         * 
         * @param hookResultId
         *        The unique identifier of the Hook result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hookResultId(String hookResultId);

        /**
         * <p>
         * The specific point in the provisioning process where the Hook is invoked.
         * </p>
         * 
         * @param invocationPoint
         *        The specific point in the provisioning process where the Hook is invoked.
         * @see HookInvocationPoint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookInvocationPoint
         */
        Builder invocationPoint(String invocationPoint);

        /**
         * <p>
         * The specific point in the provisioning process where the Hook is invoked.
         * </p>
         * 
         * @param invocationPoint
         *        The specific point in the provisioning process where the Hook is invoked.
         * @see HookInvocationPoint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookInvocationPoint
         */
        Builder invocationPoint(HookInvocationPoint invocationPoint);

        /**
         * <p>
         * The failure mode of the invocation.
         * </p>
         * 
         * @param failureMode
         *        The failure mode of the invocation.
         * @see HookFailureMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookFailureMode
         */
        Builder failureMode(String failureMode);

        /**
         * <p>
         * The failure mode of the invocation.
         * </p>
         * 
         * @param failureMode
         *        The failure mode of the invocation.
         * @see HookFailureMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookFailureMode
         */
        Builder failureMode(HookFailureMode failureMode);

        /**
         * <p>
         * The name of the Hook that was invoked.
         * </p>
         * 
         * @param typeName
         *        The name of the Hook that was invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The original public type name of the Hook when an alias is used.
         * </p>
         * <p>
         * For example, if you activate <code>AWS::Hooks::GuardHook</code> with alias
         * <code>MyCompany::Custom::GuardHook</code>, then <code>TypeName</code> will be
         * <code>MyCompany::Custom::GuardHook</code> and <code>OriginalTypeName</code> will be
         * <code>AWS::Hooks::GuardHook</code>.
         * </p>
         * 
         * @param originalTypeName
         *        The original public type name of the Hook when an alias is used.</p>
         *        <p>
         *        For example, if you activate <code>AWS::Hooks::GuardHook</code> with alias
         *        <code>MyCompany::Custom::GuardHook</code>, then <code>TypeName</code> will be
         *        <code>MyCompany::Custom::GuardHook</code> and <code>OriginalTypeName</code> will be
         *        <code>AWS::Hooks::GuardHook</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originalTypeName(String originalTypeName);

        /**
         * <p>
         * The version identifier of the Hook that was invoked.
         * </p>
         * 
         * @param typeVersionId
         *        The version identifier of the Hook that was invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeVersionId(String typeVersionId);

        /**
         * <p>
         * The version identifier of the Hook configuration data that was used during invocation.
         * </p>
         * 
         * @param typeConfigurationVersionId
         *        The version identifier of the Hook configuration data that was used during invocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeConfigurationVersionId(String typeConfigurationVersionId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Hook.
         * </p>
         * 
         * @param typeArn
         *        The Amazon Resource Name (ARN) of the Hook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeArn(String typeArn);

        /**
         * <p>
         * The status of the Hook invocation. The following statuses are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HOOK_IN_PROGRESS</code>: The Hook is currently running.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HOOK_COMPLETE_SUCCEEDED</code>: The Hook completed successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HOOK_COMPLETE_FAILED</code>: The Hook completed but failed validation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HOOK_FAILED</code>: The Hook encountered an error during execution.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the Hook invocation. The following statuses are possible:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HOOK_IN_PROGRESS</code>: The Hook is currently running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HOOK_COMPLETE_SUCCEEDED</code>: The Hook completed successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HOOK_COMPLETE_FAILED</code>: The Hook completed but failed validation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HOOK_FAILED</code>: The Hook encountered an error during execution.
         *        </p>
         *        </li>
         * @see HookStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the Hook invocation. The following statuses are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HOOK_IN_PROGRESS</code>: The Hook is currently running.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HOOK_COMPLETE_SUCCEEDED</code>: The Hook completed successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HOOK_COMPLETE_FAILED</code>: The Hook completed but failed validation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HOOK_FAILED</code>: The Hook encountered an error during execution.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the Hook invocation. The following statuses are possible:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HOOK_IN_PROGRESS</code>: The Hook is currently running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HOOK_COMPLETE_SUCCEEDED</code>: The Hook completed successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HOOK_COMPLETE_FAILED</code>: The Hook completed but failed validation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HOOK_FAILED</code>: The Hook encountered an error during execution.
         *        </p>
         *        </li>
         * @see HookStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HookStatus
         */
        Builder status(HookStatus status);

        /**
         * <p>
         * A message that provides additional details about the Hook invocation status.
         * </p>
         * 
         * @param hookStatusReason
         *        A message that provides additional details about the Hook invocation status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hookStatusReason(String hookStatusReason);

        /**
         * <p>
         * The timestamp when the Hook was invoked.
         * </p>
         * 
         * @param invokedAt
         *        The timestamp when the Hook was invoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invokedAt(Instant invokedAt);

        /**
         * <p>
         * Information about the target of the Hook invocation.
         * </p>
         * 
         * @param target
         *        Information about the target of the Hook invocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(HookTarget target);

        /**
         * <p>
         * Information about the target of the Hook invocation.
         * </p>
         * This is a convenience method that creates an instance of the {@link HookTarget.Builder} avoiding the need to
         * create one manually via {@link HookTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HookTarget.Builder#build()} is called immediately and its result
         * is passed to {@link #target(HookTarget)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link HookTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(HookTarget)
         */
        default Builder target(Consumer<HookTarget.Builder> target) {
            return target(HookTarget.builder().applyMutation(target).build());
        }

        /**
         * <p>
         * A list of objects with additional information and guidance that can help you resolve a failed Hook
         * invocation.
         * </p>
         * 
         * @param annotations
         *        A list of objects with additional information and guidance that can help you resolve a failed Hook
         *        invocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotations(Collection<Annotation> annotations);

        /**
         * <p>
         * A list of objects with additional information and guidance that can help you resolve a failed Hook
         * invocation.
         * </p>
         * 
         * @param annotations
         *        A list of objects with additional information and guidance that can help you resolve a failed Hook
         *        invocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotations(Annotation... annotations);

        /**
         * <p>
         * A list of objects with additional information and guidance that can help you resolve a failed Hook
         * invocation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudformation.model.Annotation.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.cloudformation.model.Annotation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudformation.model.Annotation.Builder#build()} is called immediately
         * and its result is passed to {@link #annotations(List<Annotation>)}.
         * 
         * @param annotations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudformation.model.Annotation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #annotations(java.util.Collection<Annotation>)
         */
        Builder annotations(Consumer<Annotation.Builder>... annotations);
    }

    static final class BuilderImpl extends CloudFormationResponse.BuilderImpl implements Builder {
        private String hookResultId;

        private String invocationPoint;

        private String failureMode;

        private String typeName;

        private String originalTypeName;

        private String typeVersionId;

        private String typeConfigurationVersionId;

        private String typeArn;

        private String status;

        private String hookStatusReason;

        private Instant invokedAt;

        private HookTarget target;

        private List<Annotation> annotations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetHookResultResponse model) {
            super(model);
            hookResultId(model.hookResultId);
            invocationPoint(model.invocationPoint);
            failureMode(model.failureMode);
            typeName(model.typeName);
            originalTypeName(model.originalTypeName);
            typeVersionId(model.typeVersionId);
            typeConfigurationVersionId(model.typeConfigurationVersionId);
            typeArn(model.typeArn);
            status(model.status);
            hookStatusReason(model.hookStatusReason);
            invokedAt(model.invokedAt);
            target(model.target);
            annotations(model.annotations);
        }

        public final String getHookResultId() {
            return hookResultId;
        }

        public final void setHookResultId(String hookResultId) {
            this.hookResultId = hookResultId;
        }

        @Override
        public final Builder hookResultId(String hookResultId) {
            this.hookResultId = hookResultId;
            return this;
        }

        public final String getInvocationPoint() {
            return invocationPoint;
        }

        public final void setInvocationPoint(String invocationPoint) {
            this.invocationPoint = invocationPoint;
        }

        @Override
        public final Builder invocationPoint(String invocationPoint) {
            this.invocationPoint = invocationPoint;
            return this;
        }

        @Override
        public final Builder invocationPoint(HookInvocationPoint invocationPoint) {
            this.invocationPoint(invocationPoint == null ? null : invocationPoint.toString());
            return this;
        }

        public final String getFailureMode() {
            return failureMode;
        }

        public final void setFailureMode(String failureMode) {
            this.failureMode = failureMode;
        }

        @Override
        public final Builder failureMode(String failureMode) {
            this.failureMode = failureMode;
            return this;
        }

        @Override
        public final Builder failureMode(HookFailureMode failureMode) {
            this.failureMode(failureMode == null ? null : failureMode.toString());
            return this;
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getOriginalTypeName() {
            return originalTypeName;
        }

        public final void setOriginalTypeName(String originalTypeName) {
            this.originalTypeName = originalTypeName;
        }

        @Override
        public final Builder originalTypeName(String originalTypeName) {
            this.originalTypeName = originalTypeName;
            return this;
        }

        public final String getTypeVersionId() {
            return typeVersionId;
        }

        public final void setTypeVersionId(String typeVersionId) {
            this.typeVersionId = typeVersionId;
        }

        @Override
        public final Builder typeVersionId(String typeVersionId) {
            this.typeVersionId = typeVersionId;
            return this;
        }

        public final String getTypeConfigurationVersionId() {
            return typeConfigurationVersionId;
        }

        public final void setTypeConfigurationVersionId(String typeConfigurationVersionId) {
            this.typeConfigurationVersionId = typeConfigurationVersionId;
        }

        @Override
        public final Builder typeConfigurationVersionId(String typeConfigurationVersionId) {
            this.typeConfigurationVersionId = typeConfigurationVersionId;
            return this;
        }

        public final String getTypeArn() {
            return typeArn;
        }

        public final void setTypeArn(String typeArn) {
            this.typeArn = typeArn;
        }

        @Override
        public final Builder typeArn(String typeArn) {
            this.typeArn = typeArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(HookStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getHookStatusReason() {
            return hookStatusReason;
        }

        public final void setHookStatusReason(String hookStatusReason) {
            this.hookStatusReason = hookStatusReason;
        }

        @Override
        public final Builder hookStatusReason(String hookStatusReason) {
            this.hookStatusReason = hookStatusReason;
            return this;
        }

        public final Instant getInvokedAt() {
            return invokedAt;
        }

        public final void setInvokedAt(Instant invokedAt) {
            this.invokedAt = invokedAt;
        }

        @Override
        public final Builder invokedAt(Instant invokedAt) {
            this.invokedAt = invokedAt;
            return this;
        }

        public final HookTarget.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        public final void setTarget(HookTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(HookTarget target) {
            this.target = target;
            return this;
        }

        public final List<Annotation.Builder> getAnnotations() {
            List<Annotation.Builder> result = AnnotationListCopier.copyToBuilder(this.annotations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnnotations(Collection<Annotation.BuilderImpl> annotations) {
            this.annotations = AnnotationListCopier.copyFromBuilder(annotations);
        }

        @Override
        public final Builder annotations(Collection<Annotation> annotations) {
            this.annotations = AnnotationListCopier.copy(annotations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder annotations(Annotation... annotations) {
            annotations(Arrays.asList(annotations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder annotations(Consumer<Annotation.Builder>... annotations) {
            annotations(Stream.of(annotations).map(c -> Annotation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetHookResultResponse build() {
            return new GetHookResultResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
