/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.EventFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEventsRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, DescribeEventsRequest> {
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackName").getter(DescribeEventsRequest.getter(DescribeEventsRequest::stackName)).setter(DescribeEventsRequest.setter(Builder::stackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()}).build();
    private static final SdkField<String> CHANGE_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeSetName").getter(DescribeEventsRequest.getter(DescribeEventsRequest::changeSetName)).setter(DescribeEventsRequest.setter(Builder::changeSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetName").build()}).build();
    private static final SdkField<String> OPERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationId").getter(DescribeEventsRequest.getter(DescribeEventsRequest::operationId)).setter(DescribeEventsRequest.setter(Builder::operationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperationId").build()}).build();
    private static final SdkField<EventFilter> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filters").getter(DescribeEventsRequest.getter(DescribeEventsRequest::filters)).setter(DescribeEventsRequest.setter(Builder::filters)).constructor(EventFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeEventsRequest.getter(DescribeEventsRequest::nextToken)).setter(DescribeEventsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAME_FIELD, CHANGE_SET_NAME_FIELD, OPERATION_ID_FIELD, FILTERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeEventsRequest.memberNameToFieldInitializer();
    private final String stackName;
    private final String changeSetName;
    private final String operationId;
    private final EventFilter filters;
    private final String nextToken;

    private DescribeEventsRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.changeSetName = builder.changeSetName;
        this.operationId = builder.operationId;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
    }

    public final String stackName() {
        return this.stackName;
    }

    public final String changeSetName() {
        return this.changeSetName;
    }

    public final String operationId() {
        return this.operationId;
    }

    public final EventFilter filters() {
        return this.filters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventsRequest)) {
            return false;
        }
        DescribeEventsRequest other = (DescribeEventsRequest)((Object)obj);
        return Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.changeSetName(), other.changeSetName()) && Objects.equals(this.operationId(), other.operationId()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEventsRequest").add("StackName", (Object)this.stackName()).add("ChangeSetName", (Object)this.changeSetName()).add("OperationId", (Object)this.operationId()).add("Filters", (Object)this.filters()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
            case "ChangeSetName": {
                return Optional.ofNullable(clazz.cast(this.changeSetName()));
            }
            case "OperationId": {
                return Optional.ofNullable(clazz.cast(this.operationId()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StackName", STACK_NAME_FIELD);
        map.put("ChangeSetName", CHANGE_SET_NAME_FIELD);
        map.put("OperationId", OPERATION_ID_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventsRequest, T> g) {
        return obj -> g.apply((DescribeEventsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String stackName;
        private String changeSetName;
        private String operationId;
        private EventFilter filters;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventsRequest model) {
            super(model);
            this.stackName(model.stackName);
            this.changeSetName(model.changeSetName);
            this.operationId(model.operationId);
            this.filters(model.filters);
            this.nextToken(model.nextToken);
        }

        public final String getStackName() {
            return this.stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final String getChangeSetName() {
            return this.changeSetName;
        }

        public final void setChangeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
        }

        @Override
        public final Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public final String getOperationId() {
            return this.operationId;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final EventFilter.Builder getFilters() {
            return this.filters != null ? this.filters.toBuilder() : null;
        }

        public final void setFilters(EventFilter.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(EventFilter filters) {
            this.filters = filters;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeEventsRequest build() {
            return new DescribeEventsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEventsRequest> {
        public Builder stackName(String var1);

        public Builder changeSetName(String var1);

        public Builder operationId(String var1);

        public Builder filters(EventFilter var1);

        default public Builder filters(Consumer<EventFilter.Builder> filters) {
            return this.filters((EventFilter)((EventFilter.Builder)EventFilter.builder().applyMutation(filters)).build());
        }

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

