/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationAsyncClient;
import software.amazon.awssdk.services.cloudformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudformation.model.ListGeneratedTemplatesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListGeneratedTemplatesResponse;
import software.amazon.awssdk.services.cloudformation.model.TemplateSummary;

public class ListGeneratedTemplatesPublisher
implements SdkPublisher<ListGeneratedTemplatesResponse> {
    private final CloudFormationAsyncClient client;
    private final ListGeneratedTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGeneratedTemplatesPublisher(CloudFormationAsyncClient client, ListGeneratedTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGeneratedTemplatesPublisher(CloudFormationAsyncClient client, ListGeneratedTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGeneratedTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGeneratedTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TemplateSummary> summaries() {
        return this.flatMapIterable(response -> response.summaries());
    }

    private class ListGeneratedTemplatesResponseFetcher
    implements AsyncPageFetcher<ListGeneratedTemplatesResponse> {
        private ListGeneratedTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListGeneratedTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListGeneratedTemplatesResponse> nextPage(ListGeneratedTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListGeneratedTemplatesPublisher.this.client.listGeneratedTemplates(ListGeneratedTemplatesPublisher.this.firstRequest);
            }
            return ListGeneratedTemplatesPublisher.this.client.listGeneratedTemplates((ListGeneratedTemplatesRequest)((Object)ListGeneratedTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

