/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudformation.model.Change;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetResponse;

public class DescribeChangeSetIterable
implements SdkIterable<DescribeChangeSetResponse> {
    private final CloudFormationClient client;
    private final DescribeChangeSetRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeChangeSetIterable(CloudFormationClient client, DescribeChangeSetRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeChangeSetResponseFetcher();
    }

    public Iterator<DescribeChangeSetResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Change> changes() {
        Function<DescribeChangeSetResponse, Iterator> getIterator = response -> {
            if (response != null && response.changes() != null) {
                return response.changes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeChangeSetResponseFetcher
    implements SyncPageFetcher<DescribeChangeSetResponse> {
        private DescribeChangeSetResponseFetcher() {
        }

        public boolean hasNextPage(DescribeChangeSetResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeChangeSetResponse nextPage(DescribeChangeSetResponse previousPage) {
            if (previousPage == null) {
                return DescribeChangeSetIterable.this.client.describeChangeSet(DescribeChangeSetIterable.this.firstRequest);
            }
            return DescribeChangeSetIterable.this.client.describeChangeSet((DescribeChangeSetRequest)((Object)DescribeChangeSetIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

