/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationAsyncClient;
import software.amazon.awssdk.services.cloudformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackSetOperationsResponse;
import software.amazon.awssdk.services.cloudformation.model.StackSetOperationSummary;

public class ListStackSetOperationsPublisher
implements SdkPublisher<ListStackSetOperationsResponse> {
    private final CloudFormationAsyncClient client;
    private final ListStackSetOperationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStackSetOperationsPublisher(CloudFormationAsyncClient client, ListStackSetOperationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStackSetOperationsPublisher(CloudFormationAsyncClient client, ListStackSetOperationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStackSetOperationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStackSetOperationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StackSetOperationSummary> summaries() {
        return this.flatMapIterable(response -> response.summaries());
    }

    private class ListStackSetOperationsResponseFetcher
    implements AsyncPageFetcher<ListStackSetOperationsResponse> {
        private ListStackSetOperationsResponseFetcher() {
        }

        public boolean hasNextPage(ListStackSetOperationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStackSetOperationsResponse> nextPage(ListStackSetOperationsResponse previousPage) {
            if (previousPage == null) {
                return ListStackSetOperationsPublisher.this.client.listStackSetOperations(ListStackSetOperationsPublisher.this.firstRequest);
            }
            return ListStackSetOperationsPublisher.this.client.listStackSetOperations((ListStackSetOperationsRequest)((Object)ListStackSetOperationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

