/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.HookTargetAction;
import software.amazon.awssdk.services.cloudformation.model.HookTargetType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HookTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HookTarget> {
    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetType").getter(HookTarget.getter(HookTarget::targetTypeAsString)).setter(HookTarget.setter(Builder::targetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()}).build();
    private static final SdkField<String> TARGET_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetTypeName").getter(HookTarget.getter(HookTarget::targetTypeName)).setter(HookTarget.setter(Builder::targetTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTypeName").build()}).build();
    private static final SdkField<String> TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetId").getter(HookTarget.getter(HookTarget::targetId)).setter(HookTarget.setter(Builder::targetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetId").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(HookTarget.getter(HookTarget::actionAsString)).setter(HookTarget.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_TYPE_FIELD, TARGET_TYPE_NAME_FIELD, TARGET_ID_FIELD, ACTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HookTarget.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String targetType;
    private final String targetTypeName;
    private final String targetId;
    private final String action;

    private HookTarget(BuilderImpl builder) {
        this.targetType = builder.targetType;
        this.targetTypeName = builder.targetTypeName;
        this.targetId = builder.targetId;
        this.action = builder.action;
    }

    public final HookTargetType targetType() {
        return HookTargetType.fromValue(this.targetType);
    }

    public final String targetTypeAsString() {
        return this.targetType;
    }

    public final String targetTypeName() {
        return this.targetTypeName;
    }

    public final String targetId() {
        return this.targetId;
    }

    public final HookTargetAction action() {
        return HookTargetAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HookTarget)) {
            return false;
        }
        HookTarget other = (HookTarget)obj;
        return Objects.equals(this.targetTypeAsString(), other.targetTypeAsString()) && Objects.equals(this.targetTypeName(), other.targetTypeName()) && Objects.equals(this.targetId(), other.targetId()) && Objects.equals(this.actionAsString(), other.actionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"HookTarget").add("TargetType", (Object)this.targetTypeAsString()).add("TargetTypeName", (Object)this.targetTypeName()).add("TargetId", (Object)this.targetId()).add("Action", (Object)this.actionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetType": {
                return Optional.ofNullable(clazz.cast(this.targetTypeAsString()));
            }
            case "TargetTypeName": {
                return Optional.ofNullable(clazz.cast(this.targetTypeName()));
            }
            case "TargetId": {
                return Optional.ofNullable(clazz.cast(this.targetId()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("TargetType", TARGET_TYPE_FIELD);
        map.put("TargetTypeName", TARGET_TYPE_NAME_FIELD);
        map.put("TargetId", TARGET_ID_FIELD);
        map.put("Action", ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HookTarget, T> g) {
        return obj -> g.apply((HookTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String targetType;
        private String targetTypeName;
        private String targetId;
        private String action;

        private BuilderImpl() {
        }

        private BuilderImpl(HookTarget model) {
            this.targetType(model.targetType);
            this.targetTypeName(model.targetTypeName);
            this.targetId(model.targetId);
            this.action(model.action);
        }

        public final String getTargetType() {
            return this.targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(HookTargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        public final String getTargetTypeName() {
            return this.targetTypeName;
        }

        public final void setTargetTypeName(String targetTypeName) {
            this.targetTypeName = targetTypeName;
        }

        @Override
        public final Builder targetTypeName(String targetTypeName) {
            this.targetTypeName = targetTypeName;
            return this;
        }

        public final String getTargetId() {
            return this.targetId;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(HookTargetAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public HookTarget build() {
            return new HookTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HookTarget> {
        public Builder targetType(String var1);

        public Builder targetType(HookTargetType var1);

        public Builder targetTypeName(String var1);

        public Builder targetId(String var1);

        public Builder action(String var1);

        public Builder action(HookTargetAction var1);
    }
}

