/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.StackResourceDriftStatus;
import software.amazon.awssdk.services.cloudformation.model.StackResourceDriftStatusFiltersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStackResourceDriftsRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, DescribeStackResourceDriftsRequest> {
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackName").getter(DescribeStackResourceDriftsRequest.getter(DescribeStackResourceDriftsRequest::stackName)).setter(DescribeStackResourceDriftsRequest.setter(Builder::stackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()}).build();
    private static final SdkField<List<String>> STACK_RESOURCE_DRIFT_STATUS_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StackResourceDriftStatusFilters").getter(DescribeStackResourceDriftsRequest.getter(DescribeStackResourceDriftsRequest::stackResourceDriftStatusFiltersAsStrings)).setter(DescribeStackResourceDriftsRequest.setter(Builder::stackResourceDriftStatusFiltersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackResourceDriftStatusFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeStackResourceDriftsRequest.getter(DescribeStackResourceDriftsRequest::nextToken)).setter(DescribeStackResourceDriftsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeStackResourceDriftsRequest.getter(DescribeStackResourceDriftsRequest::maxResults)).setter(DescribeStackResourceDriftsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAME_FIELD, STACK_RESOURCE_DRIFT_STATUS_FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeStackResourceDriftsRequest.memberNameToFieldInitializer();
    private final String stackName;
    private final List<String> stackResourceDriftStatusFilters;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeStackResourceDriftsRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.stackResourceDriftStatusFilters = builder.stackResourceDriftStatusFilters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String stackName() {
        return this.stackName;
    }

    public final List<StackResourceDriftStatus> stackResourceDriftStatusFilters() {
        return StackResourceDriftStatusFiltersCopier.copyStringToEnum(this.stackResourceDriftStatusFilters);
    }

    public final boolean hasStackResourceDriftStatusFilters() {
        return this.stackResourceDriftStatusFilters != null && !(this.stackResourceDriftStatusFilters instanceof SdkAutoConstructList);
    }

    public final List<String> stackResourceDriftStatusFiltersAsStrings() {
        return this.stackResourceDriftStatusFilters;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStackResourceDriftStatusFilters() ? this.stackResourceDriftStatusFiltersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackResourceDriftsRequest)) {
            return false;
        }
        DescribeStackResourceDriftsRequest other = (DescribeStackResourceDriftsRequest)((Object)obj);
        return Objects.equals(this.stackName(), other.stackName()) && this.hasStackResourceDriftStatusFilters() == other.hasStackResourceDriftStatusFilters() && Objects.equals(this.stackResourceDriftStatusFiltersAsStrings(), other.stackResourceDriftStatusFiltersAsStrings()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeStackResourceDriftsRequest").add("StackName", (Object)this.stackName()).add("StackResourceDriftStatusFilters", this.hasStackResourceDriftStatusFilters() ? this.stackResourceDriftStatusFiltersAsStrings() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
            case "StackResourceDriftStatusFilters": {
                return Optional.ofNullable(clazz.cast(this.stackResourceDriftStatusFiltersAsStrings()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StackName", STACK_NAME_FIELD);
        map.put("StackResourceDriftStatusFilters", STACK_RESOURCE_DRIFT_STATUS_FILTERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeStackResourceDriftsRequest, T> g) {
        return obj -> g.apply((DescribeStackResourceDriftsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String stackName;
        private List<String> stackResourceDriftStatusFilters = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackResourceDriftsRequest model) {
            super(model);
            this.stackName(model.stackName);
            this.stackResourceDriftStatusFiltersWithStrings(model.stackResourceDriftStatusFilters);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getStackName() {
            return this.stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final Collection<String> getStackResourceDriftStatusFilters() {
            if (this.stackResourceDriftStatusFilters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stackResourceDriftStatusFilters;
        }

        public final void setStackResourceDriftStatusFilters(Collection<String> stackResourceDriftStatusFilters) {
            this.stackResourceDriftStatusFilters = StackResourceDriftStatusFiltersCopier.copy(stackResourceDriftStatusFilters);
        }

        @Override
        public final Builder stackResourceDriftStatusFiltersWithStrings(Collection<String> stackResourceDriftStatusFilters) {
            this.stackResourceDriftStatusFilters = StackResourceDriftStatusFiltersCopier.copy(stackResourceDriftStatusFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackResourceDriftStatusFiltersWithStrings(String ... stackResourceDriftStatusFilters) {
            this.stackResourceDriftStatusFiltersWithStrings(Arrays.asList(stackResourceDriftStatusFilters));
            return this;
        }

        @Override
        public final Builder stackResourceDriftStatusFilters(Collection<StackResourceDriftStatus> stackResourceDriftStatusFilters) {
            this.stackResourceDriftStatusFilters = StackResourceDriftStatusFiltersCopier.copyEnumToString(stackResourceDriftStatusFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackResourceDriftStatusFilters(StackResourceDriftStatus ... stackResourceDriftStatusFilters) {
            this.stackResourceDriftStatusFilters(Arrays.asList(stackResourceDriftStatusFilters));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeStackResourceDriftsRequest build() {
            return new DescribeStackResourceDriftsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStackResourceDriftsRequest> {
        public Builder stackName(String var1);

        public Builder stackResourceDriftStatusFiltersWithStrings(Collection<String> var1);

        public Builder stackResourceDriftStatusFiltersWithStrings(String ... var1);

        public Builder stackResourceDriftStatusFilters(Collection<StackResourceDriftStatus> var1);

        public Builder stackResourceDriftStatusFilters(StackResourceDriftStatus ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

