/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationAsyncClient;
import software.amazon.awssdk.services.cloudformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudformation.model.ListStackRefactorsRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackRefactorsResponse;
import software.amazon.awssdk.services.cloudformation.model.StackRefactorSummary;

public class ListStackRefactorsPublisher
implements SdkPublisher<ListStackRefactorsResponse> {
    private final CloudFormationAsyncClient client;
    private final ListStackRefactorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStackRefactorsPublisher(CloudFormationAsyncClient client, ListStackRefactorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStackRefactorsPublisher(CloudFormationAsyncClient client, ListStackRefactorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStackRefactorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStackRefactorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StackRefactorSummary> stackRefactorSummaries() {
        return this.flatMapIterable(response -> response.stackRefactorSummaries());
    }

    private class ListStackRefactorsResponseFetcher
    implements AsyncPageFetcher<ListStackRefactorsResponse> {
        private ListStackRefactorsResponseFetcher() {
        }

        public boolean hasNextPage(ListStackRefactorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStackRefactorsResponse> nextPage(ListStackRefactorsResponse previousPage) {
            if (previousPage == null) {
                return ListStackRefactorsPublisher.this.client.listStackRefactors(ListStackRefactorsPublisher.this.firstRequest);
            }
            return ListStackRefactorsPublisher.this.client.listStackRefactors((ListStackRefactorsRequest)((Object)ListStackRefactorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

