/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudformation.CloudFormationAsyncClient;
import software.amazon.awssdk.services.cloudformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudformation.model.ListStacksRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStacksResponse;
import software.amazon.awssdk.services.cloudformation.model.StackSummary;

public class ListStacksPublisher
implements SdkPublisher<ListStacksResponse> {
    private final CloudFormationAsyncClient client;
    private final ListStacksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStacksPublisher(CloudFormationAsyncClient client, ListStacksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStacksPublisher(CloudFormationAsyncClient client, ListStacksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStacksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStacksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StackSummary> stackSummaries() {
        return this.flatMapIterable(response -> response.stackSummaries());
    }

    private class ListStacksResponseFetcher
    implements AsyncPageFetcher<ListStacksResponse> {
        private ListStacksResponseFetcher() {
        }

        public boolean hasNextPage(ListStacksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStacksResponse> nextPage(ListStacksResponse previousPage) {
            if (previousPage == null) {
                return ListStacksPublisher.this.client.listStacks(ListStacksPublisher.this.firstRequest);
            }
            return ListStacksPublisher.this.client.listStacks((ListStacksRequest)((Object)ListStacksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

