/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StackRefactorDetection {
    AUTO("AUTO"),
    MANUAL("MANUAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StackRefactorDetection> VALUE_MAP;
    private final String value;

    private StackRefactorDetection(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StackRefactorDetection fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StackRefactorDetection> knownValues() {
        EnumSet<StackRefactorDetection> knownValues = EnumSet.allOf(StackRefactorDetection.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StackRefactorDetection.class, StackRefactorDetection::toString);
    }
}

