/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ValidationStatus {
    FAILED("FAILED"),
    SKIPPED("SKIPPED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ValidationStatus> VALUE_MAP;
    private final String value;

    private ValidationStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ValidationStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ValidationStatus> knownValues() {
        EnumSet<ValidationStatus> knownValues = EnumSet.allOf(ValidationStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ValidationStatus.class, ValidationStatus::toString);
    }
}

