/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.nio.file.Path;
import java.security.PrivateKey;
import java.time.Instant;
import java.util.Objects;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.services.cloudfront.internal.utils.SigningUtils;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontSignerRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Immutable
@ThreadSafe
@SdkPublicApi
public final class CustomSignerRequest
implements CloudFrontSignerRequest,
ToCopyableBuilder<Builder, CustomSignerRequest> {
    private final String resourceUrl;
    private final PrivateKey privateKey;
    private final String keyPairId;
    private final Instant expirationDate;
    private final Instant activeDate;
    private final String ipRange;

    private CustomSignerRequest(DefaultBuilder builder) {
        this.resourceUrl = builder.resourceUrl;
        this.privateKey = builder.privateKey;
        this.keyPairId = builder.keyPairId;
        this.expirationDate = builder.expirationDate;
        this.activeDate = builder.activeDate;
        this.ipRange = builder.ipRange;
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public Builder toBuilder() {
        return new DefaultBuilder(this);
    }

    @Override
    public String resourceUrl() {
        return this.resourceUrl;
    }

    @Override
    public PrivateKey privateKey() {
        return this.privateKey;
    }

    @Override
    public String keyPairId() {
        return this.keyPairId;
    }

    @Override
    public Instant expirationDate() {
        return this.expirationDate;
    }

    public Instant activeDate() {
        return this.activeDate;
    }

    public String ipRange() {
        return this.ipRange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomSignerRequest cookie = (CustomSignerRequest)o;
        return Objects.equals(this.resourceUrl, cookie.resourceUrl) && Objects.equals(this.privateKey, cookie.privateKey) && Objects.equals(this.keyPairId, cookie.keyPairId) && Objects.equals(this.expirationDate, cookie.expirationDate) && Objects.equals(this.activeDate, cookie.activeDate) && Objects.equals(this.ipRange, cookie.ipRange);
    }

    public int hashCode() {
        int result = this.resourceUrl != null ? this.resourceUrl.hashCode() : 0;
        result = 31 * result + (this.privateKey != null ? this.privateKey.hashCode() : 0);
        result = 31 * result + (this.keyPairId != null ? this.keyPairId.hashCode() : 0);
        result = 31 * result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
        result = 31 * result + (this.activeDate != null ? this.activeDate.hashCode() : 0);
        result = 31 * result + (this.ipRange != null ? this.ipRange.hashCode() : 0);
        return result;
    }

    private static final class DefaultBuilder
    implements Builder {
        private String resourceUrl;
        private PrivateKey privateKey;
        private String keyPairId;
        private Instant expirationDate;
        private Instant activeDate;
        private String ipRange;

        private DefaultBuilder() {
        }

        private DefaultBuilder(CustomSignerRequest request) {
            this.resourceUrl = request.resourceUrl;
            this.privateKey = request.privateKey;
            this.keyPairId = request.keyPairId;
            this.expirationDate = request.expirationDate;
            this.activeDate = request.activeDate;
            this.ipRange = request.ipRange;
        }

        @Override
        public Builder resourceUrl(String resourceUrl) {
            this.resourceUrl = resourceUrl;
            return this;
        }

        @Override
        public Builder privateKey(PrivateKey privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        @Override
        public Builder privateKey(Path keyFile) throws Exception {
            this.privateKey = SigningUtils.loadPrivateKey(keyFile);
            return this;
        }

        @Override
        public Builder keyPairId(String keyPairId) {
            this.keyPairId = keyPairId;
            return this;
        }

        @Override
        public Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        @Override
        public Builder activeDate(Instant activeDate) {
            this.activeDate = activeDate;
            return this;
        }

        @Override
        public Builder ipRange(String ipRange) {
            this.ipRange = ipRange;
            return this;
        }

        public CustomSignerRequest build() {
            return new CustomSignerRequest(this);
        }
    }

    @NotThreadSafe
    @SdkPublicApi
    public static interface Builder
    extends CopyableBuilder<Builder, CustomSignerRequest> {
        public Builder resourceUrl(String var1);

        public Builder privateKey(PrivateKey var1);

        public Builder privateKey(Path var1) throws Exception;

        public Builder keyPairId(String var1);

        public Builder expirationDate(Instant var1);

        public Builder activeDate(Instant var1);

        public Builder ipRange(String var1);
    }
}

