/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.Response;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.xml.AwsXmlProtocolFactory;
import software.amazon.awssdk.protocols.xml.XmlOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.cloudfront.internal.CloudFrontServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.cloudfront.model.AccessDeniedException;
import software.amazon.awssdk.services.cloudfront.model.AssociateAliasRequest;
import software.amazon.awssdk.services.cloudfront.model.AssociateAliasResponse;
import software.amazon.awssdk.services.cloudfront.model.BatchTooLargeException;
import software.amazon.awssdk.services.cloudfront.model.CachePolicyAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.CachePolicyInUseException;
import software.amazon.awssdk.services.cloudfront.model.CannotChangeImmutablePublicKeyFieldsException;
import software.amazon.awssdk.services.cloudfront.model.CannotDeleteEntityWhileInUseException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityInUseException;
import software.amazon.awssdk.services.cloudfront.model.CnameAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicyAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicyInUseException;
import software.amazon.awssdk.services.cloudfront.model.CopyDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.CopyDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateCachePolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateCachePolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateContinuousDeploymentPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateContinuousDeploymentPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionWithTagsRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionWithTagsResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateInvalidationRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateInvalidationResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateKeyGroupRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateKeyGroupResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateKeyValueStoreRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateKeyValueStoreResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateMonitoringSubscriptionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateMonitoringSubscriptionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateOriginAccessControlRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateOriginAccessControlResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateOriginRequestPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateOriginRequestPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateRealtimeLogConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateRealtimeLogConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateResponseHeadersPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateResponseHeadersPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionWithTagsRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionWithTagsResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteCachePolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteCachePolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteContinuousDeploymentPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteContinuousDeploymentPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteKeyGroupRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteKeyGroupResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteKeyValueStoreRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteKeyValueStoreResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteMonitoringSubscriptionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteMonitoringSubscriptionResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteOriginAccessControlRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteOriginAccessControlResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteOriginRequestPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteOriginRequestPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.DeletePublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.DeletePublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteRealtimeLogConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteRealtimeLogConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteResponseHeadersPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteResponseHeadersPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.DescribeFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.DescribeFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.DescribeKeyValueStoreRequest;
import software.amazon.awssdk.services.cloudfront.model.DescribeKeyValueStoreResponse;
import software.amazon.awssdk.services.cloudfront.model.DistributionAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.DistributionNotDisabledException;
import software.amazon.awssdk.services.cloudfront.model.EntityAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.EntityLimitExceededException;
import software.amazon.awssdk.services.cloudfront.model.EntityNotFoundException;
import software.amazon.awssdk.services.cloudfront.model.EntitySizeLimitExceededException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionConfigAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionConfigInUseException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileInUseException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileSizeExceededException;
import software.amazon.awssdk.services.cloudfront.model.FunctionAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.FunctionInUseException;
import software.amazon.awssdk.services.cloudfront.model.FunctionSizeLimitExceededException;
import software.amazon.awssdk.services.cloudfront.model.GetCachePolicyConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCachePolicyConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetCachePolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCachePolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.GetContinuousDeploymentPolicyConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetContinuousDeploymentPolicyConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetContinuousDeploymentPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.GetContinuousDeploymentPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationRequest;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationResponse;
import software.amazon.awssdk.services.cloudfront.model.GetKeyGroupConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetKeyGroupConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetKeyGroupRequest;
import software.amazon.awssdk.services.cloudfront.model.GetKeyGroupResponse;
import software.amazon.awssdk.services.cloudfront.model.GetMonitoringSubscriptionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetMonitoringSubscriptionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetOriginAccessControlConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetOriginAccessControlConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetOriginAccessControlRequest;
import software.amazon.awssdk.services.cloudfront.model.GetOriginAccessControlResponse;
import software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.GetRealtimeLogConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetRealtimeLogConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetResponseHeadersPolicyConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetResponseHeadersPolicyConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetResponseHeadersPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.GetResponseHeadersPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.IllegalDeleteException;
import software.amazon.awssdk.services.cloudfront.model.IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException;
import software.amazon.awssdk.services.cloudfront.model.IllegalOriginAccessConfigurationException;
import software.amazon.awssdk.services.cloudfront.model.IllegalUpdateException;
import software.amazon.awssdk.services.cloudfront.model.InconsistentQuantitiesException;
import software.amazon.awssdk.services.cloudfront.model.InvalidArgumentException;
import software.amazon.awssdk.services.cloudfront.model.InvalidDefaultRootObjectException;
import software.amazon.awssdk.services.cloudfront.model.InvalidDomainNameForOriginAccessControlException;
import software.amazon.awssdk.services.cloudfront.model.InvalidErrorCodeException;
import software.amazon.awssdk.services.cloudfront.model.InvalidForwardCookiesException;
import software.amazon.awssdk.services.cloudfront.model.InvalidFunctionAssociationException;
import software.amazon.awssdk.services.cloudfront.model.InvalidGeoRestrictionParameterException;
import software.amazon.awssdk.services.cloudfront.model.InvalidHeadersForS3OriginException;
import software.amazon.awssdk.services.cloudfront.model.InvalidIfMatchVersionException;
import software.amazon.awssdk.services.cloudfront.model.InvalidLambdaFunctionAssociationException;
import software.amazon.awssdk.services.cloudfront.model.InvalidLocationCodeException;
import software.amazon.awssdk.services.cloudfront.model.InvalidMinimumProtocolVersionException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginAccessControlException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginAccessIdentityException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginKeepaliveTimeoutException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginReadTimeoutException;
import software.amazon.awssdk.services.cloudfront.model.InvalidProtocolSettingsException;
import software.amazon.awssdk.services.cloudfront.model.InvalidQueryStringParametersException;
import software.amazon.awssdk.services.cloudfront.model.InvalidRelativePathException;
import software.amazon.awssdk.services.cloudfront.model.InvalidRequiredProtocolException;
import software.amazon.awssdk.services.cloudfront.model.InvalidResponseCodeException;
import software.amazon.awssdk.services.cloudfront.model.InvalidTaggingException;
import software.amazon.awssdk.services.cloudfront.model.InvalidTtlOrderException;
import software.amazon.awssdk.services.cloudfront.model.InvalidViewerCertificateException;
import software.amazon.awssdk.services.cloudfront.model.InvalidWebAclIdException;
import software.amazon.awssdk.services.cloudfront.model.KeyGroupAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.ListCachePoliciesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListCachePoliciesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListConflictingAliasesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListConflictingAliasesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListContinuousDeploymentPoliciesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListContinuousDeploymentPoliciesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByCachePolicyIdRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByCachePolicyIdResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByKeyGroupRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByKeyGroupResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByOriginRequestPolicyIdRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByOriginRequestPolicyIdResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByRealtimeLogConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByRealtimeLogConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByResponseHeadersPolicyIdRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByResponseHeadersPolicyIdResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionConfigsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionConfigsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListFunctionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListFunctionsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListKeyGroupsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListKeyGroupsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListKeyValueStoresRequest;
import software.amazon.awssdk.services.cloudfront.model.ListKeyValueStoresResponse;
import software.amazon.awssdk.services.cloudfront.model.ListOriginAccessControlsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListOriginAccessControlsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListOriginRequestPoliciesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListOriginRequestPoliciesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListPublicKeysRequest;
import software.amazon.awssdk.services.cloudfront.model.ListPublicKeysResponse;
import software.amazon.awssdk.services.cloudfront.model.ListRealtimeLogConfigsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListRealtimeLogConfigsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListResponseHeadersPoliciesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListResponseHeadersPoliciesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.MissingBodyException;
import software.amazon.awssdk.services.cloudfront.model.MonitoringSubscriptionAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchCachePolicyException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchCloudFrontOriginAccessIdentityException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchContinuousDeploymentPolicyException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchDistributionException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchFieldLevelEncryptionConfigException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchFieldLevelEncryptionProfileException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchFunctionExistsException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchInvalidationException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchMonitoringSubscriptionException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchOriginAccessControlException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchOriginException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchOriginRequestPolicyException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchPublicKeyException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchRealtimeLogConfigException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchResourceException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchResponseHeadersPolicyException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchStreamingDistributionException;
import software.amazon.awssdk.services.cloudfront.model.OriginAccessControlAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.OriginAccessControlInUseException;
import software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyInUseException;
import software.amazon.awssdk.services.cloudfront.model.PreconditionFailedException;
import software.amazon.awssdk.services.cloudfront.model.PublicKeyAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.PublicKeyInUseException;
import software.amazon.awssdk.services.cloudfront.model.PublishFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.PublishFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.QueryArgProfileEmptyException;
import software.amazon.awssdk.services.cloudfront.model.RealtimeLogConfigAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.RealtimeLogConfigInUseException;
import software.amazon.awssdk.services.cloudfront.model.RealtimeLogConfigOwnerMismatchException;
import software.amazon.awssdk.services.cloudfront.model.ResourceInUseException;
import software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyInUseException;
import software.amazon.awssdk.services.cloudfront.model.StagingDistributionInUseException;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionNotDisabledException;
import software.amazon.awssdk.services.cloudfront.model.TagResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.TagResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.TestFunctionFailedException;
import software.amazon.awssdk.services.cloudfront.model.TestFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.TestFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.TooLongCspInResponseHeadersPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCacheBehaviorsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCachePoliciesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCertificatesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCloudFrontOriginAccessIdentitiesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyContinuousDeploymentPoliciesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCookieNamesInWhiteListException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCookiesInCachePolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCookiesInOriginRequestPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCustomHeadersInResponseHeadersPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionCnamEsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsAssociatedToCachePolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsAssociatedToKeyGroupException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsAssociatedToOriginAccessControlException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsAssociatedToOriginRequestPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsAssociatedToResponseHeadersPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsWithFunctionAssociationsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsWithLambdaAssociationsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsWithSingleFunctionArnException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionConfigsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionContentTypeProfilesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionEncryptionEntitiesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionFieldPatternsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionProfilesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionQueryArgProfilesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFunctionAssociationsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFunctionsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyHeadersInCachePolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyHeadersInForwardedValuesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyHeadersInOriginRequestPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyInvalidationsInProgressException;
import software.amazon.awssdk.services.cloudfront.model.TooManyKeyGroupsAssociatedToDistributionException;
import software.amazon.awssdk.services.cloudfront.model.TooManyKeyGroupsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyLambdaFunctionAssociationsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginAccessControlsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginCustomHeadersException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginGroupsPerDistributionException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginRequestPoliciesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyPublicKeysException;
import software.amazon.awssdk.services.cloudfront.model.TooManyPublicKeysInKeyGroupException;
import software.amazon.awssdk.services.cloudfront.model.TooManyQueryStringParametersException;
import software.amazon.awssdk.services.cloudfront.model.TooManyQueryStringsInCachePolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyQueryStringsInOriginRequestPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyRealtimeLogConfigsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyRemoveHeadersInResponseHeadersPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyResponseHeadersPoliciesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyStreamingDistributionCnamEsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyStreamingDistributionsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyTrustedSignersException;
import software.amazon.awssdk.services.cloudfront.model.TrustedKeyGroupDoesNotExistException;
import software.amazon.awssdk.services.cloudfront.model.TrustedSignerDoesNotExistException;
import software.amazon.awssdk.services.cloudfront.model.UnsupportedOperationException;
import software.amazon.awssdk.services.cloudfront.model.UntagResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.UntagResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateCachePolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateCachePolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateContinuousDeploymentPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateContinuousDeploymentPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateDistributionWithStagingConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateDistributionWithStagingConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateKeyGroupRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateKeyGroupResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateKeyValueStoreRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateKeyValueStoreResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateOriginAccessControlRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateOriginAccessControlResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateOriginRequestPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateOriginRequestPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdatePublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdatePublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateRealtimeLogConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateRealtimeLogConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateResponseHeadersPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateResponseHeadersPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.transform.AssociateAliasRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CopyDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateCachePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateCloudFrontOriginAccessIdentityRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateContinuousDeploymentPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateDistributionWithTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateFieldLevelEncryptionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateFieldLevelEncryptionProfileRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateFunctionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateInvalidationRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateKeyGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateKeyValueStoreRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateMonitoringSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateOriginAccessControlRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateOriginRequestPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreatePublicKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateRealtimeLogConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateResponseHeadersPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateStreamingDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateStreamingDistributionWithTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteCachePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteCloudFrontOriginAccessIdentityRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteContinuousDeploymentPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteFieldLevelEncryptionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteFieldLevelEncryptionProfileRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteFunctionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteKeyGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteKeyValueStoreRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteMonitoringSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteOriginAccessControlRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteOriginRequestPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeletePublicKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteRealtimeLogConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteResponseHeadersPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteStreamingDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DescribeFunctionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DescribeKeyValueStoreRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetCachePolicyConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetCachePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetCloudFrontOriginAccessIdentityConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetCloudFrontOriginAccessIdentityRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetContinuousDeploymentPolicyConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetContinuousDeploymentPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetDistributionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetFieldLevelEncryptionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetFieldLevelEncryptionProfileConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetFieldLevelEncryptionProfileRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetFieldLevelEncryptionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetFunctionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetInvalidationRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetKeyGroupConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetKeyGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetMonitoringSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetOriginAccessControlConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetOriginAccessControlRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetOriginRequestPolicyConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetOriginRequestPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetPublicKeyConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetPublicKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetRealtimeLogConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetResponseHeadersPolicyConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetResponseHeadersPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetStreamingDistributionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetStreamingDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListCachePoliciesRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListCloudFrontOriginAccessIdentitiesRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListConflictingAliasesRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListContinuousDeploymentPoliciesRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsByCachePolicyIdRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsByKeyGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsByOriginRequestPolicyIdRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsByRealtimeLogConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsByResponseHeadersPolicyIdRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsByWebAclIdRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListFieldLevelEncryptionConfigsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListFieldLevelEncryptionProfilesRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListFunctionsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListInvalidationsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListKeyGroupsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListKeyValueStoresRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListOriginAccessControlsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListOriginRequestPoliciesRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListPublicKeysRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListRealtimeLogConfigsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListResponseHeadersPoliciesRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListStreamingDistributionsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.PublishFunctionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.TestFunctionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateCachePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateCloudFrontOriginAccessIdentityRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateContinuousDeploymentPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateDistributionWithStagingConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateFieldLevelEncryptionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateFieldLevelEncryptionProfileRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateFunctionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateKeyGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateKeyValueStoreRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateOriginAccessControlRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateOriginRequestPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdatePublicKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateRealtimeLogConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateResponseHeadersPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateStreamingDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.waiters.CloudFrontWaiter;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link CloudFrontClient}.
 *
 * @see CloudFrontClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultCloudFrontClient implements CloudFrontClient {
    private static final Logger log = Logger.loggerFor(DefaultCloudFrontClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_XML).build();

    private final SyncClientHandler clientHandler;

    private final AwsXmlProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCloudFrontClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init();
    }

    /**
     * <p>
     * Associates an alias (also known as a CNAME or an alternate domain name) with a CloudFront distribution.
     * </p>
     * <p>
     * With this operation you can move an alias that's already in use on a CloudFront distribution to a different
     * distribution in one step. This prevents the downtime that could occur if you first remove the alias from one
     * distribution and then separately add the alias to another distribution.
     * </p>
     * <p>
     * To use this operation to associate an alias with a distribution, you provide the alias and the ID of the target
     * distribution for the alias. For more information, including how to set up the target distribution, prerequisites
     * that you must complete, and other restrictions, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html#alternate-domain-names-move"
     * >Moving an alternate domain name to a different distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param associateAliasRequest
     * @return Result of the AssociateAlias operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws TooManyDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.AssociateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/AssociateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AssociateAliasResponse associateAlias(AssociateAliasRequest associateAliasRequest) throws InvalidArgumentException,
            NoSuchDistributionException, TooManyDistributionCnamEsException, IllegalUpdateException, AccessDeniedException,
            AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<AssociateAliasResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                AssociateAliasResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateAliasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateAlias");

            return clientHandler.execute(new ClientExecutionParams<AssociateAliasRequest, AssociateAliasResponse>()
                    .withOperationName("AssociateAlias").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(associateAliasRequest)
                    .withMarshaller(new AssociateAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a staging distribution using the configuration of the provided primary distribution. A staging
     * distribution is a copy of an existing distribution (called the primary distribution) that you can use in a
     * continuous deployment workflow.
     * </p>
     * <p>
     * After you create a staging distribution, you can use <code>UpdateDistribution</code> to modify the staging
     * distribution's configuration. Then you can use <code>CreateContinuousDeploymentPolicy</code> to incrementally
     * move traffic to the staging distribution.
     * </p>
     * <p>
     * This API operation requires the following IAM permissions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistribution.html">GetDistribution</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CreateDistribution.html">
     * CreateDistribution</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CopyDistribution.html">CopyDistribution</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param copyDistributionRequest
     * @return Result of the CopyDistribution operation returned by the service.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws DistributionAlreadyExistsException
     *         The caller reference you attempted to create the distribution with is associated with another
     *         distribution.
     * @throws InvalidOriginException
     *         The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws InvalidOriginAccessControlException
     *         The origin access control is not valid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws InvalidViewerCertificateException
     *         A viewer certificate specified is not valid.
     * @throws InvalidMinimumProtocolVersionException
     *         The minimum protocol version specified is not valid.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws TooManyDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws TooManyDistributionsException
     *         Processing your request would cause you to exceed the maximum number of distributions allowed.
     * @throws InvalidDefaultRootObjectException
     *         The default root object file name is too big or contains an invalid character.
     * @throws InvalidRelativePathException
     *         The relative path is too big, is not URL-encoded, or does not begin with a slash (/).
     * @throws InvalidErrorCodeException
     *         An invalid error code was specified.
     * @throws InvalidResponseCodeException
     *         A response code is not valid.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidRequiredProtocolException
     *         This operation requires the HTTPS protocol. Ensure that you specify the HTTPS protocol in your request,
     *         or omit the <code>RequiredProtocols</code> element from your distribution configuration.
     * @throws NoSuchOriginException
     *         No origin exists with the specified <code>Origin Id</code>.
     * @throws TooManyOriginsException
     *         You cannot create more origins for the distribution.
     * @throws TooManyOriginGroupsPerDistributionException
     *         Processing your request would cause you to exceed the maximum number of origin groups allowed.
     * @throws TooManyCacheBehaviorsException
     *         You cannot create more cache behaviors for the distribution.
     * @throws TooManyCookieNamesInWhiteListException
     *         Your request contains more cookie names in the whitelist than are allowed per cache behavior.
     * @throws InvalidForwardCookiesException
     *         Your request contains forward cookies option which doesn't match with the expectation for the
     *         <code>whitelisted</code> list of cookie names. Either list of cookie names has been specified when not
     *         allowed or list of cookie names is missing when expected.
     * @throws TooManyHeadersInForwardedValuesException
     *         Your request contains too many headers in forwarded values.
     * @throws InvalidHeadersForS3OriginException
     *         The headers specified are not valid for an Amazon S3 origin.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws TooManyCertificatesException
     *         You cannot create anymore custom SSL/TLS certificates.
     * @throws InvalidLocationCodeException
     *         The location code specified is not valid.
     * @throws InvalidGeoRestrictionParameterException
     *         The specified geo restriction parameter is not valid.
     * @throws InvalidProtocolSettingsException
     *         You cannot specify SSLv3 as the minimum protocol version if you only want to support only clients that
     *         support Server Name Indication (SNI).
     * @throws InvalidTtlOrderException
     *         The TTL order specified is not valid.
     * @throws InvalidWebAclIdException
     *         A web ACL ID specified is not valid. To specify a web ACL created using the latest version of WAF, use
     *         the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * @throws TooManyOriginCustomHeadersException
     *         Your request contains too many origin custom headers.
     * @throws TooManyQueryStringParametersException
     *         Your request contains too many query string parameters.
     * @throws InvalidQueryStringParametersException
     *         The query string parameters specified are not valid.
     * @throws TooManyDistributionsWithLambdaAssociationsException
     *         Processing your request would cause the maximum number of distributions with Lambda@Edge function
     *         associations per owner to be exceeded.
     * @throws TooManyDistributionsWithSingleFunctionArnException
     *         The maximum number of distributions have been associated with the specified Lambda@Edge function.
     * @throws TooManyLambdaFunctionAssociationsException
     *         Your request contains more Lambda@Edge function associations than are allowed per distribution.
     * @throws InvalidLambdaFunctionAssociationException
     *         The specified Lambda@Edge function association is invalid.
     * @throws TooManyDistributionsWithFunctionAssociationsException
     *         You have reached the maximum number of distributions that are associated with a CloudFront function. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyFunctionAssociationsException
     *         You have reached the maximum number of CloudFront function associations for this distribution. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws InvalidFunctionAssociationException
     *         A CloudFront function association is invalid.
     * @throws InvalidOriginReadTimeoutException
     *         The read timeout specified for the origin is not valid.
     * @throws InvalidOriginKeepaliveTimeoutException
     *         The keep alive timeout specified for the origin is not valid.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException
     *         The specified configuration for field-level encryption can't be associated with the specified cache
     *         behavior.
     * @throws TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException
     *         The maximum number of distributions have been associated with the specified configuration for field-level
     *         encryption.
     * @throws NoSuchCachePolicyException
     *         The cache policy does not exist.
     * @throws TooManyDistributionsAssociatedToCachePolicyException
     *         The maximum number of distributions have been associated with the specified cache policy. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyDistributionsAssociatedToOriginAccessControlException
     *         The maximum number of distributions have been associated with the specified origin access control.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws NoSuchResponseHeadersPolicyException
     *         The response headers policy does not exist.
     * @throws TooManyDistributionsAssociatedToResponseHeadersPolicyException
     *         The maximum number of distributions have been associated with the specified response headers policy.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws NoSuchOriginRequestPolicyException
     *         The origin request policy does not exist.
     * @throws TooManyDistributionsAssociatedToOriginRequestPolicyException
     *         The maximum number of distributions have been associated with the specified origin request policy. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyDistributionsAssociatedToKeyGroupException
     *         The number of distributions that reference this key group is more than the maximum allowed. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyKeyGroupsAssociatedToDistributionException
     *         The number of key groups referenced by this distribution is more than the maximum allowed. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TrustedKeyGroupDoesNotExistException
     *         The specified key group does not exist.
     * @throws NoSuchRealtimeLogConfigException
     *         The real-time log configuration does not exist.
     * @throws RealtimeLogConfigOwnerMismatchException
     *         The specified real-time log configuration belongs to a different Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CopyDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CopyDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CopyDistributionResponse copyDistribution(CopyDistributionRequest copyDistributionRequest)
            throws CnameAlreadyExistsException, DistributionAlreadyExistsException, InvalidOriginException,
            InvalidOriginAccessIdentityException, InvalidOriginAccessControlException, InvalidIfMatchVersionException,
            NoSuchDistributionException, PreconditionFailedException, AccessDeniedException, TooManyTrustedSignersException,
            TrustedSignerDoesNotExistException, InvalidViewerCertificateException, InvalidMinimumProtocolVersionException,
            MissingBodyException, TooManyDistributionCnamEsException, TooManyDistributionsException,
            InvalidDefaultRootObjectException, InvalidRelativePathException, InvalidErrorCodeException,
            InvalidResponseCodeException, InvalidArgumentException, InvalidRequiredProtocolException, NoSuchOriginException,
            TooManyOriginsException, TooManyOriginGroupsPerDistributionException, TooManyCacheBehaviorsException,
            TooManyCookieNamesInWhiteListException, InvalidForwardCookiesException, TooManyHeadersInForwardedValuesException,
            InvalidHeadersForS3OriginException, InconsistentQuantitiesException, TooManyCertificatesException,
            InvalidLocationCodeException, InvalidGeoRestrictionParameterException, InvalidProtocolSettingsException,
            InvalidTtlOrderException, InvalidWebAclIdException, TooManyOriginCustomHeadersException,
            TooManyQueryStringParametersException, InvalidQueryStringParametersException,
            TooManyDistributionsWithLambdaAssociationsException, TooManyDistributionsWithSingleFunctionArnException,
            TooManyLambdaFunctionAssociationsException, InvalidLambdaFunctionAssociationException,
            TooManyDistributionsWithFunctionAssociationsException, TooManyFunctionAssociationsException,
            InvalidFunctionAssociationException, InvalidOriginReadTimeoutException, InvalidOriginKeepaliveTimeoutException,
            NoSuchFieldLevelEncryptionConfigException, IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException,
            TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException, NoSuchCachePolicyException,
            TooManyDistributionsAssociatedToCachePolicyException, TooManyDistributionsAssociatedToOriginAccessControlException,
            NoSuchResponseHeadersPolicyException, TooManyDistributionsAssociatedToResponseHeadersPolicyException,
            NoSuchOriginRequestPolicyException, TooManyDistributionsAssociatedToOriginRequestPolicyException,
            TooManyDistributionsAssociatedToKeyGroupException, TooManyKeyGroupsAssociatedToDistributionException,
            TrustedKeyGroupDoesNotExistException, NoSuchRealtimeLogConfigException, RealtimeLogConfigOwnerMismatchException,
            AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<CopyDistributionResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                CopyDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(copyDistributionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copyDistributionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopyDistribution");

            return clientHandler.execute(new ClientExecutionParams<CopyDistributionRequest, CopyDistributionResponse>()
                    .withOperationName("CopyDistribution").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(copyDistributionRequest)
                    .withMarshaller(new CopyDistributionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a cache policy.
     * </p>
     * <p>
     * After you create a cache policy, you can attach it to one or more cache behaviors. When it's attached to a cache
     * behavior, the cache policy determines the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The values that CloudFront includes in the <i>cache key</i>. These values can include HTTP headers, cookies, and
     * URL query strings. CloudFront uses the cache key to find an object in its cache that it can return to the viewer.
     * </p>
     * </li>
     * <li>
     * <p>
     * The default, minimum, and maximum time to live (TTL) values that you want objects to stay in the CloudFront
     * cache.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The headers, cookies, and query strings that are included in the cache key are also included in requests that
     * CloudFront sends to the origin. CloudFront sends a request when it can't find an object in its cache that matches
     * the request's cache key. If you want to send values to the origin but <i>not</i> include them in the cache key,
     * use <code>OriginRequestPolicy</code>.
     * </p>
     * <p>
     * For more information about cache policies, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html"
     * >Controlling the cache key</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param createCachePolicyRequest
     * @return Result of the CreateCachePolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws CachePolicyAlreadyExistsException
     *         A cache policy with this name already exists. You must provide a unique name. To modify an existing cache
     *         policy, use <code>UpdateCachePolicy</code>.
     * @throws TooManyCachePoliciesException
     *         You have reached the maximum number of cache policies for this Amazon Web Services account. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyHeadersInCachePolicyException
     *         The number of headers in the cache policy exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyCookiesInCachePolicyException
     *         The number of cookies in the cache policy exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyQueryStringsInCachePolicyException
     *         The number of query strings in the cache policy exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateCachePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateCachePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateCachePolicyResponse createCachePolicy(CreateCachePolicyRequest createCachePolicyRequest)
            throws AccessDeniedException, InconsistentQuantitiesException, InvalidArgumentException,
            CachePolicyAlreadyExistsException, TooManyCachePoliciesException, TooManyHeadersInCachePolicyException,
            TooManyCookiesInCachePolicyException, TooManyQueryStringsInCachePolicyException, AwsServiceException,
            SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<CreateCachePolicyResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                CreateCachePolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCachePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCachePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCachePolicy");

            return clientHandler.execute(new ClientExecutionParams<CreateCachePolicyRequest, CreateCachePolicyResponse>()
                    .withOperationName("CreateCachePolicy").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(createCachePolicyRequest)
                    .withMarshaller(new CreateCachePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new origin access identity. If you're using Amazon S3 for your origin, you can use an origin access
     * identity to require users to access your content using a CloudFront URL instead of the Amazon S3 URL. For more
     * information about how to use origin access identities, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
     * Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param createCloudFrontOriginAccessIdentityRequest
     *        The request to create a new origin access identity (OAI). An origin access identity is a special
     *        CloudFront user that you can associate with Amazon S3 origins, so that you can secure all or just some of
     *        your Amazon S3 content. For more information, see <a href=
     *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html"
     *        > Restricting Access to Amazon S3 Content by Using an Origin Access Identity</a> in the <i>Amazon
     *        CloudFront Developer Guide</i>.
     * @return Result of the CreateCloudFrontOriginAccessIdentity operation returned by the service.
     * @throws CloudFrontOriginAccessIdentityAlreadyExistsException
     *         If the <code>CallerReference</code> is a value you already sent in a previous request to create an
     *         identity but the content of the <code>CloudFrontOriginAccessIdentityConfig</code> is different from the
     *         original request, CloudFront returns a <code>CloudFrontOriginAccessIdentityAlreadyExists</code> error.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws TooManyCloudFrontOriginAccessIdentitiesException
     *         Processing your request would cause you to exceed the maximum number of origin access identities allowed.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateCloudFrontOriginAccessIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateCloudFrontOriginAccessIdentityResponse createCloudFrontOriginAccessIdentity(
            CreateCloudFrontOriginAccessIdentityRequest createCloudFrontOriginAccessIdentityRequest)
            throws CloudFrontOriginAccessIdentityAlreadyExistsException, MissingBodyException,
            TooManyCloudFrontOriginAccessIdentitiesException, InvalidArgumentException, InconsistentQuantitiesException,
            AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<CreateCloudFrontOriginAccessIdentityResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(CreateCloudFrontOriginAccessIdentityResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCloudFrontOriginAccessIdentityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createCloudFrontOriginAccessIdentityRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCloudFrontOriginAccessIdentity");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateCloudFrontOriginAccessIdentityRequest, CreateCloudFrontOriginAccessIdentityResponse>()
                            .withOperationName("CreateCloudFrontOriginAccessIdentity").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(createCloudFrontOriginAccessIdentityRequest)
                            .withMarshaller(new CreateCloudFrontOriginAccessIdentityRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a continuous deployment policy that distributes traffic for a custom domain name to two different
     * CloudFront distributions.
     * </p>
     * <p>
     * To use a continuous deployment policy, first use <code>CopyDistribution</code> to create a staging distribution,
     * then use <code>UpdateDistribution</code> to modify the staging distribution's configuration.
     * </p>
     * <p>
     * After you create and update a staging distribution, you can use a continuous deployment policy to incrementally
     * move traffic to the staging distribution. This workflow enables you to test changes to a distribution's
     * configuration before moving all of your domain's production traffic to the new configuration.
     * </p>
     *
     * @param createContinuousDeploymentPolicyRequest
     * @return Result of the CreateContinuousDeploymentPolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws ContinuousDeploymentPolicyAlreadyExistsException
     *         A continuous deployment policy with this configuration already exists.
     * @throws TooManyContinuousDeploymentPoliciesException
     *         You have reached the maximum number of continuous deployment policies for this Amazon Web Services
     *         account.
     * @throws StagingDistributionInUseException
     *         A continuous deployment policy for this staging distribution already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateContinuousDeploymentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateContinuousDeploymentPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateContinuousDeploymentPolicyResponse createContinuousDeploymentPolicy(
            CreateContinuousDeploymentPolicyRequest createContinuousDeploymentPolicyRequest) throws AccessDeniedException,
            InvalidArgumentException, InconsistentQuantitiesException, ContinuousDeploymentPolicyAlreadyExistsException,
            TooManyContinuousDeploymentPoliciesException, StagingDistributionInUseException, AwsServiceException,
            SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<CreateContinuousDeploymentPolicyResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(CreateContinuousDeploymentPolicyResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createContinuousDeploymentPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createContinuousDeploymentPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateContinuousDeploymentPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateContinuousDeploymentPolicyRequest, CreateContinuousDeploymentPolicyResponse>()
                            .withOperationName("CreateContinuousDeploymentPolicy").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(createContinuousDeploymentPolicyRequest)
                            .withMarshaller(new CreateContinuousDeploymentPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a CloudFront distribution.
     * </p>
     *
     * @param createDistributionRequest
     *        The request to create a new distribution.
     * @return Result of the CreateDistribution operation returned by the service.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws DistributionAlreadyExistsException
     *         The caller reference you attempted to create the distribution with is associated with another
     *         distribution.
     * @throws InvalidOriginException
     *         The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws InvalidOriginAccessControlException
     *         The origin access control is not valid.
     * @throws IllegalOriginAccessConfigurationException
     *         An origin cannot contain both an origin access control (OAC) and an origin access identity (OAI).
     * @throws TooManyDistributionsAssociatedToOriginAccessControlException
     *         The maximum number of distributions have been associated with the specified origin access control.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws InvalidViewerCertificateException
     *         A viewer certificate specified is not valid.
     * @throws InvalidMinimumProtocolVersionException
     *         The minimum protocol version specified is not valid.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws TooManyDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws TooManyDistributionsException
     *         Processing your request would cause you to exceed the maximum number of distributions allowed.
     * @throws InvalidDefaultRootObjectException
     *         The default root object file name is too big or contains an invalid character.
     * @throws InvalidRelativePathException
     *         The relative path is too big, is not URL-encoded, or does not begin with a slash (/).
     * @throws InvalidErrorCodeException
     *         An invalid error code was specified.
     * @throws InvalidResponseCodeException
     *         A response code is not valid.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidRequiredProtocolException
     *         This operation requires the HTTPS protocol. Ensure that you specify the HTTPS protocol in your request,
     *         or omit the <code>RequiredProtocols</code> element from your distribution configuration.
     * @throws NoSuchOriginException
     *         No origin exists with the specified <code>Origin Id</code>.
     * @throws TooManyOriginsException
     *         You cannot create more origins for the distribution.
     * @throws TooManyOriginGroupsPerDistributionException
     *         Processing your request would cause you to exceed the maximum number of origin groups allowed.
     * @throws TooManyCacheBehaviorsException
     *         You cannot create more cache behaviors for the distribution.
     * @throws TooManyCookieNamesInWhiteListException
     *         Your request contains more cookie names in the whitelist than are allowed per cache behavior.
     * @throws InvalidForwardCookiesException
     *         Your request contains forward cookies option which doesn't match with the expectation for the
     *         <code>whitelisted</code> list of cookie names. Either list of cookie names has been specified when not
     *         allowed or list of cookie names is missing when expected.
     * @throws TooManyHeadersInForwardedValuesException
     *         Your request contains too many headers in forwarded values.
     * @throws InvalidHeadersForS3OriginException
     *         The headers specified are not valid for an Amazon S3 origin.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws TooManyCertificatesException
     *         You cannot create anymore custom SSL/TLS certificates.
     * @throws InvalidLocationCodeException
     *         The location code specified is not valid.
     * @throws InvalidGeoRestrictionParameterException
     *         The specified geo restriction parameter is not valid.
     * @throws InvalidProtocolSettingsException
     *         You cannot specify SSLv3 as the minimum protocol version if you only want to support only clients that
     *         support Server Name Indication (SNI).
     * @throws InvalidTtlOrderException
     *         The TTL order specified is not valid.
     * @throws InvalidWebAclIdException
     *         A web ACL ID specified is not valid. To specify a web ACL created using the latest version of WAF, use
     *         the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * @throws TooManyOriginCustomHeadersException
     *         Your request contains too many origin custom headers.
     * @throws TooManyQueryStringParametersException
     *         Your request contains too many query string parameters.
     * @throws InvalidQueryStringParametersException
     *         The query string parameters specified are not valid.
     * @throws TooManyDistributionsWithLambdaAssociationsException
     *         Processing your request would cause the maximum number of distributions with Lambda@Edge function
     *         associations per owner to be exceeded.
     * @throws TooManyDistributionsWithSingleFunctionArnException
     *         The maximum number of distributions have been associated with the specified Lambda@Edge function.
     * @throws TooManyLambdaFunctionAssociationsException
     *         Your request contains more Lambda@Edge function associations than are allowed per distribution.
     * @throws InvalidLambdaFunctionAssociationException
     *         The specified Lambda@Edge function association is invalid.
     * @throws TooManyDistributionsWithFunctionAssociationsException
     *         You have reached the maximum number of distributions that are associated with a CloudFront function. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyFunctionAssociationsException
     *         You have reached the maximum number of CloudFront function associations for this distribution. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws InvalidFunctionAssociationException
     *         A CloudFront function association is invalid.
     * @throws InvalidOriginReadTimeoutException
     *         The read timeout specified for the origin is not valid.
     * @throws InvalidOriginKeepaliveTimeoutException
     *         The keep alive timeout specified for the origin is not valid.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException
     *         The specified configuration for field-level encryption can't be associated with the specified cache
     *         behavior.
     * @throws TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException
     *         The maximum number of distributions have been associated with the specified configuration for field-level
     *         encryption.
     * @throws NoSuchCachePolicyException
     *         The cache policy does not exist.
     * @throws TooManyDistributionsAssociatedToCachePolicyException
     *         The maximum number of distributions have been associated with the specified cache policy. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws NoSuchResponseHeadersPolicyException
     *         The response headers policy does not exist.
     * @throws TooManyDistributionsAssociatedToResponseHeadersPolicyException
     *         The maximum number of distributions have been associated with the specified response headers policy.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws NoSuchOriginRequestPolicyException
     *         The origin request policy does not exist.
     * @throws TooManyDistributionsAssociatedToOriginRequestPolicyException
     *         The maximum number of distributions have been associated with the specified origin request policy. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyDistributionsAssociatedToKeyGroupException
     *         The number of distributions that reference this key group is more than the maximum allowed. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyKeyGroupsAssociatedToDistributionException
     *         The number of key groups referenced by this distribution is more than the maximum allowed. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TrustedKeyGroupDoesNotExistException
     *         The specified key group does not exist.
     * @throws NoSuchRealtimeLogConfigException
     *         The real-time log configuration does not exist.
     * @throws RealtimeLogConfigOwnerMismatchException
     *         The specified real-time log configuration belongs to a different Amazon Web Services account.
     * @throws ContinuousDeploymentPolicyInUseException
     *         You cannot delete a continuous deployment policy that is associated with a primary distribution.
     * @throws NoSuchContinuousDeploymentPolicyException
     *         The continuous deployment policy doesn't exist.
     * @throws InvalidDomainNameForOriginAccessControlException
     *         An origin access control is associated with an origin whose domain name is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateDistributionResponse createDistribution(CreateDistributionRequest createDistributionRequest)
            throws CnameAlreadyExistsException, DistributionAlreadyExistsException, InvalidOriginException,
            InvalidOriginAccessIdentityException, InvalidOriginAccessControlException, IllegalOriginAccessConfigurationException,
            TooManyDistributionsAssociatedToOriginAccessControlException, AccessDeniedException, TooManyTrustedSignersException,
            TrustedSignerDoesNotExistException, InvalidViewerCertificateException, InvalidMinimumProtocolVersionException,
            MissingBodyException, TooManyDistributionCnamEsException, TooManyDistributionsException,
            InvalidDefaultRootObjectException, InvalidRelativePathException, InvalidErrorCodeException,
            InvalidResponseCodeException, InvalidArgumentException, InvalidRequiredProtocolException, NoSuchOriginException,
            TooManyOriginsException, TooManyOriginGroupsPerDistributionException, TooManyCacheBehaviorsException,
            TooManyCookieNamesInWhiteListException, InvalidForwardCookiesException, TooManyHeadersInForwardedValuesException,
            InvalidHeadersForS3OriginException, InconsistentQuantitiesException, TooManyCertificatesException,
            InvalidLocationCodeException, InvalidGeoRestrictionParameterException, InvalidProtocolSettingsException,
            InvalidTtlOrderException, InvalidWebAclIdException, TooManyOriginCustomHeadersException,
            TooManyQueryStringParametersException, InvalidQueryStringParametersException,
            TooManyDistributionsWithLambdaAssociationsException, TooManyDistributionsWithSingleFunctionArnException,
            TooManyLambdaFunctionAssociationsException, InvalidLambdaFunctionAssociationException,
            TooManyDistributionsWithFunctionAssociationsException, TooManyFunctionAssociationsException,
            InvalidFunctionAssociationException, InvalidOriginReadTimeoutException, InvalidOriginKeepaliveTimeoutException,
            NoSuchFieldLevelEncryptionConfigException, IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException,
            TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException, NoSuchCachePolicyException,
            TooManyDistributionsAssociatedToCachePolicyException, NoSuchResponseHeadersPolicyException,
            TooManyDistributionsAssociatedToResponseHeadersPolicyException, NoSuchOriginRequestPolicyException,
            TooManyDistributionsAssociatedToOriginRequestPolicyException, TooManyDistributionsAssociatedToKeyGroupException,
            TooManyKeyGroupsAssociatedToDistributionException, TrustedKeyGroupDoesNotExistException,
            NoSuchRealtimeLogConfigException, RealtimeLogConfigOwnerMismatchException, ContinuousDeploymentPolicyInUseException,
            NoSuchContinuousDeploymentPolicyException, InvalidDomainNameForOriginAccessControlException, AwsServiceException,
            SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<CreateDistributionResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(CreateDistributionResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDistributionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDistributionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDistribution");

            return clientHandler.execute(new ClientExecutionParams<CreateDistributionRequest, CreateDistributionResponse>()
                    .withOperationName("CreateDistribution").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(createDistributionRequest)
                    .withMarshaller(new CreateDistributionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create a new distribution with tags. This API operation requires the following IAM permissions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CreateDistribution.html">
     * CreateDistribution</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_TagResource.html">TagResource</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createDistributionWithTagsRequest
     *        The request to create a new distribution with tags.
     * @return Result of the CreateDistributionWithTags operation returned by the service.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws DistributionAlreadyExistsException
     *         The caller reference you attempted to create the distribution with is associated with another
     *         distribution.
     * @throws InvalidOriginException
     *         The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws InvalidOriginAccessControlException
     *         The origin access control is not valid.
     * @throws IllegalOriginAccessConfigurationException
     *         An origin cannot contain both an origin access control (OAC) and an origin access identity (OAI).
     * @throws AccessDeniedException
     *         Access denied.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws InvalidViewerCertificateException
     *         A viewer certificate specified is not valid.
     * @throws InvalidMinimumProtocolVersionException
     *         The minimum protocol version specified is not valid.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws TooManyDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws TooManyDistributionsException
     *         Processing your request would cause you to exceed the maximum number of distributions allowed.
     * @throws InvalidDefaultRootObjectException
     *         The default root object file name is too big or contains an invalid character.
     * @throws InvalidRelativePathException
     *         The relative path is too big, is not URL-encoded, or does not begin with a slash (/).
     * @throws InvalidErrorCodeException
     *         An invalid error code was specified.
     * @throws InvalidResponseCodeException
     *         A response code is not valid.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidRequiredProtocolException
     *         This operation requires the HTTPS protocol. Ensure that you specify the HTTPS protocol in your request,
     *         or omit the <code>RequiredProtocols</code> element from your distribution configuration.
     * @throws NoSuchOriginException
     *         No origin exists with the specified <code>Origin Id</code>.
     * @throws TooManyOriginsException
     *         You cannot create more origins for the distribution.
     * @throws TooManyOriginGroupsPerDistributionException
     *         Processing your request would cause you to exceed the maximum number of origin groups allowed.
     * @throws TooManyCacheBehaviorsException
     *         You cannot create more cache behaviors for the distribution.
     * @throws TooManyCookieNamesInWhiteListException
     *         Your request contains more cookie names in the whitelist than are allowed per cache behavior.
     * @throws InvalidForwardCookiesException
     *         Your request contains forward cookies option which doesn't match with the expectation for the
     *         <code>whitelisted</code> list of cookie names. Either list of cookie names has been specified when not
     *         allowed or list of cookie names is missing when expected.
     * @throws TooManyHeadersInForwardedValuesException
     *         Your request contains too many headers in forwarded values.
     * @throws InvalidHeadersForS3OriginException
     *         The headers specified are not valid for an Amazon S3 origin.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws TooManyCertificatesException
     *         You cannot create anymore custom SSL/TLS certificates.
     * @throws InvalidLocationCodeException
     *         The location code specified is not valid.
     * @throws InvalidGeoRestrictionParameterException
     *         The specified geo restriction parameter is not valid.
     * @throws InvalidProtocolSettingsException
     *         You cannot specify SSLv3 as the minimum protocol version if you only want to support only clients that
     *         support Server Name Indication (SNI).
     * @throws InvalidTtlOrderException
     *         The TTL order specified is not valid.
     * @throws InvalidWebAclIdException
     *         A web ACL ID specified is not valid. To specify a web ACL created using the latest version of WAF, use
     *         the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * @throws TooManyOriginCustomHeadersException
     *         Your request contains too many origin custom headers.
     * @throws InvalidTaggingException
     *         The tagging specified is not valid.
     * @throws TooManyQueryStringParametersException
     *         Your request contains too many query string parameters.
     * @throws InvalidQueryStringParametersException
     *         The query string parameters specified are not valid.
     * @throws TooManyDistributionsWithLambdaAssociationsException
     *         Processing your request would cause the maximum number of distributions with Lambda@Edge function
     *         associations per owner to be exceeded.
     * @throws TooManyDistributionsWithSingleFunctionArnException
     *         The maximum number of distributions have been associated with the specified Lambda@Edge function.
     * @throws TooManyLambdaFunctionAssociationsException
     *         Your request contains more Lambda@Edge function associations than are allowed per distribution.
     * @throws InvalidLambdaFunctionAssociationException
     *         The specified Lambda@Edge function association is invalid.
     * @throws TooManyDistributionsWithFunctionAssociationsException
     *         You have reached the maximum number of distributions that are associated with a CloudFront function. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyFunctionAssociationsException
     *         You have reached the maximum number of CloudFront function associations for this distribution. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws InvalidFunctionAssociationException
     *         A CloudFront function association is invalid.
     * @throws InvalidOriginReadTimeoutException
     *         The read timeout specified for the origin is not valid.
     * @throws InvalidOriginKeepaliveTimeoutException
     *         The keep alive timeout specified for the origin is not valid.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException
     *         The specified configuration for field-level encryption can't be associated with the specified cache
     *         behavior.
     * @throws TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException
     *         The maximum number of distributions have been associated with the specified configuration for field-level
     *         encryption.
     * @throws NoSuchCachePolicyException
     *         The cache policy does not exist.
     * @throws TooManyDistributionsAssociatedToCachePolicyException
     *         The maximum number of distributions have been associated with the specified cache policy. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyDistributionsAssociatedToOriginAccessControlException
     *         The maximum number of distributions have been associated with the specified origin access control.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws NoSuchResponseHeadersPolicyException
     *         The response headers policy does not exist.
     * @throws TooManyDistributionsAssociatedToResponseHeadersPolicyException
     *         The maximum number of distributions have been associated with the specified response headers policy.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws NoSuchOriginRequestPolicyException
     *         The origin request policy does not exist.
     * @throws TooManyDistributionsAssociatedToOriginRequestPolicyException
     *         The maximum number of distributions have been associated with the specified origin request policy. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyDistributionsAssociatedToKeyGroupException
     *         The number of distributions that reference this key group is more than the maximum allowed. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyKeyGroupsAssociatedToDistributionException
     *         The number of key groups referenced by this distribution is more than the maximum allowed. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TrustedKeyGroupDoesNotExistException
     *         The specified key group does not exist.
     * @throws NoSuchRealtimeLogConfigException
     *         The real-time log configuration does not exist.
     * @throws RealtimeLogConfigOwnerMismatchException
     *         The specified real-time log configuration belongs to a different Amazon Web Services account.
     * @throws ContinuousDeploymentPolicyInUseException
     *         You cannot delete a continuous deployment policy that is associated with a primary distribution.
     * @throws NoSuchContinuousDeploymentPolicyException
     *         The continuous deployment policy doesn't exist.
     * @throws InvalidDomainNameForOriginAccessControlException
     *         An origin access control is associated with an origin whose domain name is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateDistributionWithTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateDistributionWithTags"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateDistributionWithTagsResponse createDistributionWithTags(
            CreateDistributionWithTagsRequest createDistributionWithTagsRequest) throws CnameAlreadyExistsException,
            DistributionAlreadyExistsException, InvalidOriginException, InvalidOriginAccessIdentityException,
            InvalidOriginAccessControlException, IllegalOriginAccessConfigurationException, AccessDeniedException,
            TooManyTrustedSignersException, TrustedSignerDoesNotExistException, InvalidViewerCertificateException,
            InvalidMinimumProtocolVersionException, MissingBodyException, TooManyDistributionCnamEsException,
            TooManyDistributionsException, InvalidDefaultRootObjectException, InvalidRelativePathException,
            InvalidErrorCodeException, InvalidResponseCodeException, InvalidArgumentException, InvalidRequiredProtocolException,
            NoSuchOriginException, TooManyOriginsException, TooManyOriginGroupsPerDistributionException,
            TooManyCacheBehaviorsException, TooManyCookieNamesInWhiteListException, InvalidForwardCookiesException,
            TooManyHeadersInForwardedValuesException, InvalidHeadersForS3OriginException, InconsistentQuantitiesException,
            TooManyCertificatesException, InvalidLocationCodeException, InvalidGeoRestrictionParameterException,
            InvalidProtocolSettingsException, InvalidTtlOrderException, InvalidWebAclIdException,
            TooManyOriginCustomHeadersException, InvalidTaggingException, TooManyQueryStringParametersException,
            InvalidQueryStringParametersException, TooManyDistributionsWithLambdaAssociationsException,
            TooManyDistributionsWithSingleFunctionArnException, TooManyLambdaFunctionAssociationsException,
            InvalidLambdaFunctionAssociationException, TooManyDistributionsWithFunctionAssociationsException,
            TooManyFunctionAssociationsException, InvalidFunctionAssociationException, InvalidOriginReadTimeoutException,
            InvalidOriginKeepaliveTimeoutException, NoSuchFieldLevelEncryptionConfigException,
            IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException,
            TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException, NoSuchCachePolicyException,
            TooManyDistributionsAssociatedToCachePolicyException, TooManyDistributionsAssociatedToOriginAccessControlException,
            NoSuchResponseHeadersPolicyException, TooManyDistributionsAssociatedToResponseHeadersPolicyException,
            NoSuchOriginRequestPolicyException, TooManyDistributionsAssociatedToOriginRequestPolicyException,
            TooManyDistributionsAssociatedToKeyGroupException, TooManyKeyGroupsAssociatedToDistributionException,
            TrustedKeyGroupDoesNotExistException, NoSuchRealtimeLogConfigException, RealtimeLogConfigOwnerMismatchException,
            ContinuousDeploymentPolicyInUseException, NoSuchContinuousDeploymentPolicyException,
            InvalidDomainNameForOriginAccessControlException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<CreateDistributionWithTagsResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(CreateDistributionWithTagsResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDistributionWithTagsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDistributionWithTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDistributionWithTags");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateDistributionWithTagsRequest, CreateDistributionWithTagsResponse>()
                            .withOperationName("CreateDistributionWithTags").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(createDistributionWithTagsRequest)
                            .withMarshaller(new CreateDistributionWithTagsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create a new field-level encryption configuration.
     * </p>
     *
     * @param createFieldLevelEncryptionConfigRequest
     * @return Result of the CreateFieldLevelEncryptionConfig operation returned by the service.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws FieldLevelEncryptionConfigAlreadyExistsException
     *         The specified configuration for field-level encryption already exists.
     * @throws TooManyFieldLevelEncryptionConfigsException
     *         The maximum number of configurations for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionQueryArgProfilesException
     *         The maximum number of query arg profiles for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionContentTypeProfilesException
     *         The maximum number of content type profiles for field-level encryption have been created.
     * @throws QueryArgProfileEmptyException
     *         No profile specified for the field-level encryption query argument.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateFieldLevelEncryptionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateFieldLevelEncryptionConfigResponse createFieldLevelEncryptionConfig(
            CreateFieldLevelEncryptionConfigRequest createFieldLevelEncryptionConfigRequest)
            throws InconsistentQuantitiesException, InvalidArgumentException, NoSuchFieldLevelEncryptionProfileException,
            FieldLevelEncryptionConfigAlreadyExistsException, TooManyFieldLevelEncryptionConfigsException,
            TooManyFieldLevelEncryptionQueryArgProfilesException, TooManyFieldLevelEncryptionContentTypeProfilesException,
            QueryArgProfileEmptyException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<CreateFieldLevelEncryptionConfigResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(CreateFieldLevelEncryptionConfigResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFieldLevelEncryptionConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createFieldLevelEncryptionConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFieldLevelEncryptionConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateFieldLevelEncryptionConfigRequest, CreateFieldLevelEncryptionConfigResponse>()
                            .withOperationName("CreateFieldLevelEncryptionConfig").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(createFieldLevelEncryptionConfigRequest)
                            .withMarshaller(new CreateFieldLevelEncryptionConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create a field-level encryption profile.
     * </p>
     *
     * @param createFieldLevelEncryptionProfileRequest
     * @return Result of the CreateFieldLevelEncryptionProfile operation returned by the service.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws FieldLevelEncryptionProfileAlreadyExistsException
     *         The specified profile for field-level encryption already exists.
     * @throws FieldLevelEncryptionProfileSizeExceededException
     *         The maximum size of a profile for field-level encryption was exceeded.
     * @throws TooManyFieldLevelEncryptionProfilesException
     *         The maximum number of profiles for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionEncryptionEntitiesException
     *         The maximum number of encryption entities for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionFieldPatternsException
     *         The maximum number of field patterns for field-level encryption have been created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateFieldLevelEncryptionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateFieldLevelEncryptionProfileResponse createFieldLevelEncryptionProfile(
            CreateFieldLevelEncryptionProfileRequest createFieldLevelEncryptionProfileRequest)
            throws InconsistentQuantitiesException, InvalidArgumentException, NoSuchPublicKeyException,
            FieldLevelEncryptionProfileAlreadyExistsException, FieldLevelEncryptionProfileSizeExceededException,
            TooManyFieldLevelEncryptionProfilesException, TooManyFieldLevelEncryptionEncryptionEntitiesException,
            TooManyFieldLevelEncryptionFieldPatternsException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<CreateFieldLevelEncryptionProfileResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(CreateFieldLevelEncryptionProfileResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFieldLevelEncryptionProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createFieldLevelEncryptionProfileRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFieldLevelEncryptionProfile");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateFieldLevelEncryptionProfileRequest, CreateFieldLevelEncryptionProfileResponse>()
                            .withOperationName("CreateFieldLevelEncryptionProfile").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(createFieldLevelEncryptionProfileRequest)
                            .withMarshaller(new CreateFieldLevelEncryptionProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a CloudFront function.
     * </p>
     * <p>
     * To create a function, you provide the function code and some configuration information about the function. The
     * response contains an Amazon Resource Name (ARN) that uniquely identifies the function.
     * </p>
     * <p>
     * When you create a function, it's in the <code>DEVELOPMENT</code> stage. In this stage, you can test the function
     * with <code>TestFunction</code>, and update it with <code>UpdateFunction</code>.
     * </p>
     * <p>
     * When you're ready to use your function with a CloudFront distribution, use <code>PublishFunction</code> to copy
     * the function from the <code>DEVELOPMENT</code> stage to <code>LIVE</code>. When it's live, you can attach the
     * function to a distribution's cache behavior, using the function's ARN.
     * </p>
     *
     * @param createFunctionRequest
     * @return Result of the CreateFunction operation returned by the service.
     * @throws TooManyFunctionsException
     *         You have reached the maximum number of CloudFront functions for this Amazon Web Services account. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws FunctionAlreadyExistsException
     *         A function with the same name already exists in this Amazon Web Services account. To create a function,
     *         you must provide a unique name. To update an existing function, use <code>UpdateFunction</code>.
     * @throws FunctionSizeLimitExceededException
     *         The function is too large. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateFunctionResponse createFunction(CreateFunctionRequest createFunctionRequest) throws TooManyFunctionsException,
            FunctionAlreadyExistsException, FunctionSizeLimitExceededException, InvalidArgumentException,
            UnsupportedOperationException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<CreateFunctionResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                CreateFunctionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFunctionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFunctionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFunction");

            return clientHandler.execute(new ClientExecutionParams<CreateFunctionRequest, CreateFunctionResponse>()
                    .withOperationName("CreateFunction").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(createFunctionRequest)
                    .withMarshaller(new CreateFunctionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create a new invalidation. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/Invalidation.html">Invalidating
     * files</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param createInvalidationRequest
     *        The request to create an invalidation.
     * @return Result of the CreateInvalidation operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws BatchTooLargeException
     *         Invalidation batch specified is too large.
     * @throws TooManyInvalidationsInProgressException
     *         You have exceeded the maximum number of allowable InProgress invalidation batch requests, or invalidation
     *         objects.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateInvalidation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateInvalidation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateInvalidationResponse createInvalidation(CreateInvalidationRequest createInvalidationRequest)
            throws AccessDeniedException, MissingBodyException, InvalidArgumentException, NoSuchDistributionException,
            BatchTooLargeException, TooManyInvalidationsInProgressException, InconsistentQuantitiesException,
            AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<CreateInvalidationResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(CreateInvalidationResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createInvalidationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createInvalidationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInvalidation");

            return clientHandler.execute(new ClientExecutionParams<CreateInvalidationRequest, CreateInvalidationResponse>()
                    .withOperationName("CreateInvalidation").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(createInvalidationRequest)
                    .withMarshaller(new CreateInvalidationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a key group that you can use with <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">CloudFront signed
     * URLs and signed cookies</a>.
     * </p>
     * <p>
     * To create a key group, you must specify at least one public key for the key group. After you create a key group,
     * you can reference it from one or more cache behaviors. When you reference a key group in a cache behavior,
     * CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or
     * cookies must be signed with a private key whose corresponding public key is in the key group. The signed URL or
     * cookie contains information about which public key CloudFront should use to verify the signature. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private
     * content</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param createKeyGroupRequest
     * @return Result of the CreateKeyGroup operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws KeyGroupAlreadyExistsException
     *         A key group with this name already exists. You must provide a unique name. To modify an existing key
     *         group, use <code>UpdateKeyGroup</code>.
     * @throws TooManyKeyGroupsException
     *         You have reached the maximum number of key groups for this Amazon Web Services account. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyPublicKeysInKeyGroupException
     *         The number of public keys in this key group is more than the maximum allowed. For more information, see
     *         <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas
     *         </a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateKeyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateKeyGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateKeyGroupResponse createKeyGroup(CreateKeyGroupRequest createKeyGroupRequest) throws InvalidArgumentException,
            KeyGroupAlreadyExistsException, TooManyKeyGroupsException, TooManyPublicKeysInKeyGroupException, AwsServiceException,
            SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<CreateKeyGroupResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                CreateKeyGroupResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createKeyGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createKeyGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateKeyGroup");

            return clientHandler.execute(new ClientExecutionParams<CreateKeyGroupRequest, CreateKeyGroupResponse>()
                    .withOperationName("CreateKeyGroup").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(createKeyGroupRequest)
                    .withMarshaller(new CreateKeyGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Specifies the key value store resource to add to your account. In your account, the key value store names must be
     * unique. You can also import key value store data in JSON format from an S3 bucket by providing a valid
     * <code>ImportSource</code> that you own.
     * </p>
     *
     * @param createKeyValueStoreRequest
     * @return Result of the CreateKeyValueStore operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws EntityLimitExceededException
     *         The key value store entity limit has been exceeded.
     * @throws EntityAlreadyExistsException
     *         The key value store entity already exists. You must provide a unique key value store entity.
     * @throws EntitySizeLimitExceededException
     *         The key value store entity size limit was exceeded.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateKeyValueStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateKeyValueStore"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateKeyValueStoreResponse createKeyValueStore(CreateKeyValueStoreRequest createKeyValueStoreRequest)
            throws AccessDeniedException, EntityLimitExceededException, EntityAlreadyExistsException,
            EntitySizeLimitExceededException, InvalidArgumentException, UnsupportedOperationException, AwsServiceException,
            SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<CreateKeyValueStoreResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(CreateKeyValueStoreResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createKeyValueStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createKeyValueStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateKeyValueStore");

            return clientHandler.execute(new ClientExecutionParams<CreateKeyValueStoreRequest, CreateKeyValueStoreResponse>()
                    .withOperationName("CreateKeyValueStore").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(createKeyValueStoreRequest)
                    .withMarshaller(new CreateKeyValueStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables additional CloudWatch metrics for the specified CloudFront distribution. The additional metrics incur an
     * additional cost.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/viewing-cloudfront-metrics.html#monitoring-console.distributions-additional"
     * >Viewing additional CloudFront distribution metrics</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param createMonitoringSubscriptionRequest
     * @return Result of the CreateMonitoringSubscription operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws MonitoringSubscriptionAlreadyExistsException
     *         A monitoring subscription already exists for the specified distribution.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateMonitoringSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateMonitoringSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateMonitoringSubscriptionResponse createMonitoringSubscription(
            CreateMonitoringSubscriptionRequest createMonitoringSubscriptionRequest) throws AccessDeniedException,
            NoSuchDistributionException, MonitoringSubscriptionAlreadyExistsException, UnsupportedOperationException,
            AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<CreateMonitoringSubscriptionResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(CreateMonitoringSubscriptionResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMonitoringSubscriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMonitoringSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMonitoringSubscription");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateMonitoringSubscriptionRequest, CreateMonitoringSubscriptionResponse>()
                            .withOperationName("CreateMonitoringSubscription").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(createMonitoringSubscriptionRequest)
                            .withMarshaller(new CreateMonitoringSubscriptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new origin access control in CloudFront. After you create an origin access control, you can add it to
     * an origin in a CloudFront distribution so that CloudFront sends authenticated (signed) requests to the origin.
     * </p>
     * <p>
     * This makes it possible to block public access to the origin, allowing viewers (users) to access the origin's
     * content only through CloudFront.
     * </p>
     * <p>
     * For more information about using a CloudFront origin access control, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-origin.html"
     * >Restricting access to an Amazon Web Services origin</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param createOriginAccessControlRequest
     * @return Result of the CreateOriginAccessControl operation returned by the service.
     * @throws OriginAccessControlAlreadyExistsException
     *         An origin access control with the specified parameters already exists.
     * @throws TooManyOriginAccessControlsException
     *         The number of origin access controls in your Amazon Web Services account exceeds the maximum allowed.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateOriginAccessControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateOriginAccessControl"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateOriginAccessControlResponse createOriginAccessControl(
            CreateOriginAccessControlRequest createOriginAccessControlRequest) throws OriginAccessControlAlreadyExistsException,
            TooManyOriginAccessControlsException, InvalidArgumentException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<CreateOriginAccessControlResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(CreateOriginAccessControlResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createOriginAccessControlRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createOriginAccessControlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOriginAccessControl");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateOriginAccessControlRequest, CreateOriginAccessControlResponse>()
                            .withOperationName("CreateOriginAccessControl").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(createOriginAccessControlRequest)
                            .withMarshaller(new CreateOriginAccessControlRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an origin request policy.
     * </p>
     * <p>
     * After you create an origin request policy, you can attach it to one or more cache behaviors. When it's attached
     * to a cache behavior, the origin request policy determines the values that CloudFront includes in requests that it
     * sends to the origin. Each request that CloudFront sends to the origin includes the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The request body and the URL path (without the domain name) from the viewer request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The headers that CloudFront automatically includes in every origin request, including <code>Host</code>,
     * <code>User-Agent</code>, and <code>X-Amz-Cf-Id</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * All HTTP headers, cookies, and URL query strings that are specified in the cache policy or the origin request
     * policy. These can include items from the viewer request and, in the case of headers, additional ones that are
     * added by CloudFront.
     * </p>
     * </li>
     * </ul>
     * <p>
     * CloudFront sends a request when it can't find a valid object in its cache that matches the request. If you want
     * to send values to the origin and also include them in the cache key, use <code>CachePolicy</code>.
     * </p>
     * <p>
     * For more information about origin request policies, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html"
     * >Controlling origin requests</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param createOriginRequestPolicyRequest
     * @return Result of the CreateOriginRequestPolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws OriginRequestPolicyAlreadyExistsException
     *         An origin request policy with this name already exists. You must provide a unique name. To modify an
     *         existing origin request policy, use <code>UpdateOriginRequestPolicy</code>.
     * @throws TooManyOriginRequestPoliciesException
     *         You have reached the maximum number of origin request policies for this Amazon Web Services account. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyHeadersInOriginRequestPolicyException
     *         The number of headers in the origin request policy exceeds the maximum. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a>
     *         (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyCookiesInOriginRequestPolicyException
     *         The number of cookies in the origin request policy exceeds the maximum. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a>
     *         (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyQueryStringsInOriginRequestPolicyException
     *         The number of query strings in the origin request policy exceeds the maximum. For more information, see
     *         <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas
     *         </a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateOriginRequestPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateOriginRequestPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateOriginRequestPolicyResponse createOriginRequestPolicy(
            CreateOriginRequestPolicyRequest createOriginRequestPolicyRequest) throws AccessDeniedException,
            InconsistentQuantitiesException, InvalidArgumentException, OriginRequestPolicyAlreadyExistsException,
            TooManyOriginRequestPoliciesException, TooManyHeadersInOriginRequestPolicyException,
            TooManyCookiesInOriginRequestPolicyException, TooManyQueryStringsInOriginRequestPolicyException, AwsServiceException,
            SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<CreateOriginRequestPolicyResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(CreateOriginRequestPolicyResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createOriginRequestPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createOriginRequestPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOriginRequestPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateOriginRequestPolicyRequest, CreateOriginRequestPolicyResponse>()
                            .withOperationName("CreateOriginRequestPolicy").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(createOriginRequestPolicyRequest)
                            .withMarshaller(new CreateOriginRequestPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Uploads a public key to CloudFront that you can use with <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and
     * signed cookies</a>, or with <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level
     * encryption</a>.
     * </p>
     *
     * @param createPublicKeyRequest
     * @return Result of the CreatePublicKey operation returned by the service.
     * @throws PublicKeyAlreadyExistsException
     *         The specified public key already exists.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws TooManyPublicKeysException
     *         The maximum number of public keys for field-level encryption have been created. To create a new public
     *         key, delete one of the existing keys.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreatePublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreatePublicKey" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreatePublicKeyResponse createPublicKey(CreatePublicKeyRequest createPublicKeyRequest)
            throws PublicKeyAlreadyExistsException, InvalidArgumentException, TooManyPublicKeysException, AwsServiceException,
            SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<CreatePublicKeyResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                CreatePublicKeyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPublicKeyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPublicKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePublicKey");

            return clientHandler.execute(new ClientExecutionParams<CreatePublicKeyRequest, CreatePublicKeyResponse>()
                    .withOperationName("CreatePublicKey").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(createPublicKeyRequest)
                    .withMarshaller(new CreatePublicKeyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a real-time log configuration.
     * </p>
     * <p>
     * After you create a real-time log configuration, you can attach it to one or more cache behaviors to send
     * real-time log data to the specified Amazon Kinesis data stream.
     * </p>
     * <p>
     * For more information about real-time log configurations, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html">Real-time logs</a>
     * in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param createRealtimeLogConfigRequest
     * @return Result of the CreateRealtimeLogConfig operation returned by the service.
     * @throws RealtimeLogConfigAlreadyExistsException
     *         A real-time log configuration with this name already exists. You must provide a unique name. To modify an
     *         existing real-time log configuration, use <code>UpdateRealtimeLogConfig</code>.
     * @throws TooManyRealtimeLogConfigsException
     *         You have reached the maximum number of real-time log configurations for this Amazon Web Services account.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateRealtimeLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateRealtimeLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateRealtimeLogConfigResponse createRealtimeLogConfig(CreateRealtimeLogConfigRequest createRealtimeLogConfigRequest)
            throws RealtimeLogConfigAlreadyExistsException, TooManyRealtimeLogConfigsException, InvalidArgumentException,
            AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<CreateRealtimeLogConfigResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(CreateRealtimeLogConfigResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRealtimeLogConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRealtimeLogConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRealtimeLogConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateRealtimeLogConfigRequest, CreateRealtimeLogConfigResponse>()
                            .withOperationName("CreateRealtimeLogConfig").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(createRealtimeLogConfigRequest)
                            .withMarshaller(new CreateRealtimeLogConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a response headers policy.
     * </p>
     * <p>
     * A response headers policy contains information about a set of HTTP headers. To create a response headers policy,
     * you provide some metadata about the policy and a set of configurations that specify the headers.
     * </p>
     * <p>
     * After you create a response headers policy, you can use its ID to attach it to one or more cache behaviors in a
     * CloudFront distribution. When it's attached to a cache behavior, the response headers policy affects the HTTP
     * headers that CloudFront includes in HTTP responses to requests that match the cache behavior. CloudFront adds or
     * removes response headers according to the configuration of the response headers policy.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/modifying-response-headers.html">Adding
     * or removing HTTP headers in CloudFront responses</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param createResponseHeadersPolicyRequest
     * @return Result of the CreateResponseHeadersPolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws ResponseHeadersPolicyAlreadyExistsException
     *         A response headers policy with this name already exists. You must provide a unique name. To modify an
     *         existing response headers policy, use <code>UpdateResponseHeadersPolicy</code>.
     * @throws TooManyResponseHeadersPoliciesException
     *         You have reached the maximum number of response headers policies for this Amazon Web Services
     *         account.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyCustomHeadersInResponseHeadersPolicyException
     *         The number of custom headers in the response headers policy exceeds the maximum.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooLongCspInResponseHeadersPolicyException
     *         The length of the <code>Content-Security-Policy</code> header value in the response headers policy
     *         exceeds the maximum.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyRemoveHeadersInResponseHeadersPolicyException
     *         The number of headers in <code>RemoveHeadersConfig</code> in the response headers policy exceeds the
     *         maximum.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateResponseHeadersPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateResponseHeadersPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateResponseHeadersPolicyResponse createResponseHeadersPolicy(
            CreateResponseHeadersPolicyRequest createResponseHeadersPolicyRequest) throws AccessDeniedException,
            InconsistentQuantitiesException, InvalidArgumentException, ResponseHeadersPolicyAlreadyExistsException,
            TooManyResponseHeadersPoliciesException, TooManyCustomHeadersInResponseHeadersPolicyException,
            TooLongCspInResponseHeadersPolicyException, TooManyRemoveHeadersInResponseHeadersPolicyException,
            AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<CreateResponseHeadersPolicyResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(CreateResponseHeadersPolicyResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createResponseHeadersPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createResponseHeadersPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateResponseHeadersPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateResponseHeadersPolicyRequest, CreateResponseHeadersPolicyResponse>()
                            .withOperationName("CreateResponseHeadersPolicy").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(createResponseHeadersPolicyRequest)
                            .withMarshaller(new CreateResponseHeadersPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This API is deprecated. Amazon CloudFront is deprecating real-time messaging protocol (RTMP) distributions on
     * December 31, 2020. For more information, <a href="http://forums.aws.amazon.com/ann.jspa?annID=7356">read the
     * announcement</a> on the Amazon CloudFront discussion forum.
     * </p>
     *
     * @param createStreamingDistributionRequest
     *        The request to create a new streaming distribution.
     * @return Result of the CreateStreamingDistribution operation returned by the service.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws StreamingDistributionAlreadyExistsException
     *         The caller reference you attempted to create the streaming distribution with is associated with another
     *         distribution
     * @throws InvalidOriginException
     *         The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws InvalidOriginAccessControlException
     *         The origin access control is not valid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws TooManyStreamingDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws TooManyStreamingDistributionsException
     *         Processing your request would cause you to exceed the maximum number of streaming distributions allowed.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateStreamingDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateStreamingDistributionResponse createStreamingDistribution(
            CreateStreamingDistributionRequest createStreamingDistributionRequest) throws CnameAlreadyExistsException,
            StreamingDistributionAlreadyExistsException, InvalidOriginException, InvalidOriginAccessIdentityException,
            InvalidOriginAccessControlException, AccessDeniedException, TooManyTrustedSignersException,
            TrustedSignerDoesNotExistException, MissingBodyException, TooManyStreamingDistributionCnamEsException,
            TooManyStreamingDistributionsException, InvalidArgumentException, InconsistentQuantitiesException,
            AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<CreateStreamingDistributionResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(CreateStreamingDistributionResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createStreamingDistributionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStreamingDistributionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStreamingDistribution");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateStreamingDistributionRequest, CreateStreamingDistributionResponse>()
                            .withOperationName("CreateStreamingDistribution").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(createStreamingDistributionRequest)
                            .withMarshaller(new CreateStreamingDistributionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This API is deprecated. Amazon CloudFront is deprecating real-time messaging protocol (RTMP) distributions on
     * December 31, 2020. For more information, <a href="http://forums.aws.amazon.com/ann.jspa?annID=7356">read the
     * announcement</a> on the Amazon CloudFront discussion forum.
     * </p>
     *
     * @param createStreamingDistributionWithTagsRequest
     *        The request to create a new streaming distribution with tags.
     * @return Result of the CreateStreamingDistributionWithTags operation returned by the service.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws StreamingDistributionAlreadyExistsException
     *         The caller reference you attempted to create the streaming distribution with is associated with another
     *         distribution
     * @throws InvalidOriginException
     *         The Amazon S3 origin server specified does not refer to a valid Amazon S3 bucket.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws InvalidOriginAccessControlException
     *         The origin access control is not valid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws TooManyStreamingDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws TooManyStreamingDistributionsException
     *         Processing your request would cause you to exceed the maximum number of streaming distributions allowed.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidTaggingException
     *         The tagging specified is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.CreateStreamingDistributionWithTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateStreamingDistributionWithTags"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateStreamingDistributionWithTagsResponse createStreamingDistributionWithTags(
            CreateStreamingDistributionWithTagsRequest createStreamingDistributionWithTagsRequest)
            throws CnameAlreadyExistsException, StreamingDistributionAlreadyExistsException, InvalidOriginException,
            InvalidOriginAccessIdentityException, InvalidOriginAccessControlException, AccessDeniedException,
            TooManyTrustedSignersException, TrustedSignerDoesNotExistException, MissingBodyException,
            TooManyStreamingDistributionCnamEsException, TooManyStreamingDistributionsException, InvalidArgumentException,
            InconsistentQuantitiesException, InvalidTaggingException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<CreateStreamingDistributionWithTagsResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(CreateStreamingDistributionWithTagsResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createStreamingDistributionWithTagsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createStreamingDistributionWithTagsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStreamingDistributionWithTags");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateStreamingDistributionWithTagsRequest, CreateStreamingDistributionWithTagsResponse>()
                            .withOperationName("CreateStreamingDistributionWithTags").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(createStreamingDistributionWithTagsRequest)
                            .withMarshaller(new CreateStreamingDistributionWithTagsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a cache policy.
     * </p>
     * <p>
     * You cannot delete a cache policy if it's attached to a cache behavior. First update your distributions to remove
     * the cache policy from all cache behaviors, then delete the cache policy.
     * </p>
     * <p>
     * To delete a cache policy, you must provide the policy's identifier and version. To get these values, you can use
     * <code>ListCachePolicies</code> or <code>GetCachePolicy</code>.
     * </p>
     *
     * @param deleteCachePolicyRequest
     * @return Result of the DeleteCachePolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchCachePolicyException
     *         The cache policy does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws IllegalDeleteException
     *         You cannot delete a managed policy.
     * @throws CachePolicyInUseException
     *         Cannot delete the cache policy because it is attached to one or more cache behaviors.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteCachePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteCachePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteCachePolicyResponse deleteCachePolicy(DeleteCachePolicyRequest deleteCachePolicyRequest)
            throws AccessDeniedException, InvalidIfMatchVersionException, NoSuchCachePolicyException,
            PreconditionFailedException, IllegalDeleteException, CachePolicyInUseException, AwsServiceException,
            SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<DeleteCachePolicyResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                DeleteCachePolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCachePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCachePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCachePolicy");

            return clientHandler.execute(new ClientExecutionParams<DeleteCachePolicyRequest, DeleteCachePolicyResponse>()
                    .withOperationName("DeleteCachePolicy").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteCachePolicyRequest)
                    .withMarshaller(new DeleteCachePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete an origin access identity.
     * </p>
     *
     * @param deleteCloudFrontOriginAccessIdentityRequest
     *        Deletes a origin access identity.
     * @return Result of the DeleteCloudFrontOriginAccessIdentity operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchCloudFrontOriginAccessIdentityException
     *         The specified origin access identity does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws CloudFrontOriginAccessIdentityInUseException
     *         The Origin Access Identity specified is already in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteCloudFrontOriginAccessIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteCloudFrontOriginAccessIdentityResponse deleteCloudFrontOriginAccessIdentity(
            DeleteCloudFrontOriginAccessIdentityRequest deleteCloudFrontOriginAccessIdentityRequest)
            throws AccessDeniedException, InvalidIfMatchVersionException, NoSuchCloudFrontOriginAccessIdentityException,
            PreconditionFailedException, CloudFrontOriginAccessIdentityInUseException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<DeleteCloudFrontOriginAccessIdentityResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(DeleteCloudFrontOriginAccessIdentityResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCloudFrontOriginAccessIdentityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteCloudFrontOriginAccessIdentityRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCloudFrontOriginAccessIdentity");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteCloudFrontOriginAccessIdentityRequest, DeleteCloudFrontOriginAccessIdentityResponse>()
                            .withOperationName("DeleteCloudFrontOriginAccessIdentity").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteCloudFrontOriginAccessIdentityRequest)
                            .withMarshaller(new DeleteCloudFrontOriginAccessIdentityRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a continuous deployment policy.
     * </p>
     * <p>
     * You cannot delete a continuous deployment policy that's attached to a primary distribution. First update your
     * distribution to remove the continuous deployment policy, then you can delete the policy.
     * </p>
     *
     * @param deleteContinuousDeploymentPolicyRequest
     * @return Result of the DeleteContinuousDeploymentPolicy operation returned by the service.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws ContinuousDeploymentPolicyInUseException
     *         You cannot delete a continuous deployment policy that is associated with a primary distribution.
     * @throws NoSuchContinuousDeploymentPolicyException
     *         The continuous deployment policy doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteContinuousDeploymentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteContinuousDeploymentPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteContinuousDeploymentPolicyResponse deleteContinuousDeploymentPolicy(
            DeleteContinuousDeploymentPolicyRequest deleteContinuousDeploymentPolicyRequest)
            throws InvalidIfMatchVersionException, InvalidArgumentException, AccessDeniedException, PreconditionFailedException,
            ContinuousDeploymentPolicyInUseException, NoSuchContinuousDeploymentPolicyException, AwsServiceException,
            SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<DeleteContinuousDeploymentPolicyResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(DeleteContinuousDeploymentPolicyResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteContinuousDeploymentPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteContinuousDeploymentPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteContinuousDeploymentPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteContinuousDeploymentPolicyRequest, DeleteContinuousDeploymentPolicyResponse>()
                            .withOperationName("DeleteContinuousDeploymentPolicy").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteContinuousDeploymentPolicyRequest)
                            .withMarshaller(new DeleteContinuousDeploymentPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete a distribution.
     * </p>
     *
     * @param deleteDistributionRequest
     *        This action deletes a web distribution. To delete a web distribution using the CloudFront API, perform the
     *        following steps.</p>
     *        <p>
     *        <b>To delete a web distribution using the CloudFront API:</b>
     *        </p>
     *        <ol>
     *        <li>
     *        <p>
     *        Disable the web distribution
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>GET Distribution Config</code> request to get the current configuration and the
     *        <code>Etag</code> header for the distribution.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Update the XML document that was returned in the response to your <code>GET Distribution Config</code>
     *        request to change the value of <code>Enabled</code> to <code>false</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>PUT Distribution Config</code> request to update the configuration for your distribution.
     *        In the request body, include the XML document that you updated in Step 3. Set the value of the HTTP
     *        <code>If-Match</code> header to the value of the <code>ETag</code> header that CloudFront returned when
     *        you submitted the <code>GET Distribution Config</code> request in Step 2.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Review the response to the <code>PUT Distribution Config</code> request to confirm that the distribution
     *        was successfully disabled.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>GET Distribution</code> request to confirm that your changes have propagated. When
     *        propagation is complete, the value of <code>Status</code> is <code>Deployed</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>DELETE Distribution</code> request. Set the value of the HTTP <code>If-Match</code> header
     *        to the value of the <code>ETag</code> header that CloudFront returned when you submitted the
     *        <code>GET Distribution Config</code> request in Step 6.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Review the response to your <code>DELETE Distribution</code> request to confirm that the distribution was
     *        successfully deleted.
     *        </p>
     *        </li>
     *        </ol>
     *        <p>
     *        For information about deleting a distribution using the CloudFront console, see <a
     *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html"
     *        >Deleting a Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * @return Result of the DeleteDistribution operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws DistributionNotDisabledException
     *         The specified CloudFront distribution is not disabled. You must disable the distribution before you can
     *         delete it.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteDistributionResponse deleteDistribution(DeleteDistributionRequest deleteDistributionRequest)
            throws AccessDeniedException, DistributionNotDisabledException, InvalidIfMatchVersionException,
            NoSuchDistributionException, PreconditionFailedException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<DeleteDistributionResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(DeleteDistributionResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDistributionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDistributionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDistribution");

            return clientHandler.execute(new ClientExecutionParams<DeleteDistributionRequest, DeleteDistributionResponse>()
                    .withOperationName("DeleteDistribution").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDistributionRequest)
                    .withMarshaller(new DeleteDistributionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Remove a field-level encryption configuration.
     * </p>
     *
     * @param deleteFieldLevelEncryptionConfigRequest
     * @return Result of the DeleteFieldLevelEncryptionConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws FieldLevelEncryptionConfigInUseException
     *         The specified configuration for field-level encryption is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteFieldLevelEncryptionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteFieldLevelEncryptionConfigResponse deleteFieldLevelEncryptionConfig(
            DeleteFieldLevelEncryptionConfigRequest deleteFieldLevelEncryptionConfigRequest) throws AccessDeniedException,
            InvalidIfMatchVersionException, NoSuchFieldLevelEncryptionConfigException, PreconditionFailedException,
            FieldLevelEncryptionConfigInUseException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<DeleteFieldLevelEncryptionConfigResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(DeleteFieldLevelEncryptionConfigResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFieldLevelEncryptionConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteFieldLevelEncryptionConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFieldLevelEncryptionConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteFieldLevelEncryptionConfigRequest, DeleteFieldLevelEncryptionConfigResponse>()
                            .withOperationName("DeleteFieldLevelEncryptionConfig").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteFieldLevelEncryptionConfigRequest)
                            .withMarshaller(new DeleteFieldLevelEncryptionConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Remove a field-level encryption profile.
     * </p>
     *
     * @param deleteFieldLevelEncryptionProfileRequest
     * @return Result of the DeleteFieldLevelEncryptionProfile operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws FieldLevelEncryptionProfileInUseException
     *         The specified profile for field-level encryption is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteFieldLevelEncryptionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteFieldLevelEncryptionProfileResponse deleteFieldLevelEncryptionProfile(
            DeleteFieldLevelEncryptionProfileRequest deleteFieldLevelEncryptionProfileRequest) throws AccessDeniedException,
            InvalidIfMatchVersionException, NoSuchFieldLevelEncryptionProfileException, PreconditionFailedException,
            FieldLevelEncryptionProfileInUseException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<DeleteFieldLevelEncryptionProfileResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(DeleteFieldLevelEncryptionProfileResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFieldLevelEncryptionProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteFieldLevelEncryptionProfileRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFieldLevelEncryptionProfile");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteFieldLevelEncryptionProfileRequest, DeleteFieldLevelEncryptionProfileResponse>()
                            .withOperationName("DeleteFieldLevelEncryptionProfile").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteFieldLevelEncryptionProfileRequest)
                            .withMarshaller(new DeleteFieldLevelEncryptionProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a CloudFront function.
     * </p>
     * <p>
     * You cannot delete a function if it's associated with a cache behavior. First, update your distributions to remove
     * the function association from all cache behaviors, then delete the function.
     * </p>
     * <p>
     * To delete a function, you must provide the function's name and version (<code>ETag</code> value). To get these
     * values, you can use <code>ListFunctions</code> and <code>DescribeFunction</code>.
     * </p>
     *
     * @param deleteFunctionRequest
     * @return Result of the DeleteFunction operation returned by the service.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchFunctionExistsException
     *         The function does not exist.
     * @throws FunctionInUseException
     *         Cannot delete the function because it's attached to one or more cache behaviors.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteFunction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteFunctionResponse deleteFunction(DeleteFunctionRequest deleteFunctionRequest)
            throws InvalidIfMatchVersionException, NoSuchFunctionExistsException, FunctionInUseException,
            PreconditionFailedException, UnsupportedOperationException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<DeleteFunctionResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                DeleteFunctionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFunctionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFunctionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFunction");

            return clientHandler.execute(new ClientExecutionParams<DeleteFunctionRequest, DeleteFunctionResponse>()
                    .withOperationName("DeleteFunction").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteFunctionRequest)
                    .withMarshaller(new DeleteFunctionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a key group.
     * </p>
     * <p>
     * You cannot delete a key group that is referenced in a cache behavior. First update your distributions to remove
     * the key group from all cache behaviors, then delete the key group.
     * </p>
     * <p>
     * To delete a key group, you must provide the key group's identifier and version. To get these values, use
     * <code>ListKeyGroups</code> followed by <code>GetKeyGroup</code> or <code>GetKeyGroupConfig</code>.
     * </p>
     *
     * @param deleteKeyGroupRequest
     * @return Result of the DeleteKeyGroup operation returned by the service.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchResourceException
     *         A resource that was specified is not valid.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws ResourceInUseException
     *         Cannot delete this resource because it is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteKeyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteKeyGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteKeyGroupResponse deleteKeyGroup(DeleteKeyGroupRequest deleteKeyGroupRequest)
            throws InvalidIfMatchVersionException, NoSuchResourceException, PreconditionFailedException, ResourceInUseException,
            AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<DeleteKeyGroupResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                DeleteKeyGroupResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteKeyGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteKeyGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteKeyGroup");

            return clientHandler.execute(new ClientExecutionParams<DeleteKeyGroupRequest, DeleteKeyGroupResponse>()
                    .withOperationName("DeleteKeyGroup").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteKeyGroupRequest)
                    .withMarshaller(new DeleteKeyGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Specifies the key value store to delete.
     * </p>
     *
     * @param deleteKeyValueStoreRequest
     * @return Result of the DeleteKeyValueStore operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws EntityNotFoundException
     *         The key value store entity was not found.
     * @throws CannotDeleteEntityWhileInUseException
     *         The key value store entity cannot be deleted while it is in use.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteKeyValueStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteKeyValueStore"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteKeyValueStoreResponse deleteKeyValueStore(DeleteKeyValueStoreRequest deleteKeyValueStoreRequest)
            throws AccessDeniedException, InvalidIfMatchVersionException, EntityNotFoundException,
            CannotDeleteEntityWhileInUseException, PreconditionFailedException, UnsupportedOperationException,
            AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<DeleteKeyValueStoreResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(DeleteKeyValueStoreResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteKeyValueStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteKeyValueStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteKeyValueStore");

            return clientHandler.execute(new ClientExecutionParams<DeleteKeyValueStoreRequest, DeleteKeyValueStoreResponse>()
                    .withOperationName("DeleteKeyValueStore").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteKeyValueStoreRequest)
                    .withMarshaller(new DeleteKeyValueStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disables additional CloudWatch metrics for the specified CloudFront distribution.
     * </p>
     *
     * @param deleteMonitoringSubscriptionRequest
     * @return Result of the DeleteMonitoringSubscription operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws NoSuchMonitoringSubscriptionException
     *         A monitoring subscription does not exist for the specified distribution.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteMonitoringSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteMonitoringSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteMonitoringSubscriptionResponse deleteMonitoringSubscription(
            DeleteMonitoringSubscriptionRequest deleteMonitoringSubscriptionRequest) throws AccessDeniedException,
            NoSuchDistributionException, NoSuchMonitoringSubscriptionException, UnsupportedOperationException,
            AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<DeleteMonitoringSubscriptionResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(DeleteMonitoringSubscriptionResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMonitoringSubscriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMonitoringSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMonitoringSubscription");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteMonitoringSubscriptionRequest, DeleteMonitoringSubscriptionResponse>()
                            .withOperationName("DeleteMonitoringSubscription").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteMonitoringSubscriptionRequest)
                            .withMarshaller(new DeleteMonitoringSubscriptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a CloudFront origin access control.
     * </p>
     * <p>
     * You cannot delete an origin access control if it's in use. First, update all distributions to remove the origin
     * access control from all origins, then delete the origin access control.
     * </p>
     *
     * @param deleteOriginAccessControlRequest
     * @return Result of the DeleteOriginAccessControl operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchOriginAccessControlException
     *         The origin access control does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws OriginAccessControlInUseException
     *         Cannot delete the origin access control because it's in use by one or more distributions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteOriginAccessControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteOriginAccessControl"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteOriginAccessControlResponse deleteOriginAccessControl(
            DeleteOriginAccessControlRequest deleteOriginAccessControlRequest) throws AccessDeniedException,
            InvalidIfMatchVersionException, NoSuchOriginAccessControlException, PreconditionFailedException,
            OriginAccessControlInUseException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<DeleteOriginAccessControlResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(DeleteOriginAccessControlResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteOriginAccessControlRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOriginAccessControlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOriginAccessControl");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteOriginAccessControlRequest, DeleteOriginAccessControlResponse>()
                            .withOperationName("DeleteOriginAccessControl").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteOriginAccessControlRequest)
                            .withMarshaller(new DeleteOriginAccessControlRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an origin request policy.
     * </p>
     * <p>
     * You cannot delete an origin request policy if it's attached to any cache behaviors. First update your
     * distributions to remove the origin request policy from all cache behaviors, then delete the origin request
     * policy.
     * </p>
     * <p>
     * To delete an origin request policy, you must provide the policy's identifier and version. To get the identifier,
     * you can use <code>ListOriginRequestPolicies</code> or <code>GetOriginRequestPolicy</code>.
     * </p>
     *
     * @param deleteOriginRequestPolicyRequest
     * @return Result of the DeleteOriginRequestPolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchOriginRequestPolicyException
     *         The origin request policy does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws IllegalDeleteException
     *         You cannot delete a managed policy.
     * @throws OriginRequestPolicyInUseException
     *         Cannot delete the origin request policy because it is attached to one or more cache behaviors.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteOriginRequestPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteOriginRequestPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteOriginRequestPolicyResponse deleteOriginRequestPolicy(
            DeleteOriginRequestPolicyRequest deleteOriginRequestPolicyRequest) throws AccessDeniedException,
            InvalidIfMatchVersionException, NoSuchOriginRequestPolicyException, PreconditionFailedException,
            IllegalDeleteException, OriginRequestPolicyInUseException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<DeleteOriginRequestPolicyResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(DeleteOriginRequestPolicyResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteOriginRequestPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOriginRequestPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOriginRequestPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteOriginRequestPolicyRequest, DeleteOriginRequestPolicyResponse>()
                            .withOperationName("DeleteOriginRequestPolicy").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteOriginRequestPolicyRequest)
                            .withMarshaller(new DeleteOriginRequestPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Remove a public key you previously added to CloudFront.
     * </p>
     *
     * @param deletePublicKeyRequest
     * @return Result of the DeletePublicKey operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws PublicKeyInUseException
     *         The specified public key is in use.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeletePublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeletePublicKey" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeletePublicKeyResponse deletePublicKey(DeletePublicKeyRequest deletePublicKeyRequest) throws AccessDeniedException,
            PublicKeyInUseException, InvalidIfMatchVersionException, NoSuchPublicKeyException, PreconditionFailedException,
            AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<DeletePublicKeyResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                DeletePublicKeyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePublicKeyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePublicKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePublicKey");

            return clientHandler.execute(new ClientExecutionParams<DeletePublicKeyRequest, DeletePublicKeyResponse>()
                    .withOperationName("DeletePublicKey").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(deletePublicKeyRequest)
                    .withMarshaller(new DeletePublicKeyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a real-time log configuration.
     * </p>
     * <p>
     * You cannot delete a real-time log configuration if it's attached to a cache behavior. First update your
     * distributions to remove the real-time log configuration from all cache behaviors, then delete the real-time log
     * configuration.
     * </p>
     * <p>
     * To delete a real-time log configuration, you can provide the configuration's name or its Amazon Resource Name
     * (ARN). You must provide at least one. If you provide both, CloudFront uses the name to identify the real-time log
     * configuration to delete.
     * </p>
     *
     * @param deleteRealtimeLogConfigRequest
     * @return Result of the DeleteRealtimeLogConfig operation returned by the service.
     * @throws NoSuchRealtimeLogConfigException
     *         The real-time log configuration does not exist.
     * @throws RealtimeLogConfigInUseException
     *         Cannot delete the real-time log configuration because it is attached to one or more cache behaviors.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteRealtimeLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteRealtimeLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteRealtimeLogConfigResponse deleteRealtimeLogConfig(DeleteRealtimeLogConfigRequest deleteRealtimeLogConfigRequest)
            throws NoSuchRealtimeLogConfigException, RealtimeLogConfigInUseException, InvalidArgumentException,
            AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<DeleteRealtimeLogConfigResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(DeleteRealtimeLogConfigResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRealtimeLogConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRealtimeLogConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRealtimeLogConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteRealtimeLogConfigRequest, DeleteRealtimeLogConfigResponse>()
                            .withOperationName("DeleteRealtimeLogConfig").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteRealtimeLogConfigRequest)
                            .withMarshaller(new DeleteRealtimeLogConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a response headers policy.
     * </p>
     * <p>
     * You cannot delete a response headers policy if it's attached to a cache behavior. First update your distributions
     * to remove the response headers policy from all cache behaviors, then delete the response headers policy.
     * </p>
     * <p>
     * To delete a response headers policy, you must provide the policy's identifier and version. To get these values,
     * you can use <code>ListResponseHeadersPolicies</code> or <code>GetResponseHeadersPolicy</code>.
     * </p>
     *
     * @param deleteResponseHeadersPolicyRequest
     * @return Result of the DeleteResponseHeadersPolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchResponseHeadersPolicyException
     *         The response headers policy does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws IllegalDeleteException
     *         You cannot delete a managed policy.
     * @throws ResponseHeadersPolicyInUseException
     *         Cannot delete the response headers policy because it is attached to one or more cache behaviors in a
     *         CloudFront distribution.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteResponseHeadersPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteResponseHeadersPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteResponseHeadersPolicyResponse deleteResponseHeadersPolicy(
            DeleteResponseHeadersPolicyRequest deleteResponseHeadersPolicyRequest) throws AccessDeniedException,
            InvalidIfMatchVersionException, NoSuchResponseHeadersPolicyException, PreconditionFailedException,
            IllegalDeleteException, ResponseHeadersPolicyInUseException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<DeleteResponseHeadersPolicyResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(DeleteResponseHeadersPolicyResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteResponseHeadersPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResponseHeadersPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResponseHeadersPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteResponseHeadersPolicyRequest, DeleteResponseHeadersPolicyResponse>()
                            .withOperationName("DeleteResponseHeadersPolicy").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteResponseHeadersPolicyRequest)
                            .withMarshaller(new DeleteResponseHeadersPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete a streaming distribution. To delete an RTMP distribution using the CloudFront API, perform the following
     * steps.
     * </p>
     * <p>
     * <b>To delete an RTMP distribution using the CloudFront API</b>:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Disable the RTMP distribution.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>GET Streaming Distribution Config</code> request to get the current configuration and the
     * <code>Etag</code> header for the distribution.
     * </p>
     * </li>
     * <li>
     * <p>
     * Update the XML document that was returned in the response to your <code>GET Streaming Distribution Config</code>
     * request to change the value of <code>Enabled</code> to <code>false</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>PUT Streaming Distribution Config</code> request to update the configuration for your
     * distribution. In the request body, include the XML document that you updated in Step 3. Then set the value of the
     * HTTP <code>If-Match</code> header to the value of the <code>ETag</code> header that CloudFront returned when you
     * submitted the <code>GET Streaming Distribution Config</code> request in Step 2.
     * </p>
     * </li>
     * <li>
     * <p>
     * Review the response to the <code>PUT Streaming Distribution Config</code> request to confirm that the
     * distribution was successfully disabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>GET Streaming Distribution Config</code> request to confirm that your changes have propagated.
     * When propagation is complete, the value of <code>Status</code> is <code>Deployed</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>DELETE Streaming Distribution</code> request. Set the value of the HTTP <code>If-Match</code>
     * header to the value of the <code>ETag</code> header that CloudFront returned when you submitted the
     * <code>GET Streaming Distribution Config</code> request in Step 2.
     * </p>
     * </li>
     * <li>
     * <p>
     * Review the response to your <code>DELETE Streaming Distribution</code> request to confirm that the distribution
     * was successfully deleted.
     * </p>
     * </li>
     * </ol>
     * <p>
     * For information about deleting a distribution using the CloudFront console, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html">Deleting a
     * Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param deleteStreamingDistributionRequest
     *        The request to delete a streaming distribution.
     * @return Result of the DeleteStreamingDistribution operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws StreamingDistributionNotDisabledException
     *         The specified CloudFront distribution is not disabled. You must disable the distribution before you can
     *         delete it.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchStreamingDistributionException
     *         The specified streaming distribution does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DeleteStreamingDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteStreamingDistributionResponse deleteStreamingDistribution(
            DeleteStreamingDistributionRequest deleteStreamingDistributionRequest) throws AccessDeniedException,
            StreamingDistributionNotDisabledException, InvalidIfMatchVersionException, NoSuchStreamingDistributionException,
            PreconditionFailedException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<DeleteStreamingDistributionResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(DeleteStreamingDistributionResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteStreamingDistributionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStreamingDistributionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStreamingDistribution");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteStreamingDistributionRequest, DeleteStreamingDistributionResponse>()
                            .withOperationName("DeleteStreamingDistribution").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteStreamingDistributionRequest)
                            .withMarshaller(new DeleteStreamingDistributionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets configuration information and metadata about a CloudFront function, but not the function's code. To get a
     * function's code, use <code>GetFunction</code>.
     * </p>
     * <p>
     * To get configuration information and metadata about a function, you must provide the function's name and stage.
     * To get these values, you can use <code>ListFunctions</code>.
     * </p>
     *
     * @param describeFunctionRequest
     * @return Result of the DescribeFunction operation returned by the service.
     * @throws NoSuchFunctionExistsException
     *         The function does not exist.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DescribeFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DescribeFunction" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeFunctionResponse describeFunction(DescribeFunctionRequest describeFunctionRequest)
            throws NoSuchFunctionExistsException, UnsupportedOperationException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<DescribeFunctionResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                DescribeFunctionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFunctionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFunctionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFunction");

            return clientHandler.execute(new ClientExecutionParams<DescribeFunctionRequest, DescribeFunctionResponse>()
                    .withOperationName("DescribeFunction").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(describeFunctionRequest)
                    .withMarshaller(new DescribeFunctionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Specifies the key value store and its configuration.
     * </p>
     *
     * @param describeKeyValueStoreRequest
     * @return Result of the DescribeKeyValueStore operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws EntityNotFoundException
     *         The key value store entity was not found.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.DescribeKeyValueStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DescribeKeyValueStore"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeKeyValueStoreResponse describeKeyValueStore(DescribeKeyValueStoreRequest describeKeyValueStoreRequest)
            throws AccessDeniedException, InvalidArgumentException, EntityNotFoundException, UnsupportedOperationException,
            AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<DescribeKeyValueStoreResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(DescribeKeyValueStoreResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeKeyValueStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeKeyValueStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeKeyValueStore");

            return clientHandler.execute(new ClientExecutionParams<DescribeKeyValueStoreRequest, DescribeKeyValueStoreResponse>()
                    .withOperationName("DescribeKeyValueStore").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(describeKeyValueStoreRequest)
                    .withMarshaller(new DescribeKeyValueStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a cache policy, including the following metadata:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The policy's identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * The date and time when the policy was last modified.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get a cache policy, you must provide the policy's identifier. If the cache policy is attached to a
     * distribution's cache behavior, you can get the policy's identifier using <code>ListDistributions</code> or
     * <code>GetDistribution</code>. If the cache policy is not attached to a cache behavior, you can get the identifier
     * using <code>ListCachePolicies</code>.
     * </p>
     *
     * @param getCachePolicyRequest
     * @return Result of the GetCachePolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchCachePolicyException
     *         The cache policy does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetCachePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCachePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetCachePolicyResponse getCachePolicy(GetCachePolicyRequest getCachePolicyRequest) throws AccessDeniedException,
            NoSuchCachePolicyException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<GetCachePolicyResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                GetCachePolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCachePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCachePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCachePolicy");

            return clientHandler.execute(new ClientExecutionParams<GetCachePolicyRequest, GetCachePolicyResponse>()
                    .withOperationName("GetCachePolicy").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(getCachePolicyRequest)
                    .withMarshaller(new GetCachePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a cache policy configuration.
     * </p>
     * <p>
     * To get a cache policy configuration, you must provide the policy's identifier. If the cache policy is attached to
     * a distribution's cache behavior, you can get the policy's identifier using <code>ListDistributions</code> or
     * <code>GetDistribution</code>. If the cache policy is not attached to a cache behavior, you can get the identifier
     * using <code>ListCachePolicies</code>.
     * </p>
     *
     * @param getCachePolicyConfigRequest
     * @return Result of the GetCachePolicyConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchCachePolicyException
     *         The cache policy does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetCachePolicyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCachePolicyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCachePolicyConfigResponse getCachePolicyConfig(GetCachePolicyConfigRequest getCachePolicyConfigRequest)
            throws AccessDeniedException, NoSuchCachePolicyException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<GetCachePolicyConfigResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetCachePolicyConfigResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCachePolicyConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCachePolicyConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCachePolicyConfig");

            return clientHandler.execute(new ClientExecutionParams<GetCachePolicyConfigRequest, GetCachePolicyConfigResponse>()
                    .withOperationName("GetCachePolicyConfig").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(getCachePolicyConfigRequest)
                    .withMarshaller(new GetCachePolicyConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get the information about an origin access identity.
     * </p>
     *
     * @param getCloudFrontOriginAccessIdentityRequest
     *        The request to get an origin access identity's information.
     * @return Result of the GetCloudFrontOriginAccessIdentity operation returned by the service.
     * @throws NoSuchCloudFrontOriginAccessIdentityException
     *         The specified origin access identity does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetCloudFrontOriginAccessIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCloudFrontOriginAccessIdentityResponse getCloudFrontOriginAccessIdentity(
            GetCloudFrontOriginAccessIdentityRequest getCloudFrontOriginAccessIdentityRequest)
            throws NoSuchCloudFrontOriginAccessIdentityException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<GetCloudFrontOriginAccessIdentityResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetCloudFrontOriginAccessIdentityResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCloudFrontOriginAccessIdentityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getCloudFrontOriginAccessIdentityRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCloudFrontOriginAccessIdentity");

            return clientHandler
                    .execute(new ClientExecutionParams<GetCloudFrontOriginAccessIdentityRequest, GetCloudFrontOriginAccessIdentityResponse>()
                            .withOperationName("GetCloudFrontOriginAccessIdentity").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(getCloudFrontOriginAccessIdentityRequest)
                            .withMarshaller(new GetCloudFrontOriginAccessIdentityRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get the configuration information about an origin access identity.
     * </p>
     *
     * @param getCloudFrontOriginAccessIdentityConfigRequest
     *        The origin access identity's configuration information. For more information, see <a href=
     *        "https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CloudFrontOriginAccessIdentityConfig.html"
     *        >CloudFrontOriginAccessIdentityConfig</a>.
     * @return Result of the GetCloudFrontOriginAccessIdentityConfig operation returned by the service.
     * @throws NoSuchCloudFrontOriginAccessIdentityException
     *         The specified origin access identity does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetCloudFrontOriginAccessIdentityConfig
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCloudFrontOriginAccessIdentityConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCloudFrontOriginAccessIdentityConfigResponse getCloudFrontOriginAccessIdentityConfig(
            GetCloudFrontOriginAccessIdentityConfigRequest getCloudFrontOriginAccessIdentityConfigRequest)
            throws NoSuchCloudFrontOriginAccessIdentityException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<GetCloudFrontOriginAccessIdentityConfigResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetCloudFrontOriginAccessIdentityConfigResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCloudFrontOriginAccessIdentityConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getCloudFrontOriginAccessIdentityConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCloudFrontOriginAccessIdentityConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<GetCloudFrontOriginAccessIdentityConfigRequest, GetCloudFrontOriginAccessIdentityConfigResponse>()
                            .withOperationName("GetCloudFrontOriginAccessIdentityConfig").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(getCloudFrontOriginAccessIdentityConfigRequest)
                            .withMarshaller(new GetCloudFrontOriginAccessIdentityConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a continuous deployment policy, including metadata (the policy's identifier and the date and time when the
     * policy was last modified).
     * </p>
     *
     * @param getContinuousDeploymentPolicyRequest
     * @return Result of the GetContinuousDeploymentPolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchContinuousDeploymentPolicyException
     *         The continuous deployment policy doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetContinuousDeploymentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetContinuousDeploymentPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetContinuousDeploymentPolicyResponse getContinuousDeploymentPolicy(
            GetContinuousDeploymentPolicyRequest getContinuousDeploymentPolicyRequest) throws AccessDeniedException,
            NoSuchContinuousDeploymentPolicyException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<GetContinuousDeploymentPolicyResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetContinuousDeploymentPolicyResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getContinuousDeploymentPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getContinuousDeploymentPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetContinuousDeploymentPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<GetContinuousDeploymentPolicyRequest, GetContinuousDeploymentPolicyResponse>()
                            .withOperationName("GetContinuousDeploymentPolicy").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(getContinuousDeploymentPolicyRequest)
                            .withMarshaller(new GetContinuousDeploymentPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets configuration information about a continuous deployment policy.
     * </p>
     *
     * @param getContinuousDeploymentPolicyConfigRequest
     * @return Result of the GetContinuousDeploymentPolicyConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchContinuousDeploymentPolicyException
     *         The continuous deployment policy doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetContinuousDeploymentPolicyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetContinuousDeploymentPolicyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetContinuousDeploymentPolicyConfigResponse getContinuousDeploymentPolicyConfig(
            GetContinuousDeploymentPolicyConfigRequest getContinuousDeploymentPolicyConfigRequest) throws AccessDeniedException,
            NoSuchContinuousDeploymentPolicyException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<GetContinuousDeploymentPolicyConfigResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetContinuousDeploymentPolicyConfigResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getContinuousDeploymentPolicyConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getContinuousDeploymentPolicyConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetContinuousDeploymentPolicyConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<GetContinuousDeploymentPolicyConfigRequest, GetContinuousDeploymentPolicyConfigResponse>()
                            .withOperationName("GetContinuousDeploymentPolicyConfig").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(getContinuousDeploymentPolicyConfigRequest)
                            .withMarshaller(new GetContinuousDeploymentPolicyConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get the information about a distribution.
     * </p>
     *
     * @param getDistributionRequest
     *        The request to get a distribution's information.
     * @return Result of the GetDistribution operation returned by the service.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetDistributionResponse getDistribution(GetDistributionRequest getDistributionRequest)
            throws NoSuchDistributionException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<GetDistributionResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                GetDistributionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDistributionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDistributionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDistribution");

            return clientHandler.execute(new ClientExecutionParams<GetDistributionRequest, GetDistributionResponse>()
                    .withOperationName("GetDistribution").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(getDistributionRequest)
                    .withMarshaller(new GetDistributionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get the configuration information about a distribution.
     * </p>
     *
     * @param getDistributionConfigRequest
     *        The request to get a distribution configuration.
     * @return Result of the GetDistributionConfig operation returned by the service.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetDistributionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetDistributionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetDistributionConfigResponse getDistributionConfig(GetDistributionConfigRequest getDistributionConfigRequest)
            throws NoSuchDistributionException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<GetDistributionConfigResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetDistributionConfigResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDistributionConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDistributionConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDistributionConfig");

            return clientHandler.execute(new ClientExecutionParams<GetDistributionConfigRequest, GetDistributionConfigResponse>()
                    .withOperationName("GetDistributionConfig").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(getDistributionConfigRequest)
                    .withMarshaller(new GetDistributionConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get the field-level encryption configuration information.
     * </p>
     *
     * @param getFieldLevelEncryptionRequest
     * @return Result of the GetFieldLevelEncryption operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetFieldLevelEncryption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFieldLevelEncryption"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetFieldLevelEncryptionResponse getFieldLevelEncryption(GetFieldLevelEncryptionRequest getFieldLevelEncryptionRequest)
            throws AccessDeniedException, NoSuchFieldLevelEncryptionConfigException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<GetFieldLevelEncryptionResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetFieldLevelEncryptionResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getFieldLevelEncryptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFieldLevelEncryptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFieldLevelEncryption");

            return clientHandler
                    .execute(new ClientExecutionParams<GetFieldLevelEncryptionRequest, GetFieldLevelEncryptionResponse>()
                            .withOperationName("GetFieldLevelEncryption").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(getFieldLevelEncryptionRequest)
                            .withMarshaller(new GetFieldLevelEncryptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get the field-level encryption configuration information.
     * </p>
     *
     * @param getFieldLevelEncryptionConfigRequest
     * @return Result of the GetFieldLevelEncryptionConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetFieldLevelEncryptionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetFieldLevelEncryptionConfigResponse getFieldLevelEncryptionConfig(
            GetFieldLevelEncryptionConfigRequest getFieldLevelEncryptionConfigRequest) throws AccessDeniedException,
            NoSuchFieldLevelEncryptionConfigException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<GetFieldLevelEncryptionConfigResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetFieldLevelEncryptionConfigResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getFieldLevelEncryptionConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getFieldLevelEncryptionConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFieldLevelEncryptionConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<GetFieldLevelEncryptionConfigRequest, GetFieldLevelEncryptionConfigResponse>()
                            .withOperationName("GetFieldLevelEncryptionConfig").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(getFieldLevelEncryptionConfigRequest)
                            .withMarshaller(new GetFieldLevelEncryptionConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get the field-level encryption profile information.
     * </p>
     *
     * @param getFieldLevelEncryptionProfileRequest
     * @return Result of the GetFieldLevelEncryptionProfile operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetFieldLevelEncryptionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetFieldLevelEncryptionProfileResponse getFieldLevelEncryptionProfile(
            GetFieldLevelEncryptionProfileRequest getFieldLevelEncryptionProfileRequest) throws AccessDeniedException,
            NoSuchFieldLevelEncryptionProfileException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<GetFieldLevelEncryptionProfileResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetFieldLevelEncryptionProfileResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getFieldLevelEncryptionProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getFieldLevelEncryptionProfileRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFieldLevelEncryptionProfile");

            return clientHandler
                    .execute(new ClientExecutionParams<GetFieldLevelEncryptionProfileRequest, GetFieldLevelEncryptionProfileResponse>()
                            .withOperationName("GetFieldLevelEncryptionProfile").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(getFieldLevelEncryptionProfileRequest)
                            .withMarshaller(new GetFieldLevelEncryptionProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get the field-level encryption profile configuration information.
     * </p>
     *
     * @param getFieldLevelEncryptionProfileConfigRequest
     * @return Result of the GetFieldLevelEncryptionProfileConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetFieldLevelEncryptionProfileConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFieldLevelEncryptionProfileConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetFieldLevelEncryptionProfileConfigResponse getFieldLevelEncryptionProfileConfig(
            GetFieldLevelEncryptionProfileConfigRequest getFieldLevelEncryptionProfileConfigRequest)
            throws AccessDeniedException, NoSuchFieldLevelEncryptionProfileException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<GetFieldLevelEncryptionProfileConfigResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetFieldLevelEncryptionProfileConfigResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getFieldLevelEncryptionProfileConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getFieldLevelEncryptionProfileConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFieldLevelEncryptionProfileConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<GetFieldLevelEncryptionProfileConfigRequest, GetFieldLevelEncryptionProfileConfigResponse>()
                            .withOperationName("GetFieldLevelEncryptionProfileConfig").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(getFieldLevelEncryptionProfileConfigRequest)
                            .withMarshaller(new GetFieldLevelEncryptionProfileConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the code of a CloudFront function. To get configuration information and metadata about a function, use
     * <code>DescribeFunction</code>.
     * </p>
     * <p>
     * To get a function's code, you must provide the function's name and stage. To get these values, you can use
     * <code>ListFunctions</code>.
     * </p>
     *
     * @param getFunctionRequest
     * @return Result of the GetFunction operation returned by the service.
     * @throws NoSuchFunctionExistsException
     *         The function does not exist.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFunction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetFunctionResponse getFunction(GetFunctionRequest getFunctionRequest) throws NoSuchFunctionExistsException,
            UnsupportedOperationException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<GetFunctionResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                GetFunctionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getFunctionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFunctionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFunction");

            return clientHandler.execute(new ClientExecutionParams<GetFunctionRequest, GetFunctionResponse>()
                    .withOperationName("GetFunction").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(getFunctionRequest)
                    .withMarshaller(new GetFunctionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get the information about an invalidation.
     * </p>
     *
     * @param getInvalidationRequest
     *        The request to get an invalidation's information.
     * @return Result of the GetInvalidation operation returned by the service.
     * @throws NoSuchInvalidationException
     *         The specified invalidation does not exist.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetInvalidation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetInvalidation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetInvalidationResponse getInvalidation(GetInvalidationRequest getInvalidationRequest)
            throws NoSuchInvalidationException, NoSuchDistributionException, AccessDeniedException, AwsServiceException,
            SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<GetInvalidationResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                GetInvalidationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getInvalidationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getInvalidationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInvalidation");

            return clientHandler.execute(new ClientExecutionParams<GetInvalidationRequest, GetInvalidationResponse>()
                    .withOperationName("GetInvalidation").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(getInvalidationRequest)
                    .withMarshaller(new GetInvalidationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a key group, including the date and time when the key group was last modified.
     * </p>
     * <p>
     * To get a key group, you must provide the key group's identifier. If the key group is referenced in a
     * distribution's cache behavior, you can get the key group's identifier using <code>ListDistributions</code> or
     * <code>GetDistribution</code>. If the key group is not referenced in a cache behavior, you can get the identifier
     * using <code>ListKeyGroups</code>.
     * </p>
     *
     * @param getKeyGroupRequest
     * @return Result of the GetKeyGroup operation returned by the service.
     * @throws NoSuchResourceException
     *         A resource that was specified is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetKeyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetKeyGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetKeyGroupResponse getKeyGroup(GetKeyGroupRequest getKeyGroupRequest) throws NoSuchResourceException,
            AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<GetKeyGroupResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                GetKeyGroupResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getKeyGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getKeyGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetKeyGroup");

            return clientHandler.execute(new ClientExecutionParams<GetKeyGroupRequest, GetKeyGroupResponse>()
                    .withOperationName("GetKeyGroup").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(getKeyGroupRequest)
                    .withMarshaller(new GetKeyGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a key group configuration.
     * </p>
     * <p>
     * To get a key group configuration, you must provide the key group's identifier. If the key group is referenced in
     * a distribution's cache behavior, you can get the key group's identifier using <code>ListDistributions</code> or
     * <code>GetDistribution</code>. If the key group is not referenced in a cache behavior, you can get the identifier
     * using <code>ListKeyGroups</code>.
     * </p>
     *
     * @param getKeyGroupConfigRequest
     * @return Result of the GetKeyGroupConfig operation returned by the service.
     * @throws NoSuchResourceException
     *         A resource that was specified is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetKeyGroupConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetKeyGroupConfig" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetKeyGroupConfigResponse getKeyGroupConfig(GetKeyGroupConfigRequest getKeyGroupConfigRequest)
            throws NoSuchResourceException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<GetKeyGroupConfigResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                GetKeyGroupConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getKeyGroupConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getKeyGroupConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetKeyGroupConfig");

            return clientHandler.execute(new ClientExecutionParams<GetKeyGroupConfigRequest, GetKeyGroupConfigResponse>()
                    .withOperationName("GetKeyGroupConfig").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(getKeyGroupConfigRequest)
                    .withMarshaller(new GetKeyGroupConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about whether additional CloudWatch metrics are enabled for the specified CloudFront
     * distribution.
     * </p>
     *
     * @param getMonitoringSubscriptionRequest
     * @return Result of the GetMonitoringSubscription operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws NoSuchMonitoringSubscriptionException
     *         A monitoring subscription does not exist for the specified distribution.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetMonitoringSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetMonitoringSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetMonitoringSubscriptionResponse getMonitoringSubscription(
            GetMonitoringSubscriptionRequest getMonitoringSubscriptionRequest) throws AccessDeniedException,
            NoSuchDistributionException, NoSuchMonitoringSubscriptionException, UnsupportedOperationException,
            AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<GetMonitoringSubscriptionResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetMonitoringSubscriptionResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMonitoringSubscriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMonitoringSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMonitoringSubscription");

            return clientHandler
                    .execute(new ClientExecutionParams<GetMonitoringSubscriptionRequest, GetMonitoringSubscriptionResponse>()
                            .withOperationName("GetMonitoringSubscription").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(getMonitoringSubscriptionRequest)
                            .withMarshaller(new GetMonitoringSubscriptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a CloudFront origin access control, including its unique identifier.
     * </p>
     *
     * @param getOriginAccessControlRequest
     * @return Result of the GetOriginAccessControl operation returned by the service.
     * @throws NoSuchOriginAccessControlException
     *         The origin access control does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetOriginAccessControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetOriginAccessControl"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetOriginAccessControlResponse getOriginAccessControl(GetOriginAccessControlRequest getOriginAccessControlRequest)
            throws NoSuchOriginAccessControlException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<GetOriginAccessControlResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetOriginAccessControlResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getOriginAccessControlRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOriginAccessControlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOriginAccessControl");

            return clientHandler
                    .execute(new ClientExecutionParams<GetOriginAccessControlRequest, GetOriginAccessControlResponse>()
                            .withOperationName("GetOriginAccessControl").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(getOriginAccessControlRequest)
                            .withMarshaller(new GetOriginAccessControlRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a CloudFront origin access control configuration.
     * </p>
     *
     * @param getOriginAccessControlConfigRequest
     * @return Result of the GetOriginAccessControlConfig operation returned by the service.
     * @throws NoSuchOriginAccessControlException
     *         The origin access control does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetOriginAccessControlConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetOriginAccessControlConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetOriginAccessControlConfigResponse getOriginAccessControlConfig(
            GetOriginAccessControlConfigRequest getOriginAccessControlConfigRequest) throws NoSuchOriginAccessControlException,
            AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<GetOriginAccessControlConfigResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetOriginAccessControlConfigResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getOriginAccessControlConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOriginAccessControlConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOriginAccessControlConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<GetOriginAccessControlConfigRequest, GetOriginAccessControlConfigResponse>()
                            .withOperationName("GetOriginAccessControlConfig").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(getOriginAccessControlConfigRequest)
                            .withMarshaller(new GetOriginAccessControlConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets an origin request policy, including the following metadata:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The policy's identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * The date and time when the policy was last modified.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get an origin request policy, you must provide the policy's identifier. If the origin request policy is
     * attached to a distribution's cache behavior, you can get the policy's identifier using
     * <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request policy is not attached to a
     * cache behavior, you can get the identifier using <code>ListOriginRequestPolicies</code>.
     * </p>
     *
     * @param getOriginRequestPolicyRequest
     * @return Result of the GetOriginRequestPolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchOriginRequestPolicyException
     *         The origin request policy does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetOriginRequestPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetOriginRequestPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetOriginRequestPolicyResponse getOriginRequestPolicy(GetOriginRequestPolicyRequest getOriginRequestPolicyRequest)
            throws AccessDeniedException, NoSuchOriginRequestPolicyException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<GetOriginRequestPolicyResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetOriginRequestPolicyResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getOriginRequestPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOriginRequestPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOriginRequestPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<GetOriginRequestPolicyRequest, GetOriginRequestPolicyResponse>()
                            .withOperationName("GetOriginRequestPolicy").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(getOriginRequestPolicyRequest)
                            .withMarshaller(new GetOriginRequestPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets an origin request policy configuration.
     * </p>
     * <p>
     * To get an origin request policy configuration, you must provide the policy's identifier. If the origin request
     * policy is attached to a distribution's cache behavior, you can get the policy's identifier using
     * <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request policy is not attached to a
     * cache behavior, you can get the identifier using <code>ListOriginRequestPolicies</code>.
     * </p>
     *
     * @param getOriginRequestPolicyConfigRequest
     * @return Result of the GetOriginRequestPolicyConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchOriginRequestPolicyException
     *         The origin request policy does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetOriginRequestPolicyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetOriginRequestPolicyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetOriginRequestPolicyConfigResponse getOriginRequestPolicyConfig(
            GetOriginRequestPolicyConfigRequest getOriginRequestPolicyConfigRequest) throws AccessDeniedException,
            NoSuchOriginRequestPolicyException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<GetOriginRequestPolicyConfigResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetOriginRequestPolicyConfigResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getOriginRequestPolicyConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOriginRequestPolicyConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOriginRequestPolicyConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<GetOriginRequestPolicyConfigRequest, GetOriginRequestPolicyConfigResponse>()
                            .withOperationName("GetOriginRequestPolicyConfig").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(getOriginRequestPolicyConfigRequest)
                            .withMarshaller(new GetOriginRequestPolicyConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a public key.
     * </p>
     *
     * @param getPublicKeyRequest
     * @return Result of the GetPublicKey operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetPublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetPublicKeyResponse getPublicKey(GetPublicKeyRequest getPublicKeyRequest) throws AccessDeniedException,
            NoSuchPublicKeyException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<GetPublicKeyResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                GetPublicKeyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPublicKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPublicKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPublicKey");

            return clientHandler.execute(new ClientExecutionParams<GetPublicKeyRequest, GetPublicKeyResponse>()
                    .withOperationName("GetPublicKey").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(getPublicKeyRequest)
                    .withMarshaller(new GetPublicKeyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a public key configuration.
     * </p>
     *
     * @param getPublicKeyConfigRequest
     * @return Result of the GetPublicKeyConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetPublicKeyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetPublicKeyConfig" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetPublicKeyConfigResponse getPublicKeyConfig(GetPublicKeyConfigRequest getPublicKeyConfigRequest)
            throws AccessDeniedException, NoSuchPublicKeyException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<GetPublicKeyConfigResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetPublicKeyConfigResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPublicKeyConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPublicKeyConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPublicKeyConfig");

            return clientHandler.execute(new ClientExecutionParams<GetPublicKeyConfigRequest, GetPublicKeyConfigResponse>()
                    .withOperationName("GetPublicKeyConfig").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(getPublicKeyConfigRequest)
                    .withMarshaller(new GetPublicKeyConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a real-time log configuration.
     * </p>
     * <p>
     * To get a real-time log configuration, you can provide the configuration's name or its Amazon Resource Name (ARN).
     * You must provide at least one. If you provide both, CloudFront uses the name to identify the real-time log
     * configuration to get.
     * </p>
     *
     * @param getRealtimeLogConfigRequest
     * @return Result of the GetRealtimeLogConfig operation returned by the service.
     * @throws NoSuchRealtimeLogConfigException
     *         The real-time log configuration does not exist.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetRealtimeLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetRealtimeLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetRealtimeLogConfigResponse getRealtimeLogConfig(GetRealtimeLogConfigRequest getRealtimeLogConfigRequest)
            throws NoSuchRealtimeLogConfigException, InvalidArgumentException, AccessDeniedException, AwsServiceException,
            SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<GetRealtimeLogConfigResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetRealtimeLogConfigResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRealtimeLogConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRealtimeLogConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRealtimeLogConfig");

            return clientHandler.execute(new ClientExecutionParams<GetRealtimeLogConfigRequest, GetRealtimeLogConfigResponse>()
                    .withOperationName("GetRealtimeLogConfig").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(getRealtimeLogConfigRequest)
                    .withMarshaller(new GetRealtimeLogConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a response headers policy, including metadata (the policy's identifier and the date and time when the policy
     * was last modified).
     * </p>
     * <p>
     * To get a response headers policy, you must provide the policy's identifier. If the response headers policy is
     * attached to a distribution's cache behavior, you can get the policy's identifier using
     * <code>ListDistributions</code> or <code>GetDistribution</code>. If the response headers policy is not attached to
     * a cache behavior, you can get the identifier using <code>ListResponseHeadersPolicies</code>.
     * </p>
     *
     * @param getResponseHeadersPolicyRequest
     * @return Result of the GetResponseHeadersPolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchResponseHeadersPolicyException
     *         The response headers policy does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetResponseHeadersPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetResponseHeadersPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetResponseHeadersPolicyResponse getResponseHeadersPolicy(
            GetResponseHeadersPolicyRequest getResponseHeadersPolicyRequest) throws AccessDeniedException,
            NoSuchResponseHeadersPolicyException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<GetResponseHeadersPolicyResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetResponseHeadersPolicyResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getResponseHeadersPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResponseHeadersPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResponseHeadersPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<GetResponseHeadersPolicyRequest, GetResponseHeadersPolicyResponse>()
                            .withOperationName("GetResponseHeadersPolicy").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(getResponseHeadersPolicyRequest)
                            .withMarshaller(new GetResponseHeadersPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a response headers policy configuration.
     * </p>
     * <p>
     * To get a response headers policy configuration, you must provide the policy's identifier. If the response headers
     * policy is attached to a distribution's cache behavior, you can get the policy's identifier using
     * <code>ListDistributions</code> or <code>GetDistribution</code>. If the response headers policy is not attached to
     * a cache behavior, you can get the identifier using <code>ListResponseHeadersPolicies</code>.
     * </p>
     *
     * @param getResponseHeadersPolicyConfigRequest
     * @return Result of the GetResponseHeadersPolicyConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchResponseHeadersPolicyException
     *         The response headers policy does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetResponseHeadersPolicyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetResponseHeadersPolicyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetResponseHeadersPolicyConfigResponse getResponseHeadersPolicyConfig(
            GetResponseHeadersPolicyConfigRequest getResponseHeadersPolicyConfigRequest) throws AccessDeniedException,
            NoSuchResponseHeadersPolicyException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<GetResponseHeadersPolicyConfigResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetResponseHeadersPolicyConfigResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getResponseHeadersPolicyConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getResponseHeadersPolicyConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResponseHeadersPolicyConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<GetResponseHeadersPolicyConfigRequest, GetResponseHeadersPolicyConfigResponse>()
                            .withOperationName("GetResponseHeadersPolicyConfig").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(getResponseHeadersPolicyConfigRequest)
                            .withMarshaller(new GetResponseHeadersPolicyConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a specified RTMP distribution, including the distribution configuration.
     * </p>
     *
     * @param getStreamingDistributionRequest
     *        The request to get a streaming distribution's information.
     * @return Result of the GetStreamingDistribution operation returned by the service.
     * @throws NoSuchStreamingDistributionException
     *         The specified streaming distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetStreamingDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetStreamingDistributionResponse getStreamingDistribution(
            GetStreamingDistributionRequest getStreamingDistributionRequest) throws NoSuchStreamingDistributionException,
            AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<GetStreamingDistributionResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetStreamingDistributionResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getStreamingDistributionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStreamingDistributionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStreamingDistribution");

            return clientHandler
                    .execute(new ClientExecutionParams<GetStreamingDistributionRequest, GetStreamingDistributionResponse>()
                            .withOperationName("GetStreamingDistribution").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(getStreamingDistributionRequest)
                            .withMarshaller(new GetStreamingDistributionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get the configuration information about a streaming distribution.
     * </p>
     *
     * @param getStreamingDistributionConfigRequest
     *        To request to get a streaming distribution configuration.
     * @return Result of the GetStreamingDistributionConfig operation returned by the service.
     * @throws NoSuchStreamingDistributionException
     *         The specified streaming distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.GetStreamingDistributionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetStreamingDistributionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetStreamingDistributionConfigResponse getStreamingDistributionConfig(
            GetStreamingDistributionConfigRequest getStreamingDistributionConfigRequest)
            throws NoSuchStreamingDistributionException, AccessDeniedException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<GetStreamingDistributionConfigResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(GetStreamingDistributionConfigResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getStreamingDistributionConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getStreamingDistributionConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStreamingDistributionConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<GetStreamingDistributionConfigRequest, GetStreamingDistributionConfigResponse>()
                            .withOperationName("GetStreamingDistributionConfig").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(getStreamingDistributionConfigRequest)
                            .withMarshaller(new GetStreamingDistributionConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of cache policies.
     * </p>
     * <p>
     * You can optionally apply a filter to return only the managed policies created by Amazon Web Services, or only the
     * custom policies created in your Amazon Web Services account.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listCachePoliciesRequest
     * @return Result of the ListCachePolicies operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchCachePolicyException
     *         The cache policy does not exist.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListCachePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListCachePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListCachePoliciesResponse listCachePolicies(ListCachePoliciesRequest listCachePoliciesRequest)
            throws AccessDeniedException, NoSuchCachePolicyException, InvalidArgumentException, AwsServiceException,
            SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<ListCachePoliciesResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                ListCachePoliciesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCachePoliciesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCachePoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCachePolicies");

            return clientHandler.execute(new ClientExecutionParams<ListCachePoliciesRequest, ListCachePoliciesResponse>()
                    .withOperationName("ListCachePolicies").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(listCachePoliciesRequest)
                    .withMarshaller(new ListCachePoliciesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists origin access identities.
     * </p>
     *
     * @param listCloudFrontOriginAccessIdentitiesRequest
     *        The request to list origin access identities.
     * @return Result of the ListCloudFrontOriginAccessIdentities operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListCloudFrontOriginAccessIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListCloudFrontOriginAccessIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListCloudFrontOriginAccessIdentitiesResponse listCloudFrontOriginAccessIdentities(
            ListCloudFrontOriginAccessIdentitiesRequest listCloudFrontOriginAccessIdentitiesRequest)
            throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<ListCloudFrontOriginAccessIdentitiesResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListCloudFrontOriginAccessIdentitiesResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCloudFrontOriginAccessIdentitiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCloudFrontOriginAccessIdentitiesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCloudFrontOriginAccessIdentities");

            return clientHandler
                    .execute(new ClientExecutionParams<ListCloudFrontOriginAccessIdentitiesRequest, ListCloudFrontOriginAccessIdentitiesResponse>()
                            .withOperationName("ListCloudFrontOriginAccessIdentities").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(listCloudFrontOriginAccessIdentitiesRequest)
                            .withMarshaller(new ListCloudFrontOriginAccessIdentitiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of aliases (also called CNAMEs or alternate domain names) that conflict or overlap with the provided
     * alias, and the associated CloudFront distributions and Amazon Web Services accounts for each conflicting alias.
     * In the returned list, the distribution and account IDs are partially hidden, which allows you to identify the
     * distributions and accounts that you own, but helps to protect the information of ones that you don't own.
     * </p>
     * <p>
     * Use this operation to find aliases that are in use in CloudFront that conflict or overlap with the provided
     * alias. For example, if you provide <code>www.example.com</code> as input, the returned list can include
     * <code>www.example.com</code> and the overlapping wildcard alternate domain name (<code>*.example.com</code>), if
     * they exist. If you provide <code>*.example.com</code> as input, the returned list can include
     * <code>*.example.com</code> and any alternate domain names covered by that wildcard (for example,
     * <code>www.example.com</code>, <code>test.example.com</code>, <code>dev.example.com</code>, and so on), if they
     * exist.
     * </p>
     * <p>
     * To list conflicting aliases, you provide the alias to search and the ID of a distribution in your account that
     * has an attached SSL/TLS certificate that includes the provided alias. For more information, including how to set
     * up the distribution and certificate, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html#alternate-domain-names-move"
     * >Moving an alternate domain name to a different distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listConflictingAliasesRequest
     * @return Result of the ListConflictingAliases operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListConflictingAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListConflictingAliases"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListConflictingAliasesResponse listConflictingAliases(ListConflictingAliasesRequest listConflictingAliasesRequest)
            throws InvalidArgumentException, NoSuchDistributionException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<ListConflictingAliasesResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListConflictingAliasesResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listConflictingAliasesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listConflictingAliasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListConflictingAliases");

            return clientHandler
                    .execute(new ClientExecutionParams<ListConflictingAliasesRequest, ListConflictingAliasesResponse>()
                            .withOperationName("ListConflictingAliases").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(listConflictingAliasesRequest)
                            .withMarshaller(new ListConflictingAliasesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of the continuous deployment policies in your Amazon Web Services account.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listContinuousDeploymentPoliciesRequest
     * @return Result of the ListContinuousDeploymentPolicies operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchContinuousDeploymentPolicyException
     *         The continuous deployment policy doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListContinuousDeploymentPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListContinuousDeploymentPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListContinuousDeploymentPoliciesResponse listContinuousDeploymentPolicies(
            ListContinuousDeploymentPoliciesRequest listContinuousDeploymentPoliciesRequest) throws InvalidArgumentException,
            AccessDeniedException, NoSuchContinuousDeploymentPolicyException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<ListContinuousDeploymentPoliciesResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListContinuousDeploymentPoliciesResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listContinuousDeploymentPoliciesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listContinuousDeploymentPoliciesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListContinuousDeploymentPolicies");

            return clientHandler
                    .execute(new ClientExecutionParams<ListContinuousDeploymentPoliciesRequest, ListContinuousDeploymentPoliciesResponse>()
                            .withOperationName("ListContinuousDeploymentPolicies").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(listContinuousDeploymentPoliciesRequest)
                            .withMarshaller(new ListContinuousDeploymentPoliciesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List CloudFront distributions.
     * </p>
     *
     * @param listDistributionsRequest
     *        The request to list your distributions.
     * @return Result of the ListDistributions operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListDistributions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListDistributionsResponse listDistributions(ListDistributionsRequest listDistributionsRequest)
            throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<ListDistributionsResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                ListDistributionsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDistributionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDistributionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDistributions");

            return clientHandler.execute(new ClientExecutionParams<ListDistributionsRequest, ListDistributionsResponse>()
                    .withOperationName("ListDistributions").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(listDistributionsRequest)
                    .withMarshaller(new ListDistributionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of distribution IDs for distributions that have a cache behavior that's associated with the specified
     * cache policy.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listDistributionsByCachePolicyIdRequest
     * @return Result of the ListDistributionsByCachePolicyId operation returned by the service.
     * @throws NoSuchCachePolicyException
     *         The cache policy does not exist.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListDistributionsByCachePolicyId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByCachePolicyId"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDistributionsByCachePolicyIdResponse listDistributionsByCachePolicyId(
            ListDistributionsByCachePolicyIdRequest listDistributionsByCachePolicyIdRequest) throws NoSuchCachePolicyException,
            InvalidArgumentException, AccessDeniedException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<ListDistributionsByCachePolicyIdResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListDistributionsByCachePolicyIdResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDistributionsByCachePolicyIdRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listDistributionsByCachePolicyIdRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDistributionsByCachePolicyId");

            return clientHandler
                    .execute(new ClientExecutionParams<ListDistributionsByCachePolicyIdRequest, ListDistributionsByCachePolicyIdResponse>()
                            .withOperationName("ListDistributionsByCachePolicyId").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(listDistributionsByCachePolicyIdRequest)
                            .withMarshaller(new ListDistributionsByCachePolicyIdRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of distribution IDs for distributions that have a cache behavior that references the specified key
     * group.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listDistributionsByKeyGroupRequest
     * @return Result of the ListDistributionsByKeyGroup operation returned by the service.
     * @throws NoSuchResourceException
     *         A resource that was specified is not valid.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListDistributionsByKeyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByKeyGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDistributionsByKeyGroupResponse listDistributionsByKeyGroup(
            ListDistributionsByKeyGroupRequest listDistributionsByKeyGroupRequest) throws NoSuchResourceException,
            InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<ListDistributionsByKeyGroupResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListDistributionsByKeyGroupResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDistributionsByKeyGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDistributionsByKeyGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDistributionsByKeyGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<ListDistributionsByKeyGroupRequest, ListDistributionsByKeyGroupResponse>()
                            .withOperationName("ListDistributionsByKeyGroup").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(listDistributionsByKeyGroupRequest)
                            .withMarshaller(new ListDistributionsByKeyGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of distribution IDs for distributions that have a cache behavior that's associated with the specified
     * origin request policy.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listDistributionsByOriginRequestPolicyIdRequest
     * @return Result of the ListDistributionsByOriginRequestPolicyId operation returned by the service.
     * @throws NoSuchOriginRequestPolicyException
     *         The origin request policy does not exist.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListDistributionsByOriginRequestPolicyId
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByOriginRequestPolicyId"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDistributionsByOriginRequestPolicyIdResponse listDistributionsByOriginRequestPolicyId(
            ListDistributionsByOriginRequestPolicyIdRequest listDistributionsByOriginRequestPolicyIdRequest)
            throws NoSuchOriginRequestPolicyException, InvalidArgumentException, AccessDeniedException, AwsServiceException,
            SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<ListDistributionsByOriginRequestPolicyIdResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListDistributionsByOriginRequestPolicyIdResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                listDistributionsByOriginRequestPolicyIdRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listDistributionsByOriginRequestPolicyIdRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDistributionsByOriginRequestPolicyId");

            return clientHandler
                    .execute(new ClientExecutionParams<ListDistributionsByOriginRequestPolicyIdRequest, ListDistributionsByOriginRequestPolicyIdResponse>()
                            .withOperationName("ListDistributionsByOriginRequestPolicyId").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(listDistributionsByOriginRequestPolicyIdRequest)
                            .withMarshaller(new ListDistributionsByOriginRequestPolicyIdRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of distributions that have a cache behavior that's associated with the specified real-time log
     * configuration.
     * </p>
     * <p>
     * You can specify the real-time log configuration by its name or its Amazon Resource Name (ARN). You must provide
     * at least one. If you provide both, CloudFront uses the name to identify the real-time log configuration to list
     * distributions for.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listDistributionsByRealtimeLogConfigRequest
     * @return Result of the ListDistributionsByRealtimeLogConfig operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListDistributionsByRealtimeLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByRealtimeLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDistributionsByRealtimeLogConfigResponse listDistributionsByRealtimeLogConfig(
            ListDistributionsByRealtimeLogConfigRequest listDistributionsByRealtimeLogConfigRequest)
            throws InvalidArgumentException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<ListDistributionsByRealtimeLogConfigResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListDistributionsByRealtimeLogConfigResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDistributionsByRealtimeLogConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listDistributionsByRealtimeLogConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDistributionsByRealtimeLogConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<ListDistributionsByRealtimeLogConfigRequest, ListDistributionsByRealtimeLogConfigResponse>()
                            .withOperationName("ListDistributionsByRealtimeLogConfig").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(listDistributionsByRealtimeLogConfigRequest)
                            .withMarshaller(new ListDistributionsByRealtimeLogConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of distribution IDs for distributions that have a cache behavior that's associated with the specified
     * response headers policy.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listDistributionsByResponseHeadersPolicyIdRequest
     * @return Result of the ListDistributionsByResponseHeadersPolicyId operation returned by the service.
     * @throws NoSuchResponseHeadersPolicyException
     *         The response headers policy does not exist.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListDistributionsByResponseHeadersPolicyId
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByResponseHeadersPolicyId"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDistributionsByResponseHeadersPolicyIdResponse listDistributionsByResponseHeadersPolicyId(
            ListDistributionsByResponseHeadersPolicyIdRequest listDistributionsByResponseHeadersPolicyIdRequest)
            throws NoSuchResponseHeadersPolicyException, InvalidArgumentException, AccessDeniedException, AwsServiceException,
            SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<ListDistributionsByResponseHeadersPolicyIdResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListDistributionsByResponseHeadersPolicyIdResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                listDistributionsByResponseHeadersPolicyIdRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listDistributionsByResponseHeadersPolicyIdRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDistributionsByResponseHeadersPolicyId");

            return clientHandler
                    .execute(new ClientExecutionParams<ListDistributionsByResponseHeadersPolicyIdRequest, ListDistributionsByResponseHeadersPolicyIdResponse>()
                            .withOperationName("ListDistributionsByResponseHeadersPolicyId")
                            .withProtocolMetadata(protocolMetadata).withCombinedResponseHandler(responseHandler)
                            .withMetricCollector(apiCallMetricCollector).withRequestConfiguration(clientConfiguration)
                            .withInput(listDistributionsByResponseHeadersPolicyIdRequest)
                            .withMarshaller(new ListDistributionsByResponseHeadersPolicyIdRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List the distributions that are associated with a specified WAF web ACL.
     * </p>
     *
     * @param listDistributionsByWebAclIdRequest
     *        The request to list distributions that are associated with a specified WAF web ACL.
     * @return Result of the ListDistributionsByWebACLId operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidWebAclIdException
     *         A web ACL ID specified is not valid. To specify a web ACL created using the latest version of WAF, use
     *         the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListDistributionsByWebACLId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByWebACLId"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDistributionsByWebAclIdResponse listDistributionsByWebACLId(
            ListDistributionsByWebAclIdRequest listDistributionsByWebAclIdRequest) throws InvalidArgumentException,
            InvalidWebAclIdException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<ListDistributionsByWebAclIdResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListDistributionsByWebAclIdResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDistributionsByWebAclIdRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDistributionsByWebAclIdRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDistributionsByWebACLId");

            return clientHandler
                    .execute(new ClientExecutionParams<ListDistributionsByWebAclIdRequest, ListDistributionsByWebAclIdResponse>()
                            .withOperationName("ListDistributionsByWebACLId").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(listDistributionsByWebAclIdRequest)
                            .withMarshaller(new ListDistributionsByWebAclIdRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List all field-level encryption configurations that have been created in CloudFront for this account.
     * </p>
     *
     * @param listFieldLevelEncryptionConfigsRequest
     * @return Result of the ListFieldLevelEncryptionConfigs operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListFieldLevelEncryptionConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListFieldLevelEncryptionConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListFieldLevelEncryptionConfigsResponse listFieldLevelEncryptionConfigs(
            ListFieldLevelEncryptionConfigsRequest listFieldLevelEncryptionConfigsRequest) throws InvalidArgumentException,
            AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<ListFieldLevelEncryptionConfigsResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListFieldLevelEncryptionConfigsResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFieldLevelEncryptionConfigsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listFieldLevelEncryptionConfigsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFieldLevelEncryptionConfigs");

            return clientHandler
                    .execute(new ClientExecutionParams<ListFieldLevelEncryptionConfigsRequest, ListFieldLevelEncryptionConfigsResponse>()
                            .withOperationName("ListFieldLevelEncryptionConfigs").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(listFieldLevelEncryptionConfigsRequest)
                            .withMarshaller(new ListFieldLevelEncryptionConfigsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Request a list of field-level encryption profiles that have been created in CloudFront for this account.
     * </p>
     *
     * @param listFieldLevelEncryptionProfilesRequest
     * @return Result of the ListFieldLevelEncryptionProfiles operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListFieldLevelEncryptionProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListFieldLevelEncryptionProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListFieldLevelEncryptionProfilesResponse listFieldLevelEncryptionProfiles(
            ListFieldLevelEncryptionProfilesRequest listFieldLevelEncryptionProfilesRequest) throws InvalidArgumentException,
            AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<ListFieldLevelEncryptionProfilesResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListFieldLevelEncryptionProfilesResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFieldLevelEncryptionProfilesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listFieldLevelEncryptionProfilesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFieldLevelEncryptionProfiles");

            return clientHandler
                    .execute(new ClientExecutionParams<ListFieldLevelEncryptionProfilesRequest, ListFieldLevelEncryptionProfilesResponse>()
                            .withOperationName("ListFieldLevelEncryptionProfiles").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(listFieldLevelEncryptionProfilesRequest)
                            .withMarshaller(new ListFieldLevelEncryptionProfilesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of all CloudFront functions in your Amazon Web Services account.
     * </p>
     * <p>
     * You can optionally apply a filter to return only the functions that are in the specified stage, either
     * <code>DEVELOPMENT</code> or <code>LIVE</code>.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listFunctionsRequest
     * @return Result of the ListFunctions operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListFunctionsResponse listFunctions(ListFunctionsRequest listFunctionsRequest) throws InvalidArgumentException,
            UnsupportedOperationException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<ListFunctionsResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                ListFunctionsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFunctionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFunctionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFunctions");

            return clientHandler.execute(new ClientExecutionParams<ListFunctionsRequest, ListFunctionsResponse>()
                    .withOperationName("ListFunctions").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(listFunctionsRequest)
                    .withMarshaller(new ListFunctionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists invalidation batches.
     * </p>
     *
     * @param listInvalidationsRequest
     *        The request to list invalidations.
     * @return Result of the ListInvalidations operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListInvalidations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListInvalidations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListInvalidationsResponse listInvalidations(ListInvalidationsRequest listInvalidationsRequest)
            throws InvalidArgumentException, NoSuchDistributionException, AccessDeniedException, AwsServiceException,
            SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<ListInvalidationsResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                ListInvalidationsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listInvalidationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listInvalidationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListInvalidations");

            return clientHandler.execute(new ClientExecutionParams<ListInvalidationsRequest, ListInvalidationsResponse>()
                    .withOperationName("ListInvalidations").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(listInvalidationsRequest)
                    .withMarshaller(new ListInvalidationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of key groups.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listKeyGroupsRequest
     * @return Result of the ListKeyGroups operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListKeyGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListKeyGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListKeyGroupsResponse listKeyGroups(ListKeyGroupsRequest listKeyGroupsRequest) throws InvalidArgumentException,
            AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<ListKeyGroupsResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                ListKeyGroupsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listKeyGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listKeyGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListKeyGroups");

            return clientHandler.execute(new ClientExecutionParams<ListKeyGroupsRequest, ListKeyGroupsResponse>()
                    .withOperationName("ListKeyGroups").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(listKeyGroupsRequest)
                    .withMarshaller(new ListKeyGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Specifies the key value stores to list.
     * </p>
     *
     * @param listKeyValueStoresRequest
     * @return Result of the ListKeyValueStores operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListKeyValueStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListKeyValueStores" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListKeyValueStoresResponse listKeyValueStores(ListKeyValueStoresRequest listKeyValueStoresRequest)
            throws AccessDeniedException, InvalidArgumentException, UnsupportedOperationException, AwsServiceException,
            SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<ListKeyValueStoresResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListKeyValueStoresResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listKeyValueStoresRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listKeyValueStoresRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListKeyValueStores");

            return clientHandler.execute(new ClientExecutionParams<ListKeyValueStoresRequest, ListKeyValueStoresResponse>()
                    .withOperationName("ListKeyValueStores").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(listKeyValueStoresRequest)
                    .withMarshaller(new ListKeyValueStoresRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the list of CloudFront origin access controls in this Amazon Web Services account.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send another request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the next request.
     * </p>
     *
     * @param listOriginAccessControlsRequest
     * @return Result of the ListOriginAccessControls operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListOriginAccessControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListOriginAccessControls"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListOriginAccessControlsResponse listOriginAccessControls(
            ListOriginAccessControlsRequest listOriginAccessControlsRequest) throws InvalidArgumentException,
            AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<ListOriginAccessControlsResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListOriginAccessControlsResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listOriginAccessControlsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOriginAccessControlsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOriginAccessControls");

            return clientHandler
                    .execute(new ClientExecutionParams<ListOriginAccessControlsRequest, ListOriginAccessControlsResponse>()
                            .withOperationName("ListOriginAccessControls").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(listOriginAccessControlsRequest)
                            .withMarshaller(new ListOriginAccessControlsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of origin request policies.
     * </p>
     * <p>
     * You can optionally apply a filter to return only the managed policies created by Amazon Web Services, or only the
     * custom policies created in your Amazon Web Services account.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listOriginRequestPoliciesRequest
     * @return Result of the ListOriginRequestPolicies operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchOriginRequestPolicyException
     *         The origin request policy does not exist.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListOriginRequestPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListOriginRequestPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListOriginRequestPoliciesResponse listOriginRequestPolicies(
            ListOriginRequestPoliciesRequest listOriginRequestPoliciesRequest) throws AccessDeniedException,
            NoSuchOriginRequestPolicyException, InvalidArgumentException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<ListOriginRequestPoliciesResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListOriginRequestPoliciesResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listOriginRequestPoliciesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOriginRequestPoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOriginRequestPolicies");

            return clientHandler
                    .execute(new ClientExecutionParams<ListOriginRequestPoliciesRequest, ListOriginRequestPoliciesResponse>()
                            .withOperationName("ListOriginRequestPolicies").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(listOriginRequestPoliciesRequest)
                            .withMarshaller(new ListOriginRequestPoliciesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List all public keys that have been added to CloudFront for this account.
     * </p>
     *
     * @param listPublicKeysRequest
     * @return Result of the ListPublicKeys operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListPublicKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListPublicKeysResponse listPublicKeys(ListPublicKeysRequest listPublicKeysRequest) throws InvalidArgumentException,
            AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<ListPublicKeysResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                ListPublicKeysResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPublicKeysRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPublicKeysRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPublicKeys");

            return clientHandler.execute(new ClientExecutionParams<ListPublicKeysRequest, ListPublicKeysResponse>()
                    .withOperationName("ListPublicKeys").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(listPublicKeysRequest)
                    .withMarshaller(new ListPublicKeysRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of real-time log configurations.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listRealtimeLogConfigsRequest
     * @return Result of the ListRealtimeLogConfigs operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchRealtimeLogConfigException
     *         The real-time log configuration does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListRealtimeLogConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListRealtimeLogConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListRealtimeLogConfigsResponse listRealtimeLogConfigs(ListRealtimeLogConfigsRequest listRealtimeLogConfigsRequest)
            throws InvalidArgumentException, AccessDeniedException, NoSuchRealtimeLogConfigException, AwsServiceException,
            SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<ListRealtimeLogConfigsResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListRealtimeLogConfigsResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRealtimeLogConfigsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRealtimeLogConfigsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRealtimeLogConfigs");

            return clientHandler
                    .execute(new ClientExecutionParams<ListRealtimeLogConfigsRequest, ListRealtimeLogConfigsResponse>()
                            .withOperationName("ListRealtimeLogConfigs").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(listRealtimeLogConfigsRequest)
                            .withMarshaller(new ListRealtimeLogConfigsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of response headers policies.
     * </p>
     * <p>
     * You can optionally apply a filter to get only the managed policies created by Amazon Web Services, or only the
     * custom policies created in your Amazon Web Services account.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listResponseHeadersPoliciesRequest
     * @return Result of the ListResponseHeadersPolicies operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws NoSuchResponseHeadersPolicyException
     *         The response headers policy does not exist.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListResponseHeadersPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListResponseHeadersPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListResponseHeadersPoliciesResponse listResponseHeadersPolicies(
            ListResponseHeadersPoliciesRequest listResponseHeadersPoliciesRequest) throws AccessDeniedException,
            NoSuchResponseHeadersPolicyException, InvalidArgumentException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<ListResponseHeadersPoliciesResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListResponseHeadersPoliciesResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listResponseHeadersPoliciesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResponseHeadersPoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResponseHeadersPolicies");

            return clientHandler
                    .execute(new ClientExecutionParams<ListResponseHeadersPoliciesRequest, ListResponseHeadersPoliciesResponse>()
                            .withOperationName("ListResponseHeadersPolicies").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(listResponseHeadersPoliciesRequest)
                            .withMarshaller(new ListResponseHeadersPoliciesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List streaming distributions.
     * </p>
     *
     * @param listStreamingDistributionsRequest
     *        The request to list your streaming distributions.
     * @return Result of the ListStreamingDistributions operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListStreamingDistributions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListStreamingDistributions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListStreamingDistributionsResponse listStreamingDistributions(
            ListStreamingDistributionsRequest listStreamingDistributionsRequest) throws InvalidArgumentException,
            AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<ListStreamingDistributionsResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListStreamingDistributionsResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listStreamingDistributionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStreamingDistributionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStreamingDistributions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListStreamingDistributionsRequest, ListStreamingDistributionsResponse>()
                            .withOperationName("ListStreamingDistributions").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(listStreamingDistributionsRequest)
                            .withMarshaller(new ListStreamingDistributionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List tags for a CloudFront resource. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/tagging.html">Tagging a distribution</a>
     * in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param listTagsForResourceRequest
     *        The request to list tags for a CloudFront resource.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidTaggingException
     *         The tagging specified is not valid.
     * @throws NoSuchResourceException
     *         A resource that was specified is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws AccessDeniedException, InvalidArgumentException, InvalidTaggingException, NoSuchResourceException,
            AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<ListTagsForResourceResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(ListTagsForResourceResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Publishes a CloudFront function by copying the function code from the <code>DEVELOPMENT</code> stage to
     * <code>LIVE</code>. This automatically updates all cache behaviors that are using this function to use the newly
     * published copy in the <code>LIVE</code> stage.
     * </p>
     * <p>
     * When a function is published to the <code>LIVE</code> stage, you can attach the function to a distribution's
     * cache behavior, using the function's Amazon Resource Name (ARN).
     * </p>
     * <p>
     * To publish a function, you must provide the function's name and version (<code>ETag</code> value). To get these
     * values, you can use <code>ListFunctions</code> and <code>DescribeFunction</code>.
     * </p>
     *
     * @param publishFunctionRequest
     * @return Result of the PublishFunction operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchFunctionExistsException
     *         The function does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.PublishFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/PublishFunction" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public PublishFunctionResponse publishFunction(PublishFunctionRequest publishFunctionRequest)
            throws InvalidArgumentException, InvalidIfMatchVersionException, NoSuchFunctionExistsException,
            PreconditionFailedException, UnsupportedOperationException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<PublishFunctionResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                PublishFunctionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(publishFunctionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, publishFunctionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PublishFunction");

            return clientHandler.execute(new ClientExecutionParams<PublishFunctionRequest, PublishFunctionResponse>()
                    .withOperationName("PublishFunction").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(publishFunctionRequest)
                    .withMarshaller(new PublishFunctionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Add tags to a CloudFront resource. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/tagging.html">Tagging a distribution</a>
     * in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param tagResourceRequest
     *        The request to add tags to a CloudFront resource.
     * @return Result of the TagResource operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidTaggingException
     *         The tagging specified is not valid.
     * @throws NoSuchResourceException
     *         A resource that was specified is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws AccessDeniedException,
            InvalidArgumentException, InvalidTaggingException, NoSuchResourceException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<TagResourceResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                TagResourceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(tagResourceRequest)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Tests a CloudFront function.
     * </p>
     * <p>
     * To test a function, you provide an <i>event object</i> that represents an HTTP request or response that your
     * CloudFront distribution could receive in production. CloudFront runs the function, passing it the event object
     * that you provided, and returns the function's result (the modified event object) in the response. The response
     * also contains function logs and error messages, if any exist. For more information about testing functions, see
     * <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/managing-functions.html#test-function"
     * >Testing functions</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * To test a function, you provide the function's name and version (<code>ETag</code> value) along with the event
     * object. To get the function's name and version, you can use <code>ListFunctions</code> and
     * <code>DescribeFunction</code>.
     * </p>
     *
     * @param testFunctionRequest
     * @return Result of the TestFunction operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchFunctionExistsException
     *         The function does not exist.
     * @throws TestFunctionFailedException
     *         The CloudFront function failed.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.TestFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/TestFunction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TestFunctionResponse testFunction(TestFunctionRequest testFunctionRequest) throws InvalidArgumentException,
            InvalidIfMatchVersionException, NoSuchFunctionExistsException, TestFunctionFailedException,
            UnsupportedOperationException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<TestFunctionResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                TestFunctionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(testFunctionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, testFunctionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TestFunction");

            return clientHandler.execute(new ClientExecutionParams<TestFunctionRequest, TestFunctionResponse>()
                    .withOperationName("TestFunction").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(testFunctionRequest)
                    .withMarshaller(new TestFunctionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Remove tags from a CloudFront resource. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/tagging.html">Tagging a distribution</a>
     * in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param untagResourceRequest
     *        The request to remove tags from a CloudFront resource.
     * @return Result of the UntagResource operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidTaggingException
     *         The tagging specified is not valid.
     * @throws NoSuchResourceException
     *         A resource that was specified is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AccessDeniedException,
            InvalidArgumentException, InvalidTaggingException, NoSuchResourceException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<UntagResourceResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                UntagResourceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a cache policy configuration.
     * </p>
     * <p>
     * When you update a cache policy configuration, all the fields are updated with the values provided in the request.
     * You cannot update some fields independent of others. To update a cache policy configuration:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Use <code>GetCachePolicyConfig</code> to get the current configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Locally modify the fields in the cache policy configuration that you want to update.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <code>UpdateCachePolicy</code> by providing the entire cache policy configuration, including the fields that
     * you modified and those that you didn't.
     * </p>
     * </li>
     * </ol>
     *
     * @param updateCachePolicyRequest
     * @return Result of the UpdateCachePolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchCachePolicyException
     *         The cache policy does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws CachePolicyAlreadyExistsException
     *         A cache policy with this name already exists. You must provide a unique name. To modify an existing cache
     *         policy, use <code>UpdateCachePolicy</code>.
     * @throws TooManyHeadersInCachePolicyException
     *         The number of headers in the cache policy exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyCookiesInCachePolicyException
     *         The number of cookies in the cache policy exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyQueryStringsInCachePolicyException
     *         The number of query strings in the cache policy exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateCachePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateCachePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateCachePolicyResponse updateCachePolicy(UpdateCachePolicyRequest updateCachePolicyRequest)
            throws AccessDeniedException, IllegalUpdateException, InconsistentQuantitiesException, InvalidArgumentException,
            InvalidIfMatchVersionException, NoSuchCachePolicyException, PreconditionFailedException,
            CachePolicyAlreadyExistsException, TooManyHeadersInCachePolicyException, TooManyCookiesInCachePolicyException,
            TooManyQueryStringsInCachePolicyException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<UpdateCachePolicyResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                UpdateCachePolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCachePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCachePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCachePolicy");

            return clientHandler.execute(new ClientExecutionParams<UpdateCachePolicyRequest, UpdateCachePolicyResponse>()
                    .withOperationName("UpdateCachePolicy").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(updateCachePolicyRequest)
                    .withMarshaller(new UpdateCachePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update an origin access identity.
     * </p>
     *
     * @param updateCloudFrontOriginAccessIdentityRequest
     *        The request to update an origin access identity.
     * @return Result of the UpdateCloudFrontOriginAccessIdentity operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws NoSuchCloudFrontOriginAccessIdentityException
     *         The specified origin access identity does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateCloudFrontOriginAccessIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateCloudFrontOriginAccessIdentityResponse updateCloudFrontOriginAccessIdentity(
            UpdateCloudFrontOriginAccessIdentityRequest updateCloudFrontOriginAccessIdentityRequest)
            throws AccessDeniedException, IllegalUpdateException, InvalidIfMatchVersionException, MissingBodyException,
            NoSuchCloudFrontOriginAccessIdentityException, PreconditionFailedException, InvalidArgumentException,
            InconsistentQuantitiesException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<UpdateCloudFrontOriginAccessIdentityResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(UpdateCloudFrontOriginAccessIdentityResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCloudFrontOriginAccessIdentityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateCloudFrontOriginAccessIdentityRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCloudFrontOriginAccessIdentity");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateCloudFrontOriginAccessIdentityRequest, UpdateCloudFrontOriginAccessIdentityResponse>()
                            .withOperationName("UpdateCloudFrontOriginAccessIdentity").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(updateCloudFrontOriginAccessIdentityRequest)
                            .withMarshaller(new UpdateCloudFrontOriginAccessIdentityRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a continuous deployment policy. You can update a continuous deployment policy to enable or disable it, to
     * change the percentage of traffic that it sends to the staging distribution, or to change the staging distribution
     * that it sends traffic to.
     * </p>
     * <p>
     * When you update a continuous deployment policy configuration, all the fields are updated with the values that are
     * provided in the request. You cannot update some fields independent of others. To update a continuous deployment
     * policy configuration:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Use <code>GetContinuousDeploymentPolicyConfig</code> to get the current configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Locally modify the fields in the continuous deployment policy configuration that you want to update.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>UpdateContinuousDeploymentPolicy</code>, providing the entire continuous deployment policy
     * configuration, including the fields that you modified and those that you didn't.
     * </p>
     * </li>
     * </ol>
     *
     * @param updateContinuousDeploymentPolicyRequest
     * @return Result of the UpdateContinuousDeploymentPolicy operation returned by the service.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws StagingDistributionInUseException
     *         A continuous deployment policy for this staging distribution already exists.
     * @throws NoSuchContinuousDeploymentPolicyException
     *         The continuous deployment policy doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateContinuousDeploymentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateContinuousDeploymentPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateContinuousDeploymentPolicyResponse updateContinuousDeploymentPolicy(
            UpdateContinuousDeploymentPolicyRequest updateContinuousDeploymentPolicyRequest)
            throws InvalidIfMatchVersionException, InvalidArgumentException, AccessDeniedException,
            InconsistentQuantitiesException, PreconditionFailedException, StagingDistributionInUseException,
            NoSuchContinuousDeploymentPolicyException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<UpdateContinuousDeploymentPolicyResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(UpdateContinuousDeploymentPolicyResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateContinuousDeploymentPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateContinuousDeploymentPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateContinuousDeploymentPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateContinuousDeploymentPolicyRequest, UpdateContinuousDeploymentPolicyResponse>()
                            .withOperationName("UpdateContinuousDeploymentPolicy").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(updateContinuousDeploymentPolicyRequest)
                            .withMarshaller(new UpdateContinuousDeploymentPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the configuration for a CloudFront distribution.
     * </p>
     * <p>
     * The update process includes getting the current distribution configuration, updating it to make your changes, and
     * then submitting an <code>UpdateDistribution</code> request to make the updates.
     * </p>
     * <p>
     * <b>To update a web distribution using the CloudFront API</b>
     * </p>
     * <ol>
     * <li>
     * <p>
     * Use <code>GetDistributionConfig</code> to get the current configuration, including the version identifier (
     * <code>ETag</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * Update the distribution configuration that was returned in the response. Note the following important
     * requirements and restrictions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must rename the <code>ETag</code> field to <code>IfMatch</code>, leaving the value unchanged. (Set the value
     * of <code>IfMatch</code> to the value of <code>ETag</code>, then remove the <code>ETag</code> field.)
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't change the value of <code>CallerReference</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Submit an <code>UpdateDistribution</code> request, providing the distribution configuration. The new
     * configuration replaces the existing configuration. The values that you specify in an
     * <code>UpdateDistribution</code> request are not merged into your existing configuration. Make sure to include all
     * fields: the ones that you modified and also the ones that you didn't.
     * </p>
     * </li>
     * </ol>
     *
     * @param updateDistributionRequest
     *        The request to update a distribution.
     * @return Result of the UpdateDistribution operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws TooManyDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws InvalidDefaultRootObjectException
     *         The default root object file name is too big or contains an invalid character.
     * @throws InvalidRelativePathException
     *         The relative path is too big, is not URL-encoded, or does not begin with a slash (/).
     * @throws InvalidErrorCodeException
     *         An invalid error code was specified.
     * @throws InvalidResponseCodeException
     *         A response code is not valid.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws InvalidOriginAccessControlException
     *         The origin access control is not valid.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws InvalidViewerCertificateException
     *         A viewer certificate specified is not valid.
     * @throws InvalidMinimumProtocolVersionException
     *         The minimum protocol version specified is not valid.
     * @throws InvalidRequiredProtocolException
     *         This operation requires the HTTPS protocol. Ensure that you specify the HTTPS protocol in your request,
     *         or omit the <code>RequiredProtocols</code> element from your distribution configuration.
     * @throws NoSuchOriginException
     *         No origin exists with the specified <code>Origin Id</code>.
     * @throws TooManyOriginsException
     *         You cannot create more origins for the distribution.
     * @throws TooManyOriginGroupsPerDistributionException
     *         Processing your request would cause you to exceed the maximum number of origin groups allowed.
     * @throws TooManyCacheBehaviorsException
     *         You cannot create more cache behaviors for the distribution.
     * @throws TooManyCookieNamesInWhiteListException
     *         Your request contains more cookie names in the whitelist than are allowed per cache behavior.
     * @throws InvalidForwardCookiesException
     *         Your request contains forward cookies option which doesn't match with the expectation for the
     *         <code>whitelisted</code> list of cookie names. Either list of cookie names has been specified when not
     *         allowed or list of cookie names is missing when expected.
     * @throws TooManyHeadersInForwardedValuesException
     *         Your request contains too many headers in forwarded values.
     * @throws InvalidHeadersForS3OriginException
     *         The headers specified are not valid for an Amazon S3 origin.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws TooManyCertificatesException
     *         You cannot create anymore custom SSL/TLS certificates.
     * @throws InvalidLocationCodeException
     *         The location code specified is not valid.
     * @throws InvalidGeoRestrictionParameterException
     *         The specified geo restriction parameter is not valid.
     * @throws InvalidTtlOrderException
     *         The TTL order specified is not valid.
     * @throws InvalidWebAclIdException
     *         A web ACL ID specified is not valid. To specify a web ACL created using the latest version of WAF, use
     *         the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * @throws TooManyOriginCustomHeadersException
     *         Your request contains too many origin custom headers.
     * @throws TooManyQueryStringParametersException
     *         Your request contains too many query string parameters.
     * @throws InvalidQueryStringParametersException
     *         The query string parameters specified are not valid.
     * @throws TooManyDistributionsWithLambdaAssociationsException
     *         Processing your request would cause the maximum number of distributions with Lambda@Edge function
     *         associations per owner to be exceeded.
     * @throws TooManyDistributionsWithSingleFunctionArnException
     *         The maximum number of distributions have been associated with the specified Lambda@Edge function.
     * @throws TooManyLambdaFunctionAssociationsException
     *         Your request contains more Lambda@Edge function associations than are allowed per distribution.
     * @throws InvalidLambdaFunctionAssociationException
     *         The specified Lambda@Edge function association is invalid.
     * @throws TooManyDistributionsWithFunctionAssociationsException
     *         You have reached the maximum number of distributions that are associated with a CloudFront function. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyFunctionAssociationsException
     *         You have reached the maximum number of CloudFront function associations for this distribution. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws InvalidFunctionAssociationException
     *         A CloudFront function association is invalid.
     * @throws InvalidOriginReadTimeoutException
     *         The read timeout specified for the origin is not valid.
     * @throws InvalidOriginKeepaliveTimeoutException
     *         The keep alive timeout specified for the origin is not valid.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException
     *         The specified configuration for field-level encryption can't be associated with the specified cache
     *         behavior.
     * @throws TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException
     *         The maximum number of distributions have been associated with the specified configuration for field-level
     *         encryption.
     * @throws NoSuchCachePolicyException
     *         The cache policy does not exist.
     * @throws TooManyDistributionsAssociatedToCachePolicyException
     *         The maximum number of distributions have been associated with the specified cache policy. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyDistributionsAssociatedToOriginAccessControlException
     *         The maximum number of distributions have been associated with the specified origin access control.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws NoSuchResponseHeadersPolicyException
     *         The response headers policy does not exist.
     * @throws TooManyDistributionsAssociatedToResponseHeadersPolicyException
     *         The maximum number of distributions have been associated with the specified response headers policy.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws NoSuchOriginRequestPolicyException
     *         The origin request policy does not exist.
     * @throws TooManyDistributionsAssociatedToOriginRequestPolicyException
     *         The maximum number of distributions have been associated with the specified origin request policy. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyDistributionsAssociatedToKeyGroupException
     *         The number of distributions that reference this key group is more than the maximum allowed. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyKeyGroupsAssociatedToDistributionException
     *         The number of key groups referenced by this distribution is more than the maximum allowed. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TrustedKeyGroupDoesNotExistException
     *         The specified key group does not exist.
     * @throws NoSuchRealtimeLogConfigException
     *         The real-time log configuration does not exist.
     * @throws RealtimeLogConfigOwnerMismatchException
     *         The specified real-time log configuration belongs to a different Amazon Web Services account.
     * @throws ContinuousDeploymentPolicyInUseException
     *         You cannot delete a continuous deployment policy that is associated with a primary distribution.
     * @throws NoSuchContinuousDeploymentPolicyException
     *         The continuous deployment policy doesn't exist.
     * @throws StagingDistributionInUseException
     *         A continuous deployment policy for this staging distribution already exists.
     * @throws IllegalOriginAccessConfigurationException
     *         An origin cannot contain both an origin access control (OAC) and an origin access identity (OAI).
     * @throws InvalidDomainNameForOriginAccessControlException
     *         An origin access control is associated with an origin whose domain name is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateDistributionResponse updateDistribution(UpdateDistributionRequest updateDistributionRequest)
            throws AccessDeniedException, CnameAlreadyExistsException, IllegalUpdateException, InvalidIfMatchVersionException,
            MissingBodyException, NoSuchDistributionException, PreconditionFailedException, TooManyDistributionCnamEsException,
            InvalidDefaultRootObjectException, InvalidRelativePathException, InvalidErrorCodeException,
            InvalidResponseCodeException, InvalidArgumentException, InvalidOriginAccessIdentityException,
            InvalidOriginAccessControlException, TooManyTrustedSignersException, TrustedSignerDoesNotExistException,
            InvalidViewerCertificateException, InvalidMinimumProtocolVersionException, InvalidRequiredProtocolException,
            NoSuchOriginException, TooManyOriginsException, TooManyOriginGroupsPerDistributionException,
            TooManyCacheBehaviorsException, TooManyCookieNamesInWhiteListException, InvalidForwardCookiesException,
            TooManyHeadersInForwardedValuesException, InvalidHeadersForS3OriginException, InconsistentQuantitiesException,
            TooManyCertificatesException, InvalidLocationCodeException, InvalidGeoRestrictionParameterException,
            InvalidTtlOrderException, InvalidWebAclIdException, TooManyOriginCustomHeadersException,
            TooManyQueryStringParametersException, InvalidQueryStringParametersException,
            TooManyDistributionsWithLambdaAssociationsException, TooManyDistributionsWithSingleFunctionArnException,
            TooManyLambdaFunctionAssociationsException, InvalidLambdaFunctionAssociationException,
            TooManyDistributionsWithFunctionAssociationsException, TooManyFunctionAssociationsException,
            InvalidFunctionAssociationException, InvalidOriginReadTimeoutException, InvalidOriginKeepaliveTimeoutException,
            NoSuchFieldLevelEncryptionConfigException, IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException,
            TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException, NoSuchCachePolicyException,
            TooManyDistributionsAssociatedToCachePolicyException, TooManyDistributionsAssociatedToOriginAccessControlException,
            NoSuchResponseHeadersPolicyException, TooManyDistributionsAssociatedToResponseHeadersPolicyException,
            NoSuchOriginRequestPolicyException, TooManyDistributionsAssociatedToOriginRequestPolicyException,
            TooManyDistributionsAssociatedToKeyGroupException, TooManyKeyGroupsAssociatedToDistributionException,
            TrustedKeyGroupDoesNotExistException, NoSuchRealtimeLogConfigException, RealtimeLogConfigOwnerMismatchException,
            ContinuousDeploymentPolicyInUseException, NoSuchContinuousDeploymentPolicyException,
            StagingDistributionInUseException, IllegalOriginAccessConfigurationException,
            InvalidDomainNameForOriginAccessControlException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<UpdateDistributionResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(UpdateDistributionResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDistributionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDistributionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDistribution");

            return clientHandler.execute(new ClientExecutionParams<UpdateDistributionRequest, UpdateDistributionResponse>()
                    .withOperationName("UpdateDistribution").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(updateDistributionRequest)
                    .withMarshaller(new UpdateDistributionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Copies the staging distribution's configuration to its corresponding primary distribution. The primary
     * distribution retains its <code>Aliases</code> (also known as alternate domain names or CNAMEs) and
     * <code>ContinuousDeploymentPolicyId</code> value, but otherwise its configuration is overwritten to match the
     * staging distribution.
     * </p>
     * <p>
     * You can use this operation in a continuous deployment workflow after you have tested configuration changes on the
     * staging distribution. After using a continuous deployment policy to move a portion of your domain name's traffic
     * to the staging distribution and verifying that it works as intended, you can use this operation to copy the
     * staging distribution's configuration to the primary distribution. This action will disable the continuous
     * deployment policy and move your domain's traffic back to the primary distribution.
     * </p>
     * <p>
     * This API operation requires the following IAM permissions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistribution.html">GetDistribution</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html">
     * UpdateDistribution</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param updateDistributionWithStagingConfigRequest
     * @return Result of the UpdateDistributionWithStagingConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws NoSuchDistributionException
     *         The specified distribution does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws TooManyDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws InvalidDefaultRootObjectException
     *         The default root object file name is too big or contains an invalid character.
     * @throws InvalidRelativePathException
     *         The relative path is too big, is not URL-encoded, or does not begin with a slash (/).
     * @throws InvalidErrorCodeException
     *         An invalid error code was specified.
     * @throws InvalidResponseCodeException
     *         A response code is not valid.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws InvalidOriginAccessControlException
     *         The origin access control is not valid.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws InvalidViewerCertificateException
     *         A viewer certificate specified is not valid.
     * @throws InvalidMinimumProtocolVersionException
     *         The minimum protocol version specified is not valid.
     * @throws InvalidRequiredProtocolException
     *         This operation requires the HTTPS protocol. Ensure that you specify the HTTPS protocol in your request,
     *         or omit the <code>RequiredProtocols</code> element from your distribution configuration.
     * @throws NoSuchOriginException
     *         No origin exists with the specified <code>Origin Id</code>.
     * @throws TooManyOriginsException
     *         You cannot create more origins for the distribution.
     * @throws TooManyOriginGroupsPerDistributionException
     *         Processing your request would cause you to exceed the maximum number of origin groups allowed.
     * @throws TooManyCacheBehaviorsException
     *         You cannot create more cache behaviors for the distribution.
     * @throws TooManyCookieNamesInWhiteListException
     *         Your request contains more cookie names in the whitelist than are allowed per cache behavior.
     * @throws InvalidForwardCookiesException
     *         Your request contains forward cookies option which doesn't match with the expectation for the
     *         <code>whitelisted</code> list of cookie names. Either list of cookie names has been specified when not
     *         allowed or list of cookie names is missing when expected.
     * @throws TooManyHeadersInForwardedValuesException
     *         Your request contains too many headers in forwarded values.
     * @throws InvalidHeadersForS3OriginException
     *         The headers specified are not valid for an Amazon S3 origin.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws TooManyCertificatesException
     *         You cannot create anymore custom SSL/TLS certificates.
     * @throws InvalidLocationCodeException
     *         The location code specified is not valid.
     * @throws InvalidGeoRestrictionParameterException
     *         The specified geo restriction parameter is not valid.
     * @throws InvalidTtlOrderException
     *         The TTL order specified is not valid.
     * @throws InvalidWebAclIdException
     *         A web ACL ID specified is not valid. To specify a web ACL created using the latest version of WAF, use
     *         the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.
     * @throws TooManyOriginCustomHeadersException
     *         Your request contains too many origin custom headers.
     * @throws TooManyQueryStringParametersException
     *         Your request contains too many query string parameters.
     * @throws InvalidQueryStringParametersException
     *         The query string parameters specified are not valid.
     * @throws TooManyDistributionsWithLambdaAssociationsException
     *         Processing your request would cause the maximum number of distributions with Lambda@Edge function
     *         associations per owner to be exceeded.
     * @throws TooManyDistributionsWithSingleFunctionArnException
     *         The maximum number of distributions have been associated with the specified Lambda@Edge function.
     * @throws TooManyLambdaFunctionAssociationsException
     *         Your request contains more Lambda@Edge function associations than are allowed per distribution.
     * @throws InvalidLambdaFunctionAssociationException
     *         The specified Lambda@Edge function association is invalid.
     * @throws TooManyDistributionsWithFunctionAssociationsException
     *         You have reached the maximum number of distributions that are associated with a CloudFront function. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyFunctionAssociationsException
     *         You have reached the maximum number of CloudFront function associations for this distribution. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws InvalidFunctionAssociationException
     *         A CloudFront function association is invalid.
     * @throws InvalidOriginReadTimeoutException
     *         The read timeout specified for the origin is not valid.
     * @throws InvalidOriginKeepaliveTimeoutException
     *         The keep alive timeout specified for the origin is not valid.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException
     *         The specified configuration for field-level encryption can't be associated with the specified cache
     *         behavior.
     * @throws TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException
     *         The maximum number of distributions have been associated with the specified configuration for field-level
     *         encryption.
     * @throws NoSuchCachePolicyException
     *         The cache policy does not exist.
     * @throws TooManyDistributionsAssociatedToCachePolicyException
     *         The maximum number of distributions have been associated with the specified cache policy. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyDistributionsAssociatedToOriginAccessControlException
     *         The maximum number of distributions have been associated with the specified origin access control.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws NoSuchResponseHeadersPolicyException
     *         The response headers policy does not exist.
     * @throws TooManyDistributionsAssociatedToResponseHeadersPolicyException
     *         The maximum number of distributions have been associated with the specified response headers policy.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws NoSuchOriginRequestPolicyException
     *         The origin request policy does not exist.
     * @throws TooManyDistributionsAssociatedToOriginRequestPolicyException
     *         The maximum number of distributions have been associated with the specified origin request policy. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyDistributionsAssociatedToKeyGroupException
     *         The number of distributions that reference this key group is more than the maximum allowed. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyKeyGroupsAssociatedToDistributionException
     *         The number of key groups referenced by this distribution is more than the maximum allowed. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TrustedKeyGroupDoesNotExistException
     *         The specified key group does not exist.
     * @throws NoSuchRealtimeLogConfigException
     *         The real-time log configuration does not exist.
     * @throws RealtimeLogConfigOwnerMismatchException
     *         The specified real-time log configuration belongs to a different Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateDistributionWithStagingConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateDistributionWithStagingConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateDistributionWithStagingConfigResponse updateDistributionWithStagingConfig(
            UpdateDistributionWithStagingConfigRequest updateDistributionWithStagingConfigRequest) throws AccessDeniedException,
            CnameAlreadyExistsException, IllegalUpdateException, InvalidIfMatchVersionException, MissingBodyException,
            NoSuchDistributionException, PreconditionFailedException, TooManyDistributionCnamEsException,
            InvalidDefaultRootObjectException, InvalidRelativePathException, InvalidErrorCodeException,
            InvalidResponseCodeException, InvalidArgumentException, InvalidOriginAccessIdentityException,
            InvalidOriginAccessControlException, TooManyTrustedSignersException, TrustedSignerDoesNotExistException,
            InvalidViewerCertificateException, InvalidMinimumProtocolVersionException, InvalidRequiredProtocolException,
            NoSuchOriginException, TooManyOriginsException, TooManyOriginGroupsPerDistributionException,
            TooManyCacheBehaviorsException, TooManyCookieNamesInWhiteListException, InvalidForwardCookiesException,
            TooManyHeadersInForwardedValuesException, InvalidHeadersForS3OriginException, InconsistentQuantitiesException,
            TooManyCertificatesException, InvalidLocationCodeException, InvalidGeoRestrictionParameterException,
            InvalidTtlOrderException, InvalidWebAclIdException, TooManyOriginCustomHeadersException,
            TooManyQueryStringParametersException, InvalidQueryStringParametersException,
            TooManyDistributionsWithLambdaAssociationsException, TooManyDistributionsWithSingleFunctionArnException,
            TooManyLambdaFunctionAssociationsException, InvalidLambdaFunctionAssociationException,
            TooManyDistributionsWithFunctionAssociationsException, TooManyFunctionAssociationsException,
            InvalidFunctionAssociationException, InvalidOriginReadTimeoutException, InvalidOriginKeepaliveTimeoutException,
            NoSuchFieldLevelEncryptionConfigException, IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException,
            TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException, NoSuchCachePolicyException,
            TooManyDistributionsAssociatedToCachePolicyException, TooManyDistributionsAssociatedToOriginAccessControlException,
            NoSuchResponseHeadersPolicyException, TooManyDistributionsAssociatedToResponseHeadersPolicyException,
            NoSuchOriginRequestPolicyException, TooManyDistributionsAssociatedToOriginRequestPolicyException,
            TooManyDistributionsAssociatedToKeyGroupException, TooManyKeyGroupsAssociatedToDistributionException,
            TrustedKeyGroupDoesNotExistException, NoSuchRealtimeLogConfigException, RealtimeLogConfigOwnerMismatchException,
            AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<UpdateDistributionWithStagingConfigResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(UpdateDistributionWithStagingConfigResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDistributionWithStagingConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateDistributionWithStagingConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDistributionWithStagingConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateDistributionWithStagingConfigRequest, UpdateDistributionWithStagingConfigResponse>()
                            .withOperationName("UpdateDistributionWithStagingConfig").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(updateDistributionWithStagingConfigRequest)
                            .withMarshaller(new UpdateDistributionWithStagingConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update a field-level encryption configuration.
     * </p>
     *
     * @param updateFieldLevelEncryptionConfigRequest
     * @return Result of the UpdateFieldLevelEncryptionConfig operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws NoSuchFieldLevelEncryptionConfigException
     *         The specified configuration for field-level encryption doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws TooManyFieldLevelEncryptionQueryArgProfilesException
     *         The maximum number of query arg profiles for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionContentTypeProfilesException
     *         The maximum number of content type profiles for field-level encryption have been created.
     * @throws QueryArgProfileEmptyException
     *         No profile specified for the field-level encryption query argument.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateFieldLevelEncryptionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateFieldLevelEncryptionConfigResponse updateFieldLevelEncryptionConfig(
            UpdateFieldLevelEncryptionConfigRequest updateFieldLevelEncryptionConfigRequest) throws AccessDeniedException,
            IllegalUpdateException, InconsistentQuantitiesException, InvalidArgumentException, InvalidIfMatchVersionException,
            NoSuchFieldLevelEncryptionProfileException, NoSuchFieldLevelEncryptionConfigException, PreconditionFailedException,
            TooManyFieldLevelEncryptionQueryArgProfilesException, TooManyFieldLevelEncryptionContentTypeProfilesException,
            QueryArgProfileEmptyException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<UpdateFieldLevelEncryptionConfigResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(UpdateFieldLevelEncryptionConfigResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFieldLevelEncryptionConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateFieldLevelEncryptionConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFieldLevelEncryptionConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateFieldLevelEncryptionConfigRequest, UpdateFieldLevelEncryptionConfigResponse>()
                            .withOperationName("UpdateFieldLevelEncryptionConfig").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(updateFieldLevelEncryptionConfigRequest)
                            .withMarshaller(new UpdateFieldLevelEncryptionConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update a field-level encryption profile.
     * </p>
     *
     * @param updateFieldLevelEncryptionProfileRequest
     * @return Result of the UpdateFieldLevelEncryptionProfile operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws FieldLevelEncryptionProfileAlreadyExistsException
     *         The specified profile for field-level encryption already exists.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws NoSuchFieldLevelEncryptionProfileException
     *         The specified profile for field-level encryption doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws FieldLevelEncryptionProfileSizeExceededException
     *         The maximum size of a profile for field-level encryption was exceeded.
     * @throws TooManyFieldLevelEncryptionEncryptionEntitiesException
     *         The maximum number of encryption entities for field-level encryption have been created.
     * @throws TooManyFieldLevelEncryptionFieldPatternsException
     *         The maximum number of field patterns for field-level encryption have been created.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateFieldLevelEncryptionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateFieldLevelEncryptionProfileResponse updateFieldLevelEncryptionProfile(
            UpdateFieldLevelEncryptionProfileRequest updateFieldLevelEncryptionProfileRequest) throws AccessDeniedException,
            FieldLevelEncryptionProfileAlreadyExistsException, IllegalUpdateException, InconsistentQuantitiesException,
            InvalidArgumentException, InvalidIfMatchVersionException, NoSuchPublicKeyException,
            NoSuchFieldLevelEncryptionProfileException, PreconditionFailedException,
            FieldLevelEncryptionProfileSizeExceededException, TooManyFieldLevelEncryptionEncryptionEntitiesException,
            TooManyFieldLevelEncryptionFieldPatternsException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<UpdateFieldLevelEncryptionProfileResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(UpdateFieldLevelEncryptionProfileResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFieldLevelEncryptionProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateFieldLevelEncryptionProfileRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFieldLevelEncryptionProfile");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateFieldLevelEncryptionProfileRequest, UpdateFieldLevelEncryptionProfileResponse>()
                            .withOperationName("UpdateFieldLevelEncryptionProfile").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(updateFieldLevelEncryptionProfileRequest)
                            .withMarshaller(new UpdateFieldLevelEncryptionProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a CloudFront function.
     * </p>
     * <p>
     * You can update a function's code or the comment that describes the function. You cannot update a function's name.
     * </p>
     * <p>
     * To update a function, you provide the function's name and version (<code>ETag</code> value) along with the
     * updated function code. To get the name and version, you can use <code>ListFunctions</code> and
     * <code>DescribeFunction</code>.
     * </p>
     *
     * @param updateFunctionRequest
     * @return Result of the UpdateFunction operation returned by the service.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchFunctionExistsException
     *         The function does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws FunctionSizeLimitExceededException
     *         The function is too large. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateFunctionResponse updateFunction(UpdateFunctionRequest updateFunctionRequest) throws InvalidArgumentException,
            InvalidIfMatchVersionException, NoSuchFunctionExistsException, PreconditionFailedException,
            FunctionSizeLimitExceededException, UnsupportedOperationException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<UpdateFunctionResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                UpdateFunctionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFunctionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFunctionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFunction");

            return clientHandler.execute(new ClientExecutionParams<UpdateFunctionRequest, UpdateFunctionResponse>()
                    .withOperationName("UpdateFunction").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(updateFunctionRequest)
                    .withMarshaller(new UpdateFunctionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a key group.
     * </p>
     * <p>
     * When you update a key group, all the fields are updated with the values provided in the request. You cannot
     * update some fields independent of others. To update a key group:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Get the current key group with <code>GetKeyGroup</code> or <code>GetKeyGroupConfig</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Locally modify the fields in the key group that you want to update. For example, add or remove public key IDs.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <code>UpdateKeyGroup</code> with the entire key group object, including the fields that you modified and
     * those that you didn't.
     * </p>
     * </li>
     * </ol>
     *
     * @param updateKeyGroupRequest
     * @return Result of the UpdateKeyGroup operation returned by the service.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchResourceException
     *         A resource that was specified is not valid.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws KeyGroupAlreadyExistsException
     *         A key group with this name already exists. You must provide a unique name. To modify an existing key
     *         group, use <code>UpdateKeyGroup</code>.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws TooManyPublicKeysInKeyGroupException
     *         The number of public keys in this key group is more than the maximum allowed. For more information, see
     *         <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas
     *         </a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateKeyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateKeyGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateKeyGroupResponse updateKeyGroup(UpdateKeyGroupRequest updateKeyGroupRequest)
            throws InvalidIfMatchVersionException, NoSuchResourceException, PreconditionFailedException,
            KeyGroupAlreadyExistsException, InvalidArgumentException, TooManyPublicKeysInKeyGroupException, AwsServiceException,
            SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<UpdateKeyGroupResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                UpdateKeyGroupResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateKeyGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateKeyGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateKeyGroup");

            return clientHandler.execute(new ClientExecutionParams<UpdateKeyGroupRequest, UpdateKeyGroupResponse>()
                    .withOperationName("UpdateKeyGroup").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(updateKeyGroupRequest)
                    .withMarshaller(new UpdateKeyGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Specifies the key value store to update.
     * </p>
     *
     * @param updateKeyValueStoreRequest
     * @return Result of the UpdateKeyValueStore operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws EntityNotFoundException
     *         The key value store entity was not found.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws UnsupportedOperationException
     *         This operation is not supported in this region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateKeyValueStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateKeyValueStore"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateKeyValueStoreResponse updateKeyValueStore(UpdateKeyValueStoreRequest updateKeyValueStoreRequest)
            throws AccessDeniedException, InvalidArgumentException, EntityNotFoundException, InvalidIfMatchVersionException,
            PreconditionFailedException, UnsupportedOperationException, AwsServiceException, SdkClientException,
            CloudFrontException {

        HttpResponseHandler<Response<UpdateKeyValueStoreResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(UpdateKeyValueStoreResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateKeyValueStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateKeyValueStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateKeyValueStore");

            return clientHandler.execute(new ClientExecutionParams<UpdateKeyValueStoreRequest, UpdateKeyValueStoreResponse>()
                    .withOperationName("UpdateKeyValueStore").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(updateKeyValueStoreRequest)
                    .withMarshaller(new UpdateKeyValueStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a CloudFront origin access control.
     * </p>
     *
     * @param updateOriginAccessControlRequest
     * @return Result of the UpdateOriginAccessControl operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws OriginAccessControlAlreadyExistsException
     *         An origin access control with the specified parameters already exists.
     * @throws NoSuchOriginAccessControlException
     *         The origin access control does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateOriginAccessControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateOriginAccessControl"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateOriginAccessControlResponse updateOriginAccessControl(
            UpdateOriginAccessControlRequest updateOriginAccessControlRequest) throws AccessDeniedException,
            IllegalUpdateException, InvalidIfMatchVersionException, OriginAccessControlAlreadyExistsException,
            NoSuchOriginAccessControlException, PreconditionFailedException, InvalidArgumentException, AwsServiceException,
            SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<UpdateOriginAccessControlResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(UpdateOriginAccessControlResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateOriginAccessControlRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateOriginAccessControlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateOriginAccessControl");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateOriginAccessControlRequest, UpdateOriginAccessControlResponse>()
                            .withOperationName("UpdateOriginAccessControl").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(updateOriginAccessControlRequest)
                            .withMarshaller(new UpdateOriginAccessControlRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an origin request policy configuration.
     * </p>
     * <p>
     * When you update an origin request policy configuration, all the fields are updated with the values provided in
     * the request. You cannot update some fields independent of others. To update an origin request policy
     * configuration:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Use <code>GetOriginRequestPolicyConfig</code> to get the current configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Locally modify the fields in the origin request policy configuration that you want to update.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <code>UpdateOriginRequestPolicy</code> by providing the entire origin request policy configuration,
     * including the fields that you modified and those that you didn't.
     * </p>
     * </li>
     * </ol>
     *
     * @param updateOriginRequestPolicyRequest
     * @return Result of the UpdateOriginRequestPolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchOriginRequestPolicyException
     *         The origin request policy does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws OriginRequestPolicyAlreadyExistsException
     *         An origin request policy with this name already exists. You must provide a unique name. To modify an
     *         existing origin request policy, use <code>UpdateOriginRequestPolicy</code>.
     * @throws TooManyHeadersInOriginRequestPolicyException
     *         The number of headers in the origin request policy exceeds the maximum. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a>
     *         (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyCookiesInOriginRequestPolicyException
     *         The number of cookies in the origin request policy exceeds the maximum. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas</a>
     *         (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyQueryStringsInOriginRequestPolicyException
     *         The number of query strings in the origin request policy exceeds the maximum. For more information, see
     *         <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html">Quotas
     *         </a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateOriginRequestPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateOriginRequestPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateOriginRequestPolicyResponse updateOriginRequestPolicy(
            UpdateOriginRequestPolicyRequest updateOriginRequestPolicyRequest) throws AccessDeniedException,
            IllegalUpdateException, InconsistentQuantitiesException, InvalidArgumentException, InvalidIfMatchVersionException,
            NoSuchOriginRequestPolicyException, PreconditionFailedException, OriginRequestPolicyAlreadyExistsException,
            TooManyHeadersInOriginRequestPolicyException, TooManyCookiesInOriginRequestPolicyException,
            TooManyQueryStringsInOriginRequestPolicyException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<UpdateOriginRequestPolicyResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(UpdateOriginRequestPolicyResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateOriginRequestPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateOriginRequestPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateOriginRequestPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateOriginRequestPolicyRequest, UpdateOriginRequestPolicyResponse>()
                            .withOperationName("UpdateOriginRequestPolicy").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(updateOriginRequestPolicyRequest)
                            .withMarshaller(new UpdateOriginRequestPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update public key information. Note that the only value you can change is the comment.
     * </p>
     *
     * @param updatePublicKeyRequest
     * @return Result of the UpdatePublicKey operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws CannotChangeImmutablePublicKeyFieldsException
     *         You can't change the value of a public key.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws NoSuchPublicKeyException
     *         The specified public key doesn't exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdatePublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdatePublicKey" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdatePublicKeyResponse updatePublicKey(UpdatePublicKeyRequest updatePublicKeyRequest) throws AccessDeniedException,
            CannotChangeImmutablePublicKeyFieldsException, InvalidArgumentException, InvalidIfMatchVersionException,
            IllegalUpdateException, NoSuchPublicKeyException, PreconditionFailedException, AwsServiceException,
            SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<UpdatePublicKeyResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                UpdatePublicKeyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updatePublicKeyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePublicKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePublicKey");

            return clientHandler.execute(new ClientExecutionParams<UpdatePublicKeyRequest, UpdatePublicKeyResponse>()
                    .withOperationName("UpdatePublicKey").withProtocolMetadata(protocolMetadata)
                    .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                    .withRequestConfiguration(clientConfiguration).withInput(updatePublicKeyRequest)
                    .withMarshaller(new UpdatePublicKeyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a real-time log configuration.
     * </p>
     * <p>
     * When you update a real-time log configuration, all the parameters are updated with the values provided in the
     * request. You cannot update some parameters independent of others. To update a real-time log configuration:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Call <code>GetRealtimeLogConfig</code> to get the current real-time log configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Locally modify the parameters in the real-time log configuration that you want to update.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call this API (<code>UpdateRealtimeLogConfig</code>) by providing the entire real-time log configuration,
     * including the parameters that you modified and those that you didn't.
     * </p>
     * </li>
     * </ol>
     * <p>
     * You cannot update a real-time log configuration's <code>Name</code> or <code>ARN</code>.
     * </p>
     *
     * @param updateRealtimeLogConfigRequest
     * @return Result of the UpdateRealtimeLogConfig operation returned by the service.
     * @throws NoSuchRealtimeLogConfigException
     *         The real-time log configuration does not exist.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateRealtimeLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateRealtimeLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateRealtimeLogConfigResponse updateRealtimeLogConfig(UpdateRealtimeLogConfigRequest updateRealtimeLogConfigRequest)
            throws NoSuchRealtimeLogConfigException, InvalidArgumentException, AccessDeniedException, AwsServiceException,
            SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<UpdateRealtimeLogConfigResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(UpdateRealtimeLogConfigResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRealtimeLogConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRealtimeLogConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRealtimeLogConfig");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateRealtimeLogConfigRequest, UpdateRealtimeLogConfigResponse>()
                            .withOperationName("UpdateRealtimeLogConfig").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(updateRealtimeLogConfigRequest)
                            .withMarshaller(new UpdateRealtimeLogConfigRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a response headers policy.
     * </p>
     * <p>
     * When you update a response headers policy, the entire policy is replaced. You cannot update some policy fields
     * independent of others. To update a response headers policy configuration:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Use <code>GetResponseHeadersPolicyConfig</code> to get the current policy's configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Modify the fields in the response headers policy configuration that you want to update.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <code>UpdateResponseHeadersPolicy</code>, providing the entire response headers policy configuration,
     * including the fields that you modified and those that you didn't.
     * </p>
     * </li>
     * </ol>
     *
     * @param updateResponseHeadersPolicyRequest
     * @return Result of the UpdateResponseHeadersPolicy operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws NoSuchResponseHeadersPolicyException
     *         The response headers policy does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws ResponseHeadersPolicyAlreadyExistsException
     *         A response headers policy with this name already exists. You must provide a unique name. To modify an
     *         existing response headers policy, use <code>UpdateResponseHeadersPolicy</code>.
     * @throws TooManyCustomHeadersInResponseHeadersPolicyException
     *         The number of custom headers in the response headers policy exceeds the maximum.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooLongCspInResponseHeadersPolicyException
     *         The length of the <code>Content-Security-Policy</code> header value in the response headers policy
     *         exceeds the maximum.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws TooManyRemoveHeadersInResponseHeadersPolicyException
     *         The number of headers in <code>RemoveHeadersConfig</code> in the response headers policy exceeds the
     *         maximum.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateResponseHeadersPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateResponseHeadersPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateResponseHeadersPolicyResponse updateResponseHeadersPolicy(
            UpdateResponseHeadersPolicyRequest updateResponseHeadersPolicyRequest) throws AccessDeniedException,
            IllegalUpdateException, InconsistentQuantitiesException, InvalidArgumentException, InvalidIfMatchVersionException,
            NoSuchResponseHeadersPolicyException, PreconditionFailedException, ResponseHeadersPolicyAlreadyExistsException,
            TooManyCustomHeadersInResponseHeadersPolicyException, TooLongCspInResponseHeadersPolicyException,
            TooManyRemoveHeadersInResponseHeadersPolicyException, AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<UpdateResponseHeadersPolicyResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(UpdateResponseHeadersPolicyResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateResponseHeadersPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateResponseHeadersPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateResponseHeadersPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateResponseHeadersPolicyRequest, UpdateResponseHeadersPolicyResponse>()
                            .withOperationName("UpdateResponseHeadersPolicy").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(updateResponseHeadersPolicyRequest)
                            .withMarshaller(new UpdateResponseHeadersPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update a streaming distribution.
     * </p>
     *
     * @param updateStreamingDistributionRequest
     *        The request to update a streaming distribution.
     * @return Result of the UpdateStreamingDistribution operation returned by the service.
     * @throws AccessDeniedException
     *         Access denied.
     * @throws CnameAlreadyExistsException
     *         The CNAME specified is already defined for CloudFront.
     * @throws IllegalUpdateException
     *         The update contains modifications that are not allowed.
     * @throws InvalidIfMatchVersionException
     *         The <code>If-Match</code> version is missing or not valid.
     * @throws MissingBodyException
     *         This operation requires a body. Ensure that the body is present and the <code>Content-Type</code> header
     *         is set.
     * @throws NoSuchStreamingDistributionException
     *         The specified streaming distribution does not exist.
     * @throws PreconditionFailedException
     *         The precondition in one or more of the request fields evaluated to <code>false</code>.
     * @throws TooManyStreamingDistributionCnamEsException
     *         Your request contains more CNAMEs than are allowed per distribution.
     * @throws InvalidArgumentException
     *         An argument is invalid.
     * @throws InvalidOriginAccessIdentityException
     *         The origin access identity is not valid or doesn't exist.
     * @throws InvalidOriginAccessControlException
     *         The origin access control is not valid.
     * @throws TooManyTrustedSignersException
     *         Your request contains more trusted signers than are allowed per distribution.
     * @throws TrustedSignerDoesNotExistException
     *         One or more of your trusted signers don't exist.
     * @throws InconsistentQuantitiesException
     *         The value of <code>Quantity</code> and the size of <code>Items</code> don't match.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CloudFrontClient.UpdateStreamingDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateStreamingDistributionResponse updateStreamingDistribution(
            UpdateStreamingDistributionRequest updateStreamingDistributionRequest) throws AccessDeniedException,
            CnameAlreadyExistsException, IllegalUpdateException, InvalidIfMatchVersionException, MissingBodyException,
            NoSuchStreamingDistributionException, PreconditionFailedException, TooManyStreamingDistributionCnamEsException,
            InvalidArgumentException, InvalidOriginAccessIdentityException, InvalidOriginAccessControlException,
            TooManyTrustedSignersException, TrustedSignerDoesNotExistException, InconsistentQuantitiesException,
            AwsServiceException, SdkClientException, CloudFrontException {

        HttpResponseHandler<Response<UpdateStreamingDistributionResponse>> responseHandler = protocolFactory
                .createCombinedResponseHandler(UpdateStreamingDistributionResponse::builder,
                        new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateStreamingDistributionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateStreamingDistributionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateStreamingDistribution");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateStreamingDistributionRequest, UpdateStreamingDistributionResponse>()
                            .withOperationName("UpdateStreamingDistribution").withProtocolMetadata(protocolMetadata)
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withRequestConfiguration(clientConfiguration).withInput(updateStreamingDistributionRequest)
                            .withMarshaller(new UpdateStreamingDistributionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Creates an instance of {@link CloudFrontUtilities} object with the configuration set on this client.
     */
    @Override
    public CloudFrontUtilities utilities() {
        return CloudFrontUtilities.create();
    }

    /**
     * Create an instance of {@link CloudFrontWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link CloudFrontWaiter}
     */
    @Override
    public CloudFrontWaiter waiter() {
        return CloudFrontWaiter.builder().client(this).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        CloudFrontServiceClientConfigurationBuilder serviceConfigBuilder = new CloudFrontServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private AwsXmlProtocolFactory init() {
        return AwsXmlProtocolFactory
                .builder()
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StreamingDistributionAlreadyExists")
                                .exceptionBuilderSupplier(StreamingDistributionAlreadyExistsException::builder)
                                .httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchInvalidation")
                                .exceptionBuilderSupplier(NoSuchInvalidationException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooLongCSPInResponseHeadersPolicy")
                                .exceptionBuilderSupplier(TooLongCspInResponseHeadersPolicyException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchFieldLevelEncryptionConfig")
                                .exceptionBuilderSupplier(NoSuchFieldLevelEncryptionConfigException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OriginRequestPolicyAlreadyExists")
                                .exceptionBuilderSupplier(OriginRequestPolicyAlreadyExistsException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyKeyGroupsAssociatedToDistribution")
                                .exceptionBuilderSupplier(TooManyKeyGroupsAssociatedToDistributionException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidMinimumProtocolVersion")
                                .exceptionBuilderSupplier(InvalidMinimumProtocolVersionException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyInvalidationsInProgress")
                                .exceptionBuilderSupplier(TooManyInvalidationsInProgressException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionConfigs")
                                .exceptionBuilderSupplier(TooManyFieldLevelEncryptionConfigsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyPublicKeys")
                                .exceptionBuilderSupplier(TooManyPublicKeysException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyCacheBehaviors")
                                .exceptionBuilderSupplier(TooManyCacheBehaviorsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CloudFrontOriginAccessIdentityInUse")
                                .exceptionBuilderSupplier(CloudFrontOriginAccessIdentityInUseException::builder)
                                .httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FieldLevelEncryptionProfileAlreadyExists")
                                .exceptionBuilderSupplier(FieldLevelEncryptionProfileAlreadyExistsException::builder)
                                .httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidOriginAccessControl")
                                .exceptionBuilderSupplier(InvalidOriginAccessControlException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MissingBody")
                                .exceptionBuilderSupplier(MissingBodyException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyResponseHeadersPolicies")
                                .exceptionBuilderSupplier(TooManyResponseHeadersPoliciesException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyOrigins")
                                .exceptionBuilderSupplier(TooManyOriginsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FunctionSizeLimitExceeded")
                                .exceptionBuilderSupplier(FunctionSizeLimitExceededException::builder).httpStatusCode(413)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedOperation")
                                .exceptionBuilderSupplier(UnsupportedOperationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BatchTooLarge")
                                .exceptionBuilderSupplier(BatchTooLargeException::builder).httpStatusCode(413).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RealtimeLogConfigInUse")
                                .exceptionBuilderSupplier(RealtimeLogConfigInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidResponseCode")
                                .exceptionBuilderSupplier(InvalidResponseCodeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FieldLevelEncryptionConfigAlreadyExists")
                                .exceptionBuilderSupplier(FieldLevelEncryptionConfigAlreadyExistsException::builder)
                                .httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidOriginKeepaliveTimeout")
                                .exceptionBuilderSupplier(InvalidOriginKeepaliveTimeoutException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyStreamingDistributionCNAMEs")
                                .exceptionBuilderSupplier(TooManyStreamingDistributionCnamEsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OriginAccessControlAlreadyExists")
                                .exceptionBuilderSupplier(OriginAccessControlAlreadyExistsException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StreamingDistributionNotDisabled")
                                .exceptionBuilderSupplier(StreamingDistributionNotDisabledException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyDistributionCNAMEs")
                                .exceptionBuilderSupplier(TooManyDistributionCnamEsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyQueryStringParameters")
                                .exceptionBuilderSupplier(TooManyQueryStringParametersException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionEncryptionEntities")
                                .exceptionBuilderSupplier(TooManyFieldLevelEncryptionEncryptionEntitiesException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FieldLevelEncryptionConfigInUse")
                                .exceptionBuilderSupplier(FieldLevelEncryptionConfigInUseException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CloudFrontOriginAccessIdentityAlreadyExists")
                                .exceptionBuilderSupplier(CloudFrontOriginAccessIdentityAlreadyExistsException::builder)
                                .httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchOriginAccessControl")
                                .exceptionBuilderSupplier(NoSuchOriginAccessControlException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchRealtimeLogConfig")
                                .exceptionBuilderSupplier(NoSuchRealtimeLogConfigException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidProtocolSettings")
                                .exceptionBuilderSupplier(InvalidProtocolSettingsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionProfiles")
                                .exceptionBuilderSupplier(TooManyFieldLevelEncryptionProfilesException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceInUse")
                                .exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidForwardCookies")
                                .exceptionBuilderSupplier(InvalidForwardCookiesException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyPublicKeysInKeyGroup")
                                .exceptionBuilderSupplier(TooManyPublicKeysInKeyGroupException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidOriginAccessIdentity")
                                .exceptionBuilderSupplier(InvalidOriginAccessIdentityException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IllegalUpdate")
                                .exceptionBuilderSupplier(IllegalUpdateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyCookieNamesInWhiteList")
                                .exceptionBuilderSupplier(TooManyCookieNamesInWhiteListException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TrustedKeyGroupDoesNotExist")
                                .exceptionBuilderSupplier(TrustedKeyGroupDoesNotExistException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata
                                .builder()
                                .errorCode("TooManyDistributionsAssociatedToResponseHeadersPolicy")
                                .exceptionBuilderSupplier(TooManyDistributionsAssociatedToResponseHeadersPolicyException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchDistribution")
                                .exceptionBuilderSupplier(NoSuchDistributionException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchResponseHeadersPolicy")
                                .exceptionBuilderSupplier(NoSuchResponseHeadersPolicyException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CNAMEAlreadyExists")
                                .exceptionBuilderSupplier(CnameAlreadyExistsException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTTLOrder")
                                .exceptionBuilderSupplier(InvalidTtlOrderException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FunctionInUse")
                                .exceptionBuilderSupplier(FunctionInUseException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidViewerCertificate")
                                .exceptionBuilderSupplier(InvalidViewerCertificateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyCachePolicies")
                                .exceptionBuilderSupplier(TooManyCachePoliciesException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyQueryStringsInCachePolicy")
                                .exceptionBuilderSupplier(TooManyQueryStringsInCachePolicyException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FunctionAlreadyExists")
                                .exceptionBuilderSupplier(FunctionAlreadyExistsException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CachePolicyInUse")
                                .exceptionBuilderSupplier(CachePolicyInUseException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDefaultRootObject")
                                .exceptionBuilderSupplier(InvalidDefaultRootObjectException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StagingDistributionInUse")
                                .exceptionBuilderSupplier(StagingDistributionInUseException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyCloudFrontOriginAccessIdentities")
                                .exceptionBuilderSupplier(TooManyCloudFrontOriginAccessIdentitiesException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EntityNotFound")
                                .exceptionBuilderSupplier(EntityNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionContentTypeProfiles")
                                .exceptionBuilderSupplier(TooManyFieldLevelEncryptionContentTypeProfilesException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRelativePath")
                                .exceptionBuilderSupplier(InvalidRelativePathException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyDistributionsWithLambdaAssociations")
                                .exceptionBuilderSupplier(TooManyDistributionsWithLambdaAssociationsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EntitySizeLimitExceeded")
                                .exceptionBuilderSupplier(EntitySizeLimitExceededException::builder).httpStatusCode(413).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidHeadersForS3Origin")
                                .exceptionBuilderSupplier(InvalidHeadersForS3OriginException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RealtimeLogConfigAlreadyExists")
                                .exceptionBuilderSupplier(RealtimeLogConfigAlreadyExistsException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyDistributions")
                                .exceptionBuilderSupplier(TooManyDistributionsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyDistributionsAssociatedToOriginRequestPolicy")
                                .exceptionBuilderSupplier(TooManyDistributionsAssociatedToOriginRequestPolicyException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CannotChangeImmutablePublicKeyFields")
                                .exceptionBuilderSupplier(CannotChangeImmutablePublicKeyFieldsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionQueryArgProfiles")
                                .exceptionBuilderSupplier(TooManyFieldLevelEncryptionQueryArgProfilesException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyCookiesInOriginRequestPolicy")
                                .exceptionBuilderSupplier(TooManyCookiesInOriginRequestPolicyException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IllegalDelete")
                                .exceptionBuilderSupplier(IllegalDeleteException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidOrigin")
                                .exceptionBuilderSupplier(InvalidOriginException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TestFunctionFailed")
                                .exceptionBuilderSupplier(TestFunctionFailedException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidGeoRestrictionParameter")
                                .exceptionBuilderSupplier(InvalidGeoRestrictionParameterException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRemoveHeadersInResponseHeadersPolicy")
                                .exceptionBuilderSupplier(TooManyRemoveHeadersInResponseHeadersPolicyException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyCustomHeadersInResponseHeadersPolicy")
                                .exceptionBuilderSupplier(TooManyCustomHeadersInResponseHeadersPolicyException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TrustedSignerDoesNotExist")
                                .exceptionBuilderSupplier(TrustedSignerDoesNotExistException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResponseHeadersPolicyInUse")
                                .exceptionBuilderSupplier(ResponseHeadersPolicyInUseException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyHeadersInForwardedValues")
                                .exceptionBuilderSupplier(TooManyHeadersInForwardedValuesException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidOriginReadTimeout")
                                .exceptionBuilderSupplier(InvalidOriginReadTimeoutException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OriginAccessControlInUse")
                                .exceptionBuilderSupplier(OriginAccessControlInUseException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OriginRequestPolicyInUse")
                                .exceptionBuilderSupplier(OriginRequestPolicyInUseException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyDistributionsAssociatedToKeyGroup")
                                .exceptionBuilderSupplier(TooManyDistributionsAssociatedToKeyGroupException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidErrorCode")
                                .exceptionBuilderSupplier(InvalidErrorCodeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ContinuousDeploymentPolicyAlreadyExists")
                                .exceptionBuilderSupplier(ContinuousDeploymentPolicyAlreadyExistsException::builder)
                                .httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionFieldPatterns")
                                .exceptionBuilderSupplier(TooManyFieldLevelEncryptionFieldPatternsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata
                                .builder()
                                .errorCode("IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior")
                                .exceptionBuilderSupplier(
                                        IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRequiredProtocol")
                                .exceptionBuilderSupplier(InvalidRequiredProtocolException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchOriginRequestPolicy")
                                .exceptionBuilderSupplier(NoSuchOriginRequestPolicyException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EntityLimitExceeded")
                                .exceptionBuilderSupplier(EntityLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchOrigin")
                                .exceptionBuilderSupplier(NoSuchOriginException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyQueryStringsInOriginRequestPolicy")
                                .exceptionBuilderSupplier(TooManyQueryStringsInOriginRequestPolicyException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTrustedSigners")
                                .exceptionBuilderSupplier(TooManyTrustedSignersException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyFunctions")
                                .exceptionBuilderSupplier(TooManyFunctionsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyDistributionsWithFunctionAssociations")
                                .exceptionBuilderSupplier(TooManyDistributionsWithFunctionAssociationsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyStreamingDistributions")
                                .exceptionBuilderSupplier(TooManyStreamingDistributionsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyDistributionsWithSingleFunctionARN")
                                .exceptionBuilderSupplier(TooManyDistributionsWithSingleFunctionArnException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PublicKeyInUse")
                                .exceptionBuilderSupplier(PublicKeyInUseException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchContinuousDeploymentPolicy")
                                .exceptionBuilderSupplier(NoSuchContinuousDeploymentPolicyException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PreconditionFailed")
                                .exceptionBuilderSupplier(PreconditionFailedException::builder).httpStatusCode(412).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyKeyGroups")
                                .exceptionBuilderSupplier(TooManyKeyGroupsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DistributionAlreadyExists")
                                .exceptionBuilderSupplier(DistributionAlreadyExistsException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CachePolicyAlreadyExists")
                                .exceptionBuilderSupplier(CachePolicyAlreadyExistsException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ContinuousDeploymentPolicyInUse")
                                .exceptionBuilderSupplier(ContinuousDeploymentPolicyInUseException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDomainNameForOriginAccessControl")
                                .exceptionBuilderSupplier(InvalidDomainNameForOriginAccessControlException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyOriginCustomHeaders")
                                .exceptionBuilderSupplier(TooManyOriginCustomHeadersException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidLocationCode")
                                .exceptionBuilderSupplier(InvalidLocationCodeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyContinuousDeploymentPolicies")
                                .exceptionBuilderSupplier(TooManyContinuousDeploymentPoliciesException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyFunctionAssociations")
                                .exceptionBuilderSupplier(TooManyFunctionAssociationsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FieldLevelEncryptionProfileSizeExceeded")
                                .exceptionBuilderSupplier(FieldLevelEncryptionProfileSizeExceededException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyCertificates")
                                .exceptionBuilderSupplier(TooManyCertificatesException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("QueryArgProfileEmpty")
                                .exceptionBuilderSupplier(QueryArgProfileEmptyException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MonitoringSubscriptionAlreadyExists")
                                .exceptionBuilderSupplier(MonitoringSubscriptionAlreadyExistsException::builder)
                                .httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRealtimeLogConfigs")
                                .exceptionBuilderSupplier(TooManyRealtimeLogConfigsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidQueryStringParameters")
                                .exceptionBuilderSupplier(InvalidQueryStringParametersException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchFunctionExists")
                                .exceptionBuilderSupplier(NoSuchFunctionExistsException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyHeadersInCachePolicy")
                                .exceptionBuilderSupplier(TooManyHeadersInCachePolicyException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EntityAlreadyExists")
                                .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RealtimeLogConfigOwnerMismatch")
                                .exceptionBuilderSupplier(RealtimeLogConfigOwnerMismatchException::builder).httpStatusCode(401)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchFieldLevelEncryptionProfile")
                                .exceptionBuilderSupplier(NoSuchFieldLevelEncryptionProfileException::builder)
                                .httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchResource")
                                .exceptionBuilderSupplier(NoSuchResourceException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InconsistentQuantities")
                                .exceptionBuilderSupplier(InconsistentQuantitiesException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidFunctionAssociation")
                                .exceptionBuilderSupplier(InvalidFunctionAssociationException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchMonitoringSubscription")
                                .exceptionBuilderSupplier(NoSuchMonitoringSubscriptionException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionAssociation")
                                .exceptionBuilderSupplier(InvalidLambdaFunctionAssociationException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyLambdaFunctionAssociations")
                                .exceptionBuilderSupplier(TooManyLambdaFunctionAssociationsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DistributionNotDisabled")
                                .exceptionBuilderSupplier(DistributionNotDisabledException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResponseHeadersPolicyAlreadyExists")
                                .exceptionBuilderSupplier(ResponseHeadersPolicyAlreadyExistsException::builder)
                                .httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyOriginGroupsPerDistribution")
                                .exceptionBuilderSupplier(TooManyOriginGroupsPerDistributionException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CannotDeleteEntityWhileInUse")
                                .exceptionBuilderSupplier(CannotDeleteEntityWhileInUseException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDenied")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyDistributionsAssociatedToOriginAccessControl")
                                .exceptionBuilderSupplier(TooManyDistributionsAssociatedToOriginAccessControlException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IllegalOriginAccessConfiguration")
                                .exceptionBuilderSupplier(IllegalOriginAccessConfigurationException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyCookiesInCachePolicy")
                                .exceptionBuilderSupplier(TooManyCookiesInCachePolicyException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyOriginAccessControls")
                                .exceptionBuilderSupplier(TooManyOriginAccessControlsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidArgument")
                                .exceptionBuilderSupplier(InvalidArgumentException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyOriginRequestPolicies")
                                .exceptionBuilderSupplier(TooManyOriginRequestPoliciesException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchCachePolicy")
                                .exceptionBuilderSupplier(NoSuchCachePolicyException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KeyGroupAlreadyExists")
                                .exceptionBuilderSupplier(KeyGroupAlreadyExistsException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchStreamingDistribution")
                                .exceptionBuilderSupplier(NoSuchStreamingDistributionException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchPublicKey")
                                .exceptionBuilderSupplier(NoSuchPublicKeyException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidWebACLId")
                                .exceptionBuilderSupplier(InvalidWebAclIdException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata
                                .builder()
                                .errorCode("TooManyDistributionsAssociatedToFieldLevelEncryptionConfig")
                                .exceptionBuilderSupplier(
                                        TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyDistributionsAssociatedToCachePolicy")
                                .exceptionBuilderSupplier(TooManyDistributionsAssociatedToCachePolicyException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PublicKeyAlreadyExists")
                                .exceptionBuilderSupplier(PublicKeyAlreadyExistsException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FieldLevelEncryptionProfileInUse")
                                .exceptionBuilderSupplier(FieldLevelEncryptionProfileInUseException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidIfMatchVersion")
                                .exceptionBuilderSupplier(InvalidIfMatchVersionException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTagging")
                                .exceptionBuilderSupplier(InvalidTaggingException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyHeadersInOriginRequestPolicy")
                                .exceptionBuilderSupplier(TooManyHeadersInOriginRequestPolicyException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchCloudFrontOriginAccessIdentity")
                                .exceptionBuilderSupplier(NoSuchCloudFrontOriginAccessIdentityException::builder)
                                .httpStatusCode(404).build()).clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(CloudFrontException::builder).build();
    }

    @Override
    public final CloudFrontServiceClientConfiguration serviceClientConfiguration() {
        return new CloudFrontServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
