/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A distribution configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DistributionConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<DistributionConfig.Builder, DistributionConfig> {
    private static final SdkField<String> CALLER_REFERENCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CallerReference")
            .getter(getter(DistributionConfig::callerReference))
            .setter(setter(Builder::callerReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallerReference")
                    .unmarshallLocationName("CallerReference").build()).build();

    private static final SdkField<Aliases> ALIASES_FIELD = SdkField
            .<Aliases> builder(MarshallingType.SDK_POJO)
            .memberName("Aliases")
            .getter(getter(DistributionConfig::aliases))
            .setter(setter(Builder::aliases))
            .constructor(Aliases::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aliases")
                    .unmarshallLocationName("Aliases").build()).build();

    private static final SdkField<String> DEFAULT_ROOT_OBJECT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DefaultRootObject")
            .getter(getter(DistributionConfig::defaultRootObject))
            .setter(setter(Builder::defaultRootObject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRootObject")
                    .unmarshallLocationName("DefaultRootObject").build()).build();

    private static final SdkField<Origins> ORIGINS_FIELD = SdkField
            .<Origins> builder(MarshallingType.SDK_POJO)
            .memberName("Origins")
            .getter(getter(DistributionConfig::origins))
            .setter(setter(Builder::origins))
            .constructor(Origins::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origins")
                    .unmarshallLocationName("Origins").build()).build();

    private static final SdkField<OriginGroups> ORIGIN_GROUPS_FIELD = SdkField
            .<OriginGroups> builder(MarshallingType.SDK_POJO)
            .memberName("OriginGroups")
            .getter(getter(DistributionConfig::originGroups))
            .setter(setter(Builder::originGroups))
            .constructor(OriginGroups::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginGroups")
                    .unmarshallLocationName("OriginGroups").build()).build();

    private static final SdkField<DefaultCacheBehavior> DEFAULT_CACHE_BEHAVIOR_FIELD = SdkField
            .<DefaultCacheBehavior> builder(MarshallingType.SDK_POJO)
            .memberName("DefaultCacheBehavior")
            .getter(getter(DistributionConfig::defaultCacheBehavior))
            .setter(setter(Builder::defaultCacheBehavior))
            .constructor(DefaultCacheBehavior::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCacheBehavior")
                    .unmarshallLocationName("DefaultCacheBehavior").build()).build();

    private static final SdkField<CacheBehaviors> CACHE_BEHAVIORS_FIELD = SdkField
            .<CacheBehaviors> builder(MarshallingType.SDK_POJO)
            .memberName("CacheBehaviors")
            .getter(getter(DistributionConfig::cacheBehaviors))
            .setter(setter(Builder::cacheBehaviors))
            .constructor(CacheBehaviors::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheBehaviors")
                    .unmarshallLocationName("CacheBehaviors").build()).build();

    private static final SdkField<CustomErrorResponses> CUSTOM_ERROR_RESPONSES_FIELD = SdkField
            .<CustomErrorResponses> builder(MarshallingType.SDK_POJO)
            .memberName("CustomErrorResponses")
            .getter(getter(DistributionConfig::customErrorResponses))
            .setter(setter(Builder::customErrorResponses))
            .constructor(CustomErrorResponses::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomErrorResponses")
                    .unmarshallLocationName("CustomErrorResponses").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Comment")
            .getter(getter(DistributionConfig::comment))
            .setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment")
                    .unmarshallLocationName("Comment").build()).build();

    private static final SdkField<LoggingConfig> LOGGING_FIELD = SdkField
            .<LoggingConfig> builder(MarshallingType.SDK_POJO)
            .memberName("Logging")
            .getter(getter(DistributionConfig::logging))
            .setter(setter(Builder::logging))
            .constructor(LoggingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Logging")
                    .unmarshallLocationName("Logging").build()).build();

    private static final SdkField<String> PRICE_CLASS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PriceClass")
            .getter(getter(DistributionConfig::priceClassAsString))
            .setter(setter(Builder::priceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PriceClass")
                    .unmarshallLocationName("PriceClass").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled")
            .getter(getter(DistributionConfig::enabled))
            .setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled")
                    .unmarshallLocationName("Enabled").build()).build();

    private static final SdkField<ViewerCertificate> VIEWER_CERTIFICATE_FIELD = SdkField
            .<ViewerCertificate> builder(MarshallingType.SDK_POJO)
            .memberName("ViewerCertificate")
            .getter(getter(DistributionConfig::viewerCertificate))
            .setter(setter(Builder::viewerCertificate))
            .constructor(ViewerCertificate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewerCertificate")
                    .unmarshallLocationName("ViewerCertificate").build()).build();

    private static final SdkField<Restrictions> RESTRICTIONS_FIELD = SdkField
            .<Restrictions> builder(MarshallingType.SDK_POJO)
            .memberName("Restrictions")
            .getter(getter(DistributionConfig::restrictions))
            .setter(setter(Builder::restrictions))
            .constructor(Restrictions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Restrictions")
                    .unmarshallLocationName("Restrictions").build()).build();

    private static final SdkField<String> WEB_ACL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("WebACLId")
            .getter(getter(DistributionConfig::webACLId))
            .setter(setter(Builder::webACLId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebACLId")
                    .unmarshallLocationName("WebACLId").build()).build();

    private static final SdkField<String> HTTP_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("HttpVersion")
            .getter(getter(DistributionConfig::httpVersionAsString))
            .setter(setter(Builder::httpVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpVersion")
                    .unmarshallLocationName("HttpVersion").build()).build();

    private static final SdkField<Boolean> IS_IPV6_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsIPV6Enabled")
            .getter(getter(DistributionConfig::isIPV6Enabled))
            .setter(setter(Builder::isIPV6Enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsIPV6Enabled")
                    .unmarshallLocationName("IsIPV6Enabled").build()).build();

    private static final SdkField<String> CONTINUOUS_DEPLOYMENT_POLICY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ContinuousDeploymentPolicyId")
            .getter(getter(DistributionConfig::continuousDeploymentPolicyId))
            .setter(setter(Builder::continuousDeploymentPolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContinuousDeploymentPolicyId")
                    .unmarshallLocationName("ContinuousDeploymentPolicyId").build()).build();

    private static final SdkField<Boolean> STAGING_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Staging")
            .getter(getter(DistributionConfig::staging))
            .setter(setter(Builder::staging))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Staging")
                    .unmarshallLocationName("Staging").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALLER_REFERENCE_FIELD,
            ALIASES_FIELD, DEFAULT_ROOT_OBJECT_FIELD, ORIGINS_FIELD, ORIGIN_GROUPS_FIELD, DEFAULT_CACHE_BEHAVIOR_FIELD,
            CACHE_BEHAVIORS_FIELD, CUSTOM_ERROR_RESPONSES_FIELD, COMMENT_FIELD, LOGGING_FIELD, PRICE_CLASS_FIELD, ENABLED_FIELD,
            VIEWER_CERTIFICATE_FIELD, RESTRICTIONS_FIELD, WEB_ACL_ID_FIELD, HTTP_VERSION_FIELD, IS_IPV6_ENABLED_FIELD,
            CONTINUOUS_DEPLOYMENT_POLICY_ID_FIELD, STAGING_FIELD));

    private static final long serialVersionUID = 1L;

    private final String callerReference;

    private final Aliases aliases;

    private final String defaultRootObject;

    private final Origins origins;

    private final OriginGroups originGroups;

    private final DefaultCacheBehavior defaultCacheBehavior;

    private final CacheBehaviors cacheBehaviors;

    private final CustomErrorResponses customErrorResponses;

    private final String comment;

    private final LoggingConfig logging;

    private final String priceClass;

    private final Boolean enabled;

    private final ViewerCertificate viewerCertificate;

    private final Restrictions restrictions;

    private final String webACLId;

    private final String httpVersion;

    private final Boolean isIPV6Enabled;

    private final String continuousDeploymentPolicyId;

    private final Boolean staging;

    private DistributionConfig(BuilderImpl builder) {
        this.callerReference = builder.callerReference;
        this.aliases = builder.aliases;
        this.defaultRootObject = builder.defaultRootObject;
        this.origins = builder.origins;
        this.originGroups = builder.originGroups;
        this.defaultCacheBehavior = builder.defaultCacheBehavior;
        this.cacheBehaviors = builder.cacheBehaviors;
        this.customErrorResponses = builder.customErrorResponses;
        this.comment = builder.comment;
        this.logging = builder.logging;
        this.priceClass = builder.priceClass;
        this.enabled = builder.enabled;
        this.viewerCertificate = builder.viewerCertificate;
        this.restrictions = builder.restrictions;
        this.webACLId = builder.webACLId;
        this.httpVersion = builder.httpVersion;
        this.isIPV6Enabled = builder.isIPV6Enabled;
        this.continuousDeploymentPolicyId = builder.continuousDeploymentPolicyId;
        this.staging = builder.staging;
    }

    /**
     * <p>
     * A unique value (for example, a date-time stamp) that ensures that the request can't be replayed.
     * </p>
     * <p>
     * If the value of <code>CallerReference</code> is new (regardless of the content of the
     * <code>DistributionConfig</code> object), CloudFront creates a new distribution.
     * </p>
     * <p>
     * If <code>CallerReference</code> is a value that you already sent in a previous request to create a distribution,
     * CloudFront returns a <code>DistributionAlreadyExists</code> error.
     * </p>
     * 
     * @return A unique value (for example, a date-time stamp) that ensures that the request can't be replayed.</p>
     *         <p>
     *         If the value of <code>CallerReference</code> is new (regardless of the content of the
     *         <code>DistributionConfig</code> object), CloudFront creates a new distribution.
     *         </p>
     *         <p>
     *         If <code>CallerReference</code> is a value that you already sent in a previous request to create a
     *         distribution, CloudFront returns a <code>DistributionAlreadyExists</code> error.
     */
    public final String callerReference() {
        return callerReference;
    }

    /**
     * <p>
     * A complex type that contains information about CNAMEs (alternate domain names), if any, for this distribution.
     * </p>
     * 
     * @return A complex type that contains information about CNAMEs (alternate domain names), if any, for this
     *         distribution.
     */
    public final Aliases aliases() {
        return aliases;
    }

    /**
     * <p>
     * The object that you want CloudFront to request from your origin (for example, <code>index.html</code>) when a
     * viewer requests the root URL for your distribution (<code>https://www.example.com</code>) instead of an object in
     * your distribution (<code>https://www.example.com/product-description.html</code>). Specifying a default root
     * object avoids exposing the contents of your distribution.
     * </p>
     * <p>
     * Specify only the object name, for example, <code>index.html</code>. Don't add a <code>/</code> before the object
     * name.
     * </p>
     * <p>
     * If you don't want to specify a default root object when you create a distribution, include an empty
     * <code>DefaultRootObject</code> element.
     * </p>
     * <p>
     * To delete the default root object from an existing distribution, update the distribution configuration and
     * include an empty <code>DefaultRootObject</code> element.
     * </p>
     * <p>
     * To replace the default root object, update the distribution configuration and specify the new object.
     * </p>
     * <p>
     * For more information about the default root object, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DefaultRootObject.html">Creating a
     * Default Root Object</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return The object that you want CloudFront to request from your origin (for example, <code>index.html</code>)
     *         when a viewer requests the root URL for your distribution (<code>https://www.example.com</code>) instead
     *         of an object in your distribution (<code>https://www.example.com/product-description.html</code>).
     *         Specifying a default root object avoids exposing the contents of your distribution.</p>
     *         <p>
     *         Specify only the object name, for example, <code>index.html</code>. Don't add a <code>/</code> before the
     *         object name.
     *         </p>
     *         <p>
     *         If you don't want to specify a default root object when you create a distribution, include an empty
     *         <code>DefaultRootObject</code> element.
     *         </p>
     *         <p>
     *         To delete the default root object from an existing distribution, update the distribution configuration
     *         and include an empty <code>DefaultRootObject</code> element.
     *         </p>
     *         <p>
     *         To replace the default root object, update the distribution configuration and specify the new object.
     *         </p>
     *         <p>
     *         For more information about the default root object, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DefaultRootObject.html">Creating
     *         a Default Root Object</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public final String defaultRootObject() {
        return defaultRootObject;
    }

    /**
     * <p>
     * A complex type that contains information about origins for this distribution.
     * </p>
     * 
     * @return A complex type that contains information about origins for this distribution.
     */
    public final Origins origins() {
        return origins;
    }

    /**
     * <p>
     * A complex type that contains information about origin groups for this distribution.
     * </p>
     * 
     * @return A complex type that contains information about origin groups for this distribution.
     */
    public final OriginGroups originGroups() {
        return originGroups;
    }

    /**
     * <p>
     * A complex type that describes the default cache behavior if you don't specify a <code>CacheBehavior</code>
     * element or if files don't match any of the values of <code>PathPattern</code> in <code>CacheBehavior</code>
     * elements. You must create exactly one default cache behavior.
     * </p>
     * 
     * @return A complex type that describes the default cache behavior if you don't specify a
     *         <code>CacheBehavior</code> element or if files don't match any of the values of <code>PathPattern</code>
     *         in <code>CacheBehavior</code> elements. You must create exactly one default cache behavior.
     */
    public final DefaultCacheBehavior defaultCacheBehavior() {
        return defaultCacheBehavior;
    }

    /**
     * <p>
     * A complex type that contains zero or more <code>CacheBehavior</code> elements.
     * </p>
     * 
     * @return A complex type that contains zero or more <code>CacheBehavior</code> elements.
     */
    public final CacheBehaviors cacheBehaviors() {
        return cacheBehaviors;
    }

    /**
     * <p>
     * A complex type that controls the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages before
     * returning the response to the viewer.
     * </p>
     * </li>
     * <li>
     * <p>
     * How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about custom error pages, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html">Customizing
     * Error Responses</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return A complex type that controls the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages before
     *         returning the response to the viewer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about custom error pages, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html"
     *         >Customizing Error Responses</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public final CustomErrorResponses customErrorResponses() {
        return customErrorResponses;
    }

    /**
     * <p>
     * A comment to describe the distribution. The comment cannot be longer than 128 characters.
     * </p>
     * 
     * @return A comment to describe the distribution. The comment cannot be longer than 128 characters.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * A complex type that controls whether access logs are written for the distribution.
     * </p>
     * <p>
     * For more information about logging, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html">Access Logs</a> in the
     * <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return A complex type that controls whether access logs are written for the distribution.</p>
     *         <p>
     *         For more information about logging, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html">Access Logs</a>
     *         in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public final LoggingConfig logging() {
        return logging;
    }

    /**
     * <p>
     * The price class that corresponds with the maximum price that you want to pay for CloudFront service. If you
     * specify <code>PriceClass_All</code>, CloudFront responds to requests for your objects from all CloudFront edge
     * locations.
     * </p>
     * <p>
     * If you specify a price class other than <code>PriceClass_All</code>, CloudFront serves your objects from the
     * CloudFront edge location that has the lowest latency among the edge locations in your price class. Viewers who
     * are in or near regions that are excluded from your specified price class may encounter slower performance.
     * </p>
     * <p>
     * For more information about price classes, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html">Choosing the Price
     * Class for a CloudFront Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>. For information about
     * CloudFront pricing, including how price classes (such as Price Class 100) map to CloudFront regions, see <a
     * href="http://aws.amazon.com/cloudfront/pricing/">Amazon CloudFront Pricing</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #priceClass} will
     * return {@link PriceClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #priceClassAsString}.
     * </p>
     * 
     * @return The price class that corresponds with the maximum price that you want to pay for CloudFront service. If
     *         you specify <code>PriceClass_All</code>, CloudFront responds to requests for your objects from all
     *         CloudFront edge locations.</p>
     *         <p>
     *         If you specify a price class other than <code>PriceClass_All</code>, CloudFront serves your objects from
     *         the CloudFront edge location that has the lowest latency among the edge locations in your price class.
     *         Viewers who are in or near regions that are excluded from your specified price class may encounter slower
     *         performance.
     *         </p>
     *         <p>
     *         For more information about price classes, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html">Choosing the
     *         Price Class for a CloudFront Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>. For
     *         information about CloudFront pricing, including how price classes (such as Price Class 100) map to
     *         CloudFront regions, see <a href="http://aws.amazon.com/cloudfront/pricing/">Amazon CloudFront
     *         Pricing</a>.
     * @see PriceClass
     */
    public final PriceClass priceClass() {
        return PriceClass.fromValue(priceClass);
    }

    /**
     * <p>
     * The price class that corresponds with the maximum price that you want to pay for CloudFront service. If you
     * specify <code>PriceClass_All</code>, CloudFront responds to requests for your objects from all CloudFront edge
     * locations.
     * </p>
     * <p>
     * If you specify a price class other than <code>PriceClass_All</code>, CloudFront serves your objects from the
     * CloudFront edge location that has the lowest latency among the edge locations in your price class. Viewers who
     * are in or near regions that are excluded from your specified price class may encounter slower performance.
     * </p>
     * <p>
     * For more information about price classes, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html">Choosing the Price
     * Class for a CloudFront Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>. For information about
     * CloudFront pricing, including how price classes (such as Price Class 100) map to CloudFront regions, see <a
     * href="http://aws.amazon.com/cloudfront/pricing/">Amazon CloudFront Pricing</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #priceClass} will
     * return {@link PriceClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #priceClassAsString}.
     * </p>
     * 
     * @return The price class that corresponds with the maximum price that you want to pay for CloudFront service. If
     *         you specify <code>PriceClass_All</code>, CloudFront responds to requests for your objects from all
     *         CloudFront edge locations.</p>
     *         <p>
     *         If you specify a price class other than <code>PriceClass_All</code>, CloudFront serves your objects from
     *         the CloudFront edge location that has the lowest latency among the edge locations in your price class.
     *         Viewers who are in or near regions that are excluded from your specified price class may encounter slower
     *         performance.
     *         </p>
     *         <p>
     *         For more information about price classes, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html">Choosing the
     *         Price Class for a CloudFront Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>. For
     *         information about CloudFront pricing, including how price classes (such as Price Class 100) map to
     *         CloudFront regions, see <a href="http://aws.amazon.com/cloudfront/pricing/">Amazon CloudFront
     *         Pricing</a>.
     * @see PriceClass
     */
    public final String priceClassAsString() {
        return priceClass;
    }

    /**
     * <p>
     * From this field, you can enable or disable the selected distribution.
     * </p>
     * 
     * @return From this field, you can enable or disable the selected distribution.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * A complex type that determines the distribution's SSL/TLS configuration for communicating with viewers.
     * </p>
     * 
     * @return A complex type that determines the distribution's SSL/TLS configuration for communicating with viewers.
     */
    public final ViewerCertificate viewerCertificate() {
        return viewerCertificate;
    }

    /**
     * <p>
     * A complex type that identifies ways in which you want to restrict distribution of your content.
     * </p>
     * 
     * @return A complex type that identifies ways in which you want to restrict distribution of your content.
     */
    public final Restrictions restrictions() {
        return restrictions;
    }

    /**
     * <p>
     * A unique identifier that specifies the WAF web ACL, if any, to associate with this distribution. To specify a web
     * ACL created using the latest version of WAF, use the ACL ARN, for example
     * <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code>
     * . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     * <code>a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code>.
     * </p>
     * <p>
     * WAF is a web application firewall that lets you monitor the HTTP and HTTPS requests that are forwarded to
     * CloudFront, and lets you control access to your content. Based on conditions that you specify, such as the IP
     * addresses that requests originate from or the values of query strings, CloudFront responds to requests either
     * with the requested content or with an HTTP 403 status code (Forbidden). You can also configure CloudFront to
     * return a custom error page when a request is blocked. For more information about WAF, see the <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html">WAF Developer Guide</a>.
     * </p>
     * 
     * @return A unique identifier that specifies the WAF web ACL, if any, to associate with this distribution. To
     *         specify a web ACL created using the latest version of WAF, use the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code>
     *         . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     *         <code>a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code>.</p>
     *         <p>
     *         WAF is a web application firewall that lets you monitor the HTTP and HTTPS requests that are forwarded to
     *         CloudFront, and lets you control access to your content. Based on conditions that you specify, such as
     *         the IP addresses that requests originate from or the values of query strings, CloudFront responds to
     *         requests either with the requested content or with an HTTP 403 status code (Forbidden). You can also
     *         configure CloudFront to return a custom error page when a request is blocked. For more information about
     *         WAF, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html">WAF
     *         Developer Guide</a>.
     */
    public final String webACLId() {
        return webACLId;
    }

    /**
     * <p>
     * (Optional) Specify the HTTP version(s) that you want viewers to use to communicate with CloudFront. The default
     * value for new web distributions is <code>http2</code>. Viewers that don't support HTTP/2 automatically use an
     * earlier HTTP version.
     * </p>
     * <p>
     * For viewers and CloudFront to use HTTP/2, viewers must support TLSv1.2 or later, and must support Server Name
     * Indication (SNI).
     * </p>
     * <p>
     * For viewers and CloudFront to use HTTP/3, viewers must support TLSv1.3 and Server Name Indication (SNI).
     * CloudFront supports HTTP/3 connection migration to allow the viewer to switch networks without losing connection.
     * For more information about connection migration, see <a
     * href="https://www.rfc-editor.org/rfc/rfc9000.html#name-connection-migration">Connection Migration</a> at RFC
     * 9000. For more information about supported TLSv1.3 ciphers, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html"
     * >Supported protocols and ciphers between viewers and CloudFront</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpVersion} will
     * return {@link HttpVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #httpVersionAsString}.
     * </p>
     * 
     * @return (Optional) Specify the HTTP version(s) that you want viewers to use to communicate with CloudFront. The
     *         default value for new web distributions is <code>http2</code>. Viewers that don't support HTTP/2
     *         automatically use an earlier HTTP version.</p>
     *         <p>
     *         For viewers and CloudFront to use HTTP/2, viewers must support TLSv1.2 or later, and must support Server
     *         Name Indication (SNI).
     *         </p>
     *         <p>
     *         For viewers and CloudFront to use HTTP/3, viewers must support TLSv1.3 and Server Name Indication (SNI).
     *         CloudFront supports HTTP/3 connection migration to allow the viewer to switch networks without losing
     *         connection. For more information about connection migration, see <a
     *         href="https://www.rfc-editor.org/rfc/rfc9000.html#name-connection-migration">Connection Migration</a> at
     *         RFC 9000. For more information about supported TLSv1.3 ciphers, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html"
     *         >Supported protocols and ciphers between viewers and CloudFront</a>.
     * @see HttpVersion
     */
    public final HttpVersion httpVersion() {
        return HttpVersion.fromValue(httpVersion);
    }

    /**
     * <p>
     * (Optional) Specify the HTTP version(s) that you want viewers to use to communicate with CloudFront. The default
     * value for new web distributions is <code>http2</code>. Viewers that don't support HTTP/2 automatically use an
     * earlier HTTP version.
     * </p>
     * <p>
     * For viewers and CloudFront to use HTTP/2, viewers must support TLSv1.2 or later, and must support Server Name
     * Indication (SNI).
     * </p>
     * <p>
     * For viewers and CloudFront to use HTTP/3, viewers must support TLSv1.3 and Server Name Indication (SNI).
     * CloudFront supports HTTP/3 connection migration to allow the viewer to switch networks without losing connection.
     * For more information about connection migration, see <a
     * href="https://www.rfc-editor.org/rfc/rfc9000.html#name-connection-migration">Connection Migration</a> at RFC
     * 9000. For more information about supported TLSv1.3 ciphers, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html"
     * >Supported protocols and ciphers between viewers and CloudFront</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #httpVersion} will
     * return {@link HttpVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #httpVersionAsString}.
     * </p>
     * 
     * @return (Optional) Specify the HTTP version(s) that you want viewers to use to communicate with CloudFront. The
     *         default value for new web distributions is <code>http2</code>. Viewers that don't support HTTP/2
     *         automatically use an earlier HTTP version.</p>
     *         <p>
     *         For viewers and CloudFront to use HTTP/2, viewers must support TLSv1.2 or later, and must support Server
     *         Name Indication (SNI).
     *         </p>
     *         <p>
     *         For viewers and CloudFront to use HTTP/3, viewers must support TLSv1.3 and Server Name Indication (SNI).
     *         CloudFront supports HTTP/3 connection migration to allow the viewer to switch networks without losing
     *         connection. For more information about connection migration, see <a
     *         href="https://www.rfc-editor.org/rfc/rfc9000.html#name-connection-migration">Connection Migration</a> at
     *         RFC 9000. For more information about supported TLSv1.3 ciphers, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html"
     *         >Supported protocols and ciphers between viewers and CloudFront</a>.
     * @see HttpVersion
     */
    public final String httpVersionAsString() {
        return httpVersion;
    }

    /**
     * <p>
     * If you want CloudFront to respond to IPv6 DNS requests with an IPv6 address for your distribution, specify
     * <code>true</code>. If you specify <code>false</code>, CloudFront responds to IPv6 DNS requests with the DNS
     * response code <code>NOERROR</code> and with no IP addresses. This allows viewers to submit a second request, for
     * an IPv4 address for your distribution.
     * </p>
     * <p>
     * In general, you should enable IPv6 if you have users on IPv6 networks who want to access your content. However,
     * if you're using signed URLs or signed cookies to restrict access to your content, and if you're using a custom
     * policy that includes the <code>IpAddress</code> parameter to restrict the IP addresses that can access your
     * content, don't enable IPv6. If you want to restrict access to some content by IP address and not restrict access
     * to other content (or restrict access but not by IP address), you can create two distributions. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-creating-signed-url-custom-policy.html"
     * >Creating a Signed URL Using a Custom Policy</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * If you're using an Route 53 Amazon Web Services Integration alias resource record set to route traffic to your
     * CloudFront distribution, you need to create a second alias resource record set when both of the following are
     * true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You enable IPv6 for the distribution
     * </p>
     * </li>
     * <li>
     * <p>
     * You're using alternate domain names in the URLs for your objects
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-to-cloudfront-distribution.html">Routing
     * Traffic to an Amazon CloudFront Web Distribution by Using Your Domain Name</a> in the <i>Route 53 Amazon Web
     * Services Integration Developer Guide</i>.
     * </p>
     * <p>
     * If you created a CNAME resource record set, either with Route 53 Amazon Web Services Integration or with another
     * DNS service, you don't need to make any changes. A CNAME record will route traffic to your distribution
     * regardless of the IP address format of the viewer request.
     * </p>
     * 
     * @return If you want CloudFront to respond to IPv6 DNS requests with an IPv6 address for your distribution,
     *         specify <code>true</code>. If you specify <code>false</code>, CloudFront responds to IPv6 DNS requests
     *         with the DNS response code <code>NOERROR</code> and with no IP addresses. This allows viewers to submit a
     *         second request, for an IPv4 address for your distribution.</p>
     *         <p>
     *         In general, you should enable IPv6 if you have users on IPv6 networks who want to access your content.
     *         However, if you're using signed URLs or signed cookies to restrict access to your content, and if you're
     *         using a custom policy that includes the <code>IpAddress</code> parameter to restrict the IP addresses
     *         that can access your content, don't enable IPv6. If you want to restrict access to some content by IP
     *         address and not restrict access to other content (or restrict access but not by IP address), you can
     *         create two distributions. For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-creating-signed-url-custom-policy.html"
     *         >Creating a Signed URL Using a Custom Policy</a> in the <i>Amazon CloudFront Developer Guide</i>.
     *         </p>
     *         <p>
     *         If you're using an Route 53 Amazon Web Services Integration alias resource record set to route traffic to
     *         your CloudFront distribution, you need to create a second alias resource record set when both of the
     *         following are true:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You enable IPv6 for the distribution
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You're using alternate domain names in the URLs for your objects
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-to-cloudfront-distribution.html"
     *         >Routing Traffic to an Amazon CloudFront Web Distribution by Using Your Domain Name</a> in the
     *         <i>Route 53 Amazon Web Services Integration Developer Guide</i>.
     *         </p>
     *         <p>
     *         If you created a CNAME resource record set, either with Route 53 Amazon Web Services Integration or with
     *         another DNS service, you don't need to make any changes. A CNAME record will route traffic to your
     *         distribution regardless of the IP address format of the viewer request.
     */
    public final Boolean isIPV6Enabled() {
        return isIPV6Enabled;
    }

    /**
     * <p>
     * The identifier of a continuous deployment policy. For more information, see
     * <code>CreateContinuousDeploymentPolicy</code>.
     * </p>
     * 
     * @return The identifier of a continuous deployment policy. For more information, see
     *         <code>CreateContinuousDeploymentPolicy</code>.
     */
    public final String continuousDeploymentPolicyId() {
        return continuousDeploymentPolicyId;
    }

    /**
     * <p>
     * A Boolean that indicates whether this is a staging distribution. When this value is <code>true</code>, this is a
     * staging distribution. When this value is <code>false</code>, this is not a staging distribution.
     * </p>
     * 
     * @return A Boolean that indicates whether this is a staging distribution. When this value is <code>true</code>,
     *         this is a staging distribution. When this value is <code>false</code>, this is not a staging
     *         distribution.
     */
    public final Boolean staging() {
        return staging;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(aliases());
        hashCode = 31 * hashCode + Objects.hashCode(defaultRootObject());
        hashCode = 31 * hashCode + Objects.hashCode(origins());
        hashCode = 31 * hashCode + Objects.hashCode(originGroups());
        hashCode = 31 * hashCode + Objects.hashCode(defaultCacheBehavior());
        hashCode = 31 * hashCode + Objects.hashCode(cacheBehaviors());
        hashCode = 31 * hashCode + Objects.hashCode(customErrorResponses());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(logging());
        hashCode = 31 * hashCode + Objects.hashCode(priceClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(viewerCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(restrictions());
        hashCode = 31 * hashCode + Objects.hashCode(webACLId());
        hashCode = 31 * hashCode + Objects.hashCode(httpVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(isIPV6Enabled());
        hashCode = 31 * hashCode + Objects.hashCode(continuousDeploymentPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(staging());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DistributionConfig)) {
            return false;
        }
        DistributionConfig other = (DistributionConfig) obj;
        return Objects.equals(callerReference(), other.callerReference()) && Objects.equals(aliases(), other.aliases())
                && Objects.equals(defaultRootObject(), other.defaultRootObject()) && Objects.equals(origins(), other.origins())
                && Objects.equals(originGroups(), other.originGroups())
                && Objects.equals(defaultCacheBehavior(), other.defaultCacheBehavior())
                && Objects.equals(cacheBehaviors(), other.cacheBehaviors())
                && Objects.equals(customErrorResponses(), other.customErrorResponses())
                && Objects.equals(comment(), other.comment()) && Objects.equals(logging(), other.logging())
                && Objects.equals(priceClassAsString(), other.priceClassAsString()) && Objects.equals(enabled(), other.enabled())
                && Objects.equals(viewerCertificate(), other.viewerCertificate())
                && Objects.equals(restrictions(), other.restrictions()) && Objects.equals(webACLId(), other.webACLId())
                && Objects.equals(httpVersionAsString(), other.httpVersionAsString())
                && Objects.equals(isIPV6Enabled(), other.isIPV6Enabled())
                && Objects.equals(continuousDeploymentPolicyId(), other.continuousDeploymentPolicyId())
                && Objects.equals(staging(), other.staging());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DistributionConfig").add("CallerReference", callerReference()).add("Aliases", aliases())
                .add("DefaultRootObject", defaultRootObject()).add("Origins", origins()).add("OriginGroups", originGroups())
                .add("DefaultCacheBehavior", defaultCacheBehavior()).add("CacheBehaviors", cacheBehaviors())
                .add("CustomErrorResponses", customErrorResponses())
                .add("Comment", comment() == null ? null : "*** Sensitive Data Redacted ***").add("Logging", logging())
                .add("PriceClass", priceClassAsString()).add("Enabled", enabled()).add("ViewerCertificate", viewerCertificate())
                .add("Restrictions", restrictions()).add("WebACLId", webACLId()).add("HttpVersion", httpVersionAsString())
                .add("IsIPV6Enabled", isIPV6Enabled()).add("ContinuousDeploymentPolicyId", continuousDeploymentPolicyId())
                .add("Staging", staging()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CallerReference":
            return Optional.ofNullable(clazz.cast(callerReference()));
        case "Aliases":
            return Optional.ofNullable(clazz.cast(aliases()));
        case "DefaultRootObject":
            return Optional.ofNullable(clazz.cast(defaultRootObject()));
        case "Origins":
            return Optional.ofNullable(clazz.cast(origins()));
        case "OriginGroups":
            return Optional.ofNullable(clazz.cast(originGroups()));
        case "DefaultCacheBehavior":
            return Optional.ofNullable(clazz.cast(defaultCacheBehavior()));
        case "CacheBehaviors":
            return Optional.ofNullable(clazz.cast(cacheBehaviors()));
        case "CustomErrorResponses":
            return Optional.ofNullable(clazz.cast(customErrorResponses()));
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "Logging":
            return Optional.ofNullable(clazz.cast(logging()));
        case "PriceClass":
            return Optional.ofNullable(clazz.cast(priceClassAsString()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "ViewerCertificate":
            return Optional.ofNullable(clazz.cast(viewerCertificate()));
        case "Restrictions":
            return Optional.ofNullable(clazz.cast(restrictions()));
        case "WebACLId":
            return Optional.ofNullable(clazz.cast(webACLId()));
        case "HttpVersion":
            return Optional.ofNullable(clazz.cast(httpVersionAsString()));
        case "IsIPV6Enabled":
            return Optional.ofNullable(clazz.cast(isIPV6Enabled()));
        case "ContinuousDeploymentPolicyId":
            return Optional.ofNullable(clazz.cast(continuousDeploymentPolicyId()));
        case "Staging":
            return Optional.ofNullable(clazz.cast(staging()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DistributionConfig, T> g) {
        return obj -> g.apply((DistributionConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DistributionConfig> {
        /**
         * <p>
         * A unique value (for example, a date-time stamp) that ensures that the request can't be replayed.
         * </p>
         * <p>
         * If the value of <code>CallerReference</code> is new (regardless of the content of the
         * <code>DistributionConfig</code> object), CloudFront creates a new distribution.
         * </p>
         * <p>
         * If <code>CallerReference</code> is a value that you already sent in a previous request to create a
         * distribution, CloudFront returns a <code>DistributionAlreadyExists</code> error.
         * </p>
         * 
         * @param callerReference
         *        A unique value (for example, a date-time stamp) that ensures that the request can't be replayed.</p>
         *        <p>
         *        If the value of <code>CallerReference</code> is new (regardless of the content of the
         *        <code>DistributionConfig</code> object), CloudFront creates a new distribution.
         *        </p>
         *        <p>
         *        If <code>CallerReference</code> is a value that you already sent in a previous request to create a
         *        distribution, CloudFront returns a <code>DistributionAlreadyExists</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerReference(String callerReference);

        /**
         * <p>
         * A complex type that contains information about CNAMEs (alternate domain names), if any, for this
         * distribution.
         * </p>
         * 
         * @param aliases
         *        A complex type that contains information about CNAMEs (alternate domain names), if any, for this
         *        distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliases(Aliases aliases);

        /**
         * <p>
         * A complex type that contains information about CNAMEs (alternate domain names), if any, for this
         * distribution.
         * </p>
         * This is a convenience method that creates an instance of the {@link Aliases.Builder} avoiding the need to
         * create one manually via {@link Aliases#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Aliases.Builder#build()} is called immediately and its result is
         * passed to {@link #aliases(Aliases)}.
         * 
         * @param aliases
         *        a consumer that will call methods on {@link Aliases.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aliases(Aliases)
         */
        default Builder aliases(Consumer<Aliases.Builder> aliases) {
            return aliases(Aliases.builder().applyMutation(aliases).build());
        }

        /**
         * <p>
         * The object that you want CloudFront to request from your origin (for example, <code>index.html</code>) when a
         * viewer requests the root URL for your distribution (<code>https://www.example.com</code>) instead of an
         * object in your distribution (<code>https://www.example.com/product-description.html</code>). Specifying a
         * default root object avoids exposing the contents of your distribution.
         * </p>
         * <p>
         * Specify only the object name, for example, <code>index.html</code>. Don't add a <code>/</code> before the
         * object name.
         * </p>
         * <p>
         * If you don't want to specify a default root object when you create a distribution, include an empty
         * <code>DefaultRootObject</code> element.
         * </p>
         * <p>
         * To delete the default root object from an existing distribution, update the distribution configuration and
         * include an empty <code>DefaultRootObject</code> element.
         * </p>
         * <p>
         * To replace the default root object, update the distribution configuration and specify the new object.
         * </p>
         * <p>
         * For more information about the default root object, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DefaultRootObject.html">Creating a
         * Default Root Object</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param defaultRootObject
         *        The object that you want CloudFront to request from your origin (for example, <code>index.html</code>)
         *        when a viewer requests the root URL for your distribution (<code>https://www.example.com</code>)
         *        instead of an object in your distribution (
         *        <code>https://www.example.com/product-description.html</code>). Specifying a default root object
         *        avoids exposing the contents of your distribution.</p>
         *        <p>
         *        Specify only the object name, for example, <code>index.html</code>. Don't add a <code>/</code> before
         *        the object name.
         *        </p>
         *        <p>
         *        If you don't want to specify a default root object when you create a distribution, include an empty
         *        <code>DefaultRootObject</code> element.
         *        </p>
         *        <p>
         *        To delete the default root object from an existing distribution, update the distribution configuration
         *        and include an empty <code>DefaultRootObject</code> element.
         *        </p>
         *        <p>
         *        To replace the default root object, update the distribution configuration and specify the new object.
         *        </p>
         *        <p>
         *        For more information about the default root object, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/DefaultRootObject.html"
         *        >Creating a Default Root Object</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultRootObject(String defaultRootObject);

        /**
         * <p>
         * A complex type that contains information about origins for this distribution.
         * </p>
         * 
         * @param origins
         *        A complex type that contains information about origins for this distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder origins(Origins origins);

        /**
         * <p>
         * A complex type that contains information about origins for this distribution.
         * </p>
         * This is a convenience method that creates an instance of the {@link Origins.Builder} avoiding the need to
         * create one manually via {@link Origins#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Origins.Builder#build()} is called immediately and its result is
         * passed to {@link #origins(Origins)}.
         * 
         * @param origins
         *        a consumer that will call methods on {@link Origins.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #origins(Origins)
         */
        default Builder origins(Consumer<Origins.Builder> origins) {
            return origins(Origins.builder().applyMutation(origins).build());
        }

        /**
         * <p>
         * A complex type that contains information about origin groups for this distribution.
         * </p>
         * 
         * @param originGroups
         *        A complex type that contains information about origin groups for this distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originGroups(OriginGroups originGroups);

        /**
         * <p>
         * A complex type that contains information about origin groups for this distribution.
         * </p>
         * This is a convenience method that creates an instance of the {@link OriginGroups.Builder} avoiding the need
         * to create one manually via {@link OriginGroups#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OriginGroups.Builder#build()} is called immediately and its
         * result is passed to {@link #originGroups(OriginGroups)}.
         * 
         * @param originGroups
         *        a consumer that will call methods on {@link OriginGroups.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #originGroups(OriginGroups)
         */
        default Builder originGroups(Consumer<OriginGroups.Builder> originGroups) {
            return originGroups(OriginGroups.builder().applyMutation(originGroups).build());
        }

        /**
         * <p>
         * A complex type that describes the default cache behavior if you don't specify a <code>CacheBehavior</code>
         * element or if files don't match any of the values of <code>PathPattern</code> in <code>CacheBehavior</code>
         * elements. You must create exactly one default cache behavior.
         * </p>
         * 
         * @param defaultCacheBehavior
         *        A complex type that describes the default cache behavior if you don't specify a
         *        <code>CacheBehavior</code> element or if files don't match any of the values of
         *        <code>PathPattern</code> in <code>CacheBehavior</code> elements. You must create exactly one default
         *        cache behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultCacheBehavior(DefaultCacheBehavior defaultCacheBehavior);

        /**
         * <p>
         * A complex type that describes the default cache behavior if you don't specify a <code>CacheBehavior</code>
         * element or if files don't match any of the values of <code>PathPattern</code> in <code>CacheBehavior</code>
         * elements. You must create exactly one default cache behavior.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefaultCacheBehavior.Builder} avoiding
         * the need to create one manually via {@link DefaultCacheBehavior#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefaultCacheBehavior.Builder#build()} is called immediately and
         * its result is passed to {@link #defaultCacheBehavior(DefaultCacheBehavior)}.
         * 
         * @param defaultCacheBehavior
         *        a consumer that will call methods on {@link DefaultCacheBehavior.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultCacheBehavior(DefaultCacheBehavior)
         */
        default Builder defaultCacheBehavior(Consumer<DefaultCacheBehavior.Builder> defaultCacheBehavior) {
            return defaultCacheBehavior(DefaultCacheBehavior.builder().applyMutation(defaultCacheBehavior).build());
        }

        /**
         * <p>
         * A complex type that contains zero or more <code>CacheBehavior</code> elements.
         * </p>
         * 
         * @param cacheBehaviors
         *        A complex type that contains zero or more <code>CacheBehavior</code> elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheBehaviors(CacheBehaviors cacheBehaviors);

        /**
         * <p>
         * A complex type that contains zero or more <code>CacheBehavior</code> elements.
         * </p>
         * This is a convenience method that creates an instance of the {@link CacheBehaviors.Builder} avoiding the need
         * to create one manually via {@link CacheBehaviors#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CacheBehaviors.Builder#build()} is called immediately and its
         * result is passed to {@link #cacheBehaviors(CacheBehaviors)}.
         * 
         * @param cacheBehaviors
         *        a consumer that will call methods on {@link CacheBehaviors.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheBehaviors(CacheBehaviors)
         */
        default Builder cacheBehaviors(Consumer<CacheBehaviors.Builder> cacheBehaviors) {
            return cacheBehaviors(CacheBehaviors.builder().applyMutation(cacheBehaviors).build());
        }

        /**
         * <p>
         * A complex type that controls the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages before
         * returning the response to the viewer.
         * </p>
         * </li>
         * <li>
         * <p>
         * How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about custom error pages, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html">Customizing
         * Error Responses</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param customErrorResponses
         *        A complex type that controls the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages
         *        before returning the response to the viewer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about custom error pages, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html"
         *        >Customizing Error Responses</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customErrorResponses(CustomErrorResponses customErrorResponses);

        /**
         * <p>
         * A complex type that controls the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Whether CloudFront replaces HTTP status codes in the 4xx and 5xx range with custom error messages before
         * returning the response to the viewer.
         * </p>
         * </li>
         * <li>
         * <p>
         * How long CloudFront caches HTTP status codes in the 4xx and 5xx range.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about custom error pages, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/custom-error-pages.html">Customizing
         * Error Responses</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomErrorResponses.Builder} avoiding
         * the need to create one manually via {@link CustomErrorResponses#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomErrorResponses.Builder#build()} is called immediately and
         * its result is passed to {@link #customErrorResponses(CustomErrorResponses)}.
         * 
         * @param customErrorResponses
         *        a consumer that will call methods on {@link CustomErrorResponses.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customErrorResponses(CustomErrorResponses)
         */
        default Builder customErrorResponses(Consumer<CustomErrorResponses.Builder> customErrorResponses) {
            return customErrorResponses(CustomErrorResponses.builder().applyMutation(customErrorResponses).build());
        }

        /**
         * <p>
         * A comment to describe the distribution. The comment cannot be longer than 128 characters.
         * </p>
         * 
         * @param comment
         *        A comment to describe the distribution. The comment cannot be longer than 128 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * A complex type that controls whether access logs are written for the distribution.
         * </p>
         * <p>
         * For more information about logging, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html">Access Logs</a> in
         * the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param logging
         *        A complex type that controls whether access logs are written for the distribution.</p>
         *        <p>
         *        For more information about logging, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html">Access
         *        Logs</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logging(LoggingConfig logging);

        /**
         * <p>
         * A complex type that controls whether access logs are written for the distribution.
         * </p>
         * <p>
         * For more information about logging, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html">Access Logs</a> in
         * the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link LoggingConfig.Builder} avoiding the need
         * to create one manually via {@link LoggingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LoggingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #logging(LoggingConfig)}.
         * 
         * @param logging
         *        a consumer that will call methods on {@link LoggingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logging(LoggingConfig)
         */
        default Builder logging(Consumer<LoggingConfig.Builder> logging) {
            return logging(LoggingConfig.builder().applyMutation(logging).build());
        }

        /**
         * <p>
         * The price class that corresponds with the maximum price that you want to pay for CloudFront service. If you
         * specify <code>PriceClass_All</code>, CloudFront responds to requests for your objects from all CloudFront
         * edge locations.
         * </p>
         * <p>
         * If you specify a price class other than <code>PriceClass_All</code>, CloudFront serves your objects from the
         * CloudFront edge location that has the lowest latency among the edge locations in your price class. Viewers
         * who are in or near regions that are excluded from your specified price class may encounter slower
         * performance.
         * </p>
         * <p>
         * For more information about price classes, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html">Choosing the Price
         * Class for a CloudFront Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>. For information
         * about CloudFront pricing, including how price classes (such as Price Class 100) map to CloudFront regions,
         * see <a href="http://aws.amazon.com/cloudfront/pricing/">Amazon CloudFront Pricing</a>.
         * </p>
         * 
         * @param priceClass
         *        The price class that corresponds with the maximum price that you want to pay for CloudFront service.
         *        If you specify <code>PriceClass_All</code>, CloudFront responds to requests for your objects from all
         *        CloudFront edge locations.</p>
         *        <p>
         *        If you specify a price class other than <code>PriceClass_All</code>, CloudFront serves your objects
         *        from the CloudFront edge location that has the lowest latency among the edge locations in your price
         *        class. Viewers who are in or near regions that are excluded from your specified price class may
         *        encounter slower performance.
         *        </p>
         *        <p>
         *        For more information about price classes, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html">Choosing the
         *        Price Class for a CloudFront Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>. For
         *        information about CloudFront pricing, including how price classes (such as Price Class 100) map to
         *        CloudFront regions, see <a href="http://aws.amazon.com/cloudfront/pricing/">Amazon CloudFront
         *        Pricing</a>.
         * @see PriceClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PriceClass
         */
        Builder priceClass(String priceClass);

        /**
         * <p>
         * The price class that corresponds with the maximum price that you want to pay for CloudFront service. If you
         * specify <code>PriceClass_All</code>, CloudFront responds to requests for your objects from all CloudFront
         * edge locations.
         * </p>
         * <p>
         * If you specify a price class other than <code>PriceClass_All</code>, CloudFront serves your objects from the
         * CloudFront edge location that has the lowest latency among the edge locations in your price class. Viewers
         * who are in or near regions that are excluded from your specified price class may encounter slower
         * performance.
         * </p>
         * <p>
         * For more information about price classes, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html">Choosing the Price
         * Class for a CloudFront Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>. For information
         * about CloudFront pricing, including how price classes (such as Price Class 100) map to CloudFront regions,
         * see <a href="http://aws.amazon.com/cloudfront/pricing/">Amazon CloudFront Pricing</a>.
         * </p>
         * 
         * @param priceClass
         *        The price class that corresponds with the maximum price that you want to pay for CloudFront service.
         *        If you specify <code>PriceClass_All</code>, CloudFront responds to requests for your objects from all
         *        CloudFront edge locations.</p>
         *        <p>
         *        If you specify a price class other than <code>PriceClass_All</code>, CloudFront serves your objects
         *        from the CloudFront edge location that has the lowest latency among the edge locations in your price
         *        class. Viewers who are in or near regions that are excluded from your specified price class may
         *        encounter slower performance.
         *        </p>
         *        <p>
         *        For more information about price classes, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PriceClass.html">Choosing the
         *        Price Class for a CloudFront Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>. For
         *        information about CloudFront pricing, including how price classes (such as Price Class 100) map to
         *        CloudFront regions, see <a href="http://aws.amazon.com/cloudfront/pricing/">Amazon CloudFront
         *        Pricing</a>.
         * @see PriceClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PriceClass
         */
        Builder priceClass(PriceClass priceClass);

        /**
         * <p>
         * From this field, you can enable or disable the selected distribution.
         * </p>
         * 
         * @param enabled
         *        From this field, you can enable or disable the selected distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * A complex type that determines the distribution's SSL/TLS configuration for communicating with viewers.
         * </p>
         * 
         * @param viewerCertificate
         *        A complex type that determines the distribution's SSL/TLS configuration for communicating with
         *        viewers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewerCertificate(ViewerCertificate viewerCertificate);

        /**
         * <p>
         * A complex type that determines the distribution's SSL/TLS configuration for communicating with viewers.
         * </p>
         * This is a convenience method that creates an instance of the {@link ViewerCertificate.Builder} avoiding the
         * need to create one manually via {@link ViewerCertificate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ViewerCertificate.Builder#build()} is called immediately and its
         * result is passed to {@link #viewerCertificate(ViewerCertificate)}.
         * 
         * @param viewerCertificate
         *        a consumer that will call methods on {@link ViewerCertificate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #viewerCertificate(ViewerCertificate)
         */
        default Builder viewerCertificate(Consumer<ViewerCertificate.Builder> viewerCertificate) {
            return viewerCertificate(ViewerCertificate.builder().applyMutation(viewerCertificate).build());
        }

        /**
         * <p>
         * A complex type that identifies ways in which you want to restrict distribution of your content.
         * </p>
         * 
         * @param restrictions
         *        A complex type that identifies ways in which you want to restrict distribution of your content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restrictions(Restrictions restrictions);

        /**
         * <p>
         * A complex type that identifies ways in which you want to restrict distribution of your content.
         * </p>
         * This is a convenience method that creates an instance of the {@link Restrictions.Builder} avoiding the need
         * to create one manually via {@link Restrictions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Restrictions.Builder#build()} is called immediately and its
         * result is passed to {@link #restrictions(Restrictions)}.
         * 
         * @param restrictions
         *        a consumer that will call methods on {@link Restrictions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #restrictions(Restrictions)
         */
        default Builder restrictions(Consumer<Restrictions.Builder> restrictions) {
            return restrictions(Restrictions.builder().applyMutation(restrictions).build());
        }

        /**
         * <p>
         * A unique identifier that specifies the WAF web ACL, if any, to associate with this distribution. To specify a
         * web ACL created using the latest version of WAF, use the ACL ARN, for example
         * <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code>
         * . To specify a web ACL created using WAF Classic, use the ACL ID, for example
         * <code>a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code>.
         * </p>
         * <p>
         * WAF is a web application firewall that lets you monitor the HTTP and HTTPS requests that are forwarded to
         * CloudFront, and lets you control access to your content. Based on conditions that you specify, such as the IP
         * addresses that requests originate from or the values of query strings, CloudFront responds to requests either
         * with the requested content or with an HTTP 403 status code (Forbidden). You can also configure CloudFront to
         * return a custom error page when a request is blocked. For more information about WAF, see the <a
         * href="https://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html">WAF Developer Guide</a>.
         * </p>
         * 
         * @param webACLId
         *        A unique identifier that specifies the WAF web ACL, if any, to associate with this distribution. To
         *        specify a web ACL created using the latest version of WAF, use the ACL ARN, for example
         *        <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code>
         *        . To specify a web ACL created using WAF Classic, use the ACL ID, for example
         *        <code>a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code>.</p>
         *        <p>
         *        WAF is a web application firewall that lets you monitor the HTTP and HTTPS requests that are forwarded
         *        to CloudFront, and lets you control access to your content. Based on conditions that you specify, such
         *        as the IP addresses that requests originate from or the values of query strings, CloudFront responds
         *        to requests either with the requested content or with an HTTP 403 status code (Forbidden). You can
         *        also configure CloudFront to return a custom error page when a request is blocked. For more
         *        information about WAF, see the <a
         *        href="https://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html">WAF Developer
         *        Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webACLId(String webACLId);

        /**
         * <p>
         * (Optional) Specify the HTTP version(s) that you want viewers to use to communicate with CloudFront. The
         * default value for new web distributions is <code>http2</code>. Viewers that don't support HTTP/2
         * automatically use an earlier HTTP version.
         * </p>
         * <p>
         * For viewers and CloudFront to use HTTP/2, viewers must support TLSv1.2 or later, and must support Server Name
         * Indication (SNI).
         * </p>
         * <p>
         * For viewers and CloudFront to use HTTP/3, viewers must support TLSv1.3 and Server Name Indication (SNI).
         * CloudFront supports HTTP/3 connection migration to allow the viewer to switch networks without losing
         * connection. For more information about connection migration, see <a
         * href="https://www.rfc-editor.org/rfc/rfc9000.html#name-connection-migration">Connection Migration</a> at RFC
         * 9000. For more information about supported TLSv1.3 ciphers, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html"
         * >Supported protocols and ciphers between viewers and CloudFront</a>.
         * </p>
         * 
         * @param httpVersion
         *        (Optional) Specify the HTTP version(s) that you want viewers to use to communicate with CloudFront.
         *        The default value for new web distributions is <code>http2</code>. Viewers that don't support HTTP/2
         *        automatically use an earlier HTTP version.</p>
         *        <p>
         *        For viewers and CloudFront to use HTTP/2, viewers must support TLSv1.2 or later, and must support
         *        Server Name Indication (SNI).
         *        </p>
         *        <p>
         *        For viewers and CloudFront to use HTTP/3, viewers must support TLSv1.3 and Server Name Indication
         *        (SNI). CloudFront supports HTTP/3 connection migration to allow the viewer to switch networks without
         *        losing connection. For more information about connection migration, see <a
         *        href="https://www.rfc-editor.org/rfc/rfc9000.html#name-connection-migration">Connection Migration</a>
         *        at RFC 9000. For more information about supported TLSv1.3 ciphers, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html"
         *        >Supported protocols and ciphers between viewers and CloudFront</a>.
         * @see HttpVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpVersion
         */
        Builder httpVersion(String httpVersion);

        /**
         * <p>
         * (Optional) Specify the HTTP version(s) that you want viewers to use to communicate with CloudFront. The
         * default value for new web distributions is <code>http2</code>. Viewers that don't support HTTP/2
         * automatically use an earlier HTTP version.
         * </p>
         * <p>
         * For viewers and CloudFront to use HTTP/2, viewers must support TLSv1.2 or later, and must support Server Name
         * Indication (SNI).
         * </p>
         * <p>
         * For viewers and CloudFront to use HTTP/3, viewers must support TLSv1.3 and Server Name Indication (SNI).
         * CloudFront supports HTTP/3 connection migration to allow the viewer to switch networks without losing
         * connection. For more information about connection migration, see <a
         * href="https://www.rfc-editor.org/rfc/rfc9000.html#name-connection-migration">Connection Migration</a> at RFC
         * 9000. For more information about supported TLSv1.3 ciphers, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html"
         * >Supported protocols and ciphers between viewers and CloudFront</a>.
         * </p>
         * 
         * @param httpVersion
         *        (Optional) Specify the HTTP version(s) that you want viewers to use to communicate with CloudFront.
         *        The default value for new web distributions is <code>http2</code>. Viewers that don't support HTTP/2
         *        automatically use an earlier HTTP version.</p>
         *        <p>
         *        For viewers and CloudFront to use HTTP/2, viewers must support TLSv1.2 or later, and must support
         *        Server Name Indication (SNI).
         *        </p>
         *        <p>
         *        For viewers and CloudFront to use HTTP/3, viewers must support TLSv1.3 and Server Name Indication
         *        (SNI). CloudFront supports HTTP/3 connection migration to allow the viewer to switch networks without
         *        losing connection. For more information about connection migration, see <a
         *        href="https://www.rfc-editor.org/rfc/rfc9000.html#name-connection-migration">Connection Migration</a>
         *        at RFC 9000. For more information about supported TLSv1.3 ciphers, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/secure-connections-supported-viewer-protocols-ciphers.html"
         *        >Supported protocols and ciphers between viewers and CloudFront</a>.
         * @see HttpVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HttpVersion
         */
        Builder httpVersion(HttpVersion httpVersion);

        /**
         * <p>
         * If you want CloudFront to respond to IPv6 DNS requests with an IPv6 address for your distribution, specify
         * <code>true</code>. If you specify <code>false</code>, CloudFront responds to IPv6 DNS requests with the DNS
         * response code <code>NOERROR</code> and with no IP addresses. This allows viewers to submit a second request,
         * for an IPv4 address for your distribution.
         * </p>
         * <p>
         * In general, you should enable IPv6 if you have users on IPv6 networks who want to access your content.
         * However, if you're using signed URLs or signed cookies to restrict access to your content, and if you're
         * using a custom policy that includes the <code>IpAddress</code> parameter to restrict the IP addresses that
         * can access your content, don't enable IPv6. If you want to restrict access to some content by IP address and
         * not restrict access to other content (or restrict access but not by IP address), you can create two
         * distributions. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-creating-signed-url-custom-policy.html"
         * >Creating a Signed URL Using a Custom Policy</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * <p>
         * If you're using an Route 53 Amazon Web Services Integration alias resource record set to route traffic to
         * your CloudFront distribution, you need to create a second alias resource record set when both of the
         * following are true:
         * </p>
         * <ul>
         * <li>
         * <p>
         * You enable IPv6 for the distribution
         * </p>
         * </li>
         * <li>
         * <p>
         * You're using alternate domain names in the URLs for your objects
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-to-cloudfront-distribution.html"
         * >Routing Traffic to an Amazon CloudFront Web Distribution by Using Your Domain Name</a> in the <i>Route 53
         * Amazon Web Services Integration Developer Guide</i>.
         * </p>
         * <p>
         * If you created a CNAME resource record set, either with Route 53 Amazon Web Services Integration or with
         * another DNS service, you don't need to make any changes. A CNAME record will route traffic to your
         * distribution regardless of the IP address format of the viewer request.
         * </p>
         * 
         * @param isIPV6Enabled
         *        If you want CloudFront to respond to IPv6 DNS requests with an IPv6 address for your distribution,
         *        specify <code>true</code>. If you specify <code>false</code>, CloudFront responds to IPv6 DNS requests
         *        with the DNS response code <code>NOERROR</code> and with no IP addresses. This allows viewers to
         *        submit a second request, for an IPv4 address for your distribution.</p>
         *        <p>
         *        In general, you should enable IPv6 if you have users on IPv6 networks who want to access your content.
         *        However, if you're using signed URLs or signed cookies to restrict access to your content, and if
         *        you're using a custom policy that includes the <code>IpAddress</code> parameter to restrict the IP
         *        addresses that can access your content, don't enable IPv6. If you want to restrict access to some
         *        content by IP address and not restrict access to other content (or restrict access but not by IP
         *        address), you can create two distributions. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-creating-signed-url-custom-policy.html"
         *        >Creating a Signed URL Using a Custom Policy</a> in the <i>Amazon CloudFront Developer Guide</i>.
         *        </p>
         *        <p>
         *        If you're using an Route 53 Amazon Web Services Integration alias resource record set to route traffic
         *        to your CloudFront distribution, you need to create a second alias resource record set when both of
         *        the following are true:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        You enable IPv6 for the distribution
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You're using alternate domain names in the URLs for your objects
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-to-cloudfront-distribution.html"
         *        >Routing Traffic to an Amazon CloudFront Web Distribution by Using Your Domain Name</a> in the
         *        <i>Route 53 Amazon Web Services Integration Developer Guide</i>.
         *        </p>
         *        <p>
         *        If you created a CNAME resource record set, either with Route 53 Amazon Web Services Integration or
         *        with another DNS service, you don't need to make any changes. A CNAME record will route traffic to
         *        your distribution regardless of the IP address format of the viewer request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isIPV6Enabled(Boolean isIPV6Enabled);

        /**
         * <p>
         * The identifier of a continuous deployment policy. For more information, see
         * <code>CreateContinuousDeploymentPolicy</code>.
         * </p>
         * 
         * @param continuousDeploymentPolicyId
         *        The identifier of a continuous deployment policy. For more information, see
         *        <code>CreateContinuousDeploymentPolicy</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuousDeploymentPolicyId(String continuousDeploymentPolicyId);

        /**
         * <p>
         * A Boolean that indicates whether this is a staging distribution. When this value is <code>true</code>, this
         * is a staging distribution. When this value is <code>false</code>, this is not a staging distribution.
         * </p>
         * 
         * @param staging
         *        A Boolean that indicates whether this is a staging distribution. When this value is <code>true</code>,
         *        this is a staging distribution. When this value is <code>false</code>, this is not a staging
         *        distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staging(Boolean staging);
    }

    static final class BuilderImpl implements Builder {
        private String callerReference;

        private Aliases aliases;

        private String defaultRootObject;

        private Origins origins;

        private OriginGroups originGroups;

        private DefaultCacheBehavior defaultCacheBehavior;

        private CacheBehaviors cacheBehaviors;

        private CustomErrorResponses customErrorResponses;

        private String comment;

        private LoggingConfig logging;

        private String priceClass;

        private Boolean enabled;

        private ViewerCertificate viewerCertificate;

        private Restrictions restrictions;

        private String webACLId;

        private String httpVersion;

        private Boolean isIPV6Enabled;

        private String continuousDeploymentPolicyId;

        private Boolean staging;

        private BuilderImpl() {
        }

        private BuilderImpl(DistributionConfig model) {
            callerReference(model.callerReference);
            aliases(model.aliases);
            defaultRootObject(model.defaultRootObject);
            origins(model.origins);
            originGroups(model.originGroups);
            defaultCacheBehavior(model.defaultCacheBehavior);
            cacheBehaviors(model.cacheBehaviors);
            customErrorResponses(model.customErrorResponses);
            comment(model.comment);
            logging(model.logging);
            priceClass(model.priceClass);
            enabled(model.enabled);
            viewerCertificate(model.viewerCertificate);
            restrictions(model.restrictions);
            webACLId(model.webACLId);
            httpVersion(model.httpVersion);
            isIPV6Enabled(model.isIPV6Enabled);
            continuousDeploymentPolicyId(model.continuousDeploymentPolicyId);
            staging(model.staging);
        }

        public final String getCallerReference() {
            return callerReference;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final Aliases.Builder getAliases() {
            return aliases != null ? aliases.toBuilder() : null;
        }

        public final void setAliases(Aliases.BuilderImpl aliases) {
            this.aliases = aliases != null ? aliases.build() : null;
        }

        @Override
        public final Builder aliases(Aliases aliases) {
            this.aliases = aliases;
            return this;
        }

        public final String getDefaultRootObject() {
            return defaultRootObject;
        }

        public final void setDefaultRootObject(String defaultRootObject) {
            this.defaultRootObject = defaultRootObject;
        }

        @Override
        public final Builder defaultRootObject(String defaultRootObject) {
            this.defaultRootObject = defaultRootObject;
            return this;
        }

        public final Origins.Builder getOrigins() {
            return origins != null ? origins.toBuilder() : null;
        }

        public final void setOrigins(Origins.BuilderImpl origins) {
            this.origins = origins != null ? origins.build() : null;
        }

        @Override
        public final Builder origins(Origins origins) {
            this.origins = origins;
            return this;
        }

        public final OriginGroups.Builder getOriginGroups() {
            return originGroups != null ? originGroups.toBuilder() : null;
        }

        public final void setOriginGroups(OriginGroups.BuilderImpl originGroups) {
            this.originGroups = originGroups != null ? originGroups.build() : null;
        }

        @Override
        public final Builder originGroups(OriginGroups originGroups) {
            this.originGroups = originGroups;
            return this;
        }

        public final DefaultCacheBehavior.Builder getDefaultCacheBehavior() {
            return defaultCacheBehavior != null ? defaultCacheBehavior.toBuilder() : null;
        }

        public final void setDefaultCacheBehavior(DefaultCacheBehavior.BuilderImpl defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior != null ? defaultCacheBehavior.build() : null;
        }

        @Override
        public final Builder defaultCacheBehavior(DefaultCacheBehavior defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior;
            return this;
        }

        public final CacheBehaviors.Builder getCacheBehaviors() {
            return cacheBehaviors != null ? cacheBehaviors.toBuilder() : null;
        }

        public final void setCacheBehaviors(CacheBehaviors.BuilderImpl cacheBehaviors) {
            this.cacheBehaviors = cacheBehaviors != null ? cacheBehaviors.build() : null;
        }

        @Override
        public final Builder cacheBehaviors(CacheBehaviors cacheBehaviors) {
            this.cacheBehaviors = cacheBehaviors;
            return this;
        }

        public final CustomErrorResponses.Builder getCustomErrorResponses() {
            return customErrorResponses != null ? customErrorResponses.toBuilder() : null;
        }

        public final void setCustomErrorResponses(CustomErrorResponses.BuilderImpl customErrorResponses) {
            this.customErrorResponses = customErrorResponses != null ? customErrorResponses.build() : null;
        }

        @Override
        public final Builder customErrorResponses(CustomErrorResponses customErrorResponses) {
            this.customErrorResponses = customErrorResponses;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final LoggingConfig.Builder getLogging() {
            return logging != null ? logging.toBuilder() : null;
        }

        public final void setLogging(LoggingConfig.BuilderImpl logging) {
            this.logging = logging != null ? logging.build() : null;
        }

        @Override
        public final Builder logging(LoggingConfig logging) {
            this.logging = logging;
            return this;
        }

        public final String getPriceClass() {
            return priceClass;
        }

        public final void setPriceClass(String priceClass) {
            this.priceClass = priceClass;
        }

        @Override
        public final Builder priceClass(String priceClass) {
            this.priceClass = priceClass;
            return this;
        }

        @Override
        public final Builder priceClass(PriceClass priceClass) {
            this.priceClass(priceClass == null ? null : priceClass.toString());
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final ViewerCertificate.Builder getViewerCertificate() {
            return viewerCertificate != null ? viewerCertificate.toBuilder() : null;
        }

        public final void setViewerCertificate(ViewerCertificate.BuilderImpl viewerCertificate) {
            this.viewerCertificate = viewerCertificate != null ? viewerCertificate.build() : null;
        }

        @Override
        public final Builder viewerCertificate(ViewerCertificate viewerCertificate) {
            this.viewerCertificate = viewerCertificate;
            return this;
        }

        public final Restrictions.Builder getRestrictions() {
            return restrictions != null ? restrictions.toBuilder() : null;
        }

        public final void setRestrictions(Restrictions.BuilderImpl restrictions) {
            this.restrictions = restrictions != null ? restrictions.build() : null;
        }

        @Override
        public final Builder restrictions(Restrictions restrictions) {
            this.restrictions = restrictions;
            return this;
        }

        public final String getWebACLId() {
            return webACLId;
        }

        public final void setWebACLId(String webACLId) {
            this.webACLId = webACLId;
        }

        @Override
        public final Builder webACLId(String webACLId) {
            this.webACLId = webACLId;
            return this;
        }

        public final String getHttpVersion() {
            return httpVersion;
        }

        public final void setHttpVersion(String httpVersion) {
            this.httpVersion = httpVersion;
        }

        @Override
        public final Builder httpVersion(String httpVersion) {
            this.httpVersion = httpVersion;
            return this;
        }

        @Override
        public final Builder httpVersion(HttpVersion httpVersion) {
            this.httpVersion(httpVersion == null ? null : httpVersion.toString());
            return this;
        }

        public final Boolean getIsIPV6Enabled() {
            return isIPV6Enabled;
        }

        public final void setIsIPV6Enabled(Boolean isIPV6Enabled) {
            this.isIPV6Enabled = isIPV6Enabled;
        }

        @Override
        public final Builder isIPV6Enabled(Boolean isIPV6Enabled) {
            this.isIPV6Enabled = isIPV6Enabled;
            return this;
        }

        public final String getContinuousDeploymentPolicyId() {
            return continuousDeploymentPolicyId;
        }

        public final void setContinuousDeploymentPolicyId(String continuousDeploymentPolicyId) {
            this.continuousDeploymentPolicyId = continuousDeploymentPolicyId;
        }

        @Override
        public final Builder continuousDeploymentPolicyId(String continuousDeploymentPolicyId) {
            this.continuousDeploymentPolicyId = continuousDeploymentPolicyId;
            return this;
        }

        public final Boolean getStaging() {
            return staging;
        }

        public final void setStaging(Boolean staging) {
            this.staging = staging;
        }

        @Override
        public final Builder staging(Boolean staging) {
            this.staging = staging;
            return this;
        }

        @Override
        public DistributionConfig build() {
            return new DistributionConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
