/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PublicKeyConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PublicKeyConfig> {
    private static final SdkField<String> CALLER_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CallerReference").getter(PublicKeyConfig.getter(PublicKeyConfig::callerReference)).setter(PublicKeyConfig.setter(Builder::callerReference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallerReference").unmarshallLocationName("CallerReference").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(PublicKeyConfig.getter(PublicKeyConfig::name)).setter(PublicKeyConfig.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<String> ENCODED_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncodedKey").getter(PublicKeyConfig.getter(PublicKeyConfig::encodedKey)).setter(PublicKeyConfig.setter(Builder::encodedKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncodedKey").unmarshallLocationName("EncodedKey").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Comment").getter(PublicKeyConfig.getter(PublicKeyConfig::comment)).setter(PublicKeyConfig.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").unmarshallLocationName("Comment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALLER_REFERENCE_FIELD, NAME_FIELD, ENCODED_KEY_FIELD, COMMENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String callerReference;
    private final String name;
    private final String encodedKey;
    private final String comment;

    private PublicKeyConfig(BuilderImpl builder) {
        this.callerReference = builder.callerReference;
        this.name = builder.name;
        this.encodedKey = builder.encodedKey;
        this.comment = builder.comment;
    }

    public final String callerReference() {
        return this.callerReference;
    }

    public final String name() {
        return this.name;
    }

    public final String encodedKey() {
        return this.encodedKey;
    }

    public final String comment() {
        return this.comment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.encodedKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublicKeyConfig)) {
            return false;
        }
        PublicKeyConfig other = (PublicKeyConfig)obj;
        return Objects.equals(this.callerReference(), other.callerReference()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.encodedKey(), other.encodedKey()) && Objects.equals(this.comment(), other.comment());
    }

    public final String toString() {
        return ToString.builder((String)"PublicKeyConfig").add("CallerReference", (Object)this.callerReference()).add("Name", (Object)this.name()).add("EncodedKey", (Object)this.encodedKey()).add("Comment", (Object)this.comment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CallerReference": {
                return Optional.ofNullable(clazz.cast(this.callerReference()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "EncodedKey": {
                return Optional.ofNullable(clazz.cast(this.encodedKey()));
            }
            case "Comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PublicKeyConfig, T> g) {
        return obj -> g.apply((PublicKeyConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String callerReference;
        private String name;
        private String encodedKey;
        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(PublicKeyConfig model) {
            this.callerReference(model.callerReference);
            this.name(model.name);
            this.encodedKey(model.encodedKey);
            this.comment(model.comment);
        }

        public final String getCallerReference() {
            return this.callerReference;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEncodedKey() {
            return this.encodedKey;
        }

        public final void setEncodedKey(String encodedKey) {
            this.encodedKey = encodedKey;
        }

        @Override
        public final Builder encodedKey(String encodedKey) {
            this.encodedKey = encodedKey;
            return this;
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public PublicKeyConfig build() {
            return new PublicKeyConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PublicKeyConfig> {
        public Builder callerReference(String var1);

        public Builder name(String var1);

        public Builder encodedKey(String var1);

        public Builder comment(String var1);
    }
}

