/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary of the information about a CloudFront origin access identity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudFrontOriginAccessIdentitySummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudFrontOriginAccessIdentitySummary.Builder, CloudFrontOriginAccessIdentitySummary> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(CloudFrontOriginAccessIdentitySummary::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> S3_CANONICAL_USER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("S3CanonicalUserId")
            .getter(getter(CloudFrontOriginAccessIdentitySummary::s3CanonicalUserId))
            .setter(setter(Builder::s3CanonicalUserId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3CanonicalUserId")
                    .unmarshallLocationName("S3CanonicalUserId").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Comment")
            .getter(getter(CloudFrontOriginAccessIdentitySummary::comment))
            .setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment")
                    .unmarshallLocationName("Comment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            S3_CANONICAL_USER_ID_FIELD, COMMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String s3CanonicalUserId;

    private final String comment;

    private CloudFrontOriginAccessIdentitySummary(BuilderImpl builder) {
        this.id = builder.id;
        this.s3CanonicalUserId = builder.s3CanonicalUserId;
        this.comment = builder.comment;
    }

    /**
     * <p>
     * The ID for the origin access identity. For example: <code>E74FTE3AJFJ256A</code>.
     * </p>
     * 
     * @return The ID for the origin access identity. For example: <code>E74FTE3AJFJ256A</code>.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon S3 canonical user ID for the origin access identity, which you use when giving the origin access
     * identity read permission to an object in Amazon S3.
     * </p>
     * 
     * @return The Amazon S3 canonical user ID for the origin access identity, which you use when giving the origin
     *         access identity read permission to an object in Amazon S3.
     */
    public final String s3CanonicalUserId() {
        return s3CanonicalUserId;
    }

    /**
     * <p>
     * The comment for this origin access identity, as originally specified when created.
     * </p>
     * 
     * @return The comment for this origin access identity, as originally specified when created.
     */
    public final String comment() {
        return comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(s3CanonicalUserId());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudFrontOriginAccessIdentitySummary)) {
            return false;
        }
        CloudFrontOriginAccessIdentitySummary other = (CloudFrontOriginAccessIdentitySummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(s3CanonicalUserId(), other.s3CanonicalUserId())
                && Objects.equals(comment(), other.comment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudFrontOriginAccessIdentitySummary").add("Id", id())
                .add("S3CanonicalUserId", s3CanonicalUserId()).add("Comment", comment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "S3CanonicalUserId":
            return Optional.ofNullable(clazz.cast(s3CanonicalUserId()));
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("S3CanonicalUserId", S3_CANONICAL_USER_ID_FIELD);
        map.put("Comment", COMMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CloudFrontOriginAccessIdentitySummary, T> g) {
        return obj -> g.apply((CloudFrontOriginAccessIdentitySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudFrontOriginAccessIdentitySummary> {
        /**
         * <p>
         * The ID for the origin access identity. For example: <code>E74FTE3AJFJ256A</code>.
         * </p>
         * 
         * @param id
         *        The ID for the origin access identity. For example: <code>E74FTE3AJFJ256A</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon S3 canonical user ID for the origin access identity, which you use when giving the origin access
         * identity read permission to an object in Amazon S3.
         * </p>
         * 
         * @param s3CanonicalUserId
         *        The Amazon S3 canonical user ID for the origin access identity, which you use when giving the origin
         *        access identity read permission to an object in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3CanonicalUserId(String s3CanonicalUserId);

        /**
         * <p>
         * The comment for this origin access identity, as originally specified when created.
         * </p>
         * 
         * @param comment
         *        The comment for this origin access identity, as originally specified when created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String s3CanonicalUserId;

        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudFrontOriginAccessIdentitySummary model) {
            id(model.id);
            s3CanonicalUserId(model.s3CanonicalUserId);
            comment(model.comment);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getS3CanonicalUserId() {
            return s3CanonicalUserId;
        }

        public final void setS3CanonicalUserId(String s3CanonicalUserId) {
            this.s3CanonicalUserId = s3CanonicalUserId;
        }

        @Override
        public final Builder s3CanonicalUserId(String s3CanonicalUserId) {
            this.s3CanonicalUserId = s3CanonicalUserId;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public CloudFrontOriginAccessIdentitySummary build() {
            return new CloudFrontOriginAccessIdentitySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
