/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCachePolicyConfigResponse extends CloudFrontResponse implements
        ToCopyableBuilder<GetCachePolicyConfigResponse.Builder, GetCachePolicyConfigResponse> {
    private static final SdkField<CachePolicyConfig> CACHE_POLICY_CONFIG_FIELD = SdkField
            .<CachePolicyConfig> builder(MarshallingType.SDK_POJO)
            .memberName("CachePolicyConfig")
            .getter(getter(GetCachePolicyConfigResponse::cachePolicyConfig))
            .setter(setter(Builder::cachePolicyConfig))
            .constructor(CachePolicyConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CachePolicyConfig")
                    .unmarshallLocationName("CachePolicyConfig").build(), PayloadTrait.create()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ETag")
            .getter(getter(GetCachePolicyConfigResponse::eTag))
            .setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_POLICY_CONFIG_FIELD,
            E_TAG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final CachePolicyConfig cachePolicyConfig;

    private final String eTag;

    private GetCachePolicyConfigResponse(BuilderImpl builder) {
        super(builder);
        this.cachePolicyConfig = builder.cachePolicyConfig;
        this.eTag = builder.eTag;
    }

    /**
     * <p>
     * The cache policy configuration.
     * </p>
     * 
     * @return The cache policy configuration.
     */
    public final CachePolicyConfig cachePolicyConfig() {
        return cachePolicyConfig;
    }

    /**
     * <p>
     * The current version of the cache policy.
     * </p>
     * 
     * @return The current version of the cache policy.
     */
    public final String eTag() {
        return eTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cachePolicyConfig());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCachePolicyConfigResponse)) {
            return false;
        }
        GetCachePolicyConfigResponse other = (GetCachePolicyConfigResponse) obj;
        return Objects.equals(cachePolicyConfig(), other.cachePolicyConfig()) && Objects.equals(eTag(), other.eTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCachePolicyConfigResponse").add("CachePolicyConfig", cachePolicyConfig()).add("ETag", eTag())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CachePolicyConfig":
            return Optional.ofNullable(clazz.cast(cachePolicyConfig()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CachePolicyConfig", CACHE_POLICY_CONFIG_FIELD);
        map.put("ETag", E_TAG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCachePolicyConfigResponse, T> g) {
        return obj -> g.apply((GetCachePolicyConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCachePolicyConfigResponse> {
        /**
         * <p>
         * The cache policy configuration.
         * </p>
         * 
         * @param cachePolicyConfig
         *        The cache policy configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cachePolicyConfig(CachePolicyConfig cachePolicyConfig);

        /**
         * <p>
         * The cache policy configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link CachePolicyConfig.Builder} avoiding the
         * need to create one manually via {@link CachePolicyConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CachePolicyConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #cachePolicyConfig(CachePolicyConfig)}.
         * 
         * @param cachePolicyConfig
         *        a consumer that will call methods on {@link CachePolicyConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cachePolicyConfig(CachePolicyConfig)
         */
        default Builder cachePolicyConfig(Consumer<CachePolicyConfig.Builder> cachePolicyConfig) {
            return cachePolicyConfig(CachePolicyConfig.builder().applyMutation(cachePolicyConfig).build());
        }

        /**
         * <p>
         * The current version of the cache policy.
         * </p>
         * 
         * @param eTag
         *        The current version of the cache policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private CachePolicyConfig cachePolicyConfig;

        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCachePolicyConfigResponse model) {
            super(model);
            cachePolicyConfig(model.cachePolicyConfig);
            eTag(model.eTag);
        }

        public final CachePolicyConfig.Builder getCachePolicyConfig() {
            return cachePolicyConfig != null ? cachePolicyConfig.toBuilder() : null;
        }

        public final void setCachePolicyConfig(CachePolicyConfig.BuilderImpl cachePolicyConfig) {
            this.cachePolicyConfig = cachePolicyConfig != null ? cachePolicyConfig.build() : null;
        }

        @Override
        public final Builder cachePolicyConfig(CachePolicyConfig cachePolicyConfig) {
            this.cachePolicyConfig = cachePolicyConfig;
            return this;
        }

        public final String getETag() {
            return eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public GetCachePolicyConfigResponse build() {
            return new GetCachePolicyConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
