/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFieldLevelEncryptionConfigsResponse extends CloudFrontResponse implements
        ToCopyableBuilder<ListFieldLevelEncryptionConfigsResponse.Builder, ListFieldLevelEncryptionConfigsResponse> {
    private static final SdkField<FieldLevelEncryptionList> FIELD_LEVEL_ENCRYPTION_LIST_FIELD = SdkField
            .<FieldLevelEncryptionList> builder(MarshallingType.SDK_POJO)
            .memberName("FieldLevelEncryptionList")
            .getter(getter(ListFieldLevelEncryptionConfigsResponse::fieldLevelEncryptionList))
            .setter(setter(Builder::fieldLevelEncryptionList))
            .constructor(FieldLevelEncryptionList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldLevelEncryptionList")
                    .unmarshallLocationName("FieldLevelEncryptionList").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FIELD_LEVEL_ENCRYPTION_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final FieldLevelEncryptionList fieldLevelEncryptionList;

    private ListFieldLevelEncryptionConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.fieldLevelEncryptionList = builder.fieldLevelEncryptionList;
    }

    /**
     * <p>
     * Returns a list of all field-level encryption configurations that have been created in CloudFront for this
     * account.
     * </p>
     * 
     * @return Returns a list of all field-level encryption configurations that have been created in CloudFront for this
     *         account.
     */
    public final FieldLevelEncryptionList fieldLevelEncryptionList() {
        return fieldLevelEncryptionList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fieldLevelEncryptionList());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFieldLevelEncryptionConfigsResponse)) {
            return false;
        }
        ListFieldLevelEncryptionConfigsResponse other = (ListFieldLevelEncryptionConfigsResponse) obj;
        return Objects.equals(fieldLevelEncryptionList(), other.fieldLevelEncryptionList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFieldLevelEncryptionConfigsResponse")
                .add("FieldLevelEncryptionList", fieldLevelEncryptionList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldLevelEncryptionList":
            return Optional.ofNullable(clazz.cast(fieldLevelEncryptionList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldLevelEncryptionList", FIELD_LEVEL_ENCRYPTION_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFieldLevelEncryptionConfigsResponse, T> g) {
        return obj -> g.apply((ListFieldLevelEncryptionConfigsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListFieldLevelEncryptionConfigsResponse> {
        /**
         * <p>
         * Returns a list of all field-level encryption configurations that have been created in CloudFront for this
         * account.
         * </p>
         * 
         * @param fieldLevelEncryptionList
         *        Returns a list of all field-level encryption configurations that have been created in CloudFront for
         *        this account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldLevelEncryptionList(FieldLevelEncryptionList fieldLevelEncryptionList);

        /**
         * <p>
         * Returns a list of all field-level encryption configurations that have been created in CloudFront for this
         * account.
         * </p>
         * This is a convenience method that creates an instance of the {@link FieldLevelEncryptionList.Builder}
         * avoiding the need to create one manually via {@link FieldLevelEncryptionList#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FieldLevelEncryptionList.Builder#build()} is called immediately
         * and its result is passed to {@link #fieldLevelEncryptionList(FieldLevelEncryptionList)}.
         * 
         * @param fieldLevelEncryptionList
         *        a consumer that will call methods on {@link FieldLevelEncryptionList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldLevelEncryptionList(FieldLevelEncryptionList)
         */
        default Builder fieldLevelEncryptionList(Consumer<FieldLevelEncryptionList.Builder> fieldLevelEncryptionList) {
            return fieldLevelEncryptionList(FieldLevelEncryptionList.builder().applyMutation(fieldLevelEncryptionList).build());
        }
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private FieldLevelEncryptionList fieldLevelEncryptionList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFieldLevelEncryptionConfigsResponse model) {
            super(model);
            fieldLevelEncryptionList(model.fieldLevelEncryptionList);
        }

        public final FieldLevelEncryptionList.Builder getFieldLevelEncryptionList() {
            return fieldLevelEncryptionList != null ? fieldLevelEncryptionList.toBuilder() : null;
        }

        public final void setFieldLevelEncryptionList(FieldLevelEncryptionList.BuilderImpl fieldLevelEncryptionList) {
            this.fieldLevelEncryptionList = fieldLevelEncryptionList != null ? fieldLevelEncryptionList.build() : null;
        }

        @Override
        public final Builder fieldLevelEncryptionList(FieldLevelEncryptionList fieldLevelEncryptionList) {
            this.fieldLevelEncryptionList = fieldLevelEncryptionList;
            return this;
        }

        @Override
        public ListFieldLevelEncryptionConfigsResponse build() {
            return new ListFieldLevelEncryptionConfigsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
