/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListKeyValueStoresResponse extends CloudFrontResponse implements
        ToCopyableBuilder<ListKeyValueStoresResponse.Builder, ListKeyValueStoresResponse> {
    private static final SdkField<KeyValueStoreList> KEY_VALUE_STORE_LIST_FIELD = SdkField
            .<KeyValueStoreList> builder(MarshallingType.SDK_POJO)
            .memberName("KeyValueStoreList")
            .getter(getter(ListKeyValueStoresResponse::keyValueStoreList))
            .setter(setter(Builder::keyValueStoreList))
            .constructor(KeyValueStoreList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyValueStoreList")
                    .unmarshallLocationName("KeyValueStoreList").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_VALUE_STORE_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final KeyValueStoreList keyValueStoreList;

    private ListKeyValueStoresResponse(BuilderImpl builder) {
        super(builder);
        this.keyValueStoreList = builder.keyValueStoreList;
    }

    /**
     * <p>
     * The resulting key value stores list.
     * </p>
     * 
     * @return The resulting key value stores list.
     */
    public final KeyValueStoreList keyValueStoreList() {
        return keyValueStoreList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyValueStoreList());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListKeyValueStoresResponse)) {
            return false;
        }
        ListKeyValueStoresResponse other = (ListKeyValueStoresResponse) obj;
        return Objects.equals(keyValueStoreList(), other.keyValueStoreList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListKeyValueStoresResponse").add("KeyValueStoreList", keyValueStoreList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyValueStoreList":
            return Optional.ofNullable(clazz.cast(keyValueStoreList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KeyValueStoreList", KEY_VALUE_STORE_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListKeyValueStoresResponse, T> g) {
        return obj -> g.apply((ListKeyValueStoresResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListKeyValueStoresResponse> {
        /**
         * <p>
         * The resulting key value stores list.
         * </p>
         * 
         * @param keyValueStoreList
         *        The resulting key value stores list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyValueStoreList(KeyValueStoreList keyValueStoreList);

        /**
         * <p>
         * The resulting key value stores list.
         * </p>
         * This is a convenience method that creates an instance of the {@link KeyValueStoreList.Builder} avoiding the
         * need to create one manually via {@link KeyValueStoreList#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KeyValueStoreList.Builder#build()} is called immediately and its
         * result is passed to {@link #keyValueStoreList(KeyValueStoreList)}.
         * 
         * @param keyValueStoreList
         *        a consumer that will call methods on {@link KeyValueStoreList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyValueStoreList(KeyValueStoreList)
         */
        default Builder keyValueStoreList(Consumer<KeyValueStoreList.Builder> keyValueStoreList) {
            return keyValueStoreList(KeyValueStoreList.builder().applyMutation(keyValueStoreList).build());
        }
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private KeyValueStoreList keyValueStoreList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListKeyValueStoresResponse model) {
            super(model);
            keyValueStoreList(model.keyValueStoreList);
        }

        public final KeyValueStoreList.Builder getKeyValueStoreList() {
            return keyValueStoreList != null ? keyValueStoreList.toBuilder() : null;
        }

        public final void setKeyValueStoreList(KeyValueStoreList.BuilderImpl keyValueStoreList) {
            this.keyValueStoreList = keyValueStoreList != null ? keyValueStoreList.build() : null;
        }

        @Override
        public final Builder keyValueStoreList(KeyValueStoreList keyValueStoreList) {
            this.keyValueStoreList = keyValueStoreList;
            return this;
        }

        @Override
        public ListKeyValueStoresResponse build() {
            return new ListKeyValueStoresResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
