/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A configuration for enabling the <code>Server-Timing</code> header in HTTP responses sent from CloudFront. CloudFront
 * adds this header to HTTP responses that it sends in response to requests that match a cache behavior that's
 * associated with this response headers policy.
 * </p>
 * <p>
 * You can use the <code>Server-Timing</code> header to view metrics that can help you gain insights about the behavior
 * and performance of CloudFront. For example, you can see which cache layer served a cache hit, or the first byte
 * latency from the origin when there was a cache miss. You can use the metrics in the <code>Server-Timing</code> header
 * to troubleshoot issues or test the efficiency of your CloudFront configuration. For more information, see <a href=
 * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/understanding-response-headers-policies.html#server-timing-header"
 * >Server-Timing header</a> in the <i>Amazon CloudFront Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResponseHeadersPolicyServerTimingHeadersConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ResponseHeadersPolicyServerTimingHeadersConfig.Builder, ResponseHeadersPolicyServerTimingHeadersConfig> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled")
            .getter(getter(ResponseHeadersPolicyServerTimingHeadersConfig::enabled))
            .setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled")
                    .unmarshallLocationName("Enabled").build()).build();

    private static final SdkField<Double> SAMPLING_RATE_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("SamplingRate")
            .getter(getter(ResponseHeadersPolicyServerTimingHeadersConfig::samplingRate))
            .setter(setter(Builder::samplingRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamplingRate")
                    .unmarshallLocationName("SamplingRate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            SAMPLING_RATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final Double samplingRate;

    private ResponseHeadersPolicyServerTimingHeadersConfig(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.samplingRate = builder.samplingRate;
    }

    /**
     * <p>
     * A Boolean that determines whether CloudFront adds the <code>Server-Timing</code> header to HTTP responses that it
     * sends in response to requests that match a cache behavior that's associated with this response headers policy.
     * </p>
     * 
     * @return A Boolean that determines whether CloudFront adds the <code>Server-Timing</code> header to HTTP responses
     *         that it sends in response to requests that match a cache behavior that's associated with this response
     *         headers policy.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * A number 0–100 (inclusive) that specifies the percentage of responses that you want CloudFront to add the
     * <code>Server-Timing</code> header to. When you set the sampling rate to 100, CloudFront adds the
     * <code>Server-Timing</code> header to the HTTP response for every request that matches the cache behavior that
     * this response headers policy is attached to. When you set it to 50, CloudFront adds the header to 50% of the
     * responses for requests that match the cache behavior. You can set the sampling rate to any number 0–100 with up
     * to four decimal places.
     * </p>
     * 
     * @return A number 0–100 (inclusive) that specifies the percentage of responses that you want CloudFront to add the
     *         <code>Server-Timing</code> header to. When you set the sampling rate to 100, CloudFront adds the
     *         <code>Server-Timing</code> header to the HTTP response for every request that matches the cache behavior
     *         that this response headers policy is attached to. When you set it to 50, CloudFront adds the header to
     *         50% of the responses for requests that match the cache behavior. You can set the sampling rate to any
     *         number 0–100 with up to four decimal places.
     */
    public final Double samplingRate() {
        return samplingRate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(samplingRate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseHeadersPolicyServerTimingHeadersConfig)) {
            return false;
        }
        ResponseHeadersPolicyServerTimingHeadersConfig other = (ResponseHeadersPolicyServerTimingHeadersConfig) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(samplingRate(), other.samplingRate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResponseHeadersPolicyServerTimingHeadersConfig").add("Enabled", enabled())
                .add("SamplingRate", samplingRate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "SamplingRate":
            return Optional.ofNullable(clazz.cast(samplingRate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Enabled", ENABLED_FIELD);
        map.put("SamplingRate", SAMPLING_RATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResponseHeadersPolicyServerTimingHeadersConfig, T> g) {
        return obj -> g.apply((ResponseHeadersPolicyServerTimingHeadersConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResponseHeadersPolicyServerTimingHeadersConfig> {
        /**
         * <p>
         * A Boolean that determines whether CloudFront adds the <code>Server-Timing</code> header to HTTP responses
         * that it sends in response to requests that match a cache behavior that's associated with this response
         * headers policy.
         * </p>
         * 
         * @param enabled
         *        A Boolean that determines whether CloudFront adds the <code>Server-Timing</code> header to HTTP
         *        responses that it sends in response to requests that match a cache behavior that's associated with
         *        this response headers policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * A number 0–100 (inclusive) that specifies the percentage of responses that you want CloudFront to add the
         * <code>Server-Timing</code> header to. When you set the sampling rate to 100, CloudFront adds the
         * <code>Server-Timing</code> header to the HTTP response for every request that matches the cache behavior that
         * this response headers policy is attached to. When you set it to 50, CloudFront adds the header to 50% of the
         * responses for requests that match the cache behavior. You can set the sampling rate to any number 0–100 with
         * up to four decimal places.
         * </p>
         * 
         * @param samplingRate
         *        A number 0–100 (inclusive) that specifies the percentage of responses that you want CloudFront to add
         *        the <code>Server-Timing</code> header to. When you set the sampling rate to 100, CloudFront adds the
         *        <code>Server-Timing</code> header to the HTTP response for every request that matches the cache
         *        behavior that this response headers policy is attached to. When you set it to 50, CloudFront adds the
         *        header to 50% of the responses for requests that match the cache behavior. You can set the sampling
         *        rate to any number 0–100 with up to four decimal places.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samplingRate(Double samplingRate);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private Double samplingRate;

        private BuilderImpl() {
        }

        private BuilderImpl(ResponseHeadersPolicyServerTimingHeadersConfig model) {
            enabled(model.enabled);
            samplingRate(model.samplingRate);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Double getSamplingRate() {
            return samplingRate;
        }

        public final void setSamplingRate(Double samplingRate) {
            this.samplingRate = samplingRate;
        }

        @Override
        public final Builder samplingRate(Double samplingRate) {
            this.samplingRate = samplingRate;
            return this;
        }

        @Override
        public ResponseHeadersPolicyServerTimingHeadersConfig build() {
            return new ResponseHeadersPolicyServerTimingHeadersConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
