/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDistributionWithStagingConfigRequest extends CloudFrontRequest implements
        ToCopyableBuilder<UpdateDistributionWithStagingConfigRequest.Builder, UpdateDistributionWithStagingConfigRequest> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(UpdateDistributionWithStagingConfigRequest::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> STAGING_DISTRIBUTION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StagingDistributionId")
            .getter(getter(UpdateDistributionWithStagingConfigRequest::stagingDistributionId))
            .setter(setter(Builder::stagingDistributionId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("StagingDistributionId")
                    .unmarshallLocationName("StagingDistributionId").build()).build();

    private static final SdkField<String> IF_MATCH_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IfMatch")
            .getter(getter(UpdateDistributionWithStagingConfigRequest::ifMatch))
            .setter(setter(Builder::ifMatch))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match")
                    .unmarshallLocationName("If-Match").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            STAGING_DISTRIBUTION_ID_FIELD, IF_MATCH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String stagingDistributionId;

    private final String ifMatch;

    private UpdateDistributionWithStagingConfigRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.stagingDistributionId = builder.stagingDistributionId;
        this.ifMatch = builder.ifMatch;
    }

    /**
     * <p>
     * The identifier of the primary distribution to which you are copying a staging distribution's configuration.
     * </p>
     * 
     * @return The identifier of the primary distribution to which you are copying a staging distribution's
     *         configuration.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The identifier of the staging distribution whose configuration you are copying to the primary distribution.
     * </p>
     * 
     * @return The identifier of the staging distribution whose configuration you are copying to the primary
     *         distribution.
     */
    public final String stagingDistributionId() {
        return stagingDistributionId;
    }

    /**
     * <p>
     * The current versions (<code>ETag</code> values) of both primary and staging distributions. Provide these in the
     * following format:
     * </p>
     * <p>
     * <code>&lt;primary ETag&gt;, &lt;staging ETag&gt;</code>
     * </p>
     * 
     * @return The current versions (<code>ETag</code> values) of both primary and staging distributions. Provide these
     *         in the following format:</p>
     *         <p>
     *         <code>&lt;primary ETag&gt;, &lt;staging ETag&gt;</code>
     */
    public final String ifMatch() {
        return ifMatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(stagingDistributionId());
        hashCode = 31 * hashCode + Objects.hashCode(ifMatch());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDistributionWithStagingConfigRequest)) {
            return false;
        }
        UpdateDistributionWithStagingConfigRequest other = (UpdateDistributionWithStagingConfigRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(stagingDistributionId(), other.stagingDistributionId())
                && Objects.equals(ifMatch(), other.ifMatch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDistributionWithStagingConfigRequest").add("Id", id())
                .add("StagingDistributionId", stagingDistributionId()).add("IfMatch", ifMatch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "StagingDistributionId":
            return Optional.ofNullable(clazz.cast(stagingDistributionId()));
        case "IfMatch":
            return Optional.ofNullable(clazz.cast(ifMatch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("StagingDistributionId", STAGING_DISTRIBUTION_ID_FIELD);
        map.put("If-Match", IF_MATCH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDistributionWithStagingConfigRequest, T> g) {
        return obj -> g.apply((UpdateDistributionWithStagingConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDistributionWithStagingConfigRequest> {
        /**
         * <p>
         * The identifier of the primary distribution to which you are copying a staging distribution's configuration.
         * </p>
         * 
         * @param id
         *        The identifier of the primary distribution to which you are copying a staging distribution's
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The identifier of the staging distribution whose configuration you are copying to the primary distribution.
         * </p>
         * 
         * @param stagingDistributionId
         *        The identifier of the staging distribution whose configuration you are copying to the primary
         *        distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stagingDistributionId(String stagingDistributionId);

        /**
         * <p>
         * The current versions (<code>ETag</code> values) of both primary and staging distributions. Provide these in
         * the following format:
         * </p>
         * <p>
         * <code>&lt;primary ETag&gt;, &lt;staging ETag&gt;</code>
         * </p>
         * 
         * @param ifMatch
         *        The current versions (<code>ETag</code> values) of both primary and staging distributions. Provide
         *        these in the following format:</p>
         *        <p>
         *        <code>&lt;primary ETag&gt;, &lt;staging ETag&gt;</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifMatch(String ifMatch);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private String id;

        private String stagingDistributionId;

        private String ifMatch;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDistributionWithStagingConfigRequest model) {
            super(model);
            id(model.id);
            stagingDistributionId(model.stagingDistributionId);
            ifMatch(model.ifMatch);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStagingDistributionId() {
            return stagingDistributionId;
        }

        public final void setStagingDistributionId(String stagingDistributionId) {
            this.stagingDistributionId = stagingDistributionId;
        }

        @Override
        public final Builder stagingDistributionId(String stagingDistributionId) {
            this.stagingDistributionId = stagingDistributionId;
            return this;
        }

        public final String getIfMatch() {
            return ifMatch;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDistributionWithStagingConfigRequest build() {
            return new UpdateDistributionWithStagingConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
