/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An Amazon CloudFront VPC origin endpoint configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcOriginEndpointConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcOriginEndpointConfig.Builder, VpcOriginEndpointConfig> {
    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(VpcOriginEndpointConfig::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Arn")
            .getter(getter(VpcOriginEndpointConfig::arn))
            .setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").unmarshallLocationName("Arn")
                    .build()).build();

    private static final SdkField<Integer> HTTP_PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("HTTPPort")
            .getter(getter(VpcOriginEndpointConfig::httpPort))
            .setter(setter(Builder::httpPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HTTPPort")
                    .unmarshallLocationName("HTTPPort").build()).build();

    private static final SdkField<Integer> HTTPS_PORT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("HTTPSPort")
            .getter(getter(VpcOriginEndpointConfig::httpsPort))
            .setter(setter(Builder::httpsPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HTTPSPort")
                    .unmarshallLocationName("HTTPSPort").build()).build();

    private static final SdkField<String> ORIGIN_PROTOCOL_POLICY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OriginProtocolPolicy")
            .getter(getter(VpcOriginEndpointConfig::originProtocolPolicyAsString))
            .setter(setter(Builder::originProtocolPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginProtocolPolicy")
                    .unmarshallLocationName("OriginProtocolPolicy").build()).build();

    private static final SdkField<OriginSslProtocols> ORIGIN_SSL_PROTOCOLS_FIELD = SdkField
            .<OriginSslProtocols> builder(MarshallingType.SDK_POJO)
            .memberName("OriginSslProtocols")
            .getter(getter(VpcOriginEndpointConfig::originSslProtocols))
            .setter(setter(Builder::originSslProtocols))
            .constructor(OriginSslProtocols::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginSslProtocols")
                    .unmarshallLocationName("OriginSslProtocols").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            HTTP_PORT_FIELD, HTTPS_PORT_FIELD, ORIGIN_PROTOCOL_POLICY_FIELD, ORIGIN_SSL_PROTOCOLS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String arn;

    private final Integer httpPort;

    private final Integer httpsPort;

    private final String originProtocolPolicy;

    private final OriginSslProtocols originSslProtocols;

    private VpcOriginEndpointConfig(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.httpPort = builder.httpPort;
        this.httpsPort = builder.httpsPort;
        this.originProtocolPolicy = builder.originProtocolPolicy;
        this.originSslProtocols = builder.originSslProtocols;
    }

    /**
     * <p>
     * The name of the CloudFront VPC origin endpoint configuration.
     * </p>
     * 
     * @return The name of the CloudFront VPC origin endpoint configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of the CloudFront VPC origin endpoint configuration.
     * </p>
     * 
     * @return The ARN of the CloudFront VPC origin endpoint configuration.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The HTTP port for the CloudFront VPC origin endpoint configuration.
     * </p>
     * 
     * @return The HTTP port for the CloudFront VPC origin endpoint configuration.
     */
    public final Integer httpPort() {
        return httpPort;
    }

    /**
     * <p>
     * The HTTPS port of the CloudFront VPC origin endpoint configuration.
     * </p>
     * 
     * @return The HTTPS port of the CloudFront VPC origin endpoint configuration.
     */
    public final Integer httpsPort() {
        return httpsPort;
    }

    /**
     * <p>
     * The origin protocol policy for the CloudFront VPC origin endpoint configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #originProtocolPolicy} will return {@link OriginProtocolPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #originProtocolPolicyAsString}.
     * </p>
     * 
     * @return The origin protocol policy for the CloudFront VPC origin endpoint configuration.
     * @see OriginProtocolPolicy
     */
    public final OriginProtocolPolicy originProtocolPolicy() {
        return OriginProtocolPolicy.fromValue(originProtocolPolicy);
    }

    /**
     * <p>
     * The origin protocol policy for the CloudFront VPC origin endpoint configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #originProtocolPolicy} will return {@link OriginProtocolPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #originProtocolPolicyAsString}.
     * </p>
     * 
     * @return The origin protocol policy for the CloudFront VPC origin endpoint configuration.
     * @see OriginProtocolPolicy
     */
    public final String originProtocolPolicyAsString() {
        return originProtocolPolicy;
    }

    /**
     * Returns the value of the OriginSslProtocols property for this object.
     * 
     * @return The value of the OriginSslProtocols property for this object.
     */
    public final OriginSslProtocols originSslProtocols() {
        return originSslProtocols;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(httpPort());
        hashCode = 31 * hashCode + Objects.hashCode(httpsPort());
        hashCode = 31 * hashCode + Objects.hashCode(originProtocolPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(originSslProtocols());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcOriginEndpointConfig)) {
            return false;
        }
        VpcOriginEndpointConfig other = (VpcOriginEndpointConfig) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(httpPort(), other.httpPort()) && Objects.equals(httpsPort(), other.httpsPort())
                && Objects.equals(originProtocolPolicyAsString(), other.originProtocolPolicyAsString())
                && Objects.equals(originSslProtocols(), other.originSslProtocols());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcOriginEndpointConfig").add("Name", name()).add("Arn", arn()).add("HTTPPort", httpPort())
                .add("HTTPSPort", httpsPort()).add("OriginProtocolPolicy", originProtocolPolicyAsString())
                .add("OriginSslProtocols", originSslProtocols()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "HTTPPort":
            return Optional.ofNullable(clazz.cast(httpPort()));
        case "HTTPSPort":
            return Optional.ofNullable(clazz.cast(httpsPort()));
        case "OriginProtocolPolicy":
            return Optional.ofNullable(clazz.cast(originProtocolPolicyAsString()));
        case "OriginSslProtocols":
            return Optional.ofNullable(clazz.cast(originSslProtocols()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("HTTPPort", HTTP_PORT_FIELD);
        map.put("HTTPSPort", HTTPS_PORT_FIELD);
        map.put("OriginProtocolPolicy", ORIGIN_PROTOCOL_POLICY_FIELD);
        map.put("OriginSslProtocols", ORIGIN_SSL_PROTOCOLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcOriginEndpointConfig, T> g) {
        return obj -> g.apply((VpcOriginEndpointConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcOriginEndpointConfig> {
        /**
         * <p>
         * The name of the CloudFront VPC origin endpoint configuration.
         * </p>
         * 
         * @param name
         *        The name of the CloudFront VPC origin endpoint configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of the CloudFront VPC origin endpoint configuration.
         * </p>
         * 
         * @param arn
         *        The ARN of the CloudFront VPC origin endpoint configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The HTTP port for the CloudFront VPC origin endpoint configuration.
         * </p>
         * 
         * @param httpPort
         *        The HTTP port for the CloudFront VPC origin endpoint configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpPort(Integer httpPort);

        /**
         * <p>
         * The HTTPS port of the CloudFront VPC origin endpoint configuration.
         * </p>
         * 
         * @param httpsPort
         *        The HTTPS port of the CloudFront VPC origin endpoint configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpsPort(Integer httpsPort);

        /**
         * <p>
         * The origin protocol policy for the CloudFront VPC origin endpoint configuration.
         * </p>
         * 
         * @param originProtocolPolicy
         *        The origin protocol policy for the CloudFront VPC origin endpoint configuration.
         * @see OriginProtocolPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginProtocolPolicy
         */
        Builder originProtocolPolicy(String originProtocolPolicy);

        /**
         * <p>
         * The origin protocol policy for the CloudFront VPC origin endpoint configuration.
         * </p>
         * 
         * @param originProtocolPolicy
         *        The origin protocol policy for the CloudFront VPC origin endpoint configuration.
         * @see OriginProtocolPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginProtocolPolicy
         */
        Builder originProtocolPolicy(OriginProtocolPolicy originProtocolPolicy);

        /**
         * Sets the value of the OriginSslProtocols property for this object.
         *
         * @param originSslProtocols
         *        The new value for the OriginSslProtocols property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originSslProtocols(OriginSslProtocols originSslProtocols);

        /**
         * Sets the value of the OriginSslProtocols property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OriginSslProtocols.Builder} avoiding the
         * need to create one manually via {@link OriginSslProtocols#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OriginSslProtocols.Builder#build()} is called immediately and its
         * result is passed to {@link #originSslProtocols(OriginSslProtocols)}.
         * 
         * @param originSslProtocols
         *        a consumer that will call methods on {@link OriginSslProtocols.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #originSslProtocols(OriginSslProtocols)
         */
        default Builder originSslProtocols(Consumer<OriginSslProtocols.Builder> originSslProtocols) {
            return originSslProtocols(OriginSslProtocols.builder().applyMutation(originSslProtocols).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private Integer httpPort;

        private Integer httpsPort;

        private String originProtocolPolicy;

        private OriginSslProtocols originSslProtocols;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcOriginEndpointConfig model) {
            name(model.name);
            arn(model.arn);
            httpPort(model.httpPort);
            httpsPort(model.httpsPort);
            originProtocolPolicy(model.originProtocolPolicy);
            originSslProtocols(model.originSslProtocols);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Integer getHttpPort() {
            return httpPort;
        }

        public final void setHttpPort(Integer httpPort) {
            this.httpPort = httpPort;
        }

        @Override
        public final Builder httpPort(Integer httpPort) {
            this.httpPort = httpPort;
            return this;
        }

        public final Integer getHttpsPort() {
            return httpsPort;
        }

        public final void setHttpsPort(Integer httpsPort) {
            this.httpsPort = httpsPort;
        }

        @Override
        public final Builder httpsPort(Integer httpsPort) {
            this.httpsPort = httpsPort;
            return this;
        }

        public final String getOriginProtocolPolicy() {
            return originProtocolPolicy;
        }

        public final void setOriginProtocolPolicy(String originProtocolPolicy) {
            this.originProtocolPolicy = originProtocolPolicy;
        }

        @Override
        public final Builder originProtocolPolicy(String originProtocolPolicy) {
            this.originProtocolPolicy = originProtocolPolicy;
            return this;
        }

        @Override
        public final Builder originProtocolPolicy(OriginProtocolPolicy originProtocolPolicy) {
            this.originProtocolPolicy(originProtocolPolicy == null ? null : originProtocolPolicy.toString());
            return this;
        }

        public final OriginSslProtocols.Builder getOriginSslProtocols() {
            return originSslProtocols != null ? originSslProtocols.toBuilder() : null;
        }

        public final void setOriginSslProtocols(OriginSslProtocols.BuilderImpl originSslProtocols) {
            this.originSslProtocols = originSslProtocols != null ? originSslProtocols.build() : null;
        }

        @Override
        public final Builder originSslProtocols(OriginSslProtocols originSslProtocols) {
            this.originSslProtocols = originSslProtocols;
            return this;
        }

        @Override
        public VpcOriginEndpointConfig build() {
            return new VpcOriginEndpointConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
