/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.internal.cookie;

import java.net.URI;
import java.util.Objects;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.services.cloudfront.cookie.CookiesForCannedPolicy;
import software.amazon.awssdk.utils.ToString;

@Immutable
@ThreadSafe
@SdkInternalApi
public final class DefaultCookiesForCannedPolicy
implements CookiesForCannedPolicy {
    private final String resourceUrl;
    private final String keyPairIdHeaderValue;
    private final String signatureHeaderValue;
    private final String expiresHeaderValue;

    private DefaultCookiesForCannedPolicy(DefaultBuilder builder) {
        this.resourceUrl = builder.resourceUrl;
        this.keyPairIdHeaderValue = builder.keyPairIdHeaderValue;
        this.signatureHeaderValue = builder.signatureHeaderValue;
        this.expiresHeaderValue = builder.expiresHeaderValue;
    }

    public static CookiesForCannedPolicy.Builder builder() {
        return new DefaultBuilder();
    }

    public CookiesForCannedPolicy.Builder toBuilder() {
        return new DefaultBuilder(this);
    }

    public String toString() {
        return ToString.builder((String)"DefaultCookiesForCannedPolicy").add("resourceUrl", (Object)this.resourceUrl).add("signatureHeaderValue", (Object)this.signatureHeaderValue).add("keyPairIdHeaderValue", (Object)this.keyPairIdHeaderValue).add("expiresHeaderValue", (Object)this.expiresHeaderValue).build();
    }

    @Override
    public String resourceUrl() {
        return this.resourceUrl;
    }

    @Override
    public SdkHttpRequest createHttpGetRequest() {
        return (SdkHttpRequest)SdkHttpRequest.builder().uri(URI.create(this.resourceUrl)).appendHeader("Cookie", this.signatureHeaderValue()).appendHeader("Cookie", this.keyPairIdHeaderValue()).appendHeader("Cookie", this.expiresHeaderValue()).method(SdkHttpMethod.GET).build();
    }

    @Override
    public String signatureHeaderValue() {
        return this.signatureHeaderValue;
    }

    @Override
    public String keyPairIdHeaderValue() {
        return this.keyPairIdHeaderValue;
    }

    @Override
    public String expiresHeaderValue() {
        return this.expiresHeaderValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultCookiesForCannedPolicy cookie = (DefaultCookiesForCannedPolicy)o;
        return Objects.equals(this.keyPairIdHeaderValue, cookie.keyPairIdHeaderValue) && Objects.equals(this.signatureHeaderValue, cookie.signatureHeaderValue) && Objects.equals(this.resourceUrl, cookie.resourceUrl) && Objects.equals(this.expiresHeaderValue, cookie.expiresHeaderValue);
    }

    public int hashCode() {
        int result = this.keyPairIdHeaderValue != null ? this.keyPairIdHeaderValue.hashCode() : 0;
        result = 31 * result + (this.signatureHeaderValue != null ? this.signatureHeaderValue.hashCode() : 0);
        result = 31 * result + (this.resourceUrl != null ? this.resourceUrl.hashCode() : 0);
        result = 31 * result + (this.expiresHeaderValue != null ? this.expiresHeaderValue.hashCode() : 0);
        return result;
    }

    private static final class DefaultBuilder
    implements CookiesForCannedPolicy.Builder {
        private String resourceUrl;
        private String signatureHeaderValue;
        private String keyPairIdHeaderValue;
        private String expiresHeaderValue;

        private DefaultBuilder() {
        }

        private DefaultBuilder(DefaultCookiesForCannedPolicy cookies) {
            this.resourceUrl = cookies.resourceUrl;
            this.signatureHeaderValue = cookies.signatureHeaderValue;
            this.keyPairIdHeaderValue = cookies.keyPairIdHeaderValue;
            this.expiresHeaderValue = cookies.expiresHeaderValue;
        }

        @Override
        public CookiesForCannedPolicy.Builder resourceUrl(String resourceUrl) {
            this.resourceUrl = resourceUrl;
            return this;
        }

        @Override
        public CookiesForCannedPolicy.Builder signatureHeaderValue(String signatureHeaderValue) {
            this.signatureHeaderValue = signatureHeaderValue;
            return this;
        }

        @Override
        public CookiesForCannedPolicy.Builder keyPairIdHeaderValue(String keyPairIdHeaderValue) {
            this.keyPairIdHeaderValue = keyPairIdHeaderValue;
            return this;
        }

        @Override
        public CookiesForCannedPolicy.Builder expiresHeaderValue(String expiresHeaderValue) {
            this.expiresHeaderValue = expiresHeaderValue;
            return this;
        }

        public DefaultCookiesForCannedPolicy build() {
            return new DefaultCookiesForCannedPolicy(this);
        }
    }
}

