/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.ActiveTrustedSigners;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamingDistribution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StreamingDistribution> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(StreamingDistribution.getter(StreamingDistribution::id)).setter(StreamingDistribution.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARN").getter(StreamingDistribution.getter(StreamingDistribution::arn)).setter(StreamingDistribution.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").unmarshallLocationName("ARN").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(StreamingDistribution.getter(StreamingDistribution::status)).setter(StreamingDistribution.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("Status").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(StreamingDistribution.getter(StreamingDistribution::lastModifiedTime)).setter(StreamingDistribution.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").unmarshallLocationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(StreamingDistribution.getter(StreamingDistribution::domainName)).setter(StreamingDistribution.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").unmarshallLocationName("DomainName").build()}).build();
    private static final SdkField<ActiveTrustedSigners> ACTIVE_TRUSTED_SIGNERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ActiveTrustedSigners").getter(StreamingDistribution.getter(StreamingDistribution::activeTrustedSigners)).setter(StreamingDistribution.setter(Builder::activeTrustedSigners)).constructor(ActiveTrustedSigners::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveTrustedSigners").unmarshallLocationName("ActiveTrustedSigners").build()}).build();
    private static final SdkField<StreamingDistributionConfig> STREAMING_DISTRIBUTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StreamingDistributionConfig").getter(StreamingDistribution.getter(StreamingDistribution::streamingDistributionConfig)).setter(StreamingDistribution.setter(Builder::streamingDistributionConfig)).constructor(StreamingDistributionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamingDistributionConfig").unmarshallLocationName("StreamingDistributionConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, STATUS_FIELD, LAST_MODIFIED_TIME_FIELD, DOMAIN_NAME_FIELD, ACTIVE_TRUSTED_SIGNERS_FIELD, STREAMING_DISTRIBUTION_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StreamingDistribution.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String status;
    private final Instant lastModifiedTime;
    private final String domainName;
    private final ActiveTrustedSigners activeTrustedSigners;
    private final StreamingDistributionConfig streamingDistributionConfig;

    private StreamingDistribution(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.status = builder.status;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.domainName = builder.domainName;
        this.activeTrustedSigners = builder.activeTrustedSigners;
        this.streamingDistributionConfig = builder.streamingDistributionConfig;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String status() {
        return this.status;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final ActiveTrustedSigners activeTrustedSigners() {
        return this.activeTrustedSigners;
    }

    public final StreamingDistributionConfig streamingDistributionConfig() {
        return this.streamingDistributionConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeTrustedSigners());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamingDistributionConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingDistribution)) {
            return false;
        }
        StreamingDistribution other = (StreamingDistribution)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.activeTrustedSigners(), other.activeTrustedSigners()) && Objects.equals(this.streamingDistributionConfig(), other.streamingDistributionConfig());
    }

    public final String toString() {
        return ToString.builder((String)"StreamingDistribution").add("Id", (Object)this.id()).add("ARN", (Object)this.arn()).add("Status", (Object)this.status()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("DomainName", (Object)this.domainName()).add("ActiveTrustedSigners", (Object)this.activeTrustedSigners()).add("StreamingDistributionConfig", (Object)this.streamingDistributionConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "ActiveTrustedSigners": {
                return Optional.ofNullable(clazz.cast(this.activeTrustedSigners()));
            }
            case "StreamingDistributionConfig": {
                return Optional.ofNullable(clazz.cast(this.streamingDistributionConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("ARN", ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("ActiveTrustedSigners", ACTIVE_TRUSTED_SIGNERS_FIELD);
        map.put("StreamingDistributionConfig", STREAMING_DISTRIBUTION_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StreamingDistribution, T> g) {
        return obj -> g.apply((StreamingDistribution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String status;
        private Instant lastModifiedTime;
        private String domainName;
        private ActiveTrustedSigners activeTrustedSigners;
        private StreamingDistributionConfig streamingDistributionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingDistribution model) {
            this.id(model.id);
            this.arn(model.arn);
            this.status(model.status);
            this.lastModifiedTime(model.lastModifiedTime);
            this.domainName(model.domainName);
            this.activeTrustedSigners(model.activeTrustedSigners);
            this.streamingDistributionConfig(model.streamingDistributionConfig);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final ActiveTrustedSigners.Builder getActiveTrustedSigners() {
            return this.activeTrustedSigners != null ? this.activeTrustedSigners.toBuilder() : null;
        }

        public final void setActiveTrustedSigners(ActiveTrustedSigners.BuilderImpl activeTrustedSigners) {
            this.activeTrustedSigners = activeTrustedSigners != null ? activeTrustedSigners.build() : null;
        }

        @Override
        public final Builder activeTrustedSigners(ActiveTrustedSigners activeTrustedSigners) {
            this.activeTrustedSigners = activeTrustedSigners;
            return this;
        }

        public final StreamingDistributionConfig.Builder getStreamingDistributionConfig() {
            return this.streamingDistributionConfig != null ? this.streamingDistributionConfig.toBuilder() : null;
        }

        public final void setStreamingDistributionConfig(StreamingDistributionConfig.BuilderImpl streamingDistributionConfig) {
            this.streamingDistributionConfig = streamingDistributionConfig != null ? streamingDistributionConfig.build() : null;
        }

        @Override
        public final Builder streamingDistributionConfig(StreamingDistributionConfig streamingDistributionConfig) {
            this.streamingDistributionConfig = streamingDistributionConfig;
            return this;
        }

        public StreamingDistribution build() {
            return new StreamingDistribution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StreamingDistribution> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder domainName(String var1);

        public Builder activeTrustedSigners(ActiveTrustedSigners var1);

        default public Builder activeTrustedSigners(Consumer<ActiveTrustedSigners.Builder> activeTrustedSigners) {
            return this.activeTrustedSigners((ActiveTrustedSigners)((ActiveTrustedSigners.Builder)ActiveTrustedSigners.builder().applyMutation(activeTrustedSigners)).build());
        }

        public Builder streamingDistributionConfig(StreamingDistributionConfig var1);

        default public Builder streamingDistributionConfig(Consumer<StreamingDistributionConfig.Builder> streamingDistributionConfig) {
            return this.streamingDistributionConfig((StreamingDistributionConfig)((StreamingDistributionConfig.Builder)StreamingDistributionConfig.builder().applyMutation(streamingDistributionConfig)).build());
        }
    }
}

