/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.Customizations;
import software.amazon.awssdk.services.cloudfront.model.DomainResult;
import software.amazon.awssdk.services.cloudfront.model.DomainResultListCopier;
import software.amazon.awssdk.services.cloudfront.model.Parameter;
import software.amazon.awssdk.services.cloudfront.model.ParametersCopier;
import software.amazon.awssdk.services.cloudfront.model.Tags;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DistributionTenant
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DistributionTenant> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(DistributionTenant.getter(DistributionTenant::id)).setter(DistributionTenant.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<String> DISTRIBUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DistributionId").getter(DistributionTenant.getter(DistributionTenant::distributionId)).setter(DistributionTenant.setter(Builder::distributionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistributionId").unmarshallLocationName("DistributionId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DistributionTenant.getter(DistributionTenant::name)).setter(DistributionTenant.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DistributionTenant.getter(DistributionTenant::arn)).setter(DistributionTenant.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").unmarshallLocationName("Arn").build()}).build();
    private static final SdkField<List<DomainResult>> DOMAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Domains").getter(DistributionTenant.getter(DistributionTenant::domains)).setter(DistributionTenant.setter(Builder::domains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domains").unmarshallLocationName("Domains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<Tags> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Tags").getter(DistributionTenant.getter(DistributionTenant::tags)).setter(DistributionTenant.setter(Builder::tags)).constructor(Tags::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").unmarshallLocationName("Tags").build()}).build();
    private static final SdkField<Customizations> CUSTOMIZATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Customizations").getter(DistributionTenant.getter(DistributionTenant::customizations)).setter(DistributionTenant.setter(Builder::customizations)).constructor(Customizations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Customizations").unmarshallLocationName("Customizations").build()}).build();
    private static final SdkField<List<Parameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Parameters").getter(DistributionTenant.getter(DistributionTenant::parameters)).setter(DistributionTenant.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").unmarshallLocationName("Parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Parameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONNECTION_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionGroupId").getter(DistributionTenant.getter(DistributionTenant::connectionGroupId)).setter(DistributionTenant.setter(Builder::connectionGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionGroupId").unmarshallLocationName("ConnectionGroupId").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(DistributionTenant.getter(DistributionTenant::createdTime)).setter(DistributionTenant.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").unmarshallLocationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DistributionTenant.getter(DistributionTenant::lastModifiedTime)).setter(DistributionTenant.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").unmarshallLocationName("LastModifiedTime").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(DistributionTenant.getter(DistributionTenant::enabled)).setter(DistributionTenant.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").unmarshallLocationName("Enabled").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DistributionTenant.getter(DistributionTenant::status)).setter(DistributionTenant.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DISTRIBUTION_ID_FIELD, NAME_FIELD, ARN_FIELD, DOMAINS_FIELD, TAGS_FIELD, CUSTOMIZATIONS_FIELD, PARAMETERS_FIELD, CONNECTION_GROUP_ID_FIELD, CREATED_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, ENABLED_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DistributionTenant.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String distributionId;
    private final String name;
    private final String arn;
    private final List<DomainResult> domains;
    private final Tags tags;
    private final Customizations customizations;
    private final List<Parameter> parameters;
    private final String connectionGroupId;
    private final Instant createdTime;
    private final Instant lastModifiedTime;
    private final Boolean enabled;
    private final String status;

    private DistributionTenant(BuilderImpl builder) {
        this.id = builder.id;
        this.distributionId = builder.distributionId;
        this.name = builder.name;
        this.arn = builder.arn;
        this.domains = builder.domains;
        this.tags = builder.tags;
        this.customizations = builder.customizations;
        this.parameters = builder.parameters;
        this.connectionGroupId = builder.connectionGroupId;
        this.createdTime = builder.createdTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.enabled = builder.enabled;
        this.status = builder.status;
    }

    public final String id() {
        return this.id;
    }

    public final String distributionId() {
        return this.distributionId;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasDomains() {
        return this.domains != null && !(this.domains instanceof SdkAutoConstructList);
    }

    public final List<DomainResult> domains() {
        return this.domains;
    }

    public final Tags tags() {
        return this.tags;
    }

    public final Customizations customizations() {
        return this.customizations;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<Parameter> parameters() {
        return this.parameters;
    }

    public final String connectionGroupId() {
        return this.connectionGroupId;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.distributionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomains() ? this.domains() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.customizations());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DistributionTenant)) {
            return false;
        }
        DistributionTenant other = (DistributionTenant)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.distributionId(), other.distributionId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && this.hasDomains() == other.hasDomains() && Objects.equals(this.domains(), other.domains()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.customizations(), other.customizations()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.connectionGroupId(), other.connectionGroupId()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"DistributionTenant").add("Id", (Object)this.id()).add("DistributionId", (Object)this.distributionId()).add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("Domains", this.hasDomains() ? this.domains() : null).add("Tags", (Object)this.tags()).add("Customizations", (Object)this.customizations()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("ConnectionGroupId", (Object)this.connectionGroupId()).add("CreatedTime", (Object)this.createdTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("Enabled", (Object)this.enabled()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "DistributionId": {
                return Optional.ofNullable(clazz.cast(this.distributionId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Domains": {
                return Optional.ofNullable(clazz.cast(this.domains()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Customizations": {
                return Optional.ofNullable(clazz.cast(this.customizations()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "ConnectionGroupId": {
                return Optional.ofNullable(clazz.cast(this.connectionGroupId()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("DistributionId", DISTRIBUTION_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Domains", DOMAINS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("Customizations", CUSTOMIZATIONS_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("ConnectionGroupId", CONNECTION_GROUP_ID_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("Enabled", ENABLED_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DistributionTenant, T> g) {
        return obj -> g.apply((DistributionTenant)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String distributionId;
        private String name;
        private String arn;
        private List<DomainResult> domains = DefaultSdkAutoConstructList.getInstance();
        private Tags tags;
        private Customizations customizations;
        private List<Parameter> parameters = DefaultSdkAutoConstructList.getInstance();
        private String connectionGroupId;
        private Instant createdTime;
        private Instant lastModifiedTime;
        private Boolean enabled;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DistributionTenant model) {
            this.id(model.id);
            this.distributionId(model.distributionId);
            this.name(model.name);
            this.arn(model.arn);
            this.domains(model.domains);
            this.tags(model.tags);
            this.customizations(model.customizations);
            this.parameters(model.parameters);
            this.connectionGroupId(model.connectionGroupId);
            this.createdTime(model.createdTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.enabled(model.enabled);
            this.status(model.status);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDistributionId() {
            return this.distributionId;
        }

        public final void setDistributionId(String distributionId) {
            this.distributionId = distributionId;
        }

        @Override
        public final Builder distributionId(String distributionId) {
            this.distributionId = distributionId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final List<DomainResult.Builder> getDomains() {
            List<DomainResult.Builder> result = DomainResultListCopier.copyToBuilder(this.domains);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomains(Collection<DomainResult.BuilderImpl> domains) {
            this.domains = DomainResultListCopier.copyFromBuilder(domains);
        }

        @Override
        public final Builder domains(Collection<DomainResult> domains) {
            this.domains = DomainResultListCopier.copy(domains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(DomainResult ... domains) {
            this.domains(Arrays.asList(domains));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(Consumer<DomainResult.Builder> ... domains) {
            this.domains(Stream.of(domains).map(c -> (DomainResult)((DomainResult.Builder)DomainResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Tags.Builder getTags() {
            return this.tags != null ? this.tags.toBuilder() : null;
        }

        public final void setTags(Tags.BuilderImpl tags) {
            this.tags = tags != null ? tags.build() : null;
        }

        @Override
        public final Builder tags(Tags tags) {
            this.tags = tags;
            return this;
        }

        public final Customizations.Builder getCustomizations() {
            return this.customizations != null ? this.customizations.toBuilder() : null;
        }

        public final void setCustomizations(Customizations.BuilderImpl customizations) {
            this.customizations = customizations != null ? customizations.build() : null;
        }

        @Override
        public final Builder customizations(Customizations customizations) {
            this.customizations = customizations;
            return this;
        }

        public final List<Parameter.Builder> getParameters() {
            List<Parameter.Builder> result = ParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<Parameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (Parameter)((Parameter.Builder)Parameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getConnectionGroupId() {
            return this.connectionGroupId;
        }

        public final void setConnectionGroupId(String connectionGroupId) {
            this.connectionGroupId = connectionGroupId;
        }

        @Override
        public final Builder connectionGroupId(String connectionGroupId) {
            this.connectionGroupId = connectionGroupId;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public DistributionTenant build() {
            return new DistributionTenant(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DistributionTenant> {
        public Builder id(String var1);

        public Builder distributionId(String var1);

        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder domains(Collection<DomainResult> var1);

        public Builder domains(DomainResult ... var1);

        public Builder domains(Consumer<DomainResult.Builder> ... var1);

        public Builder tags(Tags var1);

        default public Builder tags(Consumer<Tags.Builder> tags) {
            return this.tags((Tags)((Tags.Builder)Tags.builder().applyMutation(tags)).build());
        }

        public Builder customizations(Customizations var1);

        default public Builder customizations(Consumer<Customizations.Builder> customizations) {
            return this.customizations((Customizations)((Customizations.Builder)Customizations.builder().applyMutation(customizations)).build());
        }

        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);

        public Builder parameters(Consumer<Parameter.Builder> ... var1);

        public Builder connectionGroupId(String var1);

        public Builder createdTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder enabled(Boolean var1);

        public Builder status(String var1);
    }
}

