/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontResponse;
import software.amazon.awssdk.services.cloudfront.model.ConnectionGroup;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConnectionGroupResponse
extends CloudFrontResponse
implements ToCopyableBuilder<Builder, GetConnectionGroupResponse> {
    private static final SdkField<ConnectionGroup> CONNECTION_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectionGroup").getter(GetConnectionGroupResponse.getter(GetConnectionGroupResponse::connectionGroup)).setter(GetConnectionGroupResponse.setter(Builder::connectionGroup)).constructor(ConnectionGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionGroup").unmarshallLocationName("ConnectionGroup").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(GetConnectionGroupResponse.getter(GetConnectionGroupResponse::eTag)).setter(GetConnectionGroupResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").unmarshallLocationName("ETag").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_GROUP_FIELD, E_TAG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetConnectionGroupResponse.memberNameToFieldInitializer();
    private final ConnectionGroup connectionGroup;
    private final String eTag;

    private GetConnectionGroupResponse(BuilderImpl builder) {
        super(builder);
        this.connectionGroup = builder.connectionGroup;
        this.eTag = builder.eTag;
    }

    public final ConnectionGroup connectionGroup() {
        return this.connectionGroup;
    }

    public final String eTag() {
        return this.eTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectionGroupResponse)) {
            return false;
        }
        GetConnectionGroupResponse other = (GetConnectionGroupResponse)((Object)obj);
        return Objects.equals(this.connectionGroup(), other.connectionGroup()) && Objects.equals(this.eTag(), other.eTag());
    }

    public final String toString() {
        return ToString.builder((String)"GetConnectionGroupResponse").add("ConnectionGroup", (Object)this.connectionGroup()).add("ETag", (Object)this.eTag()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionGroup": {
                return Optional.ofNullable(clazz.cast(this.connectionGroup()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConnectionGroup", CONNECTION_GROUP_FIELD);
        map.put("ETag", E_TAG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetConnectionGroupResponse, T> g) {
        return obj -> g.apply((GetConnectionGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontResponse.BuilderImpl
    implements Builder {
        private ConnectionGroup connectionGroup;
        private String eTag;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectionGroupResponse model) {
            super(model);
            this.connectionGroup(model.connectionGroup);
            this.eTag(model.eTag);
        }

        public final ConnectionGroup.Builder getConnectionGroup() {
            return this.connectionGroup != null ? this.connectionGroup.toBuilder() : null;
        }

        public final void setConnectionGroup(ConnectionGroup.BuilderImpl connectionGroup) {
            this.connectionGroup = connectionGroup != null ? connectionGroup.build() : null;
        }

        @Override
        public final Builder connectionGroup(ConnectionGroup connectionGroup) {
            this.connectionGroup = connectionGroup;
            return this;
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public GetConnectionGroupResponse build() {
            return new GetConnectionGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFrontResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConnectionGroupResponse> {
        public Builder connectionGroup(ConnectionGroup var1);

        default public Builder connectionGroup(Consumer<ConnectionGroup.Builder> connectionGroup) {
            return this.connectionGroup((ConnectionGroup)((ConnectionGroup.Builder)ConnectionGroup.builder().applyMutation(connectionGroup)).build());
        }

        public Builder eTag(String var1);
    }
}

