/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateConnectionGroupRequest
extends CloudFrontRequest
implements ToCopyableBuilder<Builder, UpdateConnectionGroupRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(UpdateConnectionGroupRequest.getter(UpdateConnectionGroupRequest::id)).setter(UpdateConnectionGroupRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<Boolean> IPV6_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Ipv6Enabled").getter(UpdateConnectionGroupRequest.getter(UpdateConnectionGroupRequest::ipv6Enabled)).setter(UpdateConnectionGroupRequest.setter(Builder::ipv6Enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Enabled").unmarshallLocationName("Ipv6Enabled").build()}).build();
    private static final SdkField<String> IF_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IfMatch").getter(UpdateConnectionGroupRequest.getter(UpdateConnectionGroupRequest::ifMatch)).setter(UpdateConnectionGroupRequest.setter(Builder::ifMatch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match").unmarshallLocationName("If-Match").build()}).build();
    private static final SdkField<String> ANYCAST_IP_LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnycastIpListId").getter(UpdateConnectionGroupRequest.getter(UpdateConnectionGroupRequest::anycastIpListId)).setter(UpdateConnectionGroupRequest.setter(Builder::anycastIpListId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnycastIpListId").unmarshallLocationName("AnycastIpListId").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(UpdateConnectionGroupRequest.getter(UpdateConnectionGroupRequest::enabled)).setter(UpdateConnectionGroupRequest.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").unmarshallLocationName("Enabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, IPV6_ENABLED_FIELD, IF_MATCH_FIELD, ANYCAST_IP_LIST_ID_FIELD, ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateConnectionGroupRequest.memberNameToFieldInitializer();
    private final String id;
    private final Boolean ipv6Enabled;
    private final String ifMatch;
    private final String anycastIpListId;
    private final Boolean enabled;

    private UpdateConnectionGroupRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.ipv6Enabled = builder.ipv6Enabled;
        this.ifMatch = builder.ifMatch;
        this.anycastIpListId = builder.anycastIpListId;
        this.enabled = builder.enabled;
    }

    public final String id() {
        return this.id;
    }

    public final Boolean ipv6Enabled() {
        return this.ipv6Enabled;
    }

    public final String ifMatch() {
        return this.ifMatch;
    }

    public final String anycastIpListId() {
        return this.anycastIpListId;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6Enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.ifMatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.anycastIpListId());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectionGroupRequest)) {
            return false;
        }
        UpdateConnectionGroupRequest other = (UpdateConnectionGroupRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.ipv6Enabled(), other.ipv6Enabled()) && Objects.equals(this.ifMatch(), other.ifMatch()) && Objects.equals(this.anycastIpListId(), other.anycastIpListId()) && Objects.equals(this.enabled(), other.enabled());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateConnectionGroupRequest").add("Id", (Object)this.id()).add("Ipv6Enabled", (Object)this.ipv6Enabled()).add("IfMatch", (Object)this.ifMatch()).add("AnycastIpListId", (Object)this.anycastIpListId()).add("Enabled", (Object)this.enabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Ipv6Enabled": {
                return Optional.ofNullable(clazz.cast(this.ipv6Enabled()));
            }
            case "IfMatch": {
                return Optional.ofNullable(clazz.cast(this.ifMatch()));
            }
            case "AnycastIpListId": {
                return Optional.ofNullable(clazz.cast(this.anycastIpListId()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("Ipv6Enabled", IPV6_ENABLED_FIELD);
        map.put("If-Match", IF_MATCH_FIELD);
        map.put("AnycastIpListId", ANYCAST_IP_LIST_ID_FIELD);
        map.put("Enabled", ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectionGroupRequest, T> g) {
        return obj -> g.apply((UpdateConnectionGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFrontRequest.BuilderImpl
    implements Builder {
        private String id;
        private Boolean ipv6Enabled;
        private String ifMatch;
        private String anycastIpListId;
        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectionGroupRequest model) {
            super(model);
            this.id(model.id);
            this.ipv6Enabled(model.ipv6Enabled);
            this.ifMatch(model.ifMatch);
            this.anycastIpListId(model.anycastIpListId);
            this.enabled(model.enabled);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Boolean getIpv6Enabled() {
            return this.ipv6Enabled;
        }

        public final void setIpv6Enabled(Boolean ipv6Enabled) {
            this.ipv6Enabled = ipv6Enabled;
        }

        @Override
        public final Builder ipv6Enabled(Boolean ipv6Enabled) {
            this.ipv6Enabled = ipv6Enabled;
            return this;
        }

        public final String getIfMatch() {
            return this.ifMatch;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final String getAnycastIpListId() {
            return this.anycastIpListId;
        }

        public final void setAnycastIpListId(String anycastIpListId) {
            this.anycastIpListId = anycastIpListId;
        }

        @Override
        public final Builder anycastIpListId(String anycastIpListId) {
            this.anycastIpListId = anycastIpListId;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConnectionGroupRequest build() {
            return new UpdateConnectionGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFrontRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateConnectionGroupRequest> {
        public Builder id(String var1);

        public Builder ipv6Enabled(Boolean var1);

        public Builder ifMatch(String var1);

        public Builder anycastIpListId(String var1);

        public Builder enabled(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

