/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.AliasICPRecordal;
import software.amazon.awssdk.services.cloudfront.model.AliasICPRecordalsCopier;
import software.amazon.awssdk.services.cloudfront.model.Aliases;
import software.amazon.awssdk.services.cloudfront.model.CacheBehaviors;
import software.amazon.awssdk.services.cloudfront.model.ConnectionMode;
import software.amazon.awssdk.services.cloudfront.model.CustomErrorResponses;
import software.amazon.awssdk.services.cloudfront.model.DefaultCacheBehavior;
import software.amazon.awssdk.services.cloudfront.model.HttpVersion;
import software.amazon.awssdk.services.cloudfront.model.OriginGroups;
import software.amazon.awssdk.services.cloudfront.model.Origins;
import software.amazon.awssdk.services.cloudfront.model.PriceClass;
import software.amazon.awssdk.services.cloudfront.model.Restrictions;
import software.amazon.awssdk.services.cloudfront.model.ViewerCertificate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DistributionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DistributionSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(DistributionSummary.getter(DistributionSummary::id)).setter(DistributionSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARN").getter(DistributionSummary.getter(DistributionSummary::arn)).setter(DistributionSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").unmarshallLocationName("ARN").build()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(DistributionSummary.getter(DistributionSummary::eTag)).setter(DistributionSummary.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ETag").unmarshallLocationName("ETag").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DistributionSummary.getter(DistributionSummary::status)).setter(DistributionSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("Status").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DistributionSummary.getter(DistributionSummary::lastModifiedTime)).setter(DistributionSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").unmarshallLocationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(DistributionSummary.getter(DistributionSummary::domainName)).setter(DistributionSummary.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").unmarshallLocationName("DomainName").build()}).build();
    private static final SdkField<Aliases> ALIASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Aliases").getter(DistributionSummary.getter(DistributionSummary::aliases)).setter(DistributionSummary.setter(Builder::aliases)).constructor(Aliases::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aliases").unmarshallLocationName("Aliases").build()}).build();
    private static final SdkField<Origins> ORIGINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Origins").getter(DistributionSummary.getter(DistributionSummary::origins)).setter(DistributionSummary.setter(Builder::origins)).constructor(Origins::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origins").unmarshallLocationName("Origins").build()}).build();
    private static final SdkField<OriginGroups> ORIGIN_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OriginGroups").getter(DistributionSummary.getter(DistributionSummary::originGroups)).setter(DistributionSummary.setter(Builder::originGroups)).constructor(OriginGroups::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginGroups").unmarshallLocationName("OriginGroups").build()}).build();
    private static final SdkField<DefaultCacheBehavior> DEFAULT_CACHE_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultCacheBehavior").getter(DistributionSummary.getter(DistributionSummary::defaultCacheBehavior)).setter(DistributionSummary.setter(Builder::defaultCacheBehavior)).constructor(DefaultCacheBehavior::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCacheBehavior").unmarshallLocationName("DefaultCacheBehavior").build()}).build();
    private static final SdkField<CacheBehaviors> CACHE_BEHAVIORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CacheBehaviors").getter(DistributionSummary.getter(DistributionSummary::cacheBehaviors)).setter(DistributionSummary.setter(Builder::cacheBehaviors)).constructor(CacheBehaviors::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheBehaviors").unmarshallLocationName("CacheBehaviors").build()}).build();
    private static final SdkField<CustomErrorResponses> CUSTOM_ERROR_RESPONSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomErrorResponses").getter(DistributionSummary.getter(DistributionSummary::customErrorResponses)).setter(DistributionSummary.setter(Builder::customErrorResponses)).constructor(CustomErrorResponses::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomErrorResponses").unmarshallLocationName("CustomErrorResponses").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Comment").getter(DistributionSummary.getter(DistributionSummary::comment)).setter(DistributionSummary.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").unmarshallLocationName("Comment").build()}).build();
    private static final SdkField<String> PRICE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PriceClass").getter(DistributionSummary.getter(DistributionSummary::priceClassAsString)).setter(DistributionSummary.setter(Builder::priceClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PriceClass").unmarshallLocationName("PriceClass").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(DistributionSummary.getter(DistributionSummary::enabled)).setter(DistributionSummary.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").unmarshallLocationName("Enabled").build()}).build();
    private static final SdkField<ViewerCertificate> VIEWER_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ViewerCertificate").getter(DistributionSummary.getter(DistributionSummary::viewerCertificate)).setter(DistributionSummary.setter(Builder::viewerCertificate)).constructor(ViewerCertificate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewerCertificate").unmarshallLocationName("ViewerCertificate").build()}).build();
    private static final SdkField<Restrictions> RESTRICTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Restrictions").getter(DistributionSummary.getter(DistributionSummary::restrictions)).setter(DistributionSummary.setter(Builder::restrictions)).constructor(Restrictions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Restrictions").unmarshallLocationName("Restrictions").build()}).build();
    private static final SdkField<String> WEB_ACL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebACLId").getter(DistributionSummary.getter(DistributionSummary::webACLId)).setter(DistributionSummary.setter(Builder::webACLId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebACLId").unmarshallLocationName("WebACLId").build()}).build();
    private static final SdkField<String> HTTP_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HttpVersion").getter(DistributionSummary.getter(DistributionSummary::httpVersionAsString)).setter(DistributionSummary.setter(Builder::httpVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpVersion").unmarshallLocationName("HttpVersion").build()}).build();
    private static final SdkField<Boolean> IS_IPV6_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsIPV6Enabled").getter(DistributionSummary.getter(DistributionSummary::isIPV6Enabled)).setter(DistributionSummary.setter(Builder::isIPV6Enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsIPV6Enabled").unmarshallLocationName("IsIPV6Enabled").build()}).build();
    private static final SdkField<List<AliasICPRecordal>> ALIAS_ICP_RECORDALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AliasICPRecordals").getter(DistributionSummary.getter(DistributionSummary::aliasICPRecordals)).setter(DistributionSummary.setter(Builder::aliasICPRecordals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasICPRecordals").unmarshallLocationName("AliasICPRecordals").build(), ListTrait.builder().memberLocationName("AliasICPRecordal").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AliasICPRecordal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasICPRecordal").unmarshallLocationName("AliasICPRecordal").build()}).build()).build()}).build();
    private static final SdkField<Boolean> STAGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Staging").getter(DistributionSummary.getter(DistributionSummary::staging)).setter(DistributionSummary.setter(Builder::staging)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Staging").unmarshallLocationName("Staging").build()}).build();
    private static final SdkField<String> CONNECTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionMode").getter(DistributionSummary.getter(DistributionSummary::connectionModeAsString)).setter(DistributionSummary.setter(Builder::connectionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionMode").unmarshallLocationName("ConnectionMode").build()}).build();
    private static final SdkField<String> ANYCAST_IP_LIST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnycastIpListId").getter(DistributionSummary.getter(DistributionSummary::anycastIpListId)).setter(DistributionSummary.setter(Builder::anycastIpListId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnycastIpListId").unmarshallLocationName("AnycastIpListId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, E_TAG_FIELD, STATUS_FIELD, LAST_MODIFIED_TIME_FIELD, DOMAIN_NAME_FIELD, ALIASES_FIELD, ORIGINS_FIELD, ORIGIN_GROUPS_FIELD, DEFAULT_CACHE_BEHAVIOR_FIELD, CACHE_BEHAVIORS_FIELD, CUSTOM_ERROR_RESPONSES_FIELD, COMMENT_FIELD, PRICE_CLASS_FIELD, ENABLED_FIELD, VIEWER_CERTIFICATE_FIELD, RESTRICTIONS_FIELD, WEB_ACL_ID_FIELD, HTTP_VERSION_FIELD, IS_IPV6_ENABLED_FIELD, ALIAS_ICP_RECORDALS_FIELD, STAGING_FIELD, CONNECTION_MODE_FIELD, ANYCAST_IP_LIST_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DistributionSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String arn;
    private final String eTag;
    private final String status;
    private final Instant lastModifiedTime;
    private final String domainName;
    private final Aliases aliases;
    private final Origins origins;
    private final OriginGroups originGroups;
    private final DefaultCacheBehavior defaultCacheBehavior;
    private final CacheBehaviors cacheBehaviors;
    private final CustomErrorResponses customErrorResponses;
    private final String comment;
    private final String priceClass;
    private final Boolean enabled;
    private final ViewerCertificate viewerCertificate;
    private final Restrictions restrictions;
    private final String webACLId;
    private final String httpVersion;
    private final Boolean isIPV6Enabled;
    private final List<AliasICPRecordal> aliasICPRecordals;
    private final Boolean staging;
    private final String connectionMode;
    private final String anycastIpListId;

    private DistributionSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.eTag = builder.eTag;
        this.status = builder.status;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.domainName = builder.domainName;
        this.aliases = builder.aliases;
        this.origins = builder.origins;
        this.originGroups = builder.originGroups;
        this.defaultCacheBehavior = builder.defaultCacheBehavior;
        this.cacheBehaviors = builder.cacheBehaviors;
        this.customErrorResponses = builder.customErrorResponses;
        this.comment = builder.comment;
        this.priceClass = builder.priceClass;
        this.enabled = builder.enabled;
        this.viewerCertificate = builder.viewerCertificate;
        this.restrictions = builder.restrictions;
        this.webACLId = builder.webACLId;
        this.httpVersion = builder.httpVersion;
        this.isIPV6Enabled = builder.isIPV6Enabled;
        this.aliasICPRecordals = builder.aliasICPRecordals;
        this.staging = builder.staging;
        this.connectionMode = builder.connectionMode;
        this.anycastIpListId = builder.anycastIpListId;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String eTag() {
        return this.eTag;
    }

    public final String status() {
        return this.status;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final Aliases aliases() {
        return this.aliases;
    }

    public final Origins origins() {
        return this.origins;
    }

    public final OriginGroups originGroups() {
        return this.originGroups;
    }

    public final DefaultCacheBehavior defaultCacheBehavior() {
        return this.defaultCacheBehavior;
    }

    public final CacheBehaviors cacheBehaviors() {
        return this.cacheBehaviors;
    }

    public final CustomErrorResponses customErrorResponses() {
        return this.customErrorResponses;
    }

    public final String comment() {
        return this.comment;
    }

    public final PriceClass priceClass() {
        return PriceClass.fromValue(this.priceClass);
    }

    public final String priceClassAsString() {
        return this.priceClass;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final ViewerCertificate viewerCertificate() {
        return this.viewerCertificate;
    }

    public final Restrictions restrictions() {
        return this.restrictions;
    }

    public final String webACLId() {
        return this.webACLId;
    }

    public final HttpVersion httpVersion() {
        return HttpVersion.fromValue(this.httpVersion);
    }

    public final String httpVersionAsString() {
        return this.httpVersion;
    }

    public final Boolean isIPV6Enabled() {
        return this.isIPV6Enabled;
    }

    public final boolean hasAliasICPRecordals() {
        return this.aliasICPRecordals != null && !(this.aliasICPRecordals instanceof SdkAutoConstructList);
    }

    public final List<AliasICPRecordal> aliasICPRecordals() {
        return this.aliasICPRecordals;
    }

    public final Boolean staging() {
        return this.staging;
    }

    public final ConnectionMode connectionMode() {
        return ConnectionMode.fromValue(this.connectionMode);
    }

    public final String connectionModeAsString() {
        return this.connectionMode;
    }

    public final String anycastIpListId() {
        return this.anycastIpListId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.aliases());
        hashCode = 31 * hashCode + Objects.hashCode(this.origins());
        hashCode = 31 * hashCode + Objects.hashCode(this.originGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultCacheBehavior());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheBehaviors());
        hashCode = 31 * hashCode + Objects.hashCode(this.customErrorResponses());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.priceClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewerCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.restrictions());
        hashCode = 31 * hashCode + Objects.hashCode(this.webACLId());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.isIPV6Enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAliasICPRecordals() ? this.aliasICPRecordals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.staging());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.anycastIpListId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DistributionSummary)) {
            return false;
        }
        DistributionSummary other = (DistributionSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.eTag(), other.eTag()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.aliases(), other.aliases()) && Objects.equals(this.origins(), other.origins()) && Objects.equals(this.originGroups(), other.originGroups()) && Objects.equals(this.defaultCacheBehavior(), other.defaultCacheBehavior()) && Objects.equals(this.cacheBehaviors(), other.cacheBehaviors()) && Objects.equals(this.customErrorResponses(), other.customErrorResponses()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.priceClassAsString(), other.priceClassAsString()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.viewerCertificate(), other.viewerCertificate()) && Objects.equals(this.restrictions(), other.restrictions()) && Objects.equals(this.webACLId(), other.webACLId()) && Objects.equals(this.httpVersionAsString(), other.httpVersionAsString()) && Objects.equals(this.isIPV6Enabled(), other.isIPV6Enabled()) && this.hasAliasICPRecordals() == other.hasAliasICPRecordals() && Objects.equals(this.aliasICPRecordals(), other.aliasICPRecordals()) && Objects.equals(this.staging(), other.staging()) && Objects.equals(this.connectionModeAsString(), other.connectionModeAsString()) && Objects.equals(this.anycastIpListId(), other.anycastIpListId());
    }

    public final String toString() {
        return ToString.builder((String)"DistributionSummary").add("Id", (Object)this.id()).add("ARN", (Object)this.arn()).add("ETag", (Object)this.eTag()).add("Status", (Object)this.status()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("DomainName", (Object)this.domainName()).add("Aliases", (Object)this.aliases()).add("Origins", (Object)this.origins()).add("OriginGroups", (Object)this.originGroups()).add("DefaultCacheBehavior", (Object)this.defaultCacheBehavior()).add("CacheBehaviors", (Object)this.cacheBehaviors()).add("CustomErrorResponses", (Object)this.customErrorResponses()).add("Comment", (Object)(this.comment() == null ? null : "*** Sensitive Data Redacted ***")).add("PriceClass", (Object)this.priceClassAsString()).add("Enabled", (Object)this.enabled()).add("ViewerCertificate", (Object)this.viewerCertificate()).add("Restrictions", (Object)this.restrictions()).add("WebACLId", (Object)this.webACLId()).add("HttpVersion", (Object)this.httpVersionAsString()).add("IsIPV6Enabled", (Object)this.isIPV6Enabled()).add("AliasICPRecordals", this.hasAliasICPRecordals() ? this.aliasICPRecordals() : null).add("Staging", (Object)this.staging()).add("ConnectionMode", (Object)this.connectionModeAsString()).add("AnycastIpListId", (Object)this.anycastIpListId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "Aliases": {
                return Optional.ofNullable(clazz.cast(this.aliases()));
            }
            case "Origins": {
                return Optional.ofNullable(clazz.cast(this.origins()));
            }
            case "OriginGroups": {
                return Optional.ofNullable(clazz.cast(this.originGroups()));
            }
            case "DefaultCacheBehavior": {
                return Optional.ofNullable(clazz.cast(this.defaultCacheBehavior()));
            }
            case "CacheBehaviors": {
                return Optional.ofNullable(clazz.cast(this.cacheBehaviors()));
            }
            case "CustomErrorResponses": {
                return Optional.ofNullable(clazz.cast(this.customErrorResponses()));
            }
            case "Comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "PriceClass": {
                return Optional.ofNullable(clazz.cast(this.priceClassAsString()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "ViewerCertificate": {
                return Optional.ofNullable(clazz.cast(this.viewerCertificate()));
            }
            case "Restrictions": {
                return Optional.ofNullable(clazz.cast(this.restrictions()));
            }
            case "WebACLId": {
                return Optional.ofNullable(clazz.cast(this.webACLId()));
            }
            case "HttpVersion": {
                return Optional.ofNullable(clazz.cast(this.httpVersionAsString()));
            }
            case "IsIPV6Enabled": {
                return Optional.ofNullable(clazz.cast(this.isIPV6Enabled()));
            }
            case "AliasICPRecordals": {
                return Optional.ofNullable(clazz.cast(this.aliasICPRecordals()));
            }
            case "Staging": {
                return Optional.ofNullable(clazz.cast(this.staging()));
            }
            case "ConnectionMode": {
                return Optional.ofNullable(clazz.cast(this.connectionModeAsString()));
            }
            case "AnycastIpListId": {
                return Optional.ofNullable(clazz.cast(this.anycastIpListId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("ARN", ARN_FIELD);
        map.put("ETag", E_TAG_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("Aliases", ALIASES_FIELD);
        map.put("Origins", ORIGINS_FIELD);
        map.put("OriginGroups", ORIGIN_GROUPS_FIELD);
        map.put("DefaultCacheBehavior", DEFAULT_CACHE_BEHAVIOR_FIELD);
        map.put("CacheBehaviors", CACHE_BEHAVIORS_FIELD);
        map.put("CustomErrorResponses", CUSTOM_ERROR_RESPONSES_FIELD);
        map.put("Comment", COMMENT_FIELD);
        map.put("PriceClass", PRICE_CLASS_FIELD);
        map.put("Enabled", ENABLED_FIELD);
        map.put("ViewerCertificate", VIEWER_CERTIFICATE_FIELD);
        map.put("Restrictions", RESTRICTIONS_FIELD);
        map.put("WebACLId", WEB_ACL_ID_FIELD);
        map.put("HttpVersion", HTTP_VERSION_FIELD);
        map.put("IsIPV6Enabled", IS_IPV6_ENABLED_FIELD);
        map.put("AliasICPRecordals", ALIAS_ICP_RECORDALS_FIELD);
        map.put("Staging", STAGING_FIELD);
        map.put("ConnectionMode", CONNECTION_MODE_FIELD);
        map.put("AnycastIpListId", ANYCAST_IP_LIST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DistributionSummary, T> g) {
        return obj -> g.apply((DistributionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String eTag;
        private String status;
        private Instant lastModifiedTime;
        private String domainName;
        private Aliases aliases;
        private Origins origins;
        private OriginGroups originGroups;
        private DefaultCacheBehavior defaultCacheBehavior;
        private CacheBehaviors cacheBehaviors;
        private CustomErrorResponses customErrorResponses;
        private String comment;
        private String priceClass;
        private Boolean enabled;
        private ViewerCertificate viewerCertificate;
        private Restrictions restrictions;
        private String webACLId;
        private String httpVersion;
        private Boolean isIPV6Enabled;
        private List<AliasICPRecordal> aliasICPRecordals = DefaultSdkAutoConstructList.getInstance();
        private Boolean staging;
        private String connectionMode;
        private String anycastIpListId;

        private BuilderImpl() {
        }

        private BuilderImpl(DistributionSummary model) {
            this.id(model.id);
            this.arn(model.arn);
            this.eTag(model.eTag);
            this.status(model.status);
            this.lastModifiedTime(model.lastModifiedTime);
            this.domainName(model.domainName);
            this.aliases(model.aliases);
            this.origins(model.origins);
            this.originGroups(model.originGroups);
            this.defaultCacheBehavior(model.defaultCacheBehavior);
            this.cacheBehaviors(model.cacheBehaviors);
            this.customErrorResponses(model.customErrorResponses);
            this.comment(model.comment);
            this.priceClass(model.priceClass);
            this.enabled(model.enabled);
            this.viewerCertificate(model.viewerCertificate);
            this.restrictions(model.restrictions);
            this.webACLId(model.webACLId);
            this.httpVersion(model.httpVersion);
            this.isIPV6Enabled(model.isIPV6Enabled);
            this.aliasICPRecordals(model.aliasICPRecordals);
            this.staging(model.staging);
            this.connectionMode(model.connectionMode);
            this.anycastIpListId(model.anycastIpListId);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Aliases.Builder getAliases() {
            return this.aliases != null ? this.aliases.toBuilder() : null;
        }

        public final void setAliases(Aliases.BuilderImpl aliases) {
            this.aliases = aliases != null ? aliases.build() : null;
        }

        @Override
        public final Builder aliases(Aliases aliases) {
            this.aliases = aliases;
            return this;
        }

        public final Origins.Builder getOrigins() {
            return this.origins != null ? this.origins.toBuilder() : null;
        }

        public final void setOrigins(Origins.BuilderImpl origins) {
            this.origins = origins != null ? origins.build() : null;
        }

        @Override
        public final Builder origins(Origins origins) {
            this.origins = origins;
            return this;
        }

        public final OriginGroups.Builder getOriginGroups() {
            return this.originGroups != null ? this.originGroups.toBuilder() : null;
        }

        public final void setOriginGroups(OriginGroups.BuilderImpl originGroups) {
            this.originGroups = originGroups != null ? originGroups.build() : null;
        }

        @Override
        public final Builder originGroups(OriginGroups originGroups) {
            this.originGroups = originGroups;
            return this;
        }

        public final DefaultCacheBehavior.Builder getDefaultCacheBehavior() {
            return this.defaultCacheBehavior != null ? this.defaultCacheBehavior.toBuilder() : null;
        }

        public final void setDefaultCacheBehavior(DefaultCacheBehavior.BuilderImpl defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior != null ? defaultCacheBehavior.build() : null;
        }

        @Override
        public final Builder defaultCacheBehavior(DefaultCacheBehavior defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior;
            return this;
        }

        public final CacheBehaviors.Builder getCacheBehaviors() {
            return this.cacheBehaviors != null ? this.cacheBehaviors.toBuilder() : null;
        }

        public final void setCacheBehaviors(CacheBehaviors.BuilderImpl cacheBehaviors) {
            this.cacheBehaviors = cacheBehaviors != null ? cacheBehaviors.build() : null;
        }

        @Override
        public final Builder cacheBehaviors(CacheBehaviors cacheBehaviors) {
            this.cacheBehaviors = cacheBehaviors;
            return this;
        }

        public final CustomErrorResponses.Builder getCustomErrorResponses() {
            return this.customErrorResponses != null ? this.customErrorResponses.toBuilder() : null;
        }

        public final void setCustomErrorResponses(CustomErrorResponses.BuilderImpl customErrorResponses) {
            this.customErrorResponses = customErrorResponses != null ? customErrorResponses.build() : null;
        }

        @Override
        public final Builder customErrorResponses(CustomErrorResponses customErrorResponses) {
            this.customErrorResponses = customErrorResponses;
            return this;
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final String getPriceClass() {
            return this.priceClass;
        }

        public final void setPriceClass(String priceClass) {
            this.priceClass = priceClass;
        }

        @Override
        public final Builder priceClass(String priceClass) {
            this.priceClass = priceClass;
            return this;
        }

        @Override
        public final Builder priceClass(PriceClass priceClass) {
            this.priceClass(priceClass == null ? null : priceClass.toString());
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final ViewerCertificate.Builder getViewerCertificate() {
            return this.viewerCertificate != null ? this.viewerCertificate.toBuilder() : null;
        }

        public final void setViewerCertificate(ViewerCertificate.BuilderImpl viewerCertificate) {
            this.viewerCertificate = viewerCertificate != null ? viewerCertificate.build() : null;
        }

        @Override
        public final Builder viewerCertificate(ViewerCertificate viewerCertificate) {
            this.viewerCertificate = viewerCertificate;
            return this;
        }

        public final Restrictions.Builder getRestrictions() {
            return this.restrictions != null ? this.restrictions.toBuilder() : null;
        }

        public final void setRestrictions(Restrictions.BuilderImpl restrictions) {
            this.restrictions = restrictions != null ? restrictions.build() : null;
        }

        @Override
        public final Builder restrictions(Restrictions restrictions) {
            this.restrictions = restrictions;
            return this;
        }

        public final String getWebACLId() {
            return this.webACLId;
        }

        public final void setWebACLId(String webACLId) {
            this.webACLId = webACLId;
        }

        @Override
        public final Builder webACLId(String webACLId) {
            this.webACLId = webACLId;
            return this;
        }

        public final String getHttpVersion() {
            return this.httpVersion;
        }

        public final void setHttpVersion(String httpVersion) {
            this.httpVersion = httpVersion;
        }

        @Override
        public final Builder httpVersion(String httpVersion) {
            this.httpVersion = httpVersion;
            return this;
        }

        @Override
        public final Builder httpVersion(HttpVersion httpVersion) {
            this.httpVersion(httpVersion == null ? null : httpVersion.toString());
            return this;
        }

        public final Boolean getIsIPV6Enabled() {
            return this.isIPV6Enabled;
        }

        public final void setIsIPV6Enabled(Boolean isIPV6Enabled) {
            this.isIPV6Enabled = isIPV6Enabled;
        }

        @Override
        public final Builder isIPV6Enabled(Boolean isIPV6Enabled) {
            this.isIPV6Enabled = isIPV6Enabled;
            return this;
        }

        public final List<AliasICPRecordal.Builder> getAliasICPRecordals() {
            List<AliasICPRecordal.Builder> result = AliasICPRecordalsCopier.copyToBuilder(this.aliasICPRecordals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAliasICPRecordals(Collection<AliasICPRecordal.BuilderImpl> aliasICPRecordals) {
            this.aliasICPRecordals = AliasICPRecordalsCopier.copyFromBuilder(aliasICPRecordals);
        }

        @Override
        public final Builder aliasICPRecordals(Collection<AliasICPRecordal> aliasICPRecordals) {
            this.aliasICPRecordals = AliasICPRecordalsCopier.copy(aliasICPRecordals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliasICPRecordals(AliasICPRecordal ... aliasICPRecordals) {
            this.aliasICPRecordals(Arrays.asList(aliasICPRecordals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliasICPRecordals(Consumer<AliasICPRecordal.Builder> ... aliasICPRecordals) {
            this.aliasICPRecordals(Stream.of(aliasICPRecordals).map(c -> (AliasICPRecordal)((AliasICPRecordal.Builder)AliasICPRecordal.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getStaging() {
            return this.staging;
        }

        public final void setStaging(Boolean staging) {
            this.staging = staging;
        }

        @Override
        public final Builder staging(Boolean staging) {
            this.staging = staging;
            return this;
        }

        public final String getConnectionMode() {
            return this.connectionMode;
        }

        public final void setConnectionMode(String connectionMode) {
            this.connectionMode = connectionMode;
        }

        @Override
        public final Builder connectionMode(String connectionMode) {
            this.connectionMode = connectionMode;
            return this;
        }

        @Override
        public final Builder connectionMode(ConnectionMode connectionMode) {
            this.connectionMode(connectionMode == null ? null : connectionMode.toString());
            return this;
        }

        public final String getAnycastIpListId() {
            return this.anycastIpListId;
        }

        public final void setAnycastIpListId(String anycastIpListId) {
            this.anycastIpListId = anycastIpListId;
        }

        @Override
        public final Builder anycastIpListId(String anycastIpListId) {
            this.anycastIpListId = anycastIpListId;
            return this;
        }

        public DistributionSummary build() {
            return new DistributionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DistributionSummary> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder eTag(String var1);

        public Builder status(String var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder domainName(String var1);

        public Builder aliases(Aliases var1);

        default public Builder aliases(Consumer<Aliases.Builder> aliases) {
            return this.aliases((Aliases)((Aliases.Builder)Aliases.builder().applyMutation(aliases)).build());
        }

        public Builder origins(Origins var1);

        default public Builder origins(Consumer<Origins.Builder> origins) {
            return this.origins((Origins)((Origins.Builder)Origins.builder().applyMutation(origins)).build());
        }

        public Builder originGroups(OriginGroups var1);

        default public Builder originGroups(Consumer<OriginGroups.Builder> originGroups) {
            return this.originGroups((OriginGroups)((OriginGroups.Builder)OriginGroups.builder().applyMutation(originGroups)).build());
        }

        public Builder defaultCacheBehavior(DefaultCacheBehavior var1);

        default public Builder defaultCacheBehavior(Consumer<DefaultCacheBehavior.Builder> defaultCacheBehavior) {
            return this.defaultCacheBehavior((DefaultCacheBehavior)((DefaultCacheBehavior.Builder)DefaultCacheBehavior.builder().applyMutation(defaultCacheBehavior)).build());
        }

        public Builder cacheBehaviors(CacheBehaviors var1);

        default public Builder cacheBehaviors(Consumer<CacheBehaviors.Builder> cacheBehaviors) {
            return this.cacheBehaviors((CacheBehaviors)((CacheBehaviors.Builder)CacheBehaviors.builder().applyMutation(cacheBehaviors)).build());
        }

        public Builder customErrorResponses(CustomErrorResponses var1);

        default public Builder customErrorResponses(Consumer<CustomErrorResponses.Builder> customErrorResponses) {
            return this.customErrorResponses((CustomErrorResponses)((CustomErrorResponses.Builder)CustomErrorResponses.builder().applyMutation(customErrorResponses)).build());
        }

        public Builder comment(String var1);

        public Builder priceClass(String var1);

        public Builder priceClass(PriceClass var1);

        public Builder enabled(Boolean var1);

        public Builder viewerCertificate(ViewerCertificate var1);

        default public Builder viewerCertificate(Consumer<ViewerCertificate.Builder> viewerCertificate) {
            return this.viewerCertificate((ViewerCertificate)((ViewerCertificate.Builder)ViewerCertificate.builder().applyMutation(viewerCertificate)).build());
        }

        public Builder restrictions(Restrictions var1);

        default public Builder restrictions(Consumer<Restrictions.Builder> restrictions) {
            return this.restrictions((Restrictions)((Restrictions.Builder)Restrictions.builder().applyMutation(restrictions)).build());
        }

        public Builder webACLId(String var1);

        public Builder httpVersion(String var1);

        public Builder httpVersion(HttpVersion var1);

        public Builder isIPV6Enabled(Boolean var1);

        public Builder aliasICPRecordals(Collection<AliasICPRecordal> var1);

        public Builder aliasICPRecordals(AliasICPRecordal ... var1);

        public Builder aliasICPRecordals(Consumer<AliasICPRecordal.Builder> ... var1);

        public Builder staging(Boolean var1);

        public Builder connectionMode(String var1);

        public Builder connectionMode(ConnectionMode var1);

        public Builder anycastIpListId(String var1);
    }
}

