/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This configuration determines which HTTP requests are sent to the staging distribution. If the HTTP request contains
 * a header and value that matches what you specify here, the request is sent to the staging distribution. Otherwise the
 * request is sent to the primary distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContinuousDeploymentSingleHeaderConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ContinuousDeploymentSingleHeaderConfig.Builder, ContinuousDeploymentSingleHeaderConfig> {
    private static final SdkField<String> HEADER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Header")
            .getter(getter(ContinuousDeploymentSingleHeaderConfig::header))
            .setter(setter(Builder::header))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Header")
                    .unmarshallLocationName("Header").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Value")
            .getter(getter(ContinuousDeploymentSingleHeaderConfig::value))
            .setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value")
                    .unmarshallLocationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADER_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String header;

    private final String value;

    private ContinuousDeploymentSingleHeaderConfig(BuilderImpl builder) {
        this.header = builder.header;
        this.value = builder.value;
    }

    /**
     * <p>
     * The request header name that you want CloudFront to send to your staging distribution. The header must contain
     * the prefix <code>aws-cf-cd-</code>.
     * </p>
     * 
     * @return The request header name that you want CloudFront to send to your staging distribution. The header must
     *         contain the prefix <code>aws-cf-cd-</code>.
     */
    public final String header() {
        return header;
    }

    /**
     * <p>
     * The request header value.
     * </p>
     * 
     * @return The request header value.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(header());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContinuousDeploymentSingleHeaderConfig)) {
            return false;
        }
        ContinuousDeploymentSingleHeaderConfig other = (ContinuousDeploymentSingleHeaderConfig) obj;
        return Objects.equals(header(), other.header()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContinuousDeploymentSingleHeaderConfig").add("Header", header()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Header":
            return Optional.ofNullable(clazz.cast(header()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Header", HEADER_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContinuousDeploymentSingleHeaderConfig, T> g) {
        return obj -> g.apply((ContinuousDeploymentSingleHeaderConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContinuousDeploymentSingleHeaderConfig> {
        /**
         * <p>
         * The request header name that you want CloudFront to send to your staging distribution. The header must
         * contain the prefix <code>aws-cf-cd-</code>.
         * </p>
         * 
         * @param header
         *        The request header name that you want CloudFront to send to your staging distribution. The header must
         *        contain the prefix <code>aws-cf-cd-</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder header(String header);

        /**
         * <p>
         * The request header value.
         * </p>
         * 
         * @param value
         *        The request header value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String header;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(ContinuousDeploymentSingleHeaderConfig model) {
            header(model.header);
            value(model.value);
        }

        public final String getHeader() {
            return header;
        }

        public final void setHeader(String header) {
            this.header = header;
        }

        @Override
        public final Builder header(String header) {
            this.header = header;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public ContinuousDeploymentSingleHeaderConfig build() {
            return new ContinuousDeploymentSingleHeaderConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
