/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that specifies whether access logs are written for the distribution.
 * </p>
 * <note>
 * <p>
 * If you already enabled standard logging (legacy) and you want to enable standard logging (v2) to send your access
 * logs to Amazon S3, we recommend that you specify a <i>different</i> Amazon S3 bucket or use a <i>separate path</i> in
 * the same bucket (for example, use a log prefix or partitioning). This helps you keep track of which log files are
 * associated with which logging subscription and prevents log files from overwriting each other. For more information,
 * see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/AccessLogs.html">Standard logging
 * (access logs)</a> in the <i>Amazon CloudFront Developer Guide</i>.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoggingConfig implements SdkPojo, Serializable, ToCopyableBuilder<LoggingConfig.Builder, LoggingConfig> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled")
            .getter(getter(LoggingConfig::enabled))
            .setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled")
                    .unmarshallLocationName("Enabled").build()).build();

    private static final SdkField<Boolean> INCLUDE_COOKIES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeCookies")
            .getter(getter(LoggingConfig::includeCookies))
            .setter(setter(Builder::includeCookies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeCookies")
                    .unmarshallLocationName("IncludeCookies").build()).build();

    private static final SdkField<String> BUCKET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Bucket")
            .getter(getter(LoggingConfig::bucket))
            .setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket")
                    .unmarshallLocationName("Bucket").build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Prefix")
            .getter(getter(LoggingConfig::prefix))
            .setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix")
                    .unmarshallLocationName("Prefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            INCLUDE_COOKIES_FIELD, BUCKET_FIELD, PREFIX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final Boolean includeCookies;

    private final String bucket;

    private final String prefix;

    private LoggingConfig(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.includeCookies = builder.includeCookies;
        this.bucket = builder.bucket;
        this.prefix = builder.prefix;
    }

    /**
     * <p>
     * Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you don't want to enable
     * logging when you create a distribution or if you want to disable logging for an existing distribution, specify
     * <code>false</code> for <code>Enabled</code>, and specify empty <code>Bucket</code> and <code>Prefix</code>
     * elements. If you specify <code>false</code> for <code>Enabled</code> but you specify values for
     * <code>Bucket</code> and <code>prefix</code>, the values are automatically deleted.
     * </p>
     * 
     * @return Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you don't want to
     *         enable logging when you create a distribution or if you want to disable logging for an existing
     *         distribution, specify <code>false</code> for <code>Enabled</code>, and specify empty <code>Bucket</code>
     *         and <code>Prefix</code> elements. If you specify <code>false</code> for <code>Enabled</code> but you
     *         specify values for <code>Bucket</code> and <code>prefix</code>, the values are automatically deleted.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * Specifies whether you want CloudFront to include cookies in access logs, specify <code>true</code> for
     * <code>IncludeCookies</code>. If you choose to include cookies in logs, CloudFront logs all cookies regardless of
     * how you configure the cache behaviors for this distribution. If you don't want to include cookies when you create
     * a distribution or if you want to disable include cookies for an existing distribution, specify <code>false</code>
     * for <code>IncludeCookies</code>.
     * </p>
     * 
     * @return Specifies whether you want CloudFront to include cookies in access logs, specify <code>true</code> for
     *         <code>IncludeCookies</code>. If you choose to include cookies in logs, CloudFront logs all cookies
     *         regardless of how you configure the cache behaviors for this distribution. If you don't want to include
     *         cookies when you create a distribution or if you want to disable include cookies for an existing
     *         distribution, specify <code>false</code> for <code>IncludeCookies</code>.
     */
    public final Boolean includeCookies() {
        return includeCookies;
    }

    /**
     * <p>
     * The Amazon S3 bucket to store the access logs in, for example, <code>amzn-s3-demo-bucket.s3.amazonaws.com</code>.
     * </p>
     * 
     * @return The Amazon S3 bucket to store the access logs in, for example,
     *         <code>amzn-s3-demo-bucket.s3.amazonaws.com</code>.
     */
    public final String bucket() {
        return bucket;
    }

    /**
     * <p>
     * An optional string that you want CloudFront to prefix to the access log <code>filenames</code> for this
     * distribution, for example, <code>myprefix/</code>. If you want to enable logging, but you don't want to specify a
     * prefix, you still must include an empty <code>Prefix</code> element in the <code>Logging</code> element.
     * </p>
     * 
     * @return An optional string that you want CloudFront to prefix to the access log <code>filenames</code> for this
     *         distribution, for example, <code>myprefix/</code>. If you want to enable logging, but you don't want to
     *         specify a prefix, you still must include an empty <code>Prefix</code> element in the <code>Logging</code>
     *         element.
     */
    public final String prefix() {
        return prefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(includeCookies());
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingConfig)) {
            return false;
        }
        LoggingConfig other = (LoggingConfig) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(includeCookies(), other.includeCookies())
                && Objects.equals(bucket(), other.bucket()) && Objects.equals(prefix(), other.prefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoggingConfig").add("Enabled", enabled()).add("IncludeCookies", includeCookies())
                .add("Bucket", bucket()).add("Prefix", prefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "IncludeCookies":
            return Optional.ofNullable(clazz.cast(includeCookies()));
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "Prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Enabled", ENABLED_FIELD);
        map.put("IncludeCookies", INCLUDE_COOKIES_FIELD);
        map.put("Bucket", BUCKET_FIELD);
        map.put("Prefix", PREFIX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoggingConfig, T> g) {
        return obj -> g.apply((LoggingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoggingConfig> {
        /**
         * <p>
         * Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you don't want to enable
         * logging when you create a distribution or if you want to disable logging for an existing distribution,
         * specify <code>false</code> for <code>Enabled</code>, and specify empty <code>Bucket</code> and
         * <code>Prefix</code> elements. If you specify <code>false</code> for <code>Enabled</code> but you specify
         * values for <code>Bucket</code> and <code>prefix</code>, the values are automatically deleted.
         * </p>
         * 
         * @param enabled
         *        Specifies whether you want CloudFront to save access logs to an Amazon S3 bucket. If you don't want to
         *        enable logging when you create a distribution or if you want to disable logging for an existing
         *        distribution, specify <code>false</code> for <code>Enabled</code>, and specify empty
         *        <code>Bucket</code> and <code>Prefix</code> elements. If you specify <code>false</code> for
         *        <code>Enabled</code> but you specify values for <code>Bucket</code> and <code>prefix</code>, the
         *        values are automatically deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * Specifies whether you want CloudFront to include cookies in access logs, specify <code>true</code> for
         * <code>IncludeCookies</code>. If you choose to include cookies in logs, CloudFront logs all cookies regardless
         * of how you configure the cache behaviors for this distribution. If you don't want to include cookies when you
         * create a distribution or if you want to disable include cookies for an existing distribution, specify
         * <code>false</code> for <code>IncludeCookies</code>.
         * </p>
         * 
         * @param includeCookies
         *        Specifies whether you want CloudFront to include cookies in access logs, specify <code>true</code> for
         *        <code>IncludeCookies</code>. If you choose to include cookies in logs, CloudFront logs all cookies
         *        regardless of how you configure the cache behaviors for this distribution. If you don't want to
         *        include cookies when you create a distribution or if you want to disable include cookies for an
         *        existing distribution, specify <code>false</code> for <code>IncludeCookies</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeCookies(Boolean includeCookies);

        /**
         * <p>
         * The Amazon S3 bucket to store the access logs in, for example,
         * <code>amzn-s3-demo-bucket.s3.amazonaws.com</code>.
         * </p>
         * 
         * @param bucket
         *        The Amazon S3 bucket to store the access logs in, for example,
         *        <code>amzn-s3-demo-bucket.s3.amazonaws.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * An optional string that you want CloudFront to prefix to the access log <code>filenames</code> for this
         * distribution, for example, <code>myprefix/</code>. If you want to enable logging, but you don't want to
         * specify a prefix, you still must include an empty <code>Prefix</code> element in the <code>Logging</code>
         * element.
         * </p>
         * 
         * @param prefix
         *        An optional string that you want CloudFront to prefix to the access log <code>filenames</code> for
         *        this distribution, for example, <code>myprefix/</code>. If you want to enable logging, but you don't
         *        want to specify a prefix, you still must include an empty <code>Prefix</code> element in the
         *        <code>Logging</code> element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private Boolean includeCookies;

        private String bucket;

        private String prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingConfig model) {
            enabled(model.enabled);
            includeCookies(model.includeCookies);
            bucket(model.bucket);
            prefix(model.prefix);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Boolean getIncludeCookies() {
            return includeCookies;
        }

        public final void setIncludeCookies(Boolean includeCookies) {
            this.includeCookies = includeCookies;
        }

        @Override
        public final Builder includeCookies(Boolean includeCookies) {
            this.includeCookies = includeCookies;
            return this;
        }

        public final String getBucket() {
            return bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getPrefix() {
            return prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        @Override
        public LoggingConfig build() {
            return new LoggingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
