/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that represents the request for the Amazon CloudFront managed ACM certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedCertificateRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<ManagedCertificateRequest.Builder, ManagedCertificateRequest> {
    private static final SdkField<String> VALIDATION_TOKEN_HOST_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ValidationTokenHost")
            .getter(getter(ManagedCertificateRequest::validationTokenHostAsString))
            .setter(setter(Builder::validationTokenHost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationTokenHost")
                    .unmarshallLocationName("ValidationTokenHost").build()).build();

    private static final SdkField<String> PRIMARY_DOMAIN_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PrimaryDomainName")
            .getter(getter(ManagedCertificateRequest::primaryDomainName))
            .setter(setter(Builder::primaryDomainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryDomainName")
                    .unmarshallLocationName("PrimaryDomainName").build()).build();

    private static final SdkField<String> CERTIFICATE_TRANSPARENCY_LOGGING_PREFERENCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CertificateTransparencyLoggingPreference")
            .getter(getter(ManagedCertificateRequest::certificateTransparencyLoggingPreferenceAsString))
            .setter(setter(Builder::certificateTransparencyLoggingPreference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CertificateTransparencyLoggingPreference")
                    .unmarshallLocationName("CertificateTransparencyLoggingPreference").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALIDATION_TOKEN_HOST_FIELD,
            PRIMARY_DOMAIN_NAME_FIELD, CERTIFICATE_TRANSPARENCY_LOGGING_PREFERENCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String validationTokenHost;

    private final String primaryDomainName;

    private final String certificateTransparencyLoggingPreference;

    private ManagedCertificateRequest(BuilderImpl builder) {
        this.validationTokenHost = builder.validationTokenHost;
        this.primaryDomainName = builder.primaryDomainName;
        this.certificateTransparencyLoggingPreference = builder.certificateTransparencyLoggingPreference;
    }

    /**
     * <p>
     * Specify how the HTTP validation token will be served when requesting the CloudFront managed ACM certificate.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <code>cloudfront</code>, CloudFront will automatically serve the validation token. Choose this mode if you
     * can point the domain's DNS to CloudFront immediately.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>self-hosted</code>, you serve the validation token from your existing infrastructure. Choose this mode
     * when you need to maintain current traffic flow while your certificate is being issued. You can place the
     * validation token at the well-known path on your existing web server, wait for ACM to validate and issue the
     * certificate, and then update your DNS to point to CloudFront.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #validationTokenHost} will return {@link ValidationTokenHost#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #validationTokenHostAsString}.
     * </p>
     * 
     * @return Specify how the HTTP validation token will be served when requesting the CloudFront managed ACM
     *         certificate.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For <code>cloudfront</code>, CloudFront will automatically serve the validation token. Choose this mode
     *         if you can point the domain's DNS to CloudFront immediately.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <code>self-hosted</code>, you serve the validation token from your existing infrastructure. Choose
     *         this mode when you need to maintain current traffic flow while your certificate is being issued. You can
     *         place the validation token at the well-known path on your existing web server, wait for ACM to validate
     *         and issue the certificate, and then update your DNS to point to CloudFront.
     *         </p>
     *         </li>
     * @see ValidationTokenHost
     */
    public final ValidationTokenHost validationTokenHost() {
        return ValidationTokenHost.fromValue(validationTokenHost);
    }

    /**
     * <p>
     * Specify how the HTTP validation token will be served when requesting the CloudFront managed ACM certificate.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <code>cloudfront</code>, CloudFront will automatically serve the validation token. Choose this mode if you
     * can point the domain's DNS to CloudFront immediately.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>self-hosted</code>, you serve the validation token from your existing infrastructure. Choose this mode
     * when you need to maintain current traffic flow while your certificate is being issued. You can place the
     * validation token at the well-known path on your existing web server, wait for ACM to validate and issue the
     * certificate, and then update your DNS to point to CloudFront.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #validationTokenHost} will return {@link ValidationTokenHost#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #validationTokenHostAsString}.
     * </p>
     * 
     * @return Specify how the HTTP validation token will be served when requesting the CloudFront managed ACM
     *         certificate.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For <code>cloudfront</code>, CloudFront will automatically serve the validation token. Choose this mode
     *         if you can point the domain's DNS to CloudFront immediately.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <code>self-hosted</code>, you serve the validation token from your existing infrastructure. Choose
     *         this mode when you need to maintain current traffic flow while your certificate is being issued. You can
     *         place the validation token at the well-known path on your existing web server, wait for ACM to validate
     *         and issue the certificate, and then update your DNS to point to CloudFront.
     *         </p>
     *         </li>
     * @see ValidationTokenHost
     */
    public final String validationTokenHostAsString() {
        return validationTokenHost;
    }

    /**
     * <p>
     * The primary domain name associated with the CloudFront managed ACM certificate.
     * </p>
     * 
     * @return The primary domain name associated with the CloudFront managed ACM certificate.
     */
    public final String primaryDomainName() {
        return primaryDomainName;
    }

    /**
     * <p>
     * You can opt out of certificate transparency logging by specifying the <code>disabled</code> option. Opt in by
     * specifying <code>enabled</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/acm/latest/userguide/acm-concepts.html#concept-transparency">Certificate
     * Transparency Logging </a> in the <i>Certificate Manager User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #certificateTransparencyLoggingPreference} will return
     * {@link CertificateTransparencyLoggingPreference#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #certificateTransparencyLoggingPreferenceAsString}.
     * </p>
     * 
     * @return You can opt out of certificate transparency logging by specifying the <code>disabled</code> option. Opt
     *         in by specifying <code>enabled</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/acm/latest/userguide/acm-concepts.html#concept-transparency"
     *         >Certificate Transparency Logging </a> in the <i>Certificate Manager User Guide</i>.
     * @see CertificateTransparencyLoggingPreference
     */
    public final CertificateTransparencyLoggingPreference certificateTransparencyLoggingPreference() {
        return CertificateTransparencyLoggingPreference.fromValue(certificateTransparencyLoggingPreference);
    }

    /**
     * <p>
     * You can opt out of certificate transparency logging by specifying the <code>disabled</code> option. Opt in by
     * specifying <code>enabled</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/acm/latest/userguide/acm-concepts.html#concept-transparency">Certificate
     * Transparency Logging </a> in the <i>Certificate Manager User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #certificateTransparencyLoggingPreference} will return
     * {@link CertificateTransparencyLoggingPreference#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #certificateTransparencyLoggingPreferenceAsString}.
     * </p>
     * 
     * @return You can opt out of certificate transparency logging by specifying the <code>disabled</code> option. Opt
     *         in by specifying <code>enabled</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/acm/latest/userguide/acm-concepts.html#concept-transparency"
     *         >Certificate Transparency Logging </a> in the <i>Certificate Manager User Guide</i>.
     * @see CertificateTransparencyLoggingPreference
     */
    public final String certificateTransparencyLoggingPreferenceAsString() {
        return certificateTransparencyLoggingPreference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(validationTokenHostAsString());
        hashCode = 31 * hashCode + Objects.hashCode(primaryDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(certificateTransparencyLoggingPreferenceAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedCertificateRequest)) {
            return false;
        }
        ManagedCertificateRequest other = (ManagedCertificateRequest) obj;
        return Objects.equals(validationTokenHostAsString(), other.validationTokenHostAsString())
                && Objects.equals(primaryDomainName(), other.primaryDomainName())
                && Objects.equals(certificateTransparencyLoggingPreferenceAsString(),
                        other.certificateTransparencyLoggingPreferenceAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManagedCertificateRequest").add("ValidationTokenHost", validationTokenHostAsString())
                .add("PrimaryDomainName", primaryDomainName())
                .add("CertificateTransparencyLoggingPreference", certificateTransparencyLoggingPreferenceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ValidationTokenHost":
            return Optional.ofNullable(clazz.cast(validationTokenHostAsString()));
        case "PrimaryDomainName":
            return Optional.ofNullable(clazz.cast(primaryDomainName()));
        case "CertificateTransparencyLoggingPreference":
            return Optional.ofNullable(clazz.cast(certificateTransparencyLoggingPreferenceAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ValidationTokenHost", VALIDATION_TOKEN_HOST_FIELD);
        map.put("PrimaryDomainName", PRIMARY_DOMAIN_NAME_FIELD);
        map.put("CertificateTransparencyLoggingPreference", CERTIFICATE_TRANSPARENCY_LOGGING_PREFERENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedCertificateRequest, T> g) {
        return obj -> g.apply((ManagedCertificateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedCertificateRequest> {
        /**
         * <p>
         * Specify how the HTTP validation token will be served when requesting the CloudFront managed ACM certificate.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For <code>cloudfront</code>, CloudFront will automatically serve the validation token. Choose this mode if
         * you can point the domain's DNS to CloudFront immediately.
         * </p>
         * </li>
         * <li>
         * <p>
         * For <code>self-hosted</code>, you serve the validation token from your existing infrastructure. Choose this
         * mode when you need to maintain current traffic flow while your certificate is being issued. You can place the
         * validation token at the well-known path on your existing web server, wait for ACM to validate and issue the
         * certificate, and then update your DNS to point to CloudFront.
         * </p>
         * </li>
         * </ul>
         * 
         * @param validationTokenHost
         *        Specify how the HTTP validation token will be served when requesting the CloudFront managed ACM
         *        certificate.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For <code>cloudfront</code>, CloudFront will automatically serve the validation token. Choose this
         *        mode if you can point the domain's DNS to CloudFront immediately.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For <code>self-hosted</code>, you serve the validation token from your existing infrastructure. Choose
         *        this mode when you need to maintain current traffic flow while your certificate is being issued. You
         *        can place the validation token at the well-known path on your existing web server, wait for ACM to
         *        validate and issue the certificate, and then update your DNS to point to CloudFront.
         *        </p>
         *        </li>
         * @see ValidationTokenHost
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationTokenHost
         */
        Builder validationTokenHost(String validationTokenHost);

        /**
         * <p>
         * Specify how the HTTP validation token will be served when requesting the CloudFront managed ACM certificate.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For <code>cloudfront</code>, CloudFront will automatically serve the validation token. Choose this mode if
         * you can point the domain's DNS to CloudFront immediately.
         * </p>
         * </li>
         * <li>
         * <p>
         * For <code>self-hosted</code>, you serve the validation token from your existing infrastructure. Choose this
         * mode when you need to maintain current traffic flow while your certificate is being issued. You can place the
         * validation token at the well-known path on your existing web server, wait for ACM to validate and issue the
         * certificate, and then update your DNS to point to CloudFront.
         * </p>
         * </li>
         * </ul>
         * 
         * @param validationTokenHost
         *        Specify how the HTTP validation token will be served when requesting the CloudFront managed ACM
         *        certificate.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For <code>cloudfront</code>, CloudFront will automatically serve the validation token. Choose this
         *        mode if you can point the domain's DNS to CloudFront immediately.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For <code>self-hosted</code>, you serve the validation token from your existing infrastructure. Choose
         *        this mode when you need to maintain current traffic flow while your certificate is being issued. You
         *        can place the validation token at the well-known path on your existing web server, wait for ACM to
         *        validate and issue the certificate, and then update your DNS to point to CloudFront.
         *        </p>
         *        </li>
         * @see ValidationTokenHost
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationTokenHost
         */
        Builder validationTokenHost(ValidationTokenHost validationTokenHost);

        /**
         * <p>
         * The primary domain name associated with the CloudFront managed ACM certificate.
         * </p>
         * 
         * @param primaryDomainName
         *        The primary domain name associated with the CloudFront managed ACM certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryDomainName(String primaryDomainName);

        /**
         * <p>
         * You can opt out of certificate transparency logging by specifying the <code>disabled</code> option. Opt in by
         * specifying <code>enabled</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/acm/latest/userguide/acm-concepts.html#concept-transparency">Certificate
         * Transparency Logging </a> in the <i>Certificate Manager User Guide</i>.
         * </p>
         * 
         * @param certificateTransparencyLoggingPreference
         *        You can opt out of certificate transparency logging by specifying the <code>disabled</code> option.
         *        Opt in by specifying <code>enabled</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/acm/latest/userguide/acm-concepts.html#concept-transparency"
         *        >Certificate Transparency Logging </a> in the <i>Certificate Manager User Guide</i>.
         * @see CertificateTransparencyLoggingPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateTransparencyLoggingPreference
         */
        Builder certificateTransparencyLoggingPreference(String certificateTransparencyLoggingPreference);

        /**
         * <p>
         * You can opt out of certificate transparency logging by specifying the <code>disabled</code> option. Opt in by
         * specifying <code>enabled</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/acm/latest/userguide/acm-concepts.html#concept-transparency">Certificate
         * Transparency Logging </a> in the <i>Certificate Manager User Guide</i>.
         * </p>
         * 
         * @param certificateTransparencyLoggingPreference
         *        You can opt out of certificate transparency logging by specifying the <code>disabled</code> option.
         *        Opt in by specifying <code>enabled</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/acm/latest/userguide/acm-concepts.html#concept-transparency"
         *        >Certificate Transparency Logging </a> in the <i>Certificate Manager User Guide</i>.
         * @see CertificateTransparencyLoggingPreference
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateTransparencyLoggingPreference
         */
        Builder certificateTransparencyLoggingPreference(
                CertificateTransparencyLoggingPreference certificateTransparencyLoggingPreference);
    }

    static final class BuilderImpl implements Builder {
        private String validationTokenHost;

        private String primaryDomainName;

        private String certificateTransparencyLoggingPreference;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedCertificateRequest model) {
            validationTokenHost(model.validationTokenHost);
            primaryDomainName(model.primaryDomainName);
            certificateTransparencyLoggingPreference(model.certificateTransparencyLoggingPreference);
        }

        public final String getValidationTokenHost() {
            return validationTokenHost;
        }

        public final void setValidationTokenHost(String validationTokenHost) {
            this.validationTokenHost = validationTokenHost;
        }

        @Override
        public final Builder validationTokenHost(String validationTokenHost) {
            this.validationTokenHost = validationTokenHost;
            return this;
        }

        @Override
        public final Builder validationTokenHost(ValidationTokenHost validationTokenHost) {
            this.validationTokenHost(validationTokenHost == null ? null : validationTokenHost.toString());
            return this;
        }

        public final String getPrimaryDomainName() {
            return primaryDomainName;
        }

        public final void setPrimaryDomainName(String primaryDomainName) {
            this.primaryDomainName = primaryDomainName;
        }

        @Override
        public final Builder primaryDomainName(String primaryDomainName) {
            this.primaryDomainName = primaryDomainName;
            return this;
        }

        public final String getCertificateTransparencyLoggingPreference() {
            return certificateTransparencyLoggingPreference;
        }

        public final void setCertificateTransparencyLoggingPreference(String certificateTransparencyLoggingPreference) {
            this.certificateTransparencyLoggingPreference = certificateTransparencyLoggingPreference;
        }

        @Override
        public final Builder certificateTransparencyLoggingPreference(String certificateTransparencyLoggingPreference) {
            this.certificateTransparencyLoggingPreference = certificateTransparencyLoggingPreference;
            return this;
        }

        @Override
        public final Builder certificateTransparencyLoggingPreference(
                CertificateTransparencyLoggingPreference certificateTransparencyLoggingPreference) {
            this.certificateTransparencyLoggingPreference(certificateTransparencyLoggingPreference == null ? null
                    : certificateTransparencyLoggingPreference.toString());
            return this;
        }

        @Override
        public ManagedCertificateRequest build() {
            return new ManagedCertificateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
