/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudfront.model.AnycastIpsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnycastIpList
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnycastIpList> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(AnycastIpList.getter(AnycastIpList::id)).setter(AnycastIpList.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AnycastIpList.getter(AnycastIpList::name)).setter(AnycastIpList.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(AnycastIpList.getter(AnycastIpList::status)).setter(AnycastIpList.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("Status").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(AnycastIpList.getter(AnycastIpList::arn)).setter(AnycastIpList.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").unmarshallLocationName("Arn").build()}).build();
    private static final SdkField<List<String>> ANYCAST_IPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AnycastIps").getter(AnycastIpList.getter(AnycastIpList::anycastIps)).setter(AnycastIpList.setter(Builder::anycastIps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnycastIps").unmarshallLocationName("AnycastIps").build(), ListTrait.builder().memberLocationName("AnycastIp").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnycastIp").unmarshallLocationName("AnycastIp").build()}).build()).build()}).build();
    private static final SdkField<Integer> IP_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("IpCount").getter(AnycastIpList.getter(AnycastIpList::ipCount)).setter(AnycastIpList.setter(Builder::ipCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpCount").unmarshallLocationName("IpCount").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(AnycastIpList.getter(AnycastIpList::lastModifiedTime)).setter(AnycastIpList.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").unmarshallLocationName("LastModifiedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, STATUS_FIELD, ARN_FIELD, ANYCAST_IPS_FIELD, IP_COUNT_FIELD, LAST_MODIFIED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AnycastIpList.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String status;
    private final String arn;
    private final List<String> anycastIps;
    private final Integer ipCount;
    private final Instant lastModifiedTime;

    private AnycastIpList(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.status = builder.status;
        this.arn = builder.arn;
        this.anycastIps = builder.anycastIps;
        this.ipCount = builder.ipCount;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String status() {
        return this.status;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasAnycastIps() {
        return this.anycastIps != null && !(this.anycastIps instanceof SdkAutoConstructList);
    }

    public final List<String> anycastIps() {
        return this.anycastIps;
    }

    public final Integer ipCount() {
        return this.ipCount;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnycastIps() ? this.anycastIps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ipCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnycastIpList)) {
            return false;
        }
        AnycastIpList other = (AnycastIpList)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.arn(), other.arn()) && this.hasAnycastIps() == other.hasAnycastIps() && Objects.equals(this.anycastIps(), other.anycastIps()) && Objects.equals(this.ipCount(), other.ipCount()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public final String toString() {
        return ToString.builder((String)"AnycastIpList").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Status", (Object)this.status()).add("Arn", (Object)this.arn()).add("AnycastIps", this.hasAnycastIps() ? this.anycastIps() : null).add("IpCount", (Object)this.ipCount()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "AnycastIps": {
                return Optional.ofNullable(clazz.cast(this.anycastIps()));
            }
            case "IpCount": {
                return Optional.ofNullable(clazz.cast(this.ipCount()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("AnycastIps", ANYCAST_IPS_FIELD);
        map.put("IpCount", IP_COUNT_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnycastIpList, T> g) {
        return obj -> g.apply((AnycastIpList)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String status;
        private String arn;
        private List<String> anycastIps = DefaultSdkAutoConstructList.getInstance();
        private Integer ipCount;
        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AnycastIpList model) {
            this.id(model.id);
            this.name(model.name);
            this.status(model.status);
            this.arn(model.arn);
            this.anycastIps(model.anycastIps);
            this.ipCount(model.ipCount);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getAnycastIps() {
            if (this.anycastIps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.anycastIps;
        }

        public final void setAnycastIps(Collection<String> anycastIps) {
            this.anycastIps = AnycastIpsCopier.copy(anycastIps);
        }

        @Override
        public final Builder anycastIps(Collection<String> anycastIps) {
            this.anycastIps = AnycastIpsCopier.copy(anycastIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anycastIps(String ... anycastIps) {
            this.anycastIps(Arrays.asList(anycastIps));
            return this;
        }

        public final Integer getIpCount() {
            return this.ipCount;
        }

        public final void setIpCount(Integer ipCount) {
            this.ipCount = ipCount;
        }

        @Override
        public final Builder ipCount(Integer ipCount) {
            this.ipCount = ipCount;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public AnycastIpList build() {
            return new AnycastIpList(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnycastIpList> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder arn(String var1);

        public Builder anycastIps(Collection<String> var1);

        public Builder anycastIps(String ... var1);

        public Builder ipCount(Integer var1);

        public Builder lastModifiedTime(Instant var1);
    }
}

