/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudtrail.CloudTrailClient;
import software.amazon.awssdk.services.cloudtrail.model.ListTagsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListTagsResponse;
import software.amazon.awssdk.services.cloudtrail.model.ResourceTag;

public class ListTagsIterable
implements SdkIterable<ListTagsResponse> {
    private final CloudTrailClient client;
    private final ListTagsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTagsIterable(CloudTrailClient client, ListTagsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTagsResponseFetcher();
    }

    public Iterator<ListTagsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResourceTag> resourceTagList() {
        Function<ListTagsResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceTagList() != null) {
                return response.resourceTagList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTagsResponseFetcher
    implements SyncPageFetcher<ListTagsResponse> {
        private ListTagsResponseFetcher() {
        }

        public boolean hasNextPage(ListTagsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTagsResponse nextPage(ListTagsResponse previousPage) {
            if (previousPage == null) {
                return ListTagsIterable.this.client.listTags(ListTagsIterable.this.firstRequest);
            }
            return ListTagsIterable.this.client.listTags((ListTagsRequest)((Object)ListTagsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

