/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.Trail;
import software.amazon.awssdk.services.cloudtrail.model.TrailListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTrailsResponse
extends CloudTrailResponse
implements ToCopyableBuilder<Builder, DescribeTrailsResponse> {
    private static final SdkField<List<Trail>> TRAIL_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("trailList").getter(DescribeTrailsResponse.getter(DescribeTrailsResponse::trailList)).setter(DescribeTrailsResponse.setter(Builder::trailList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trailList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Trail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAIL_LIST_FIELD));
    private final List<Trail> trailList;

    private DescribeTrailsResponse(BuilderImpl builder) {
        super(builder);
        this.trailList = builder.trailList;
    }

    public final boolean hasTrailList() {
        return this.trailList != null && !(this.trailList instanceof SdkAutoConstructList);
    }

    public final List<Trail> trailList() {
        return this.trailList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrailList() ? this.trailList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrailsResponse)) {
            return false;
        }
        DescribeTrailsResponse other = (DescribeTrailsResponse)((Object)obj);
        return this.hasTrailList() == other.hasTrailList() && Objects.equals(this.trailList(), other.trailList());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTrailsResponse").add("TrailList", this.hasTrailList() ? this.trailList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "trailList": {
                return Optional.ofNullable(clazz.cast(this.trailList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrailsResponse, T> g) {
        return obj -> g.apply((DescribeTrailsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailResponse.BuilderImpl
    implements Builder {
        private List<Trail> trailList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrailsResponse model) {
            super(model);
            this.trailList(model.trailList);
        }

        public final List<Trail.Builder> getTrailList() {
            List<Trail.Builder> result = TrailListCopier.copyToBuilder(this.trailList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrailList(Collection<Trail.BuilderImpl> trailList) {
            this.trailList = TrailListCopier.copyFromBuilder(trailList);
        }

        @Override
        public final Builder trailList(Collection<Trail> trailList) {
            this.trailList = TrailListCopier.copy(trailList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trailList(Trail ... trailList) {
            this.trailList(Arrays.asList(trailList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trailList(Consumer<Trail.Builder> ... trailList) {
            this.trailList(Stream.of(trailList).map(c -> (Trail)((Trail.Builder)Trail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeTrailsResponse build() {
            return new DescribeTrailsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudTrailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTrailsResponse> {
        public Builder trailList(Collection<Trail> var1);

        public Builder trailList(Trail ... var1);

        public Builder trailList(Consumer<Trail.Builder> ... var1);
    }
}

