/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.FederationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnableFederationResponse
extends CloudTrailResponse
implements ToCopyableBuilder<Builder, EnableFederationResponse> {
    private static final SdkField<String> EVENT_DATA_STORE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventDataStoreArn").getter(EnableFederationResponse.getter(EnableFederationResponse::eventDataStoreArn)).setter(EnableFederationResponse.setter(Builder::eventDataStoreArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDataStoreArn").build()}).build();
    private static final SdkField<String> FEDERATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FederationStatus").getter(EnableFederationResponse.getter(EnableFederationResponse::federationStatusAsString)).setter(EnableFederationResponse.setter(Builder::federationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FederationStatus").build()}).build();
    private static final SdkField<String> FEDERATION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FederationRoleArn").getter(EnableFederationResponse.getter(EnableFederationResponse::federationRoleArn)).setter(EnableFederationResponse.setter(Builder::federationRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FederationRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_DATA_STORE_ARN_FIELD, FEDERATION_STATUS_FIELD, FEDERATION_ROLE_ARN_FIELD));
    private final String eventDataStoreArn;
    private final String federationStatus;
    private final String federationRoleArn;

    private EnableFederationResponse(BuilderImpl builder) {
        super(builder);
        this.eventDataStoreArn = builder.eventDataStoreArn;
        this.federationStatus = builder.federationStatus;
        this.federationRoleArn = builder.federationRoleArn;
    }

    public final String eventDataStoreArn() {
        return this.eventDataStoreArn;
    }

    public final FederationStatus federationStatus() {
        return FederationStatus.fromValue(this.federationStatus);
    }

    public final String federationStatusAsString() {
        return this.federationStatus;
    }

    public final String federationRoleArn() {
        return this.federationRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDataStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.federationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.federationRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableFederationResponse)) {
            return false;
        }
        EnableFederationResponse other = (EnableFederationResponse)((Object)obj);
        return Objects.equals(this.eventDataStoreArn(), other.eventDataStoreArn()) && Objects.equals(this.federationStatusAsString(), other.federationStatusAsString()) && Objects.equals(this.federationRoleArn(), other.federationRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"EnableFederationResponse").add("EventDataStoreArn", (Object)this.eventDataStoreArn()).add("FederationStatus", (Object)this.federationStatusAsString()).add("FederationRoleArn", (Object)this.federationRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventDataStoreArn": {
                return Optional.ofNullable(clazz.cast(this.eventDataStoreArn()));
            }
            case "FederationStatus": {
                return Optional.ofNullable(clazz.cast(this.federationStatusAsString()));
            }
            case "FederationRoleArn": {
                return Optional.ofNullable(clazz.cast(this.federationRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableFederationResponse, T> g) {
        return obj -> g.apply((EnableFederationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailResponse.BuilderImpl
    implements Builder {
        private String eventDataStoreArn;
        private String federationStatus;
        private String federationRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableFederationResponse model) {
            super(model);
            this.eventDataStoreArn(model.eventDataStoreArn);
            this.federationStatus(model.federationStatus);
            this.federationRoleArn(model.federationRoleArn);
        }

        public final String getEventDataStoreArn() {
            return this.eventDataStoreArn;
        }

        public final void setEventDataStoreArn(String eventDataStoreArn) {
            this.eventDataStoreArn = eventDataStoreArn;
        }

        @Override
        public final Builder eventDataStoreArn(String eventDataStoreArn) {
            this.eventDataStoreArn = eventDataStoreArn;
            return this;
        }

        public final String getFederationStatus() {
            return this.federationStatus;
        }

        public final void setFederationStatus(String federationStatus) {
            this.federationStatus = federationStatus;
        }

        @Override
        public final Builder federationStatus(String federationStatus) {
            this.federationStatus = federationStatus;
            return this;
        }

        @Override
        public final Builder federationStatus(FederationStatus federationStatus) {
            this.federationStatus(federationStatus == null ? null : federationStatus.toString());
            return this;
        }

        public final String getFederationRoleArn() {
            return this.federationRoleArn;
        }

        public final void setFederationRoleArn(String federationRoleArn) {
            this.federationRoleArn = federationRoleArn;
        }

        @Override
        public final Builder federationRoleArn(String federationRoleArn) {
            this.federationRoleArn = federationRoleArn;
            return this;
        }

        @Override
        public EnableFederationResponse build() {
            return new EnableFederationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudTrailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EnableFederationResponse> {
        public Builder eventDataStoreArn(String var1);

        public Builder federationStatus(String var1);

        public Builder federationStatus(FederationStatus var1);

        public Builder federationRoleArn(String var1);
    }
}

