/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInsightSelectorsRequest extends CloudTrailRequest implements
        ToCopyableBuilder<GetInsightSelectorsRequest.Builder, GetInsightSelectorsRequest> {
    private static final SdkField<String> TRAIL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrailName").getter(getter(GetInsightSelectorsRequest::trailName)).setter(setter(Builder::trailName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrailName").build()).build();

    private static final SdkField<String> EVENT_DATA_STORE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventDataStore").getter(getter(GetInsightSelectorsRequest::eventDataStore))
            .setter(setter(Builder::eventDataStore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDataStore").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAIL_NAME_FIELD,
            EVENT_DATA_STORE_FIELD));

    private final String trailName;

    private final String eventDataStore;

    private GetInsightSelectorsRequest(BuilderImpl builder) {
        super(builder);
        this.trailName = builder.trailName;
        this.eventDataStore = builder.eventDataStore;
    }

    /**
     * <p>
     * Specifies the name of the trail or trail ARN. If you specify a trail name, the string must meet the following
     * requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     * </p>
     * </li>
     * <li>
     * <p>
     * Start with a letter or number, and end with a letter or number
     * </p>
     * </li>
     * <li>
     * <p>
     * Be between 3 and 128 characters
     * </p>
     * </li>
     * <li>
     * <p>
     * Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     * <code>my--namespace</code> are not valid.
     * </p>
     * </li>
     * <li>
     * <p>
     * Not be in IP address format (for example, 192.168.5.4)
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you specify a trail ARN, it must be in the format:
     * </p>
     * <p>
     * <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     * </p>
     * <p>
     * You cannot use this parameter with the <code>EventDataStore</code> parameter.
     * </p>
     * 
     * @return Specifies the name of the trail or trail ARN. If you specify a trail name, the string must meet the
     *         following requirements:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start with a letter or number, and end with a letter or number
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Be between 3 and 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
     *         <code>my--namespace</code> are not valid.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Not be in IP address format (for example, 192.168.5.4)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you specify a trail ARN, it must be in the format:
     *         </p>
     *         <p>
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         You cannot use this parameter with the <code>EventDataStore</code> parameter.
     */
    public final String trailName() {
        return trailName;
    }

    /**
     * <p>
     * Specifies the ARN (or ID suffix of the ARN) of the event data store for which you want to get Insights selectors.
     * </p>
     * <p>
     * You cannot use this parameter with the <code>TrailName</code> parameter.
     * </p>
     * 
     * @return Specifies the ARN (or ID suffix of the ARN) of the event data store for which you want to get Insights
     *         selectors. </p>
     *         <p>
     *         You cannot use this parameter with the <code>TrailName</code> parameter.
     */
    public final String eventDataStore() {
        return eventDataStore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trailName());
        hashCode = 31 * hashCode + Objects.hashCode(eventDataStore());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInsightSelectorsRequest)) {
            return false;
        }
        GetInsightSelectorsRequest other = (GetInsightSelectorsRequest) obj;
        return Objects.equals(trailName(), other.trailName()) && Objects.equals(eventDataStore(), other.eventDataStore());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetInsightSelectorsRequest").add("TrailName", trailName())
                .add("EventDataStore", eventDataStore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrailName":
            return Optional.ofNullable(clazz.cast(trailName()));
        case "EventDataStore":
            return Optional.ofNullable(clazz.cast(eventDataStore()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInsightSelectorsRequest, T> g) {
        return obj -> g.apply((GetInsightSelectorsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetInsightSelectorsRequest> {
        /**
         * <p>
         * Specifies the name of the trail or trail ARN. If you specify a trail name, the string must meet the following
         * requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
         * </p>
         * </li>
         * <li>
         * <p>
         * Start with a letter or number, and end with a letter or number
         * </p>
         * </li>
         * <li>
         * <p>
         * Be between 3 and 128 characters
         * </p>
         * </li>
         * <li>
         * <p>
         * Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
         * <code>my--namespace</code> are not valid.
         * </p>
         * </li>
         * <li>
         * <p>
         * Not be in IP address format (for example, 192.168.5.4)
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you specify a trail ARN, it must be in the format:
         * </p>
         * <p>
         * <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
         * </p>
         * <p>
         * You cannot use this parameter with the <code>EventDataStore</code> parameter.
         * </p>
         * 
         * @param trailName
         *        Specifies the name of the trail or trail ARN. If you specify a trail name, the string must meet the
         *        following requirements:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Start with a letter or number, and end with a letter or number
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Be between 3 and 128 characters
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and
         *        <code>my--namespace</code> are not valid.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Not be in IP address format (for example, 192.168.5.4)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you specify a trail ARN, it must be in the format:
         *        </p>
         *        <p>
         *        <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
         *        </p>
         *        <p>
         *        You cannot use this parameter with the <code>EventDataStore</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trailName(String trailName);

        /**
         * <p>
         * Specifies the ARN (or ID suffix of the ARN) of the event data store for which you want to get Insights
         * selectors.
         * </p>
         * <p>
         * You cannot use this parameter with the <code>TrailName</code> parameter.
         * </p>
         * 
         * @param eventDataStore
         *        Specifies the ARN (or ID suffix of the ARN) of the event data store for which you want to get Insights
         *        selectors. </p>
         *        <p>
         *        You cannot use this parameter with the <code>TrailName</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventDataStore(String eventDataStore);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudTrailRequest.BuilderImpl implements Builder {
        private String trailName;

        private String eventDataStore;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInsightSelectorsRequest model) {
            super(model);
            trailName(model.trailName);
            eventDataStore(model.eventDataStore);
        }

        public final String getTrailName() {
            return trailName;
        }

        public final void setTrailName(String trailName) {
            this.trailName = trailName;
        }

        @Override
        public final Builder trailName(String trailName) {
            this.trailName = trailName;
            return this;
        }

        public final String getEventDataStore() {
            return eventDataStore;
        }

        public final void setEventDataStore(String eventDataStore) {
            this.eventDataStore = eventDataStore;
        }

        @Override
        public final Builder eventDataStore(String eventDataStore) {
            this.eventDataStore = eventDataStore;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetInsightSelectorsRequest build() {
            return new GetInsightSelectorsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
