/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IngestionStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IngestionStatus> {
    private static final SdkField<Instant> LATEST_INGESTION_SUCCESS_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LatestIngestionSuccessTime").getter(IngestionStatus.getter(IngestionStatus::latestIngestionSuccessTime)).setter(IngestionStatus.setter(Builder::latestIngestionSuccessTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestIngestionSuccessTime").build()}).build();
    private static final SdkField<String> LATEST_INGESTION_SUCCESS_EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestIngestionSuccessEventID").getter(IngestionStatus.getter(IngestionStatus::latestIngestionSuccessEventID)).setter(IngestionStatus.setter(Builder::latestIngestionSuccessEventID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestIngestionSuccessEventID").build()}).build();
    private static final SdkField<String> LATEST_INGESTION_ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestIngestionErrorCode").getter(IngestionStatus.getter(IngestionStatus::latestIngestionErrorCode)).setter(IngestionStatus.setter(Builder::latestIngestionErrorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestIngestionErrorCode").build()}).build();
    private static final SdkField<Instant> LATEST_INGESTION_ATTEMPT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LatestIngestionAttemptTime").getter(IngestionStatus.getter(IngestionStatus::latestIngestionAttemptTime)).setter(IngestionStatus.setter(Builder::latestIngestionAttemptTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestIngestionAttemptTime").build()}).build();
    private static final SdkField<String> LATEST_INGESTION_ATTEMPT_EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestIngestionAttemptEventID").getter(IngestionStatus.getter(IngestionStatus::latestIngestionAttemptEventID)).setter(IngestionStatus.setter(Builder::latestIngestionAttemptEventID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestIngestionAttemptEventID").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LATEST_INGESTION_SUCCESS_TIME_FIELD, LATEST_INGESTION_SUCCESS_EVENT_ID_FIELD, LATEST_INGESTION_ERROR_CODE_FIELD, LATEST_INGESTION_ATTEMPT_TIME_FIELD, LATEST_INGESTION_ATTEMPT_EVENT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant latestIngestionSuccessTime;
    private final String latestIngestionSuccessEventID;
    private final String latestIngestionErrorCode;
    private final Instant latestIngestionAttemptTime;
    private final String latestIngestionAttemptEventID;

    private IngestionStatus(BuilderImpl builder) {
        this.latestIngestionSuccessTime = builder.latestIngestionSuccessTime;
        this.latestIngestionSuccessEventID = builder.latestIngestionSuccessEventID;
        this.latestIngestionErrorCode = builder.latestIngestionErrorCode;
        this.latestIngestionAttemptTime = builder.latestIngestionAttemptTime;
        this.latestIngestionAttemptEventID = builder.latestIngestionAttemptEventID;
    }

    public final Instant latestIngestionSuccessTime() {
        return this.latestIngestionSuccessTime;
    }

    public final String latestIngestionSuccessEventID() {
        return this.latestIngestionSuccessEventID;
    }

    public final String latestIngestionErrorCode() {
        return this.latestIngestionErrorCode;
    }

    public final Instant latestIngestionAttemptTime() {
        return this.latestIngestionAttemptTime;
    }

    public final String latestIngestionAttemptEventID() {
        return this.latestIngestionAttemptEventID;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.latestIngestionSuccessTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestIngestionSuccessEventID());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestIngestionErrorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestIngestionAttemptTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestIngestionAttemptEventID());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngestionStatus)) {
            return false;
        }
        IngestionStatus other = (IngestionStatus)obj;
        return Objects.equals(this.latestIngestionSuccessTime(), other.latestIngestionSuccessTime()) && Objects.equals(this.latestIngestionSuccessEventID(), other.latestIngestionSuccessEventID()) && Objects.equals(this.latestIngestionErrorCode(), other.latestIngestionErrorCode()) && Objects.equals(this.latestIngestionAttemptTime(), other.latestIngestionAttemptTime()) && Objects.equals(this.latestIngestionAttemptEventID(), other.latestIngestionAttemptEventID());
    }

    public final String toString() {
        return ToString.builder((String)"IngestionStatus").add("LatestIngestionSuccessTime", (Object)this.latestIngestionSuccessTime()).add("LatestIngestionSuccessEventID", (Object)this.latestIngestionSuccessEventID()).add("LatestIngestionErrorCode", (Object)this.latestIngestionErrorCode()).add("LatestIngestionAttemptTime", (Object)this.latestIngestionAttemptTime()).add("LatestIngestionAttemptEventID", (Object)this.latestIngestionAttemptEventID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LatestIngestionSuccessTime": {
                return Optional.ofNullable(clazz.cast(this.latestIngestionSuccessTime()));
            }
            case "LatestIngestionSuccessEventID": {
                return Optional.ofNullable(clazz.cast(this.latestIngestionSuccessEventID()));
            }
            case "LatestIngestionErrorCode": {
                return Optional.ofNullable(clazz.cast(this.latestIngestionErrorCode()));
            }
            case "LatestIngestionAttemptTime": {
                return Optional.ofNullable(clazz.cast(this.latestIngestionAttemptTime()));
            }
            case "LatestIngestionAttemptEventID": {
                return Optional.ofNullable(clazz.cast(this.latestIngestionAttemptEventID()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IngestionStatus, T> g) {
        return obj -> g.apply((IngestionStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant latestIngestionSuccessTime;
        private String latestIngestionSuccessEventID;
        private String latestIngestionErrorCode;
        private Instant latestIngestionAttemptTime;
        private String latestIngestionAttemptEventID;

        private BuilderImpl() {
        }

        private BuilderImpl(IngestionStatus model) {
            this.latestIngestionSuccessTime(model.latestIngestionSuccessTime);
            this.latestIngestionSuccessEventID(model.latestIngestionSuccessEventID);
            this.latestIngestionErrorCode(model.latestIngestionErrorCode);
            this.latestIngestionAttemptTime(model.latestIngestionAttemptTime);
            this.latestIngestionAttemptEventID(model.latestIngestionAttemptEventID);
        }

        public final Instant getLatestIngestionSuccessTime() {
            return this.latestIngestionSuccessTime;
        }

        public final void setLatestIngestionSuccessTime(Instant latestIngestionSuccessTime) {
            this.latestIngestionSuccessTime = latestIngestionSuccessTime;
        }

        @Override
        public final Builder latestIngestionSuccessTime(Instant latestIngestionSuccessTime) {
            this.latestIngestionSuccessTime = latestIngestionSuccessTime;
            return this;
        }

        public final String getLatestIngestionSuccessEventID() {
            return this.latestIngestionSuccessEventID;
        }

        public final void setLatestIngestionSuccessEventID(String latestIngestionSuccessEventID) {
            this.latestIngestionSuccessEventID = latestIngestionSuccessEventID;
        }

        @Override
        public final Builder latestIngestionSuccessEventID(String latestIngestionSuccessEventID) {
            this.latestIngestionSuccessEventID = latestIngestionSuccessEventID;
            return this;
        }

        public final String getLatestIngestionErrorCode() {
            return this.latestIngestionErrorCode;
        }

        public final void setLatestIngestionErrorCode(String latestIngestionErrorCode) {
            this.latestIngestionErrorCode = latestIngestionErrorCode;
        }

        @Override
        public final Builder latestIngestionErrorCode(String latestIngestionErrorCode) {
            this.latestIngestionErrorCode = latestIngestionErrorCode;
            return this;
        }

        public final Instant getLatestIngestionAttemptTime() {
            return this.latestIngestionAttemptTime;
        }

        public final void setLatestIngestionAttemptTime(Instant latestIngestionAttemptTime) {
            this.latestIngestionAttemptTime = latestIngestionAttemptTime;
        }

        @Override
        public final Builder latestIngestionAttemptTime(Instant latestIngestionAttemptTime) {
            this.latestIngestionAttemptTime = latestIngestionAttemptTime;
            return this;
        }

        public final String getLatestIngestionAttemptEventID() {
            return this.latestIngestionAttemptEventID;
        }

        public final void setLatestIngestionAttemptEventID(String latestIngestionAttemptEventID) {
            this.latestIngestionAttemptEventID = latestIngestionAttemptEventID;
        }

        @Override
        public final Builder latestIngestionAttemptEventID(String latestIngestionAttemptEventID) {
            this.latestIngestionAttemptEventID = latestIngestionAttemptEventID;
            return this;
        }

        public IngestionStatus build() {
            return new IngestionStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IngestionStatus> {
        public Builder latestIngestionSuccessTime(Instant var1);

        public Builder latestIngestionSuccessEventID(String var1);

        public Builder latestIngestionErrorCode(String var1);

        public Builder latestIngestionAttemptTime(Instant var1);

        public Builder latestIngestionAttemptEventID(String var1);
    }
}

