/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.SearchSampleQueriesSearchResult;
import software.amazon.awssdk.services.cloudtrail.model.SearchSampleQueriesSearchResultsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchSampleQueriesResponse
extends CloudTrailResponse
implements ToCopyableBuilder<Builder, SearchSampleQueriesResponse> {
    private static final SdkField<List<SearchSampleQueriesSearchResult>> SEARCH_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SearchResults").getter(SearchSampleQueriesResponse.getter(SearchSampleQueriesResponse::searchResults)).setter(SearchSampleQueriesResponse.setter(Builder::searchResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SearchSampleQueriesSearchResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchSampleQueriesResponse.getter(SearchSampleQueriesResponse::nextToken)).setter(SearchSampleQueriesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEARCH_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchSampleQueriesResponse.memberNameToFieldInitializer();
    private final List<SearchSampleQueriesSearchResult> searchResults;
    private final String nextToken;

    private SearchSampleQueriesResponse(BuilderImpl builder) {
        super(builder);
        this.searchResults = builder.searchResults;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSearchResults() {
        return this.searchResults != null && !(this.searchResults instanceof SdkAutoConstructList);
    }

    public final List<SearchSampleQueriesSearchResult> searchResults() {
        return this.searchResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSearchResults() ? this.searchResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchSampleQueriesResponse)) {
            return false;
        }
        SearchSampleQueriesResponse other = (SearchSampleQueriesResponse)((Object)obj);
        return this.hasSearchResults() == other.hasSearchResults() && Objects.equals(this.searchResults(), other.searchResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"SearchSampleQueriesResponse").add("SearchResults", this.hasSearchResults() ? this.searchResults() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SearchResults": {
                return Optional.ofNullable(clazz.cast(this.searchResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SearchResults", SEARCH_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchSampleQueriesResponse, T> g) {
        return obj -> g.apply((SearchSampleQueriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailResponse.BuilderImpl
    implements Builder {
        private List<SearchSampleQueriesSearchResult> searchResults = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchSampleQueriesResponse model) {
            super(model);
            this.searchResults(model.searchResults);
            this.nextToken(model.nextToken);
        }

        public final List<SearchSampleQueriesSearchResult.Builder> getSearchResults() {
            List<SearchSampleQueriesSearchResult.Builder> result = SearchSampleQueriesSearchResultsCopier.copyToBuilder(this.searchResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSearchResults(Collection<SearchSampleQueriesSearchResult.BuilderImpl> searchResults) {
            this.searchResults = SearchSampleQueriesSearchResultsCopier.copyFromBuilder(searchResults);
        }

        @Override
        public final Builder searchResults(Collection<SearchSampleQueriesSearchResult> searchResults) {
            this.searchResults = SearchSampleQueriesSearchResultsCopier.copy(searchResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchResults(SearchSampleQueriesSearchResult ... searchResults) {
            this.searchResults(Arrays.asList(searchResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchResults(Consumer<SearchSampleQueriesSearchResult.Builder> ... searchResults) {
            this.searchResults(Stream.of(searchResults).map(c -> (SearchSampleQueriesSearchResult)((SearchSampleQueriesSearchResult.Builder)SearchSampleQueriesSearchResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public SearchSampleQueriesResponse build() {
            return new SearchSampleQueriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudTrailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchSampleQueriesResponse> {
        public Builder searchResults(Collection<SearchSampleQueriesSearchResult> var1);

        public Builder searchResults(SearchSampleQueriesSearchResult ... var1);

        public Builder searchResults(Consumer<SearchSampleQueriesSearchResult.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

